/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.maven;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkFactory;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenMultiPageReport;
import org.apache.maven.reporting.MavenReportException;
import org.jacoco.maven.ReportFormat;
import org.jacoco.maven.ReportSupport;
import org.jacoco.report.IReportGroupVisitor;
import org.jacoco.report.IReportVisitor;

public abstract class AbstractReportMojo
extends AbstractMojo
implements MavenMultiPageReport {
    @Parameter(property="project.reporting.outputEncoding", defaultValue="UTF-8")
    String outputEncoding;
    @Parameter(defaultValue="HTML,XML,CSV")
    List<ReportFormat> formats;
    @Parameter(defaultValue="${project.name}")
    String title;
    @Parameter
    String footer;
    @Parameter(property="project.build.sourceEncoding", defaultValue="UTF-8")
    String sourceEncoding;
    @Parameter
    List<String> includes;
    @Parameter
    List<String> excludes;
    @Parameter(property="jacoco.skip", defaultValue="false")
    boolean skip;
    @Parameter(property="project", readonly=true)
    MavenProject project;

    public String getDescription(Locale locale) {
        return this.getName(locale) + " Coverage Report.";
    }

    public boolean isExternalReport() {
        return true;
    }

    public String getCategoryName() {
        return "Project Reports";
    }

    List<String> getIncludes() {
        return this.includes;
    }

    List<String> getExcludes() {
        return this.excludes;
    }

    public boolean canGenerateReport() {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping JaCoCo execution because property jacoco.skip is set.");
            return false;
        }
        if (!this.canGenerateReportRegardingDataFiles()) {
            this.getLog().info((CharSequence)"Skipping JaCoCo execution due to missing execution data file.");
            return false;
        }
        if (!this.canGenerateReportRegardingClassesDirectory()) {
            this.getLog().info((CharSequence)"Skipping JaCoCo execution due to missing classes directory.");
            return false;
        }
        return true;
    }

    abstract boolean canGenerateReportRegardingDataFiles();

    abstract boolean canGenerateReportRegardingClassesDirectory();

    abstract File getOutputDirectory();

    public void generate(org.codehaus.doxia.sink.Sink sink, Locale locale) throws MavenReportException {
        this.generate((Sink)sink, null, locale);
    }

    public void generate(Sink sink, SinkFactory sinkFactory, Locale locale) throws MavenReportException {
        if (!this.canGenerateReport()) {
            return;
        }
        this.executeReport(locale);
    }

    public void execute() throws MojoExecutionException {
        if (!this.canGenerateReport()) {
            return;
        }
        try {
            this.executeReport(Locale.getDefault());
        }
        catch (MavenReportException e) {
            throw new MojoExecutionException("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation.", (Exception)((Object)e));
        }
    }

    private void executeReport(Locale locale) throws MavenReportException {
        try {
            ReportSupport support = new ReportSupport(this.getLog());
            this.loadExecutionData(support);
            this.addFormatters(support, locale);
            IReportVisitor visitor = support.initRootVisitor();
            this.createReport((IReportGroupVisitor)visitor, support);
            visitor.visitEnd();
        }
        catch (IOException e) {
            throw new MavenReportException("Error while creating report: " + e.getMessage(), (Exception)e);
        }
    }

    private void addFormatters(ReportSupport support, Locale locale) throws IOException {
        this.getOutputDirectory().mkdirs();
        for (ReportFormat f : this.formats) {
            support.addVisitor(f.createVisitor(this, locale));
        }
    }

    abstract void loadExecutionData(ReportSupport var1) throws IOException;

    abstract void createReport(IReportGroupVisitor var1, ReportSupport var2) throws IOException;
}

