/*
 * Decompiled with CFR 0.152.
 */
package org.jim.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.SimpleDateFormatSerializer;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonKit {
    private static Logger log = LoggerFactory.getLogger(JsonKit.class);
    private static SerializeConfig mapping = new SerializeConfig();

    public static SerializeConfig put(Class<?> clazz, SerializeFilter filter) {
        mapping.addFilter(clazz, filter);
        return mapping;
    }

    public static SerializeConfig put(Class<?> clazz, ObjectSerializer serializer) {
        mapping.put(clazz, serializer);
        return mapping;
    }

    public static <T> T toBean(String jsonString, Class<T> tt) {
        try {
            if (StringUtils.isBlank((CharSequence)jsonString)) {
                return null;
            }
            Object t = JSON.parseObject((String)jsonString, tt);
            return (T)t;
        }
        catch (Throwable e) {
            log.error("json\u89e3\u6790\u5931\u8d25:\r\n{}", (Object)jsonString);
            throw new RuntimeException(e);
        }
    }

    public static <T> T toBean(byte[] bytes, Class<T> tt) {
        try {
            if (bytes == null) {
                return null;
            }
            Object t = JSON.parseObject((byte[])bytes, tt, (Feature[])new Feature[0]);
            return (T)t;
        }
        catch (Throwable e) {
            log.error("json\u89e3\u6790\u5931\u8d25:\r\n{}", (Object)bytes);
            throw new RuntimeException(e);
        }
    }

    public static String toFormatedJson(Object bean) {
        try {
            return JSON.toJSONString((Object)bean, (SerializeConfig)mapping, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.PrettyFormat});
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static String toJSONEnumNoUsingName(Object bean) {
        int features = SerializerFeature.config((int)JSON.DEFAULT_GENERATE_FEATURE, (SerializerFeature)SerializerFeature.WriteEnumUsingName, (boolean)false);
        return JSONObject.toJSONString((Object)bean, (int)features, (SerializerFeature[])new SerializerFeature[0]);
    }

    public static String toJSONString(Object bean, SerializerFeature serializerFeature) {
        return JSONObject.toJSONString((Object)bean, (SerializeConfig)mapping, (SerializerFeature[])new SerializerFeature[]{serializerFeature});
    }

    public static String toJSONString(Object bean) {
        try {
            return JSON.toJSONString((Object)bean, (SerializeConfig)mapping, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static String toJSONString(Object bean, SerializeFilter serializeFilter) {
        try {
            if (serializeFilter != null) {
                return JSON.toJSONString((Object)bean, (SerializeConfig)mapping, (SerializeFilter)serializeFilter, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
            }
            return JSON.toJSONString((Object)bean, (SerializeConfig)mapping, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] toJsonBytes(Object bean) {
        return JSON.toJSONBytes((Object)bean, (SerializeConfig)mapping, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
    }

    public static byte[] toJSONBytesEnumNoUsingName(Object bean) {
        int features = SerializerFeature.config((int)JSON.DEFAULT_GENERATE_FEATURE, (SerializerFeature)SerializerFeature.WriteEnumUsingName, (boolean)false);
        return JSONObject.toJSONBytes((Object)bean, (int)features, (SerializerFeature[])new SerializerFeature[0]);
    }

    public static <T> List<T> toArray(List<String> datas, Class<T> clazz) {
        if (datas == null) {
            return null;
        }
        ArrayList<T> result = new ArrayList<T>();
        for (String obj : datas) {
            result.add(JsonKit.toBean(obj, clazz));
        }
        return result;
    }

    static {
        mapping.put(Date.class, (ObjectSerializer)new SimpleDateFormatSerializer("yyyy-MM-dd HH:mm:ss"));
        mapping.put(java.sql.Date.class, (ObjectSerializer)new SimpleDateFormatSerializer("yyyy-MM-dd HH:mm:ss"));
        mapping.put(Timestamp.class, (ObjectSerializer)new SimpleDateFormatSerializer("yyyy-MM-dd HH:mm:ss"));
        mapping.put(Time.class, (ObjectSerializer)new SimpleDateFormatSerializer("HH:mm:ss"));
    }
}

