/*
 * Decompiled with CFR 0.152.
 */
package org.jim.common.utils;

import cn.hutool.core.bean.BeanUtil;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jim.common.ImPacket;
import org.jim.common.ImStatus;
import org.jim.common.http.HttpProtocol;
import org.jim.common.packets.Command;
import org.jim.common.packets.Group;
import org.jim.common.packets.RespBody;
import org.jim.common.packets.User;
import org.jim.common.protocol.AbProtocol;
import org.jim.common.protocol.IConvertProtocolPacket;
import org.jim.common.protocol.IProtocol;
import org.jim.common.tcp.TcpProtocol;
import org.jim.common.utils.JsonKit;
import org.jim.common.ws.WsProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;

public class ImKit {
    private static Logger logger = LoggerFactory.getLogger(ImKit.class);
    private static Map<String, AbProtocol> protocols = new HashMap<String, AbProtocol>();

    public static ImPacket ConvertRespPacket(RespBody respBody, ChannelContext channelContext) {
        ImPacket respPacket = null;
        if (respBody == null) {
            return respPacket;
        }
        try {
            byte[] body = respBody.toString().getBytes("utf-8");
            respPacket = ImKit.ConvertRespPacket(body, respBody.getCommand(), channelContext);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return respPacket;
    }

    public static ImPacket ConvertRespPacket(byte[] body, Command command, ChannelContext channelContext) {
        ImPacket respPacket = null;
        IConvertProtocolPacket convertor = (IConvertProtocolPacket)channelContext.getAttribute("convertor");
        if (convertor != null) {
            return convertor.RespPacket(body, command, channelContext);
        }
        for (Map.Entry<String, AbProtocol> entry : protocols.entrySet()) {
            AbProtocol protocol = entry.getValue();
            IConvertProtocolPacket convertorObj = protocol.getConvertor();
            respPacket = convertorObj.RespPacket(body, command, channelContext);
            if (respPacket == null) continue;
            channelContext.setAttribute("convertor", (Object)convertorObj);
            return respPacket;
        }
        return respPacket;
    }

    public static ImPacket ConvertRespPacket(ImPacket imPacket, Command command, ChannelContext channelContext) {
        ImPacket respPacket = ImKit.ConvertRespPacket(imPacket.getBody(), command, channelContext);
        if (respPacket == null) {
            for (Map.Entry<String, AbProtocol> entry : protocols.entrySet()) {
                AbProtocol protocol = entry.getValue();
                try {
                    IConvertProtocolPacket convertorObj;
                    boolean isProtocol = protocol.isProtocol(imPacket, channelContext);
                    if (!isProtocol || (respPacket = (convertorObj = protocol.getConvertor()).RespPacket(imPacket.getBody(), command, channelContext)) == null) continue;
                    channelContext.setAttribute("convertor", (Object)convertorObj);
                    return respPacket;
                }
                catch (Throwable e) {
                    logger.error(e.toString());
                }
            }
        }
        return respPacket;
    }

    public static IProtocol protocol(ByteBuffer byteBuffer, ChannelContext channelContext) {
        for (Map.Entry<String, AbProtocol> entry : protocols.entrySet()) {
            AbProtocol protocol = entry.getValue();
            try {
                boolean isPrototol = protocol.isProtocol(byteBuffer, channelContext);
                if (!isPrototol) continue;
                return protocol;
            }
            catch (Throwable e) {
                logger.error(e.toString(), e);
            }
        }
        return null;
    }

    public static byte[] toImStatusBody(ImStatus status) {
        return JsonKit.toJsonBytes(new RespBody().setCode(status.getCode()).setMsg(status.getDescription() + " " + status.getText()));
    }

    public static Map<String, AbProtocol> getProtocols() {
        return protocols;
    }

    public static User copyUserWithoutFriendsGroups(User source) {
        if (source == null) {
            return null;
        }
        User user = new User();
        BeanUtil.copyProperties((Object)source, (Object)user, (String[])new String[]{"friends", "groups"});
        return user;
    }

    public static User copyUserWithoutUsers(User source) {
        List<Group> groups;
        if (source == null) {
            return null;
        }
        User user = new User();
        BeanUtil.copyProperties((Object)source, (Object)user, (String[])new String[]{"friends", "groups"});
        List<Group> friends = source.getFriends();
        if (friends != null && !friends.isEmpty()) {
            ArrayList<Group> newFriends = new ArrayList<Group>();
            for (Group friend : friends) {
                Group newFriend = new Group();
                BeanUtil.copyProperties((Object)friend, (Object)newFriend);
                newFriend.setUsers(null);
                newFriends.add(newFriend);
            }
            user.setFriends(newFriends);
        }
        if ((groups = source.getGroups()) != null && !groups.isEmpty()) {
            ArrayList<Group> newGroups = new ArrayList<Group>();
            for (Group group : newGroups) {
                Group newGroup = new Group();
                BeanUtil.copyProperties((Object)group, (Object)newGroup);
                newGroup.setUsers(null);
                newGroups.add(newGroup);
            }
            user.setGroups(newGroups);
        }
        return user;
    }

    public static Group copyGroupWithoutUsers(Group source) {
        if (source == null) {
            return null;
        }
        Group group = new Group();
        BeanUtil.copyProperties((Object)source, (Object)group, (String[])new String[]{"users"});
        return group;
    }

    static {
        WsProtocol wsProtocol = new WsProtocol();
        TcpProtocol tcpProtocol = new TcpProtocol();
        HttpProtocol httpProtocol = new HttpProtocol();
        protocols.put(wsProtocol.name(), wsProtocol);
        protocols.put(tcpProtocol.name(), tcpProtocol);
        protocols.put(httpProtocol.name(), httpProtocol);
    }
}

