/*
 * Decompiled with CFR 0.152.
 */
package org.jim.common.utils;

import org.apache.log4j.Logger;
import org.jim.common.ImAio;
import org.jim.common.ImConfig;
import org.jim.common.ImPacket;
import org.jim.common.ImSessionContext;
import org.jim.common.ImStatus;
import org.jim.common.packets.ChatBody;
import org.jim.common.packets.Command;
import org.jim.common.packets.RespBody;
import org.jim.common.packets.User;
import org.jim.common.session.id.impl.UUIDSessionIdGenerator;
import org.jim.common.utils.ImKit;
import org.jim.common.utils.JsonKit;
import org.jim.common.utils.Md5;
import org.tio.core.ChannelContext;
import org.tio.utils.lock.SetWithLock;

public class ChatKit {
    private static Logger log = Logger.getLogger(ChatKit.class);

    public static ChatBody toChatBody(byte[] body, ChannelContext channelContext) {
        ChatBody chatReqBody = ChatKit.parseChatBody(body);
        if (chatReqBody != null && (chatReqBody.getFrom() == null || "".equals(chatReqBody.getFrom()))) {
            ImSessionContext imSessionContext = (ImSessionContext)channelContext.getAttribute();
            User user = imSessionContext.getClient().getUser();
            if (user != null) {
                chatReqBody.setFrom(user.getNick());
            } else {
                chatReqBody.setFrom(channelContext.getId());
            }
        }
        return chatReqBody;
    }

    private static ChatBody parseChatBody(byte[] body) {
        if (body == null) {
            return null;
        }
        ChatBody chatReqBody = null;
        try {
            String text = new String(body, "utf-8");
            chatReqBody = JsonKit.toBean(text, ChatBody.class);
            if (chatReqBody != null) {
                if (chatReqBody.getCreateTime() == null || "".equals(chatReqBody.getCreateTime())) {
                    chatReqBody.setCreateTime(System.currentTimeMillis());
                }
                chatReqBody.setId(UUIDSessionIdGenerator.instance.sessionId(null));
                return chatReqBody;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return chatReqBody;
    }

    public static ChatBody parseChatBody(String bodyStr) {
        if (bodyStr == null) {
            return null;
        }
        try {
            return ChatKit.parseChatBody(bodyStr.getBytes("utf-8"));
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
    }

    public static ImPacket dataInCorrectRespPacket(ChannelContext channelContext) throws Exception {
        RespBody chatDataInCorrectRespPacket = new RespBody(Command.COMMAND_CHAT_RESP, ImStatus.C10002);
        ImPacket respPacket = ImKit.ConvertRespPacket(chatDataInCorrectRespPacket, channelContext);
        respPacket.setStatus(ImStatus.C10002);
        return respPacket;
    }

    public static ImPacket sendSuccessRespPacket(ChannelContext channelContext) throws Exception {
        RespBody chatDataInCorrectRespPacket = new RespBody(Command.COMMAND_CHAT_RESP, ImStatus.C10000);
        ImPacket respPacket = ImKit.ConvertRespPacket(chatDataInCorrectRespPacket, channelContext);
        respPacket.setStatus(ImStatus.C10000);
        return respPacket;
    }

    public static ImPacket offlineRespPacket(ChannelContext channelContext) throws Exception {
        RespBody chatDataInCorrectRespPacket = new RespBody(Command.COMMAND_CHAT_RESP, ImStatus.C10001);
        ImPacket respPacket = ImKit.ConvertRespPacket(chatDataInCorrectRespPacket, channelContext);
        respPacket.setStatus(ImStatus.C10001);
        return respPacket;
    }

    public static boolean isOnline(String userid) {
        boolean isStore = "on".equals(ImConfig.isStore);
        if (isStore) {
            return ImConfig.getMessageHelper().isOnline(userid);
        }
        SetWithLock<ChannelContext> toChannleContexts = ImAio.getChannelContextsByUserid(userid);
        return toChannleContexts != null && toChannleContexts.size() > 0;
    }

    public static String sessionId(String from, String to) {
        String sessionId = "";
        try {
            boolean isequal;
            byte[] fbytes = from.getBytes("utf-8");
            byte[] tbytes = to.getBytes("utf-8");
            boolean isfmax = fbytes.length > tbytes.length;
            boolean bl = isequal = fbytes.length == tbytes.length;
            if (isfmax) {
                for (int i = 0; i < fbytes.length; ++i) {
                    for (int j = 0; j < tbytes.length; ++j) {
                        fbytes[i] = (byte)(fbytes[i] ^ tbytes[j]);
                    }
                }
                sessionId = new String(fbytes);
            } else if (isequal) {
                for (int i = 0; i < fbytes.length; ++i) {
                    fbytes[i] = (byte)(fbytes[i] ^ tbytes[i]);
                }
                sessionId = new String(fbytes);
            } else {
                for (int i = 0; i < tbytes.length; ++i) {
                    for (int j = 0; j < fbytes.length; ++j) {
                        tbytes[i] = (byte)(tbytes[i] ^ fbytes[j]);
                    }
                }
                sessionId = new String(tbytes);
            }
        }
        catch (Exception e) {
            log.error((Object)e.toString(), (Throwable)e);
        }
        return Md5.getMD5(sessionId);
    }
}

