/*
 * Decompiled with CFR 0.152.
 */
package org.jim.common.utils;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferUtil {
    private static Logger log = LoggerFactory.getLogger(BufferUtil.class);
    private static final ThreadLocal<Calendar> localCalendar = new ThreadLocal();

    public static byte read(ByteBuffer buffer) {
        return buffer.get();
    }

    public static int readUB2(ByteBuffer buffer) {
        int ret = buffer.get() & 0xFF;
        return ret |= (buffer.get() & 0xFF) << 8;
    }

    public static int readUB3(ByteBuffer buffer) {
        int ret = buffer.get() & 0xFF;
        ret |= (buffer.get() & 0xFF) << 8;
        return ret |= (buffer.get() & 0xFF) << 16;
    }

    public static long readUB4(ByteBuffer buffer) {
        long ret = buffer.get() & 0xFF;
        ret |= (long)(buffer.get() & 0xFF) << 8;
        ret |= (long)(buffer.get() & 0xFF) << 16;
        return ret |= (long)(buffer.get() & 0xFF) << 24;
    }

    public static int readInt(ByteBuffer buffer) {
        int i = buffer.get() & 0xFF;
        i |= (buffer.get() & 0xFF) << 8;
        i |= (buffer.get() & 0xFF) << 16;
        return i |= (buffer.get() & 0xFF) << 24;
    }

    public static float readFloat(ByteBuffer buffer) {
        return Float.intBitsToFloat(BufferUtil.readInt(buffer));
    }

    public static long readLong(ByteBuffer buffer) {
        return buffer.getLong();
    }

    public static double readDouble(ByteBuffer buffer) {
        return buffer.getDouble();
    }

    public static String readString(ByteBuffer buffer) {
        return BufferUtil.readString(buffer, null);
    }

    public static String readString(ByteBuffer buffer, String charset) {
        if (!buffer.hasRemaining()) {
            return null;
        }
        int length = buffer.limit() - buffer.position();
        String s = BufferUtil.readString(buffer, length, charset);
        return s;
    }

    public static String readStringWithNull(ByteBuffer buffer, String charset) {
        if (!buffer.hasRemaining()) {
            return null;
        }
        int offset = -1;
        int position = buffer.position();
        int length = buffer.limit();
        boolean needPlus1 = true;
        for (int i = position; i < length; ++i) {
            if (buffer.get(i) != 0) continue;
            offset = i;
            break;
        }
        if (offset == -1) {
            needPlus1 = false;
            offset = buffer.limit();
        }
        if (offset > position) {
            int bytelength = offset - buffer.position();
            String s = BufferUtil.readString(buffer, bytelength, charset);
            if (needPlus1) {
                buffer.position(buffer.position() + 1);
            }
            return s;
        }
        buffer.position(buffer.position() + 1);
        return null;
    }

    public static String readString(ByteBuffer buffer, int length, String charset) {
        int bytelength = length;
        byte[] dst = new byte[bytelength];
        buffer.get(dst, 0, bytelength);
        String s = null;
        if (charset != null) {
            try {
                s = new String(dst, charset);
            }
            catch (UnsupportedEncodingException e) {
                log.error(e.toString(), (Throwable)e);
                s = new String(dst);
            }
        } else {
            s = new String(dst);
        }
        return s;
    }

    public static String readStringWithNull(ByteBuffer buffer) {
        return BufferUtil.readStringWithNull(buffer, null);
    }

    public static Time readTime(ByteBuffer buffer) {
        BufferUtil.move(6, buffer);
        byte hour = BufferUtil.read(buffer);
        byte minute = BufferUtil.read(buffer);
        byte second = BufferUtil.read(buffer);
        Calendar cal = BufferUtil.getLocalCalendar();
        cal.set(0, 0, 0, hour, minute, second);
        return new Time(cal.getTimeInMillis());
    }

    public static Date readDate(ByteBuffer buffer) {
        byte length = BufferUtil.read(buffer);
        int year = BufferUtil.readUB2(buffer);
        byte month = BufferUtil.read(buffer);
        byte date = BufferUtil.read(buffer);
        byte hour = BufferUtil.read(buffer);
        byte minute = BufferUtil.read(buffer);
        byte second = BufferUtil.read(buffer);
        if (length == 11) {
            long nanos = BufferUtil.readUB4(buffer);
            Calendar cal = BufferUtil.getLocalCalendar();
            month = (byte)(month - 1);
            cal.set(year, month, date, hour, minute, second);
            Timestamp time = new Timestamp(cal.getTimeInMillis());
            time.setNanos((int)nanos);
            return time;
        }
        Calendar cal = BufferUtil.getLocalCalendar();
        month = (byte)(month - 1);
        cal.set(year, month, date, hour, minute, second);
        return new java.sql.Date(cal.getTimeInMillis());
    }

    public static void move(int i, ByteBuffer buffer) {
        buffer.position(buffer.position() + i);
    }

    public static void position(int i, ByteBuffer buffer) {
        buffer.position(i);
    }

    public static final void writeUB2(ByteBuffer buffer, int i) {
        buffer.put((byte)(i & 0xFF));
        buffer.put((byte)(i >>> 8));
    }

    public static final void writeUB3(ByteBuffer buffer, int i) {
        buffer.put((byte)(i & 0xFF));
        buffer.put((byte)(i >>> 8));
        buffer.put((byte)(i >>> 16));
    }

    public static final void writeInt(ByteBuffer buffer, int i) {
        buffer.put((byte)(i & 0xFF));
        buffer.put((byte)(i >>> 8));
        buffer.put((byte)(i >>> 16));
        buffer.put((byte)(i >>> 24));
    }

    public static final void writeFloat(ByteBuffer buffer, float f) {
        BufferUtil.writeInt(buffer, Float.floatToIntBits(f));
    }

    public static final void writeUB4(ByteBuffer buffer, long l) {
        buffer.put((byte)(l & 0xFFL));
        buffer.put((byte)(l >>> 8));
        buffer.put((byte)(l >>> 16));
        buffer.put((byte)(l >>> 24));
    }

    public static final void writeLong(ByteBuffer buffer, long l) {
        buffer.put((byte)(l & 0xFFL));
        buffer.put((byte)(l >>> 8));
        buffer.put((byte)(l >>> 16));
        buffer.put((byte)(l >>> 24));
        buffer.put((byte)(l >>> 32));
        buffer.put((byte)(l >>> 40));
        buffer.put((byte)(l >>> 48));
        buffer.put((byte)(l >>> 56));
    }

    public static final void writeDouble(ByteBuffer buffer, double d) {
        BufferUtil.writeLong(buffer, Double.doubleToLongBits(d));
    }

    public static final void writeLength(ByteBuffer buffer, long l) {
        if (l < 251L) {
            buffer.put((byte)l);
        } else if (l < 65536L) {
            buffer.put((byte)-4);
            BufferUtil.writeUB2(buffer, (int)l);
        } else if (l < 0x1000000L) {
            buffer.put((byte)-3);
            BufferUtil.writeUB3(buffer, (int)l);
        } else {
            buffer.put((byte)-2);
            BufferUtil.writeLong(buffer, l);
        }
    }

    public static final void writeWithNull(ByteBuffer buffer, byte[] src) {
        buffer.put(src);
        buffer.put((byte)0);
    }

    public static final void writeWithLength(ByteBuffer buffer, byte[] src) {
        int length = src.length;
        if (length < 251) {
            buffer.put((byte)length);
        } else if ((long)length < 65536L) {
            buffer.put((byte)-4);
            BufferUtil.writeUB2(buffer, length);
        } else if ((long)length < 0x1000000L) {
            buffer.put((byte)-3);
            BufferUtil.writeUB3(buffer, length);
        } else {
            buffer.put((byte)-2);
            BufferUtil.writeLong(buffer, length);
        }
        buffer.put(src);
    }

    public static final void writeWithLength(ByteBuffer buffer, byte[] src, byte nullValue) {
        if (src == null) {
            buffer.put(nullValue);
        } else {
            BufferUtil.writeWithLength(buffer, src);
        }
    }

    public static final int getLength(long length) {
        if (length < 251L) {
            return 1;
        }
        if (length < 65536L) {
            return 3;
        }
        if (length < 0x1000000L) {
            return 4;
        }
        return 9;
    }

    public static final int getLength(byte[] src) {
        int length = src.length;
        if (length < 251) {
            return 1 + length;
        }
        if ((long)length < 65536L) {
            return 3 + length;
        }
        if ((long)length < 0x1000000L) {
            return 4 + length;
        }
        return 9 + length;
    }

    private static final Calendar getLocalCalendar() {
        Calendar cal = localCalendar.get();
        if (cal == null) {
            cal = Calendar.getInstance();
            localCalendar.set(cal);
        }
        return cal;
    }
}

