/*
 * Decompiled with CFR 0.152.
 */
package org.jim.common.packets;

import org.jim.common.utils.DynamicEnumUtil;

public enum Command {
    COMMAND_UNKNOW(0),
    COMMAND_HANDSHAKE_REQ(1),
    COMMAND_HANDSHAKE_RESP(2),
    COMMAND_AUTH_REQ(3),
    COMMAND_AUTH_RESP(4),
    COMMAND_LOGIN_REQ(5),
    COMMAND_LOGIN_RESP(6),
    COMMAND_JOIN_GROUP_REQ(7),
    COMMAND_JOIN_GROUP_RESP(8),
    COMMAND_JOIN_GROUP_NOTIFY_RESP(9),
    COMMAND_EXIT_GROUP_NOTIFY_RESP(10),
    COMMAND_CHAT_REQ(11),
    COMMAND_CHAT_RESP(12),
    COMMAND_HEARTBEAT_REQ(13),
    COMMAND_CLOSE_REQ(14),
    COMMAND_CANCEL_MSG_REQ(15),
    COMMAND_CANCEL_MSG_RESP(16),
    COMMAND_GET_USER_REQ(17),
    COMMAND_GET_USER_RESP(18),
    COMMAND_GET_MESSAGE_REQ(19),
    COMMAND_GET_MESSAGE_RESP(20);

    private final int value;

    public final int getNumber() {
        return this.value;
    }

    public static Command valueOf(int value) {
        return Command.forNumber(value);
    }

    public static Command forNumber(int value) {
        for (Command command : Command.values()) {
            if (command.getNumber() != value) continue;
            return command;
        }
        return null;
    }

    public static Command addAndGet(String name, int value) {
        return DynamicEnumUtil.addEnum(Command.class, name, new Class[]{Integer.TYPE}, new Object[]{value});
    }

    private Command(int value) {
        this.value = value;
    }
}

