/*
 * Decompiled with CFR 0.152.
 */
package org.jim.common.cluster.redis;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.jim.common.ImAio;
import org.jim.common.ImPacket;
import org.jim.common.cluster.ImClusterConfig;
import org.jim.common.cluster.ImClusterVo;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.redisson.api.listener.MessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.Aio;
import org.tio.core.GroupContext;
import org.tio.core.intf.Packet;
import org.tio.utils.json.Json;

public class RedisClusterConfig
extends ImClusterConfig {
    private static Logger log = LoggerFactory.getLogger(RedisClusterConfig.class);
    public static final String IM_CLUSTER_TOPIC = "JIM_CLUSTER";
    private String topicSuffix;
    private String topic;
    private RedissonClient redisson;
    public RTopic<ImClusterVo> rtopic;
    public static final AtomicLong RECEIVED_TOPIC_COUNT = new AtomicLong();

    public static RedisClusterConfig newInstance(String topicSuffix, RedissonClient redisson, final GroupContext groupContext) {
        if (redisson == null) {
            throw new RuntimeException(RedissonClient.class.getSimpleName() + "\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (groupContext == null) {
            throw new RuntimeException("GroupContext\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        final RedisClusterConfig me = new RedisClusterConfig(topicSuffix, redisson, groupContext);
        me.rtopic = redisson.getTopic(me.topic);
        me.rtopic.addListener((MessageListener)new MessageListener<ImClusterVo>(){

            public void onMessage(String channel, ImClusterVo imClusterVo) {
                String ip;
                String token;
                String userid;
                String group;
                log.info("\u6536\u5230topic:{}, count:{}, ImClusterVo:{}", new Object[]{channel, RECEIVED_TOPIC_COUNT.incrementAndGet(), Json.toJson((Object)imClusterVo)});
                String clientid = imClusterVo.getClientId();
                if (StringUtils.isBlank((CharSequence)clientid)) {
                    log.error("clientid is null");
                    return;
                }
                if (Objects.equals(ImClusterVo.CLIENTID, clientid)) {
                    log.info("\u81ea\u5df1\u53d1\u5e03\u7684\u6d88\u606f\uff0c\u5ffd\u7565\u6389,{}", (Object)clientid);
                    return;
                }
                ImPacket packet = imClusterVo.getPacket();
                if (packet == null) {
                    log.error("packet is null");
                    return;
                }
                packet.setFromCluster(true);
                boolean isToAll = imClusterVo.isToAll();
                if (isToAll) {
                    Aio.sendToAll((GroupContext)groupContext, (Packet)packet);
                }
                if (StringUtils.isNotBlank((CharSequence)(group = imClusterVo.getGroup()))) {
                    ImAio.sendToGroup(group, packet);
                }
                if (StringUtils.isNotBlank((CharSequence)(userid = imClusterVo.getUserid()))) {
                    ImAio.sendToUser(userid, packet);
                }
                if (StringUtils.isNotBlank((CharSequence)(token = imClusterVo.getToken()))) {
                    Aio.sendToToken((GroupContext)me.groupContext, (String)token, (Packet)packet);
                }
                if (StringUtils.isNotBlank((CharSequence)(ip = imClusterVo.getIp()))) {
                    ImAio.sendToIp(me.groupContext, ip, packet);
                }
            }
        });
        return me;
    }

    private RedisClusterConfig(String topicSuffix, RedissonClient redisson, GroupContext groupContext) {
        this.setTopicSuffix(topicSuffix);
        this.setRedisson(redisson);
        this.groupContext = groupContext;
    }

    public String getTopicSuffix() {
        return this.topicSuffix;
    }

    public void setTopicSuffix(String topicSuffix) {
        this.topicSuffix = topicSuffix;
        this.topic = topicSuffix + IM_CLUSTER_TOPIC;
    }

    public String getTopic() {
        return this.topic;
    }

    public void publishAsyn(ImClusterVo imClusterVo) {
        this.rtopic.publishAsync((Object)imClusterVo);
    }

    public void publish(ImClusterVo imClusterVo) {
        this.rtopic.publish((Object)imClusterVo);
    }

    public RedissonClient getRedisson() {
        return this.redisson;
    }

    public void setRedisson(RedissonClient redisson) {
        this.redisson = redisson;
    }

    @Override
    public void send(ImClusterVo imClusterVo) {
        this.rtopic.publish((Object)imClusterVo);
    }

    @Override
    public void sendAsyn(ImClusterVo imClusterVo) {
        this.rtopic.publishAsync((Object)imClusterVo);
    }
}

