/*
 * Decompiled with CFR 0.152.
 */
package org.jim.common.cache.redis;

import org.apache.commons.lang3.StringUtils;
import org.jim.common.cache.redis.JedisSubscriber;
import org.jim.common.cache.redis.JedisTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPubSub;

public class SubRunnable
implements Runnable {
    Logger log = LoggerFactory.getLogger(SubRunnable.class);
    private String subChannel = null;
    private Jedis jedis = null;
    private JedisSubscriber subscriber = new JedisSubscriber();

    public SubRunnable(String subChannel) {
        if (StringUtils.isEmpty((CharSequence)subChannel)) {
            throw new RuntimeException("chanel\u901a\u9053\u5f02\u5e38!");
        }
        this.subChannel = subChannel;
    }

    @Override
    public void run() {
        this.log.debug("\u8ba2\u9605 redis , chanel {} , \u7ebf\u7a0b\u5c06\u963b\u585e", (Object)this.subChannel);
        while (true) {
            try {
                this.jedis = JedisTemplate.me().getJedis();
                if (this.jedis == null) continue;
                this.jedis.subscribe((JedisPubSub)this.subscriber, new String[]{this.subChannel});
                continue;
            }
            catch (Exception e) {
                this.log.error(e.toString(), (Throwable)e);
                this.log.error("\u8ba2\u9605\u7ebf\u7a0b\u5f02\u5e38,\u91cd\u65b0\u83b7\u53d6\u8ba2\u9605\u5ba2\u6237\u7aef\u8fde\u63a5...");
                continue;
            }
            finally {
                try {
                    JedisTemplate.me().close(this.jedis);
                }
                catch (Exception e) {
                    this.log.error(e.toString(), (Throwable)e);
                }
                continue;
            }
            break;
        }
    }
}

