/*
 * Decompiled with CFR 0.152.
 */
package org.jim.common.cache.redis;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import org.jim.common.cache.redis.ExpireVo;
import org.jim.common.cache.redis.JedisTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisExpireUpdateTask {
    private static Logger log = LoggerFactory.getLogger(RedisExpireUpdateTask.class);
    private static boolean started = false;
    private static LinkedBlockingQueue<ExpireVo> redisExpireVoQueue = new LinkedBlockingQueue();

    public static void add(String cacheName, String key, Serializable value, long expire) {
        ExpireVo expireVo = new ExpireVo(cacheName, key, value, expire);
        redisExpireVoQueue.offer(expireVo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start() {
        if (started) {
            return;
        }
        Class<RedisExpireUpdateTask> clazz = RedisExpireUpdateTask.class;
        synchronized (RedisExpireUpdateTask.class) {
            if (started) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            started = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            new Thread(new Runnable(){

                @Override
                public void run() {
                    ArrayList<JedisTemplate.PairEx<String, Void, Integer>> l2Datas = new ArrayList<JedisTemplate.PairEx<String, Void, Integer>>();
                    int count = 0;
                    block4: while (true) {
                        try {
                            while (true) {
                                ExpireVo expireVo;
                                if ((expireVo = (ExpireVo)redisExpireVoQueue.poll()) != null) {
                                    l2Datas.add(JedisTemplate.me().makePairEx(expireVo.getKey(), null, Integer.parseInt(expireVo.getExpire() + "")));
                                    ++count;
                                }
                                if (count > 0 && expireVo == null) {
                                    log.debug("\u6279\u91cf\u66f4\u65b0\u7f13\u5b58\u8fc7\u671f\u65f6\u95f4,\u66f4\u65b0\u6570\u91cf:" + l2Datas.size());
                                    JedisTemplate.me().batchSetExpire(l2Datas);
                                    l2Datas.clear();
                                    count = 0;
                                    continue;
                                }
                                if (count != 0 || expireVo != null) continue;
                                try {
                                    Thread.sleep(5000L);
                                    continue block4;
                                }
                                catch (InterruptedException e) {
                                    log.error(e.toString(), (Throwable)e);
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (Throwable e) {
                            log.error(e.getMessage(), e);
                            continue;
                        }
                        break;
                    }
                }
            }, RedisExpireUpdateTask.class.getName()).start();
            return;
        }
    }

    private RedisExpireUpdateTask() {
    }
}

