/*
 * Decompiled with CFR 0.152.
 */
package org.jim.common.cache.redis;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jim.common.cache.ICache;
import org.jim.common.cache.redis.JedisTemplate;
import org.jim.common.cache.redis.RedisExpireUpdateTask;
import org.jim.common.utils.JsonKit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.utils.SystemTimer;

public class RedisCache
implements ICache {
    private Logger log = LoggerFactory.getLogger(RedisCache.class);
    private String cacheName = null;
    private Integer timeToLiveSeconds = null;
    private Integer timeToIdleSeconds = null;
    private Integer timeout = null;

    public static String cacheKey(String cacheName, String key) {
        return RedisCache.keyPrefix(cacheName) + key;
    }

    public static String keyPrefix(String cacheName) {
        return cacheName + ":";
    }

    public static void main(String[] args) {
    }

    public RedisCache(String cacheName, Integer timeToLiveSeconds, Integer timeToIdleSeconds) {
        this.cacheName = cacheName;
        this.timeToLiveSeconds = timeToLiveSeconds;
        this.timeToIdleSeconds = timeToIdleSeconds;
        this.timeout = this.timeToLiveSeconds == null ? this.timeToIdleSeconds : this.timeToLiveSeconds;
    }

    @Override
    public void clear() {
        long start = SystemTimer.currentTimeMillis();
        try {
            JedisTemplate.me().delKeysLike(RedisCache.keyPrefix(this.cacheName));
        }
        catch (Exception e) {
            this.log.error(e.toString(), (Throwable)e);
        }
        long end = SystemTimer.currentTimeMillis();
        long iv = end - start;
        this.log.info("clear cache {}, cost {}ms", (Object)this.cacheName, (Object)iv);
    }

    @Override
    public Serializable get(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        Serializable value = null;
        try {
            value = JedisTemplate.me().get(RedisCache.cacheKey(this.cacheName, key), Serializable.class);
            if (this.timeToIdleSeconds != null && value != null) {
                RedisExpireUpdateTask.add(this.cacheName, key, value, this.timeout.intValue());
            }
        }
        catch (Exception e) {
            this.log.error(e.toString(), (Throwable)e);
        }
        return value;
    }

    @Override
    public <T> T get(String key, Class<T> clazz) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        T value = null;
        try {
            value = JedisTemplate.me().get(RedisCache.cacheKey(this.cacheName, key), clazz);
            if (this.timeToIdleSeconds != null && value != null) {
                RedisExpireUpdateTask.add(this.cacheName, key, (Serializable)value, this.timeout.intValue());
            }
        }
        catch (Exception e) {
            this.log.error(e.toString(), (Throwable)e);
        }
        return value;
    }

    @Override
    public Collection<String> keys() {
        try {
            return JedisTemplate.me().keys(RedisCache.keyPrefix(this.cacheName));
        }
        catch (Exception e) {
            this.log.error(e.toString(), (Throwable)e);
            return null;
        }
    }

    @Override
    public void put(String key, Serializable value) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        try {
            JedisTemplate.me().set(RedisCache.cacheKey(this.cacheName, key), value, Integer.parseInt(this.timeout + ""));
        }
        catch (Exception e) {
            this.log.error(e.toString(), (Throwable)e);
        }
    }

    public void putAll(List<JedisTemplate.Pair<String, Serializable>> values) {
        if (values == null || values.size() < 1) {
            return;
        }
        int expire = Integer.parseInt(this.timeout + "");
        try {
            ArrayList<JedisTemplate.PairEx<String, String, Integer>> pairDatas = new ArrayList<JedisTemplate.PairEx<String, String, Integer>>();
            for (JedisTemplate.Pair<String, Serializable> pair : values) {
                pairDatas.add(JedisTemplate.me().makePairEx(RedisCache.cacheKey(this.cacheName, pair.getKey()), JsonKit.toJSONString(pair.getValue()), expire));
            }
            JedisTemplate.me().batchSetStringEx(pairDatas);
        }
        catch (Exception e) {
            this.log.error(e.toString(), (Throwable)e);
        }
    }

    public void listPushTail(String key, Serializable value) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        try {
            String jsonValue = value instanceof String ? (String)((Object)value) : JsonKit.toJSONString(value);
            JedisTemplate.me().listPushTail(RedisCache.cacheKey(this.cacheName, key), jsonValue);
        }
        catch (Exception e) {
            this.log.error(e.toString(), (Throwable)e);
        }
    }

    public List<String> listGetAll(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        try {
            return JedisTemplate.me().listGetAll(RedisCache.cacheKey(this.cacheName, key));
        }
        catch (Exception e) {
            this.log.error(e.toString(), (Throwable)e);
            return null;
        }
    }

    public Long listRemove(String key, String value) {
        if (StringUtils.isBlank((CharSequence)key) || StringUtils.isBlank((CharSequence)value)) {
            return 0L;
        }
        try {
            return JedisTemplate.me().listRemove(RedisCache.cacheKey(this.cacheName, key), 0, value);
        }
        catch (Exception e) {
            this.log.error(e.toString(), (Throwable)e);
            return 0L;
        }
    }

    public void sortSetPush(String key, double score, Serializable value) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        try {
            String jsonValue = value instanceof String ? (String)((Object)value) : JsonKit.toJSONString(value);
            JedisTemplate.me().sortSetPush(RedisCache.cacheKey(this.cacheName, key), score, jsonValue);
        }
        catch (Exception e) {
            this.log.error(e.toString(), (Throwable)e);
        }
    }

    public List<String> sortSetGetAll(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        try {
            Set<String> datas = JedisTemplate.me().sorSetRangeByScore(RedisCache.cacheKey(this.cacheName, key), Double.MIN_VALUE, Double.MAX_VALUE);
            if (datas == null) {
                return null;
            }
            return new ArrayList<String>(datas);
        }
        catch (Exception e) {
            this.log.error(e.toString(), (Throwable)e);
            return null;
        }
    }

    public List<String> sortSetGetAll(String key, double min, double max) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        try {
            Set<String> datas = JedisTemplate.me().sorSetRangeByScore(RedisCache.cacheKey(this.cacheName, key), min, max);
            if (datas == null) {
                return null;
            }
            return new ArrayList<String>(datas);
        }
        catch (Exception e) {
            this.log.error(e.toString(), (Throwable)e);
            return null;
        }
    }

    public List<String> sortSetGetAll(String key, double min, double max, int offset, int count) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        try {
            Set<String> datas = JedisTemplate.me().sorSetRangeByScore(RedisCache.cacheKey(this.cacheName, key), min, max, offset, count);
            if (datas == null) {
                return null;
            }
            return new ArrayList<String>(datas);
        }
        catch (Exception e) {
            this.log.error(e.toString(), (Throwable)e);
            return null;
        }
    }

    @Override
    public void putTemporary(String key, Serializable value) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        try {
            JedisTemplate.me().set(RedisCache.cacheKey(this.cacheName, key), value, 10);
        }
        catch (Exception e) {
            this.log.error(e.toString(), (Throwable)e);
        }
    }

    @Override
    public void remove(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        try {
            JedisTemplate.me().delKey(RedisCache.cacheKey(this.cacheName, key));
        }
        catch (Exception e) {
            this.log.error(e.toString(), (Throwable)e);
        }
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public Integer getTimeToIdleSeconds() {
        return this.timeToIdleSeconds;
    }

    public Integer getTimeToLiveSeconds() {
        return this.timeToLiveSeconds;
    }
}

