/*
 * Decompiled with CFR 0.152.
 */
package org.jim.common.cache.redis;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.jim.common.cache.CacheChangeType;
import org.jim.common.cache.CacheChangedVo;
import org.jim.common.cache.caffeineredis.CaffeineRedisCache;
import org.jim.common.cache.caffeineredis.CaffeineRedisCacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisPubSub;

public class JedisSubscriber
extends JedisPubSub {
    private static Logger log = LoggerFactory.getLogger(JedisSubscriber.class);

    public void onMessage(String channel, String message) {
        log.debug(String.format("\u63a5\u6536\u5230redis\u53d1\u5e03\u7684\u6d88\u606f,chanel %s,message %s", channel, message));
        String[] cacheChanges = message.split(":");
        String cacheName = cacheChanges[0];
        String key = cacheChanges[1];
        CacheChangeType type = CacheChangeType.from(Integer.valueOf(cacheChanges[2]));
        String clientid = cacheChanges[3];
        if (StringUtils.isBlank((CharSequence)clientid)) {
            log.error("clientid is null");
            return;
        }
        if (Objects.equals(CacheChangedVo.CLIENTID, clientid)) {
            log.debug("\u81ea\u5df1\u53d1\u5e03\u7684\u6d88\u606f,{}", (Object)clientid);
            return;
        }
        CaffeineRedisCache caffeineRedisCache = CaffeineRedisCacheManager.getCache(cacheName);
        if (caffeineRedisCache == null) {
            log.debug("\u4e0d\u80fd\u6839\u636ecacheName[{}]\u627e\u5230CaffeineRedisCache\u5bf9\u8c61", (Object)cacheName);
            return;
        }
        if (type == CacheChangeType.PUT || type == CacheChangeType.UPDATE || type == CacheChangeType.REMOVE) {
            caffeineRedisCache.getCaffeineCache().remove(key);
        } else if (type == CacheChangeType.CLEAR) {
            caffeineRedisCache.getCaffeineCache().clear();
        }
    }

    public void onSubscribe(String channel, int subscribedChannels) {
        log.debug("\u8ba2\u9605 redis \u901a\u9053\u6210\u529f, channel {} , subscribedChannels {}", (Object)channel, (Object)subscribedChannels);
    }

    public void onUnsubscribe(String channel, int subscribedChannels) {
        log.debug(String.format("\u53d6\u6d88\u8ba2\u9605 redis\u901a\u9053 , channel %s , subscribeChannels %d", channel, subscribedChannels));
    }
}

