/*
 * Decompiled with CFR 0.152.
 */
package org.jim.common.cache.caffeineredis;

import java.io.Serializable;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.jim.common.cache.CacheChangeType;
import org.jim.common.cache.CacheChangedVo;
import org.jim.common.cache.ICache;
import org.jim.common.cache.IL2Cache;
import org.jim.common.cache.caffeine.CaffeineCache;
import org.jim.common.cache.caffeineredis.CaffeineRedisCacheManager;
import org.jim.common.cache.caffeineredis.RedisL2Vo;
import org.jim.common.cache.redis.JedisTemplate;
import org.jim.common.cache.redis.RedisCache;
import org.jim.common.cache.redis.RedisExpireUpdateTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaffeineRedisCache
implements ICache,
IL2Cache {
    Logger log = LoggerFactory.getLogger(CaffeineRedisCache.class);
    CaffeineCache caffeineCache;
    RedisCache redisCache;
    String cacheName;

    public CaffeineRedisCache() {
    }

    public CaffeineRedisCache(String cacheName, CaffeineCache caffeineCache, RedisCache redisCache) {
        this.cacheName = cacheName;
        this.caffeineCache = caffeineCache;
        this.redisCache = redisCache;
    }

    @Override
    public void clear() {
        try {
            this.caffeineCache.clear();
            this.redisCache.clear();
            CacheChangedVo cacheChangedVo = new CacheChangedVo(this.cacheName, CacheChangeType.CLEAR);
            JedisTemplate.me().publish("REDIS_CACHE_CHANGE_TOPIC_CAFFEINE", cacheChangedVo.toString());
        }
        catch (Exception e) {
            this.log.error(e.toString(), (Throwable)e);
        }
    }

    @Override
    public Serializable get(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        Serializable ret = this.caffeineCache.get(key);
        if (ret == null) {
            ret = this.redisCache.get(key);
            if (ret != null) {
                this.log.debug("Cache L2 (redis) :{}={}", (Object)key, (Object)ret);
                this.caffeineCache.put(key, ret);
            }
        } else {
            this.log.debug("Cache L1 (caffeine) :{}={}", (Object)key, (Object)ret);
            Integer timeToIdleSeconds = this.redisCache.getTimeToIdleSeconds();
            if (timeToIdleSeconds != null) {
                RedisExpireUpdateTask.add(this.cacheName, key, ret, timeToIdleSeconds.intValue());
            }
        }
        return ret;
    }

    @Override
    public Collection<String> keys() {
        return this.redisCache.keys();
    }

    @Override
    public void put(String key, Serializable value) {
        try {
            this.caffeineCache.put(key, value);
            this.redisCache.put(key, value);
            CacheChangedVo cacheChangedVo = new CacheChangedVo(this.cacheName, key, CacheChangeType.PUT);
            JedisTemplate.me().publish("REDIS_CACHE_CHANGE_TOPIC_CAFFEINE", cacheChangedVo.toString());
        }
        catch (Exception e) {
            this.log.error(e.toString(), (Throwable)e);
        }
    }

    @Override
    public void putL2Async(String key, Serializable value) {
        this.caffeineCache.put(key, value);
        CaffeineRedisCacheManager.getAsyncRedisQueue().add(new RedisL2Vo(this.redisCache, key, value));
    }

    @Override
    public void putTemporary(String key, Serializable value) {
        this.caffeineCache.putTemporary(key, value);
        this.redisCache.putTemporary(key, value);
    }

    @Override
    public void remove(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        try {
            this.caffeineCache.remove(key);
            this.redisCache.remove(key);
            CacheChangedVo cacheChangedVo = new CacheChangedVo(this.cacheName, key, CacheChangeType.REMOVE);
            JedisTemplate.me().publish("REDIS_CACHE_CHANGE_TOPIC_CAFFEINE", cacheChangedVo.toString());
        }
        catch (Exception e) {
            this.log.error(e.toString(), (Throwable)e);
        }
    }

    @Override
    public <T> T get(String key, Class<T> clazz) {
        return (T)this.get(key);
    }

    public CaffeineCache getCaffeineCache() {
        return this.caffeineCache;
    }

    public RedisCache getRedisCache() {
        return this.redisCache;
    }
}

