/*
 * Decompiled with CFR 0.152.
 */
package org.jim.common.cache.caffeine;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.RemovalListener;
import java.util.concurrent.TimeUnit;
import org.tio.utils.cache.caffeine.DefaultRemovalListener;

public class CaffeineUtils {
    public static <K, V> LoadingCache<K, V> createLoadingCache(String cacheName, Integer timeToLiveSeconds, Integer timeToIdleSeconds, Integer initialCapacity, Integer maximumSize, boolean recordStats) {
        return CaffeineUtils.createLoadingCache(cacheName, timeToLiveSeconds, timeToIdleSeconds, initialCapacity, maximumSize, recordStats, null);
    }

    public static <K, V> LoadingCache<K, V> createLoadingCache(String cacheName, Integer timeToLiveSeconds, Integer timeToIdleSeconds, Integer initialCapacity, Integer maximumSize, boolean recordStats, RemovalListener<K, V> removalListener) {
        if (removalListener == null) {
            removalListener = new DefaultRemovalListener(cacheName);
        }
        Caffeine cacheBuilder = Caffeine.newBuilder().removalListener(removalListener);
        if (timeToLiveSeconds != null && timeToLiveSeconds > 0) {
            cacheBuilder.expireAfterWrite((long)timeToLiveSeconds.intValue(), TimeUnit.SECONDS);
        }
        if (timeToIdleSeconds != null && timeToIdleSeconds > 0) {
            cacheBuilder.expireAfterAccess((long)timeToIdleSeconds.intValue(), TimeUnit.SECONDS);
        }
        cacheBuilder.initialCapacity(initialCapacity.intValue());
        cacheBuilder.maximumSize((long)maximumSize.intValue());
        if (recordStats) {
            cacheBuilder.recordStats();
        }
        LoadingCache loadingCache = cacheBuilder.build(new CacheLoader<K, V>(){

            public V load(K key) throws Exception {
                return null;
            }
        });
        return loadingCache;
    }

    public static void main(String[] args) throws Exception {
        Integer timeToLiveSeconds = 1;
        Integer timeToIdleSeconds = null;
        Integer initialCapacity = 10;
        Integer maximumSize = 1000;
        boolean recordStats = false;
        LoadingCache loadingCache = CaffeineUtils.createLoadingCache("mycache", timeToLiveSeconds, timeToIdleSeconds, initialCapacity, maximumSize, recordStats);
        loadingCache.put((Object)"1", (Object)"11111");
        TimeUnit.SECONDS.sleep(3L);
        loadingCache.put((Object)"2", (Object)"2222");
        Object o = loadingCache.getIfPresent((Object)"1");
        System.out.println(o);
        o = loadingCache.getIfPresent((Object)"2");
        System.out.println(o);
    }
}

