/*
 * Decompiled with CFR 0.152.
 */
package org.jim.common.cache.caffeine;

import java.util.Properties;

public class CaffeineConfiguration {
    private String cacheName;
    private Integer timeToLiveSeconds = 1800;
    private Integer timeToIdleSeconds = 1800;
    private Integer maximumSize = 5000000;
    private Integer initialCapacity = 10;
    private boolean recordStats = false;

    public CaffeineConfiguration() {
    }

    public CaffeineConfiguration(String cacheName, Properties prop) {
        this.cacheName = cacheName;
        String[] values = prop.getProperty(cacheName, "5000000,1800").split(",");
        this.maximumSize = Integer.valueOf(values[0]);
        if (values.length > 1) {
            this.timeToLiveSeconds = Integer.valueOf(values[1]);
            this.timeToIdleSeconds = Integer.valueOf(values[1]);
        }
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public Integer getTimeToLiveSeconds() {
        return this.timeToLiveSeconds;
    }

    public void setTimeToLiveSeconds(Integer timeToLiveSeconds) {
        this.timeToLiveSeconds = timeToLiveSeconds;
    }

    public Integer getTimeToIdleSeconds() {
        return this.timeToIdleSeconds;
    }

    public void setTimeToIdleSeconds(Integer timeToIdleSeconds) {
        this.timeToIdleSeconds = timeToIdleSeconds;
    }

    public Integer getMaximumSize() {
        return this.maximumSize;
    }

    public void setMaximumSize(Integer maximumSize) {
        this.maximumSize = maximumSize;
    }

    public Integer getInitialCapacity() {
        return this.initialCapacity;
    }

    public void setInitialCapacity(Integer initialCapacity) {
        this.initialCapacity = initialCapacity;
    }

    public boolean isRecordStats() {
        return this.recordStats;
    }

    public void setRecordStats(boolean recordStats) {
        this.recordStats = recordStats;
    }
}

