/*
 * Decompiled with CFR 0.152.
 */
package org.jim.common.cache.caffeine;

import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.RemovalListener;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jim.common.cache.caffeine.CaffeineCache;
import org.jim.common.cache.caffeine.CaffeineConfiguration;
import org.jim.common.cache.caffeine.CaffeineConfigurationFactory;
import org.jim.common.cache.caffeine.CaffeineUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaffeineCacheManager {
    private static Map<String, CaffeineCache> map = new HashMap<String, CaffeineCache>();
    private static Logger log = LoggerFactory.getLogger(CaffeineCacheManager.class);

    private CaffeineCacheManager() {
    }

    public static CaffeineCache getCache(String cacheName, boolean skipNull) {
        CaffeineCache CaffeineCache2 = map.get(cacheName);
        if (CaffeineCache2 == null && !skipNull) {
            log.error("cacheName[{}]\u8fd8\u6ca1\u6ce8\u518c\uff0c\u8bf7\u521d\u59cb\u5316\u65f6\u8c03\u7528\uff1a{}.register(cacheName, timeToLiveSeconds, timeToIdleSeconds)", (Object)cacheName, (Object)CaffeineCache.class.getSimpleName());
        }
        return CaffeineCache2;
    }

    public static CaffeineCache getCache(String cacheName) {
        return CaffeineCacheManager.getCache(cacheName, false);
    }

    public static CaffeineCache register(String cacheName, Integer timeToLiveSeconds, Integer timeToIdleSeconds) {
        CaffeineCache CaffeineCache2 = CaffeineCacheManager.register(cacheName, timeToLiveSeconds, timeToIdleSeconds, 5000000, null);
        return CaffeineCache2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CaffeineCache register(String cacheName, Integer timeToLiveSeconds, Integer timeToIdleSeconds, Integer maximumSize, RemovalListener<String, Serializable> removalListener) {
        CaffeineCache caffeineCache = map.get(cacheName);
        if (caffeineCache != null) return caffeineCache;
        Class<CaffeineCacheManager> clazz = CaffeineCacheManager.class;
        synchronized (CaffeineCacheManager.class) {
            caffeineCache = map.get(cacheName);
            if (caffeineCache != null) return caffeineCache;
            Integer initialCapacity = 10;
            boolean recordStats = false;
            LoadingCache<String, Serializable> loadingCache = CaffeineUtils.createLoadingCache(cacheName, timeToLiveSeconds, timeToIdleSeconds, initialCapacity, maximumSize, recordStats, removalListener);
            LoadingCache<String, Serializable> temporaryLoadingCache = CaffeineUtils.createLoadingCache(cacheName, null, 10, initialCapacity, maximumSize, recordStats, removalListener);
            caffeineCache = new CaffeineCache(loadingCache, temporaryLoadingCache);
            map.put(cacheName, caffeineCache);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return caffeineCache;
        }
    }

    static {
        try {
            List<CaffeineConfiguration> configurations = CaffeineConfigurationFactory.parseConfiguration();
            for (CaffeineConfiguration configuration : configurations) {
                CaffeineCacheManager.register(configuration.getCacheName(), configuration.getTimeToLiveSeconds(), configuration.getTimeToIdleSeconds(), configuration.getMaximumSize(), null);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

