/*
 * Decompiled with CFR 0.152.
 */
package org.jim.common.cache.caffeine;

import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import org.jim.common.cache.ICache;

public class CaffeineCache
implements ICache {
    private LoadingCache<String, Serializable> loadingCache = null;
    private LoadingCache<String, Serializable> temporaryLoadingCache = null;

    public CaffeineCache(LoadingCache<String, Serializable> loadingCache, LoadingCache<String, Serializable> temporaryLoadingCache) {
        this.loadingCache = loadingCache;
        this.temporaryLoadingCache = temporaryLoadingCache;
    }

    @Override
    public void clear() {
        this.loadingCache.invalidateAll();
        this.temporaryLoadingCache.invalidateAll();
    }

    @Override
    public Serializable get(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        Serializable ret = (Serializable)this.loadingCache.getIfPresent((Object)key);
        if (ret == null) {
            ret = (Serializable)this.temporaryLoadingCache.getIfPresent((Object)key);
        }
        return ret;
    }

    @Override
    public Collection<String> keys() {
        ConcurrentMap map = this.loadingCache.asMap();
        return map.keySet();
    }

    @Override
    public void put(String key, Serializable value) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        this.loadingCache.put((Object)key, (Object)value);
    }

    @Override
    public void putTemporary(String key, Serializable value) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        this.temporaryLoadingCache.put((Object)key, (Object)value);
    }

    @Override
    public void remove(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        this.loadingCache.invalidate((Object)key);
        this.temporaryLoadingCache.invalidate((Object)key);
    }

    public ConcurrentMap<String, Serializable> asMap() {
        return this.loadingCache.asMap();
    }

    public long size() {
        return this.loadingCache.estimatedSize();
    }

    @Override
    public <T> T get(String key, Class<T> clazz) {
        return (T)this.get(key);
    }
}

