/*
 * Decompiled with CFR 0.152.
 */
package org.jim.common;

import org.jim.common.Status;
import org.jim.common.packets.Command;
import org.tio.core.intf.Packet;

public class ImPacket
extends Packet {
    private static final long serialVersionUID = 2000118564569232098L;
    protected Status status;
    protected byte[] body;
    private Command command;
    private boolean isFromCluster = false;

    public ImPacket() {
    }

    public ImPacket(byte[] body) {
        this.body = body;
    }

    public ImPacket(Command command, byte[] body) {
        this(body);
        this.setCommand(command);
    }

    public ImPacket(Command command) {
        this(command, null);
    }

    public static byte encodeEncrypt(byte bs, boolean isEncrypt) {
        if (isEncrypt) {
            return (byte)(bs | 0xFFFFFF80);
        }
        return 0;
    }

    public static boolean decodeCompress(byte version) {
        return (0x40 & version) != 0;
    }

    public static byte encodeCompress(byte bs, boolean isCompress) {
        if (isCompress) {
            return (byte)(bs | 0x40);
        }
        return (byte)(bs & 0x3F);
    }

    public static boolean decodeHasSynSeq(byte maskByte) {
        return (0x20 & maskByte) != 0;
    }

    public static byte encodeHasSynSeq(byte bs, boolean hasSynSeq) {
        if (hasSynSeq) {
            return (byte)(bs | 0x20);
        }
        return (byte)(bs & 0x5F);
    }

    public static boolean decode4ByteLength(byte version) {
        return (0x10 & version) != 0;
    }

    public static byte encode4ByteLength(byte bs, boolean is4ByteLength) {
        if (is4ByteLength) {
            return (byte)(bs | 0x10);
        }
        return (byte)(bs & 0x6F);
    }

    public static byte decodeVersion(byte version) {
        return (byte)(0xF & version);
    }

    public int calcHeaderLength(boolean is4byteLength) {
        int ret = 4;
        if (is4byteLength) {
            ret += 2;
        }
        if (this.getSynSeq() > 0) {
            ret += 4;
        }
        return ret;
    }

    public Command getCommand() {
        return this.command;
    }

    public void setCommand(Command type) {
        this.command = type;
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public String logstr() {
        return this.command == null ? Command.COMMAND_UNKNOW.name() : this.command.name();
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public boolean isFromCluster() {
        return this.isFromCluster;
    }

    public void setFromCluster(boolean isFromCluster) {
        this.isFromCluster = isFromCluster;
    }
}

