/*
 * Decompiled with CFR 0.152.
 */
package org.jim.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.StringUtils;
import org.jim.common.ImConfig;
import org.jim.common.ImPacket;
import org.jim.common.ImSessionContext;
import org.jim.common.cluster.ImCluster;
import org.jim.common.listener.ImBindListener;
import org.jim.common.packets.Client;
import org.jim.common.packets.User;
import org.jim.common.utils.ImKit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.Aio;
import org.tio.core.ChannelContext;
import org.tio.core.GroupContext;
import org.tio.core.intf.Packet;
import org.tio.utils.lock.SetWithLock;

public class ImAio {
    private static GroupContext groupContext = ImConfig.groupContext;
    private static Logger log = LoggerFactory.getLogger(ImAio.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static User getUser(String userid) {
        SetWithLock<ChannelContext> userChannelContexts = ImAio.getChannelContextsByUserid(userid);
        if (userChannelContexts == null) {
            return null;
        }
        ReentrantReadWriteLock.ReadLock readLock = userChannelContexts.getLock().readLock();
        readLock.lock();
        try {
            Set userChannels = (Set)userChannelContexts.getObj();
            if (userChannels == null) {
                User user = null;
                return user;
            }
            User user = null;
            for (ChannelContext channelContext : userChannels) {
                ImSessionContext imSessionContext = (ImSessionContext)channelContext.getAttribute();
                Client client = imSessionContext.getClient();
                user = client.getUser();
                if (user == null) continue;
                User user2 = user;
                return user2;
            }
            Iterator iterator = user;
            return iterator;
        }
        finally {
            readLock.unlock();
        }
    }

    public static SetWithLock<ChannelContext> getChannelContextsByUserid(String userid) {
        SetWithLock channelContexts = Aio.getChannelContextsByUserid((GroupContext)groupContext, (String)userid);
        return channelContexts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<User> getAllUser() {
        ArrayList<User> users = new ArrayList<User>();
        SetWithLock allChannels = Aio.getAllChannelContexts((GroupContext)groupContext);
        if (allChannels == null) {
            return users;
        }
        ReentrantReadWriteLock.ReadLock readLock = allChannels.getLock().readLock();
        readLock.lock();
        try {
            Set userChannels = (Set)allChannels.getObj();
            if (userChannels == null) {
                ArrayList<User> arrayList = users;
                return arrayList;
            }
            for (ChannelContext channelContext : userChannels) {
                ImSessionContext imSessionContext = (ImSessionContext)channelContext.getAttribute();
                Client client = imSessionContext.getClient();
                if (client == null || client.getUser() == null) continue;
                User user = ImKit.copyUserWithoutUsers(client.getUser());
                users.add(user);
            }
        }
        finally {
            readLock.unlock();
        }
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<User> getAllOnlineUser() {
        ArrayList<User> users = new ArrayList<User>();
        SetWithLock onlineChannels = Aio.getAllConnectedsChannelContexts((GroupContext)groupContext);
        if (onlineChannels == null) {
            return users;
        }
        ReentrantReadWriteLock.ReadLock readLock = onlineChannels.getLock().readLock();
        readLock.lock();
        try {
            Set userChannels = (Set)onlineChannels.getObj();
            for (ChannelContext channelContext : userChannels) {
                Client client;
                ImSessionContext imSessionContext = (ImSessionContext)channelContext.getAttribute();
                if (imSessionContext == null || (client = imSessionContext.getClient()) == null || client.getUser() == null) continue;
                User user = ImKit.copyUserWithoutUsers(client.getUser());
                users.add(user);
            }
        }
        finally {
            readLock.unlock();
        }
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<User> getAllUserByGroup(String group) {
        SetWithLock withLockChannels = Aio.getChannelContextsByGroup((GroupContext)groupContext, (String)group);
        if (withLockChannels == null) {
            return null;
        }
        ReentrantReadWriteLock.ReadLock readLock = withLockChannels.getLock().readLock();
        readLock.lock();
        try {
            Set channels = (Set)withLockChannels.getObj();
            if (channels != null && channels.size() > 0) {
                ArrayList<User> users = new ArrayList<User>();
                HashMap<String, User> userMaps = new HashMap<String, User>();
                for (ChannelContext channelContext : channels) {
                    String userid = channelContext.getUserid();
                    User user = ImAio.getUser(userid);
                    if (user == null || userMaps.get(userid) != null) continue;
                    userMaps.put(userid, user);
                    users.add(user);
                }
                userMaps = null;
                ArrayList<User> arrayList = users;
                return arrayList;
            }
            List<User> list = null;
            return list;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendToGroup(String group, ImPacket packet) {
        if (packet.getBody() == null) {
            return;
        }
        SetWithLock withLockChannels = Aio.getChannelContextsByGroup((GroupContext)groupContext, (String)group);
        if (withLockChannels == null) {
            ImCluster cluster = ImConfig.cluster;
            if (cluster != null && !packet.isFromCluster()) {
                cluster.clusterToGroup(groupContext, group, packet);
            }
            return;
        }
        ReentrantReadWriteLock.ReadLock readLock = withLockChannels.getLock().readLock();
        readLock.lock();
        try {
            Set channels = (Set)withLockChannels.getObj();
            if (channels != null && channels.size() > 0) {
                for (ChannelContext channelContext : channels) {
                    ImAio.send(channelContext, packet);
                }
            }
        }
        finally {
            readLock.unlock();
            ImCluster cluster = ImConfig.cluster;
            if (cluster != null && !packet.isFromCluster()) {
                cluster.clusterToGroup(groupContext, group, packet);
            }
        }
    }

    public static boolean send(ChannelContext channelContext, ImPacket packet) {
        if (channelContext == null) {
            return false;
        }
        ImPacket rspPacket = ImKit.ConvertRespPacket(packet, packet.getCommand(), channelContext);
        if (rspPacket == null) {
            log.error("\u8f6c\u6362\u534f\u8bae\u5305\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u534f\u8bae\uff01");
            return false;
        }
        rspPacket.setSynSeq(packet.getSynSeq());
        if (groupContext == null) {
            groupContext = channelContext.getGroupContext();
        }
        return ImAio.sendToId(channelContext.getId(), rspPacket);
    }

    public static Boolean sendToId(String channelId, ImPacket packet) {
        ImCluster cluster;
        ChannelContext channelContext = Aio.getChannelContextById((GroupContext)groupContext, (String)channelId);
        if (channelContext == null && (cluster = ImConfig.cluster) != null && !packet.isFromCluster()) {
            cluster.clusterToChannelId(groupContext, channelId, packet);
        }
        return Aio.sendToId((GroupContext)groupContext, (String)channelId, (Packet)packet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendToUser(String userid, ImPacket packet) {
        if (StringUtils.isEmpty((CharSequence)userid)) {
            return;
        }
        SetWithLock<ChannelContext> toChannleContexts = ImAio.getChannelContextsByUserid(userid);
        if (toChannleContexts == null || toChannleContexts.size() < 1) {
            ImCluster cluster = ImConfig.cluster;
            if (cluster != null && !packet.isFromCluster()) {
                cluster.clusterToUser(groupContext, userid, packet);
            }
            return;
        }
        ReentrantReadWriteLock.ReadLock readLock = toChannleContexts.getLock().readLock();
        readLock.lock();
        try {
            Set channels = (Set)toChannleContexts.getObj();
            for (ChannelContext channelContext : channels) {
                ImAio.send(channelContext, packet);
            }
        }
        finally {
            readLock.unlock();
            ImCluster cluster = ImConfig.cluster;
            if (cluster != null && !packet.isFromCluster()) {
                cluster.clusterToUser(groupContext, userid, packet);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendToIp(GroupContext groupContext, String ip, ImPacket packet) {
        try {
            Aio.sendToIp((GroupContext)groupContext, (String)ip, (Packet)packet, null);
        }
        finally {
            ImCluster cluster = ImConfig.cluster;
            if (cluster != null && !packet.isFromCluster()) {
                cluster.clusterToIp(groupContext, ip, packet);
            }
        }
    }

    public static void bindUser(ChannelContext channelContext, String userid) {
        ImAio.bindUser(channelContext, userid, null);
    }

    public static void bindUser(ChannelContext channelContext, String userid, ImBindListener bindListener) {
        Aio.bindUser((ChannelContext)channelContext, (String)userid);
        if (bindListener != null) {
            try {
                bindListener.onAfterUserBind(channelContext, userid);
            }
            catch (Exception e) {
                log.error(e.toString(), (Throwable)e);
            }
        }
    }

    public static void unbindUser(String userid) {
        ImAio.unbindUser(userid, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unbindUser(String userid, ImBindListener bindListener) {
        Aio.unbindUser((GroupContext)groupContext, (String)userid);
        if (bindListener != null) {
            try {
                SetWithLock<ChannelContext> userChannelContexts = ImAio.getChannelContextsByUserid(userid);
                if (userChannelContexts == null || userChannelContexts.size() == 0) {
                    return;
                }
                ReentrantReadWriteLock.ReadLock readLock = userChannelContexts.getLock().readLock();
                readLock.lock();
                try {
                    Set channels = (Set)userChannelContexts.getObj();
                    for (ChannelContext channelContext : channels) {
                        bindListener.onAfterUserBind(channelContext, userid);
                    }
                }
                finally {
                    readLock.unlock();
                }
            }
            catch (Exception e) {
                log.error(e.toString(), (Throwable)e);
            }
        }
    }

    public static void bindGroup(ChannelContext channelContext, String group) {
        ImAio.bindGroup(channelContext, group, null);
    }

    public static void bindGroup(ChannelContext channelContext, String group, ImBindListener bindListener) {
        Aio.bindGroup((ChannelContext)channelContext, (String)group);
        if (bindListener != null) {
            try {
                bindListener.onAfterGroupBind(channelContext, group);
            }
            catch (Exception e) {
                log.error(e.toString(), (Throwable)e);
            }
        }
    }

    public static void unbindGroup(String userid, String group) {
        ImAio.unbindGroup(userid, group, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unbindGroup(String userid, String group, ImBindListener bindListener) {
        SetWithLock<ChannelContext> userChannelContexts = ImAio.getChannelContextsByUserid(userid);
        if (userChannelContexts == null || userChannelContexts.size() == 0) {
            return;
        }
        ReentrantReadWriteLock.ReadLock readLock = userChannelContexts.getLock().readLock();
        readLock.lock();
        try {
            Set channels = (Set)userChannelContexts.getObj();
            for (ChannelContext channelContext : channels) {
                Aio.unbindGroup((String)group, (ChannelContext)channelContext);
                if (bindListener == null) continue;
                try {
                    bindListener.onAfterGroupUnbind(channelContext, group);
                }
                catch (Exception e) {
                    log.error(e.toString(), (Throwable)e);
                }
            }
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(String userid, String remark) {
        SetWithLock<ChannelContext> userChannelContexts = ImAio.getChannelContextsByUserid(userid);
        if (userChannelContexts != null && userChannelContexts.size() > 0) {
            ReentrantReadWriteLock.ReadLock readLock = userChannelContexts.getLock().readLock();
            readLock.lock();
            try {
                Set channels = (Set)userChannelContexts.getObj();
                for (ChannelContext channelContext : channels) {
                    ImAio.remove(channelContext, remark);
                }
            }
            finally {
                readLock.unlock();
            }
        }
    }

    public static void remove(ChannelContext channelContext, String remark) {
        Aio.remove((ChannelContext)channelContext, (String)remark);
    }
}

