/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.base;

import org.infinispan.commands.AbstractVisitor;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.NAMED_CACHE)
public abstract class CommandInterceptor
extends AbstractVisitor {
    private CommandInterceptor next;
    protected Configuration cacheConfiguration;
    private static final Log log = LogFactory.getLog(CommandInterceptor.class);

    protected Log getLog() {
        return log;
    }

    @Inject
    public void injectConfiguration(Configuration configuration) {
        this.cacheConfiguration = configuration;
    }

    public final CommandInterceptor getNext() {
        return this.next;
    }

    public final boolean hasNext() {
        return this.getNext() != null;
    }

    public final void setNext(CommandInterceptor next) {
        this.next = next;
    }

    public final Object invokeNextInterceptor(InvocationContext ctx, VisitableCommand command) throws Throwable {
        return command.acceptVisitor(ctx, this.next);
    }

    @Override
    protected Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
        return this.invokeNextInterceptor(ctx, command);
    }

    protected final long getLockAcquisitionTimeout(FlagAffectedCommand command, boolean skipLocking) {
        if (!skipLocking) {
            return command.hasFlag(Flag.ZERO_LOCK_ACQUISITION_TIMEOUT) ? 0L : this.cacheConfiguration.locking().lockAcquisitionTimeout();
        }
        return -1L;
    }

    protected final boolean hasSkipLocking(FlagAffectedCommand command) {
        return command.hasFlag(Flag.SKIP_LOCKING);
    }
}

