/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.concurrent.TimeUnit;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.LockingConfiguration;
import org.infinispan.configuration.cache.VersioningScheme;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class LockingConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<LockingConfiguration> {
    private static final Log log = LogFactory.getLog(LockingConfigurationBuilder.class);
    private int concurrencyLevel = 32;
    private IsolationLevel isolationLevel = IsolationLevel.READ_COMMITTED;
    private long lockAcquisitionTimeout = TimeUnit.SECONDS.toMillis(10L);
    private boolean useLockStriping = false;
    private boolean writeSkewCheck = false;

    protected LockingConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    public LockingConfigurationBuilder concurrencyLevel(int i) {
        this.concurrencyLevel = i;
        return this;
    }

    public LockingConfigurationBuilder isolationLevel(IsolationLevel isolationLevel) {
        this.isolationLevel = isolationLevel;
        return this;
    }

    public LockingConfigurationBuilder supportsConcurrentUpdates(boolean itDoes) {
        if (!itDoes) {
            log.warnConcurrentUpdateSupportCannotBeConfigured();
        }
        return this;
    }

    public LockingConfigurationBuilder lockAcquisitionTimeout(long l) {
        this.lockAcquisitionTimeout = l;
        return this;
    }

    public LockingConfigurationBuilder lockAcquisitionTimeout(long l, TimeUnit unit) {
        return this.lockAcquisitionTimeout(unit.toMillis(l));
    }

    public LockingConfigurationBuilder useLockStriping(boolean b) {
        this.useLockStriping = b;
        return this;
    }

    public LockingConfigurationBuilder writeSkewCheck(boolean b) {
        this.writeSkewCheck = b;
        return this;
    }

    public void validate() {
        if (this.writeSkewCheck) {
            if (this.isolationLevel != IsolationLevel.REPEATABLE_READ) {
                throw new CacheConfigurationException("Write-skew checking only allowed with REPEATABLE_READ isolation level for cache");
            }
            if (this.transaction().lockingMode != LockingMode.OPTIMISTIC) {
                throw new CacheConfigurationException("Write-skew checking only allowed with OPTIMISTIC transactions");
            }
            if (!this.versioning().enabled || this.versioning().scheme != VersioningScheme.SIMPLE) {
                throw new CacheConfigurationException("Write-skew checking requires versioning to be enabled and versioning scheme 'SIMPLE' to be configured");
            }
            if (this.clustering().cacheMode() != CacheMode.DIST_SYNC && this.clustering().cacheMode() != CacheMode.REPL_SYNC && this.clustering().cacheMode() != CacheMode.LOCAL) {
                throw new CacheConfigurationException("Write-skew checking is only supported in REPL_SYNC, DIST_SYNC and LOCAL modes.  " + (Object)((Object)this.clustering().cacheMode()) + " cannot be used with write-skew checking");
            }
        }
        if (this.getBuilder().clustering().cacheMode().isClustered() && this.isolationLevel == IsolationLevel.NONE) {
            this.isolationLevel = IsolationLevel.READ_COMMITTED;
        }
        if (this.isolationLevel == IsolationLevel.READ_UNCOMMITTED) {
            this.isolationLevel = IsolationLevel.READ_COMMITTED;
        }
        if (this.isolationLevel == IsolationLevel.SERIALIZABLE) {
            this.isolationLevel = IsolationLevel.REPEATABLE_READ;
        }
    }

    public LockingConfiguration create() {
        return new LockingConfiguration(this.concurrencyLevel, this.isolationLevel, this.lockAcquisitionTimeout, this.useLockStriping, this.writeSkewCheck);
    }

    public LockingConfigurationBuilder read(LockingConfiguration template) {
        this.concurrencyLevel = template.concurrencyLevel();
        this.isolationLevel = template.isolationLevel();
        this.lockAcquisitionTimeout = template.lockAcquisitionTimeout();
        this.useLockStriping = template.useLockStriping();
        this.writeSkewCheck = template.writeSkewCheck();
        return this;
    }

    public String toString() {
        return "LockingConfigurationBuilder{concurrencyLevel=" + this.concurrencyLevel + ", isolationLevel=" + (Object)((Object)this.isolationLevel) + ", lockAcquisitionTimeout=" + this.lockAcquisitionTimeout + ", useLockStriping=" + this.useLockStriping + ", writeSkewCheck=" + this.writeSkewCheck + '}';
    }
}

