/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.tree;

import com.icesoft.faces.component.tree.IceUserObject;
import java.util.HashMap;
import java.util.Map;
import javax.faces.model.DataModel;
import javax.faces.model.DataModelEvent;
import javax.faces.model.DataModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;

public class TreeDataModel
extends DataModel {
    private int rowIndex = -1;
    private TreeModel treeModel;
    private Map rowIndexMap;
    private int childCount = -1;
    private int treeNodeRowIndex = -1;

    public TreeDataModel() {
        this(null);
    }

    public TreeDataModel(TreeModel treeModel) {
        this.setWrappedData(treeModel);
        this.rowIndexMap = new HashMap();
        this.setChildCount();
    }

    public boolean isRowAvailable() {
        if (this.treeModel == null) {
            return false;
        }
        return this.rowIndex >= 0 && this.rowIndex < this.childCount;
    }

    public int getRowCount() {
        return this.childCount;
    }

    private int setChildCount(DefaultMutableTreeNode treeNode) {
        int count = treeNode.getChildCount();
        for (int i = 0; i < count; ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)treeNode.getChildAt(i);
            ((IceUserObject)child.getUserObject()).setRowIndex(this.treeNodeRowIndex++);
            this.addNodeToMap(child, ((IceUserObject)child.getUserObject()).getRowIndex());
            if (!((IceUserObject)child.getUserObject()).isExpanded()) continue;
            this.childCount += treeNode.getChildCount();
            this.setChildCount(child);
        }
        return this.childCount;
    }

    private void setChildCount() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.treeModel.getRoot();
        this.rowIndexMap.clear();
        this.treeNodeRowIndex = 0;
        this.childCount = 1;
        ((IceUserObject)root.getUserObject()).setRowIndex(this.treeNodeRowIndex++);
        this.addNodeToMap(root, ((IceUserObject)root.getUserObject()).getRowIndex());
        if (((IceUserObject)root.getUserObject()).isExpanded()) {
            this.childCount += root.getChildCount();
        }
    }

    private void addNodeToMap(DefaultMutableTreeNode node, int treeNodeRowIndex) {
        this.rowIndexMap.put(new Integer(treeNodeRowIndex), node);
    }

    public Object getRowData() {
        if (this.treeModel == null) {
            return null;
        }
        if (!this.isRowAvailable()) {
            throw new IllegalArgumentException();
        }
        return this.rowIndexMap.get(new Integer(this.rowIndex));
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(int rowIndex) {
        if (rowIndex < -1) {
            throw new IllegalArgumentException();
        }
        int old = this.rowIndex;
        this.rowIndex = rowIndex;
        if (this.treeModel == null) {
            return;
        }
        DataModelListener[] listeners = this.getDataModelListeners();
        if (old != this.rowIndex && listeners != null) {
            Object rowData = null;
            if (this.isRowAvailable()) {
                rowData = this.getRowData();
            }
            DataModelEvent event = new DataModelEvent((DataModel)this, this.rowIndex, rowData);
            int n = listeners.length;
            for (int i = 0; i < n; ++i) {
                if (null == listeners[i]) continue;
                listeners[i].rowSelected(event);
            }
        }
    }

    public Object getWrappedData() {
        return this.treeModel;
    }

    public void setWrappedData(Object data) {
        if (data == null) {
            this.treeModel = null;
            this.setRowIndex(-1);
        } else {
            this.treeModel = (TreeModel)data;
            this.rowIndex = -1;
            this.setRowIndex(0);
        }
    }
}

