/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.cyberneko.filters;

import java.util.Locale;
import org.htmlunit.cyberneko.HTMLConfiguration;
import org.htmlunit.cyberneko.filters.DefaultFilter;
import org.htmlunit.cyberneko.xerces.xni.Augmentations;
import org.htmlunit.cyberneko.xerces.xni.NamespaceContext;
import org.htmlunit.cyberneko.xerces.xni.QName;
import org.htmlunit.cyberneko.xerces.xni.XMLAttributes;
import org.htmlunit.cyberneko.xerces.xni.XMLLocator;
import org.htmlunit.cyberneko.xerces.xni.XNIException;
import org.htmlunit.cyberneko.xerces.xni.parser.XMLComponentManager;
import org.htmlunit.cyberneko.xerces.xni.parser.XMLConfigurationException;

public class NamespaceBinder
extends DefaultFilter {
    public static final String XHTML_1_0_URI = "http://www.w3.org/1999/xhtml";
    public static final String XML_URI = "http://www.w3.org/XML/1998/namespace";
    public static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";
    private static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    private static final String OVERRIDE_NAMESPACES = "http://cyberneko.org/html/features/override-namespaces";
    private static final String INSERT_NAMESPACES = "http://cyberneko.org/html/features/insert-namespaces";
    private static final String[] RECOGNIZED_FEATURES = new String[]{"http://xml.org/sax/features/namespaces", "http://cyberneko.org/html/features/override-namespaces", "http://cyberneko.org/html/features/insert-namespaces"};
    private static final Boolean[] FEATURE_DEFAULTS = new Boolean[]{null, Boolean.FALSE, Boolean.FALSE};
    private static final String NAMES_ELEMS = "http://cyberneko.org/html/properties/names/elems";
    private static final String NAMESPACES_URI = "http://cyberneko.org/html/properties/namespaces-uri";
    private static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://cyberneko.org/html/properties/names/elems", "http://cyberneko.org/html/properties/namespaces-uri"};
    private static final Object[] PROPERTY_DEFAULTS = new Object[]{null, "http://www.w3.org/1999/xhtml"};
    private static final short NAMES_NO_CHANGE = 0;
    private static final short NAMES_UPPERCASE = 1;
    private static final short NAMES_LOWERCASE = 2;
    private boolean namespaces_;
    private boolean overrideNamespaces_;
    private boolean insertNamespaces_;
    private short namesElems_;
    private String namespacesURI_;
    private final NamespaceSupport namespaceContext_ = new NamespaceSupport();
    private final QName qName_ = new QName();
    private final HTMLConfiguration htmlConfiguration_;

    public NamespaceBinder(HTMLConfiguration htmlConfiguration) {
        this.htmlConfiguration_ = htmlConfiguration;
    }

    @Override
    public String[] getRecognizedFeatures() {
        return NamespaceBinder.merge(super.getRecognizedFeatures(), RECOGNIZED_FEATURES);
    }

    @Override
    public Boolean getFeatureDefault(String featureId) {
        for (int i = 0; i < RECOGNIZED_FEATURES.length; ++i) {
            if (!RECOGNIZED_FEATURES[i].equals(featureId)) continue;
            return FEATURE_DEFAULTS[i];
        }
        return super.getFeatureDefault(featureId);
    }

    @Override
    public String[] getRecognizedProperties() {
        return NamespaceBinder.merge(super.getRecognizedProperties(), RECOGNIZED_PROPERTIES);
    }

    @Override
    public Object getPropertyDefault(String propertyId) {
        for (int i = 0; i < RECOGNIZED_PROPERTIES.length; ++i) {
            if (!RECOGNIZED_PROPERTIES[i].equals(propertyId)) continue;
            return PROPERTY_DEFAULTS[i];
        }
        return super.getPropertyDefault(propertyId);
    }

    @Override
    public void reset(XMLComponentManager manager) throws XMLConfigurationException {
        super.reset(manager);
        this.namespaces_ = manager.getFeature(NAMESPACES);
        this.overrideNamespaces_ = manager.getFeature(OVERRIDE_NAMESPACES);
        this.insertNamespaces_ = manager.getFeature(INSERT_NAMESPACES);
        this.namesElems_ = NamespaceBinder.getNamesValue(String.valueOf(manager.getProperty(NAMES_ELEMS)));
        this.namespacesURI_ = String.valueOf(manager.getProperty(NAMESPACES_URI));
        this.namespaceContext_.reset();
    }

    @Override
    public void startDocument(XMLLocator locator, String encoding, NamespaceContext nscontext, Augmentations augs) throws XNIException {
        super.startDocument(locator, encoding, this.namespaceContext_, augs);
    }

    @Override
    public void startElement(QName element, XMLAttributes attrs, Augmentations augs) throws XNIException {
        if (this.namespaces_) {
            this.namespaceContext_.pushContext();
            this.bindNamespaces(element, attrs);
        }
        super.startElement(element, attrs, augs);
    }

    @Override
    public void emptyElement(QName element, XMLAttributes attrs, Augmentations augs) throws XNIException {
        if (this.namespaces_) {
            this.namespaceContext_.pushContext();
            this.bindNamespaces(element, attrs);
        }
        super.emptyElement(element, attrs, augs);
        if (this.namespaces_) {
            this.namespaceContext_.popContext();
        }
    }

    @Override
    public void endElement(QName element, Augmentations augs) throws XNIException {
        if (this.namespaces_) {
            this.bindNamespaces(element, null);
        }
        super.endElement(element, augs);
        if (this.namespaces_) {
            this.namespaceContext_.popContext();
        }
    }

    protected static short getNamesValue(String value) {
        if ("lower".equals(value)) {
            return 2;
        }
        if ("upper".equals(value)) {
            return 1;
        }
        return 0;
    }

    protected static String modifyName(String name, short mode) {
        switch (mode) {
            case 1: {
                return name.toUpperCase(Locale.ROOT);
            }
            case 2: {
                return name.toLowerCase(Locale.ROOT);
            }
        }
        return name;
    }

    protected void bindNamespaces(QName element, XMLAttributes attrs) {
        int i;
        int attrCount;
        element.splitQName();
        if (attrs != null) {
            attrCount = attrs.getLength();
            for (i = attrCount - 1; i >= 0; --i) {
                String uri;
                String prefix;
                attrs.getName(i, this.qName_);
                String rawname = this.qName_.getRawname();
                String rawnameUC = rawname.toLowerCase(Locale.ROOT);
                if (!"xmlns".equals(rawnameUC) && !rawnameUC.startsWith("xmlns:")) continue;
                int anamelen = rawname.length();
                String aprefix = anamelen > 5 ? rawname.substring(0, 5) : null;
                String alocal = anamelen > 5 ? rawname.substring(6) : rawname;
                String avalue = attrs.getValue(i);
                if (anamelen > 5) {
                    aprefix = NamespaceBinder.modifyName(aprefix, (short)2);
                    alocal = NamespaceBinder.modifyName(alocal, this.namesElems_);
                    rawname = aprefix + ':' + alocal;
                    prefix = alocal;
                } else {
                    rawname = alocal = NamespaceBinder.modifyName(alocal, (short)2);
                    prefix = "";
                }
                this.qName_.setValues(aprefix, alocal, rawname, null);
                attrs.setName(i, this.qName_);
                String string = uri = avalue.length() > 0 ? avalue : null;
                if (this.overrideNamespaces_ && prefix.equals(element.getPrefix()) && this.htmlConfiguration_.getHtmlElements().getElement(element.getLocalpart(), null) != null) {
                    uri = this.namespacesURI_;
                }
                this.namespaceContext_.declarePrefix(prefix, uri);
            }
        }
        element.setUri(this.namespaceContext_.getURI(element.getPrefix() != null ? element.getPrefix() : ""));
        if (element.getUri() != null && element.getPrefix() == null) {
            element.setPrefix("");
        }
        if (this.insertNamespaces_ && attrs != null && this.htmlConfiguration_.getHtmlElements().getElement(element.getLocalpart(), null) != null && (element.getPrefix() == null || this.namespaceContext_.getURI(element.getPrefix()) == null)) {
            String xmlns = "xmlns" + (element.getPrefix() != null ? ":" + element.getPrefix() : "");
            this.qName_.setValues(null, xmlns, xmlns, null);
            attrs.addAttribute(this.qName_, "CDATA", this.namespacesURI_);
            this.bindNamespaces(element, attrs);
            return;
        }
        if (attrs != null) {
            attrCount = attrs.getLength();
            for (i = 0; i < attrCount; ++i) {
                String prefix;
                QName qName = attrs.getName(i).splitQName();
                String string = !"xmlns".equals(qName.getRawname()) ? (qName.getPrefix() != null ? qName.getPrefix() : "") : (prefix = "xmlns");
                if (prefix.length() > 0) {
                    qName.setUri("xml".equals(prefix) ? XML_URI : this.namespaceContext_.getURI(prefix));
                }
                if (qName.getUri() != null || !"xmlns".equals(prefix)) continue;
                qName.setUri(XMLNS_URI);
            }
        }
    }

    public static class NamespaceSupport
    implements NamespaceContext {
        private int top_ = 0;
        private int[] levels_ = new int[10];
        private Entry[] entries_ = new Entry[10];

        public NamespaceSupport() {
            this.pushContext();
            this.declarePrefix("xml", NamespaceBinder.XML_URI);
            this.declarePrefix("xmlns", NamespaceBinder.XMLNS_URI);
        }

        @Override
        public String getURI(String prefix) {
            for (int i = this.levels_[this.top_] - 1; i >= 0; --i) {
                Entry entry = this.entries_[i];
                if (!entry.prefix_.equals(prefix)) continue;
                return entry.uri_;
            }
            return null;
        }

        @Override
        public int getDeclaredPrefixCount() {
            return this.levels_[this.top_] - this.levels_[this.top_ - 1];
        }

        @Override
        public String getDeclaredPrefixAt(int index) {
            return this.entries_[this.levels_[this.top_ - 1] + index].prefix_;
        }

        public NamespaceContext getParentContext() {
            return this;
        }

        @Override
        public void reset() {
            this.top_ = 1;
            this.levels_[1] = this.levels_[this.top_ - 1];
        }

        @Override
        public void pushContext() {
            if (++this.top_ == this.levels_.length) {
                int[] iarray = new int[this.levels_.length + 10];
                System.arraycopy(this.levels_, 0, iarray, 0, this.levels_.length);
                this.levels_ = iarray;
            }
            this.levels_[this.top_] = this.levels_[this.top_ - 1];
        }

        @Override
        public void popContext() {
            if (this.top_ > 1) {
                --this.top_;
            }
        }

        @Override
        public boolean declarePrefix(String prefix, String uri) {
            int count = this.getDeclaredPrefixCount();
            for (int i = 0; i < count; ++i) {
                String dprefix = this.getDeclaredPrefixAt(i);
                if (!dprefix.equals(prefix)) continue;
                return false;
            }
            Entry entry = new Entry(prefix, uri);
            if (this.levels_[this.top_] == this.entries_.length) {
                Entry[] earray = new Entry[this.entries_.length + 10];
                System.arraycopy(this.entries_, 0, earray, 0, this.entries_.length);
                this.entries_ = earray;
            }
            int n = this.top_;
            int n2 = this.levels_[n];
            this.levels_[n] = n2 + 1;
            this.entries_[n2] = entry;
            return true;
        }

        static final class Entry {
            public final String prefix_;
            public final String uri_;

            Entry(String prefix, String uri) {
                this.prefix_ = prefix;
                this.uri_ = uri;
            }
        }
    }
}

