/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.xpath.xml.dtm.ref;

import java.util.ArrayList;
import javax.xml.transform.Source;
import org.htmlunit.xpath.res.XPATHMessages;
import org.htmlunit.xpath.xml.dtm.Axis;
import org.htmlunit.xpath.xml.dtm.DTMAxisIterator;
import org.htmlunit.xpath.xml.dtm.DTMAxisTraverser;
import org.htmlunit.xpath.xml.dtm.DTMManager;
import org.htmlunit.xpath.xml.dtm.ref.DTMAxisIteratorBase;
import org.htmlunit.xpath.xml.dtm.ref.DTMDefaultBaseTraversers;

public abstract class DTMDefaultBaseIterators
extends DTMDefaultBaseTraversers {
    public DTMDefaultBaseIterators(DTMManager mgr, Source source, int dtmIdentity, boolean doIndexing) {
        super(mgr, source, dtmIdentity, doIndexing);
    }

    @Override
    public DTMAxisIterator getAxisIterator(int axis) {
        DTMAxisIterator iterator;
        switch (axis) {
            case 13: {
                iterator = new SingletonIterator();
                break;
            }
            case 3: {
                iterator = new ChildrenIterator();
                break;
            }
            case 10: {
                return new ParentIterator();
            }
            case 0: {
                return new AncestorIterator();
            }
            case 1: {
                return new AncestorIterator().includeSelf();
            }
            case 2: {
                return new AttributeIterator();
            }
            case 4: {
                iterator = new DescendantIterator();
                break;
            }
            case 5: {
                iterator = new DescendantIterator().includeSelf();
                break;
            }
            case 6: {
                iterator = new FollowingIterator();
                break;
            }
            case 11: {
                iterator = new PrecedingIterator();
                break;
            }
            case 7: {
                iterator = new FollowingSiblingIterator();
                break;
            }
            case 12: {
                iterator = new PrecedingSiblingIterator();
                break;
            }
            case 9: {
                iterator = new NamespaceIterator();
                break;
            }
            case 19: {
                iterator = new RootIterator();
                break;
            }
            default: {
                throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_ITERATOR_AXIS_NOT_IMPLEMENTED", new Object[]{Axis.getNames(axis)}));
            }
        }
        return iterator;
    }

    public class SingletonIterator
    extends InternalAxisIteratorBase {
        private final boolean _isConstant;

        public SingletonIterator() {
            this(Integer.MIN_VALUE, false);
        }

        public SingletonIterator(int node, boolean constant) {
            this._currentNode = this._startNode = node;
            this._isConstant = constant;
        }

        @Override
        public void setStartNode(int node) {
            if (node == 0) {
                node = DTMDefaultBaseIterators.this.getDocument();
            }
            if (this._isConstant) {
                this._currentNode = this._startNode;
                this.resetPosition();
            } else if (this._isRestartable) {
                this._currentNode = this._startNode = node;
                this.resetPosition();
            }
        }

        @Override
        public void reset() {
            if (this._isConstant) {
                this._currentNode = this._startNode;
                this.resetPosition();
            } else {
                boolean temp = this._isRestartable;
                this._isRestartable = true;
                this.setStartNode(this._startNode);
                this._isRestartable = temp;
            }
        }

        @Override
        public int next() {
            int result = this._currentNode;
            this._currentNode = -1;
            return this.returnNode(result);
        }
    }

    public class DescendantIterator
    extends InternalAxisIteratorBase {
        @Override
        public void setStartNode(int node) {
            if (node == 0) {
                node = DTMDefaultBaseIterators.this.getDocument();
            }
            if (this._isRestartable) {
                node = DTMDefaultBaseIterators.this.makeNodeIdentity(node);
                this._startNode = node--;
                if (this._includeSelf) {
                    // empty if block
                }
                this._currentNode = node;
                this.resetPosition();
            }
        }

        protected boolean isDescendant(int identity) {
            return DTMDefaultBaseIterators.this._parent(identity) >= this._startNode || this._startNode == identity;
        }

        @Override
        public int next() {
            short type;
            if (this._startNode == -1) {
                return -1;
            }
            if (this._includeSelf && this._currentNode + 1 == this._startNode) {
                return this.returnNode(DTMDefaultBaseIterators.this.makeNodeHandle(++this._currentNode));
            }
            int node = this._currentNode;
            do {
                if (-1 != (type = DTMDefaultBaseIterators.this._type(++node)) && this.isDescendant(node)) continue;
                this._currentNode = -1;
                return -1;
            } while (2 == type || 3 == type || 13 == type);
            this._currentNode = node;
            return this.returnNode(DTMDefaultBaseIterators.this.makeNodeHandle(node));
        }

        @Override
        public void reset() {
            boolean temp = this._isRestartable;
            this._isRestartable = true;
            this.setStartNode(DTMDefaultBaseIterators.this.makeNodeHandle(this._startNode));
            this._isRestartable = temp;
        }
    }

    public class AncestorIterator
    extends InternalAxisIteratorBase {
        final ArrayList<Integer> m_ancestors = new ArrayList();
        int m_ancestorsPos;

        @Override
        public final boolean isReverse() {
            return true;
        }

        @Override
        public DTMAxisIterator cloneIterator() {
            this._isRestartable = false;
            try {
                AncestorIterator clone = (AncestorIterator)super.clone();
                clone._startNode = this._startNode;
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_ITERATOR_CLONE_NOT_SUPPORTED", null));
            }
        }

        @Override
        public void setStartNode(int node) {
            if (node == 0) {
                node = DTMDefaultBaseIterators.this.getDocument();
            }
            if (this._isRestartable) {
                int nodeID = DTMDefaultBaseIterators.this.makeNodeIdentity(node);
                if (!this._includeSelf && node != -1) {
                    nodeID = DTMDefaultBaseIterators.this._parent(nodeID);
                    node = DTMDefaultBaseIterators.this.makeNodeHandle(nodeID);
                }
                this._startNode = node;
                while (nodeID != -1) {
                    this.m_ancestors.add(node);
                    nodeID = DTMDefaultBaseIterators.this._parent(nodeID);
                    node = DTMDefaultBaseIterators.this.makeNodeHandle(nodeID);
                }
                this.m_ancestorsPos = this.m_ancestors.size() - 1;
                this._currentNode = this.m_ancestorsPos >= 0 ? this.m_ancestors.get(this.m_ancestorsPos) : -1;
                this.resetPosition();
            }
        }

        @Override
        public void reset() {
            this.m_ancestorsPos = this.m_ancestors.size() - 1;
            this._currentNode = this.m_ancestorsPos >= 0 ? this.m_ancestors.get(this.m_ancestorsPos) : -1;
            this.resetPosition();
        }

        @Override
        public int next() {
            int pos;
            int next = this._currentNode;
            this._currentNode = (pos = --this.m_ancestorsPos) >= 0 ? this.m_ancestors.get(this.m_ancestorsPos) : -1;
            return this.returnNode(next);
        }
    }

    public class FollowingIterator
    extends InternalAxisIteratorBase {
        final DTMAxisTraverser m_traverser;

        public FollowingIterator() {
            this.m_traverser = DTMDefaultBaseIterators.this.getAxisTraverser(6);
        }

        @Override
        public void setStartNode(int node) {
            if (node == 0) {
                node = DTMDefaultBaseIterators.this.getDocument();
            }
            if (this._isRestartable) {
                this._startNode = node;
                this._currentNode = this.m_traverser.first(node);
                this.resetPosition();
            }
        }

        @Override
        public int next() {
            int node = this._currentNode;
            this._currentNode = this.m_traverser.next(this._startNode, this._currentNode);
            return this.returnNode(node);
        }
    }

    public class PrecedingIterator
    extends InternalAxisIteratorBase {
        private final int _maxAncestors = 8;
        protected int[] _stack = new int[8];
        protected int _sp;
        protected int _oldsp;

        @Override
        public boolean isReverse() {
            return true;
        }

        @Override
        public DTMAxisIterator cloneIterator() {
            this._isRestartable = false;
            try {
                PrecedingIterator clone = (PrecedingIterator)super.clone();
                int[] stackCopy = new int[this._stack.length];
                System.arraycopy(this._stack, 0, stackCopy, 0, this._stack.length);
                clone._stack = stackCopy;
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_ITERATOR_CLONE_NOT_SUPPORTED", null), e);
            }
        }

        @Override
        public void setStartNode(int node) {
            if (node == 0) {
                node = DTMDefaultBaseIterators.this.getDocument();
            }
            if (this._isRestartable) {
                if (DTMDefaultBaseIterators.this._type(node = DTMDefaultBaseIterators.this.makeNodeIdentity(node)) == 2) {
                    node = DTMDefaultBaseIterators.this._parent(node);
                }
                this._startNode = node;
                int index = 0;
                this._stack[0] = node;
                int parent = node;
                while ((parent = DTMDefaultBaseIterators.this._parent(parent)) != -1) {
                    if (++index == this._stack.length) {
                        int[] stack = new int[index + 4];
                        System.arraycopy(this._stack, 0, stack, 0, index);
                        this._stack = stack;
                    }
                    this._stack[index] = parent;
                }
                if (index > 0) {
                    --index;
                }
                this._currentNode = this._stack[index];
                this._oldsp = this._sp = index;
                this.resetPosition();
            }
        }

        @Override
        public int next() {
            ++this._currentNode;
            while (this._sp >= 0) {
                if (this._currentNode < this._stack[this._sp]) {
                    if (DTMDefaultBaseIterators.this._type(this._currentNode) != 2 && DTMDefaultBaseIterators.this._type(this._currentNode) != 13) {
                        return this.returnNode(DTMDefaultBaseIterators.this.makeNodeHandle(this._currentNode));
                    }
                } else {
                    --this._sp;
                }
                ++this._currentNode;
            }
            return -1;
        }

        @Override
        public void reset() {
            this._sp = this._oldsp;
            this.resetPosition();
        }
    }

    public class PrecedingSiblingIterator
    extends InternalAxisIteratorBase {
        protected int _startNodeID;

        @Override
        public boolean isReverse() {
            return true;
        }

        @Override
        public void setStartNode(int node) {
            if (node == 0) {
                node = DTMDefaultBaseIterators.this.getDocument();
            }
            if (this._isRestartable) {
                this._startNode = node;
                this._startNodeID = DTMDefaultBaseIterators.this.makeNodeIdentity(node);
                if ((node = this._startNodeID) == -1) {
                    this._currentNode = node;
                    this.resetPosition();
                    return;
                }
                short type = DTMDefaultBaseIterators.this.m_expandedNameTable.getType(DTMDefaultBaseIterators.this._exptype(node));
                if (2 == type || 13 == type) {
                    this._currentNode = node;
                } else {
                    this._currentNode = DTMDefaultBaseIterators.this._parent(node);
                    this._currentNode = -1 != this._currentNode ? DTMDefaultBaseIterators.this._firstch(this._currentNode) : node;
                }
                this.resetPosition();
            }
        }

        @Override
        public int next() {
            if (this._currentNode == this._startNodeID || this._currentNode == -1) {
                return -1;
            }
            int node = this._currentNode;
            this._currentNode = DTMDefaultBaseIterators.this._nextsib(node);
            return this.returnNode(DTMDefaultBaseIterators.this.makeNodeHandle(node));
        }
    }

    public final class AttributeIterator
    extends InternalAxisIteratorBase {
        @Override
        public void setStartNode(int node) {
            if (node == 0) {
                node = DTMDefaultBaseIterators.this.getDocument();
            }
            if (this._isRestartable) {
                this._startNode = node;
                this._currentNode = DTMDefaultBaseIterators.this.getFirstAttributeIdentity(DTMDefaultBaseIterators.this.makeNodeIdentity(node));
                this.resetPosition();
            }
        }

        @Override
        public int next() {
            int node = this._currentNode;
            if (node != -1) {
                this._currentNode = DTMDefaultBaseIterators.this.getNextAttributeIdentity(node);
                return this.returnNode(DTMDefaultBaseIterators.this.makeNodeHandle(node));
            }
            return -1;
        }
    }

    public class FollowingSiblingIterator
    extends InternalAxisIteratorBase {
        @Override
        public void setStartNode(int node) {
            if (node == 0) {
                node = DTMDefaultBaseIterators.this.getDocument();
            }
            if (this._isRestartable) {
                this._startNode = node;
                this._currentNode = DTMDefaultBaseIterators.this.makeNodeIdentity(node);
                this.resetPosition();
            }
        }

        @Override
        public int next() {
            this._currentNode = this._currentNode == -1 ? -1 : DTMDefaultBaseIterators.this._nextsib(this._currentNode);
            return this.returnNode(DTMDefaultBaseIterators.this.makeNodeHandle(this._currentNode));
        }
    }

    public class RootIterator
    extends InternalAxisIteratorBase {
        @Override
        public void setStartNode(int node) {
            if (this._isRestartable) {
                this._startNode = DTMDefaultBaseIterators.this.getDocumentRoot(node);
                this._currentNode = -1;
                this.resetPosition();
            }
        }

        @Override
        public int next() {
            if (this._startNode == this._currentNode) {
                return -1;
            }
            this._currentNode = this._startNode;
            return this.returnNode(this._startNode);
        }
    }

    public class NamespaceIterator
    extends InternalAxisIteratorBase {
        @Override
        public void setStartNode(int node) {
            if (node == 0) {
                node = DTMDefaultBaseIterators.this.getDocument();
            }
            if (this._isRestartable) {
                this._startNode = node;
                this._currentNode = DTMDefaultBaseIterators.this.getFirstNamespaceNode(node, true);
                this.resetPosition();
            }
        }

        @Override
        public int next() {
            int node = this._currentNode;
            if (-1 != node) {
                this._currentNode = DTMDefaultBaseIterators.this.getNextNamespaceNode(this._startNode, node, true);
            }
            return this.returnNode(node);
        }
    }

    public final class ParentIterator
    extends InternalAxisIteratorBase {
        @Override
        public void setStartNode(int node) {
            if (node == 0) {
                node = DTMDefaultBaseIterators.this.getDocument();
            }
            if (this._isRestartable) {
                this._startNode = node;
                this._currentNode = DTMDefaultBaseIterators.this.getParent(node);
                this.resetPosition();
            }
        }

        @Override
        public int next() {
            int result = this._currentNode;
            this._currentNode = -1;
            return this.returnNode(result);
        }
    }

    public final class ChildrenIterator
    extends InternalAxisIteratorBase {
        @Override
        public void setStartNode(int node) {
            if (node == 0) {
                node = DTMDefaultBaseIterators.this.getDocument();
            }
            if (this._isRestartable) {
                this._startNode = node;
                this._currentNode = node == -1 ? -1 : DTMDefaultBaseIterators.this._firstch(DTMDefaultBaseIterators.this.makeNodeIdentity(node));
                this.resetPosition();
            }
        }

        @Override
        public int next() {
            if (this._currentNode != -1) {
                int node = this._currentNode;
                this._currentNode = DTMDefaultBaseIterators.this._nextsib(node);
                return this.returnNode(DTMDefaultBaseIterators.this.makeNodeHandle(node));
            }
            return -1;
        }
    }

    public static abstract class InternalAxisIteratorBase
    extends DTMAxisIteratorBase {
        protected int _currentNode;
    }
}

