/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.xpath;

import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import org.htmlunit.xpath.ExpressionNode;
import org.htmlunit.xpath.XPathContext;
import org.htmlunit.xpath.XPathVisitable;
import org.htmlunit.xpath.objects.XObject;
import org.htmlunit.xpath.res.XPATHMessages;
import org.htmlunit.xpath.xml.dtm.DTM;
import org.htmlunit.xpath.xml.dtm.DTMIterator;

public abstract class Expression
implements ExpressionNode,
XPathVisitable {
    private ExpressionNode m_parent;

    public boolean canTraverseOutsideSubtree() {
        return false;
    }

    public XObject execute(XPathContext xctxt, int currentNode) throws TransformerException {
        return this.execute(xctxt);
    }

    public XObject execute(XPathContext xctxt, int currentNode, DTM dtm, int expType) throws TransformerException {
        return this.execute(xctxt);
    }

    public abstract XObject execute(XPathContext var1) throws TransformerException;

    public XObject execute(XPathContext xctxt, boolean destructiveOK) throws TransformerException {
        return this.execute(xctxt);
    }

    public double num(XPathContext xctxt) throws TransformerException {
        return this.execute(xctxt).num();
    }

    public boolean bool(XPathContext xctxt) throws TransformerException {
        return this.execute(xctxt).bool();
    }

    public int asNode(XPathContext xctxt) throws TransformerException {
        DTMIterator iter = this.execute(xctxt).iter();
        return iter.nextNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DTMIterator asIterator(XPathContext xctxt, int contextNode) throws TransformerException {
        try {
            xctxt.pushCurrentNodeAndExpression(contextNode);
            DTMIterator dTMIterator = this.execute(xctxt).iter();
            return dTMIterator;
        }
        finally {
            xctxt.popCurrentNodeAndExpression();
        }
    }

    public boolean isStableNumber() {
        return false;
    }

    public abstract boolean deepEquals(Expression var1);

    protected final boolean isSameClass(Expression expr) {
        if (null == expr) {
            return false;
        }
        return this.getClass() == expr.getClass();
    }

    public void assertion(boolean b, String msg) {
        if (!b) {
            String fMsg = XPATHMessages.createXPATHMessage("ER_INCORRECT_PROGRAMMER_ASSERTION", new Object[]{msg});
            throw new RuntimeException(fMsg);
        }
    }

    public void error(XPathContext xctxt, String msg, Object[] args) throws TransformerException {
        String fmsg = XPATHMessages.createXPATHMessage(msg, args);
        if (null != xctxt) {
            ErrorListener eh = xctxt.getErrorListener();
            TransformerException te = new TransformerException(fmsg, this);
            eh.fatalError(te);
        }
    }

    public ExpressionNode getExpressionOwner() {
        ExpressionNode parent;
        for (parent = this.exprGetParent(); null != parent && parent instanceof Expression; parent = parent.exprGetParent()) {
        }
        return parent;
    }

    @Override
    public void exprSetParent(ExpressionNode n) {
        this.assertion(n != this, "Can not parent an expression to itself!");
        this.m_parent = n;
    }

    @Override
    public ExpressionNode exprGetParent() {
        return this.m_parent;
    }

    @Override
    public String getPublicId() {
        if (null == this.m_parent) {
            return null;
        }
        return this.m_parent.getPublicId();
    }

    @Override
    public String getSystemId() {
        if (null == this.m_parent) {
            return null;
        }
        return this.m_parent.getSystemId();
    }

    @Override
    public int getLineNumber() {
        if (null == this.m_parent) {
            return 0;
        }
        return this.m_parent.getLineNumber();
    }

    @Override
    public int getColumnNumber() {
        if (null == this.m_parent) {
            return 0;
        }
        return this.m_parent.getColumnNumber();
    }
}

