/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.jetty.client.http;

import java.io.IOException;
import java.util.Map;
import org.htmlunit.jetty.client.AbstractConnectorHttpClientTransport;
import org.htmlunit.jetty.client.DuplexConnectionPool;
import org.htmlunit.jetty.client.HttpDestination;
import org.htmlunit.jetty.client.Origin;
import org.htmlunit.jetty.client.api.Connection;
import org.htmlunit.jetty.client.http.HttpConnectionOverHTTP;
import org.htmlunit.jetty.client.http.HttpDestinationOverHTTP;
import org.htmlunit.jetty.io.EndPoint;
import org.htmlunit.jetty.util.Callback;
import org.htmlunit.jetty.util.ProcessorUtils;
import org.htmlunit.jetty.util.Promise;
import org.htmlunit.jetty.util.annotation.ManagedAttribute;
import org.htmlunit.jetty.util.annotation.ManagedObject;

@ManagedObject(value="The HTTP/1.1 client transport")
public class HttpClientTransportOverHTTP
extends AbstractConnectorHttpClientTransport {
    private int headerCacheSize = 1024;

    public HttpClientTransportOverHTTP() {
        this(Math.max(1, ProcessorUtils.availableProcessors() / 2));
    }

    public HttpClientTransportOverHTTP(int selectors) {
        super(selectors);
        this.setConnectionPoolFactory(destination -> new DuplexConnectionPool(destination, this.getHttpClient().getMaxConnectionsPerDestination(), (Callback)destination));
    }

    @Override
    public HttpDestination newHttpDestination(Origin origin) {
        return new HttpDestinationOverHTTP(this.getHttpClient(), origin);
    }

    @Override
    public org.htmlunit.jetty.io.Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
        HttpDestination destination = (HttpDestination)context.get("http.destination");
        Promise promise = (Promise)context.get("http.connection.promise");
        HttpConnectionOverHTTP connection = this.newHttpConnection(endPoint, destination, promise);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created {}", connection);
        }
        return this.customize(connection, context);
    }

    protected HttpConnectionOverHTTP newHttpConnection(EndPoint endPoint, HttpDestination destination, Promise<Connection> promise) {
        return new HttpConnectionOverHTTP(endPoint, destination, promise);
    }

    @ManagedAttribute(value="The maximum allowed size in bytes for an HTTP header field cache")
    public int getHeaderCacheSize() {
        return this.headerCacheSize;
    }

    public void setHeaderCacheSize(int headerCacheSize) {
        this.headerCacheSize = headerCacheSize;
    }
}

