/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript.regexp;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UnicodeProperties {
    public static final byte ALPHABETIC = 1;
    public static final byte ASCII = 2;
    public static final byte CASE_IGNORABLE = 3;
    public static final byte ASCII_HEX_DIGIT = 4;
    public static final byte HEX_DIGIT = 5;
    public static final byte ID_CONTINUE = 6;
    public static final byte ID_START = 7;
    public static final byte LOWERCASE = 8;
    public static final byte UPPERCASE = 9;
    public static final byte WHITE_SPACE = 10;
    public static final byte GENERAL_CATEGORY = 11;
    public static final byte SCRIPT = 12;
    public static final byte OTHER = 1;
    public static final byte CONTROL = 2;
    public static final byte FORMAT = 3;
    public static final byte UNASSIGNED = 4;
    public static final byte PRIVATE_USE = 5;
    public static final byte SURROGATE = 6;
    public static final byte LETTER = 7;
    public static final byte LOWERCASE_LETTER = 8;
    public static final byte MODIFIER_LETTER = 9;
    public static final byte OTHER_LETTER = 10;
    public static final byte TITLECASE_LETTER = 11;
    public static final byte UPPERCASE_LETTER = 12;
    public static final byte MARK = 13;
    public static final byte SPACING_MARK = 14;
    public static final byte ENCLOSING_MARK = 15;
    public static final byte NONSPACING_MARK = 16;
    public static final byte NUMBER = 17;
    public static final byte DECIMAL_NUMBER = 18;
    public static final byte LETTER_NUMBER = 19;
    public static final byte OTHER_NUMBER = 20;
    public static final byte PUNCTUATION = 21;
    public static final byte CONNECTOR_PUNCTUATION = 22;
    public static final byte DASH_PUNCTUATION = 23;
    public static final byte CLOSE_PUNCTUATION = 24;
    public static final byte FINAL_PUNCTUATION = 25;
    public static final byte INITIAL_PUNCTUATION = 26;
    public static final byte OTHER_PUNCTUATION = 27;
    public static final byte OPEN_PUNCTUATION = 28;
    public static final byte SYMBOL = 29;
    public static final byte CURRENCY_SYMBOL = 30;
    public static final byte MODIFIER_SYMBOL = 31;
    public static final byte MATH_SYMBOL = 32;
    public static final byte OTHER_SYMBOL = 33;
    public static final byte SEPARATOR = 34;
    public static final byte LINE_SEPARATOR = 35;
    public static final byte PARAGRAPH_SEPARATOR = 36;
    public static final byte SPACE_SEPARATOR = 37;
    public static final byte TRUE = 38;
    public static final byte FALSE = 39;
    public static Map<String, Byte> PROPERTY_NAMES;
    public static Map<String, Byte> PROPERTY_VALUES;
    private static final Character.UnicodeScript[] UnicodeScriptValues;

    public static int lookup(String propertyOrValue) {
        if (propertyOrValue == null || propertyOrValue.isEmpty()) {
            return -1;
        }
        Matcher m = Pattern.compile("^(?<propName>[a-zA-Z_]+)(?:=(?<propValue>[a-zA-Z_0-9]+))?$").matcher(propertyOrValue);
        m.find();
        if (!m.matches() || m.group("propName") == null) {
            return -1;
        }
        if (m.group("propValue") == null) {
            String property = m.group("propName");
            Byte propByte = PROPERTY_NAMES.get(property);
            if (propByte == null) {
                Byte valueByte = PROPERTY_VALUES.get(property);
                if (valueByte != null) {
                    return UnicodeProperties.encodeProperty((byte)11, valueByte);
                }
                return -1;
            }
            if (propByte == 11 || propByte == 12) {
                return -1;
            }
            return UnicodeProperties.encodeProperty(propByte, (byte)38);
        }
        String property = m.group("propName");
        String value = m.group("propValue");
        Byte propByte = PROPERTY_NAMES.get(property);
        if (propByte == null) {
            return -1;
        }
        switch (propByte) {
            case 11: {
                Byte valueByte = PROPERTY_VALUES.get(value);
                if (valueByte == null) {
                    return -1;
                }
                return UnicodeProperties.encodeProperty((byte)11, valueByte);
            }
            case 12: {
                try {
                    return UnicodeProperties.encodeProperty((byte)12, (byte)Character.UnicodeScript.forName(value).ordinal());
                }
                catch (IllegalArgumentException e) {
                    return -1;
                }
            }
        }
        return -1;
    }

    private static int encodeProperty(byte property, byte value) {
        return (property & 0xFF) << 8 | value & 0xFF;
    }

    public static boolean hasProperty(int property, int codePoint) {
        byte propByte = (byte)(property >> 8 & 0xFF);
        int valueByte = property & 0xFF;
        switch (propByte) {
            case 1: {
                return Character.isAlphabetic(codePoint) == (valueByte == 38);
            }
            case 2: {
                return codePoint <= 127 == (valueByte == 38);
            }
            case 3: {
                return (Character.getType(codePoint) == 27 || Character.getType(codePoint) == 4 || Character.getType(codePoint) == 6) == (valueByte == 38);
            }
            case 11: {
                int javaCategory = Character.getType(codePoint);
                return UnicodeProperties.checkGeneralCategory(valueByte, javaCategory);
            }
            case 4: {
                return UnicodeProperties.isHexDigit(codePoint) == (valueByte == 38);
            }
            case 5: {
                return Character.digit(codePoint, 16) != -1 == (valueByte == 38);
            }
            case 6: {
                return Character.isUnicodeIdentifierPart(codePoint) == (valueByte == 38);
            }
            case 7: {
                return Character.isUnicodeIdentifierStart(codePoint) == (valueByte == 38);
            }
            case 8: {
                return Character.isLowerCase(codePoint) == (valueByte == 38);
            }
            case 9: {
                return Character.isUpperCase(codePoint) == (valueByte == 38);
            }
            case 10: {
                return valueByte == 38 == (Character.isSpaceChar(codePoint) || Character.isWhitespace(codePoint));
            }
            case 12: {
                return Character.UnicodeScript.of(codePoint) == UnicodeScriptValues[valueByte];
            }
        }
        return false;
    }

    private static boolean checkGeneralCategory(int propertyValueByte, int javaCategory) {
        switch (propertyValueByte) {
            case 7: {
                return javaCategory == 1 || javaCategory == 2 || javaCategory == 3 || javaCategory == 4 || javaCategory == 5;
            }
            case 12: {
                return javaCategory == 1;
            }
            case 8: {
                return javaCategory == 2;
            }
            case 11: {
                return javaCategory == 3;
            }
            case 9: {
                return javaCategory == 4;
            }
            case 10: {
                return javaCategory == 5;
            }
            case 13: {
                return javaCategory == 6 || javaCategory == 7 || javaCategory == 8;
            }
            case 16: {
                return javaCategory == 6;
            }
            case 15: {
                return javaCategory == 7;
            }
            case 14: {
                return javaCategory == 8;
            }
            case 17: {
                return javaCategory == 9 || javaCategory == 10 || javaCategory == 11;
            }
            case 18: {
                return javaCategory == 9;
            }
            case 19: {
                return javaCategory == 10;
            }
            case 20: {
                return javaCategory == 11;
            }
            case 34: {
                return javaCategory == 12 || javaCategory == 13 || javaCategory == 14;
            }
            case 37: {
                return javaCategory == 12;
            }
            case 35: {
                return javaCategory == 13;
            }
            case 36: {
                return javaCategory == 14;
            }
            case 1: {
                return javaCategory == 5 || javaCategory == 11 || javaCategory == 24 || javaCategory == 28;
            }
            case 2: {
                return javaCategory == 15;
            }
            case 3: {
                return javaCategory == 16;
            }
            case 6: {
                return javaCategory == 19;
            }
            case 5: {
                return javaCategory == 18;
            }
            case 21: {
                return javaCategory == 23 || javaCategory == 20 || javaCategory == 21 || javaCategory == 22 || javaCategory == 24 || javaCategory == 29 || javaCategory == 30;
            }
            case 23: {
                return javaCategory == 20;
            }
            case 28: {
                return javaCategory == 21;
            }
            case 24: {
                return javaCategory == 22;
            }
            case 22: {
                return javaCategory == 23;
            }
            case 27: {
                return javaCategory == 24;
            }
            case 26: {
                return javaCategory == 29;
            }
            case 25: {
                return javaCategory == 30;
            }
            case 29: {
                return javaCategory == 25 || javaCategory == 26 || javaCategory == 27 || javaCategory == 28;
            }
            case 32: {
                return javaCategory == 25;
            }
            case 30: {
                return javaCategory == 26;
            }
            case 31: {
                return javaCategory == 27;
            }
            case 33: {
                return javaCategory == 28;
            }
            case 4: {
                return javaCategory == 0;
            }
        }
        return false;
    }

    private static boolean isHexDigit(int codePoint) {
        return codePoint >= 48 && codePoint <= 57 || codePoint >= 97 && codePoint <= 102 || codePoint >= 65 && codePoint <= 70;
    }

    static {
        HashMap<String, Byte> map = new HashMap<String, Byte>();
        map.put("Alphabetic", (byte)1);
        map.put("Alpha", (byte)1);
        map.put("ASCII", (byte)2);
        map.put("Case_Ignorable", (byte)3);
        map.put("CI", (byte)3);
        map.put("General_Category", (byte)11);
        map.put("gc", (byte)11);
        map.put("Script", (byte)12);
        map.put("sc", (byte)12);
        map.put("ASCII_Hex_Digit", (byte)4);
        map.put("AHex", (byte)4);
        map.put("Hex_Digit", (byte)5);
        map.put("Hex", (byte)5);
        map.put("ID_Continue", (byte)6);
        map.put("IDC", (byte)6);
        map.put("ID_Start", (byte)7);
        map.put("IDS", (byte)7);
        map.put("Lowercase", (byte)8);
        map.put("Lower", (byte)8);
        map.put("Uppercase", (byte)9);
        map.put("Upper", (byte)9);
        map.put("White_Space", (byte)10);
        map.put("space", (byte)10);
        PROPERTY_NAMES = map;
        map = new HashMap();
        map.put("Other", (byte)1);
        map.put("C", (byte)1);
        map.put("Control", (byte)2);
        map.put("Cc", (byte)2);
        map.put("cntrl", (byte)2);
        map.put("Format", (byte)3);
        map.put("Cf", (byte)3);
        map.put("Unassigned", (byte)4);
        map.put("Cn", (byte)4);
        map.put("Private_Use", (byte)5);
        map.put("Co", (byte)5);
        map.put("Surrogate", (byte)6);
        map.put("Cs", (byte)6);
        map.put("Letter", (byte)7);
        map.put("L", (byte)7);
        map.put("Lowercase_Letter", (byte)8);
        map.put("Ll", (byte)8);
        map.put("Modifier_Letter", (byte)9);
        map.put("Lm", (byte)9);
        map.put("Other_Letter", (byte)10);
        map.put("Lo", (byte)10);
        map.put("Titlecase_Letter", (byte)11);
        map.put("Lt", (byte)11);
        map.put("Uppercase_Letter", (byte)12);
        map.put("Lu", (byte)12);
        map.put("Mark", (byte)13);
        map.put("M", (byte)13);
        map.put("Combining_Mark", (byte)13);
        map.put("Spacing_Mark", (byte)14);
        map.put("Mc", (byte)14);
        map.put("Enclosing_Mark", (byte)15);
        map.put("Me", (byte)15);
        map.put("Nonspacing_Mark", (byte)16);
        map.put("Mn", (byte)16);
        map.put("Number", (byte)17);
        map.put("N", (byte)17);
        map.put("Decimal_Number", (byte)18);
        map.put("Nd", (byte)18);
        map.put("digit", (byte)17);
        map.put("Letter_Number", (byte)19);
        map.put("Nl", (byte)19);
        map.put("Other_Number", (byte)20);
        map.put("No", (byte)20);
        map.put("Punctuation", (byte)21);
        map.put("P", (byte)21);
        map.put("punct", (byte)21);
        map.put("Connector_Punctuation", (byte)22);
        map.put("Pc", (byte)22);
        map.put("Dash_Punctuation", (byte)23);
        map.put("Pd", (byte)23);
        map.put("Close_Punctuation", (byte)24);
        map.put("Pe", (byte)24);
        map.put("Final_Punctuation", (byte)25);
        map.put("Pf", (byte)25);
        map.put("Initial_Punctuation", (byte)26);
        map.put("Pi", (byte)26);
        map.put("Other_Punctuation", (byte)27);
        map.put("Po", (byte)27);
        map.put("Open_Punctuation", (byte)28);
        map.put("Ps", (byte)28);
        map.put("Symbol", (byte)29);
        map.put("S", (byte)29);
        map.put("Currency_Symbol", (byte)30);
        map.put("Sc", (byte)30);
        map.put("Modifier_Symbol", (byte)31);
        map.put("Sk", (byte)31);
        map.put("Math_Symbol", (byte)32);
        map.put("Sm", (byte)32);
        map.put("Other_Symbol", (byte)33);
        map.put("So", (byte)33);
        map.put("Separator", (byte)34);
        map.put("Z", (byte)34);
        map.put("Line_Separator", (byte)35);
        map.put("Zl", (byte)35);
        map.put("Paragraph_Separator", (byte)36);
        map.put("Zp", (byte)36);
        map.put("Space_Separator", (byte)37);
        map.put("Zs", (byte)37);
        PROPERTY_VALUES = map;
        UnicodeScriptValues = Character.UnicodeScript.values();
    }
}

