/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript.regexp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.htmlunit.corejs.javascript.AbstractEcmaObjectOperations;
import org.htmlunit.corejs.javascript.AbstractEcmaStringOperations;
import org.htmlunit.corejs.javascript.BaseFunction;
import org.htmlunit.corejs.javascript.Callable;
import org.htmlunit.corejs.javascript.Constructable;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.IdFunctionObject;
import org.htmlunit.corejs.javascript.IdScriptableObject;
import org.htmlunit.corejs.javascript.Kit;
import org.htmlunit.corejs.javascript.LambdaConstructor;
import org.htmlunit.corejs.javascript.NativeArray;
import org.htmlunit.corejs.javascript.NativeObject;
import org.htmlunit.corejs.javascript.ScriptRuntime;
import org.htmlunit.corejs.javascript.ScriptRuntimeES6;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.corejs.javascript.Symbol;
import org.htmlunit.corejs.javascript.SymbolKey;
import org.htmlunit.corejs.javascript.TopLevel;
import org.htmlunit.corejs.javascript.Undefined;
import org.htmlunit.corejs.javascript.config.RhinoConfig;
import org.htmlunit.corejs.javascript.regexp.CompilerState;
import org.htmlunit.corejs.javascript.regexp.NativeRegExpCtor;
import org.htmlunit.corejs.javascript.regexp.NativeRegExpInstantiator;
import org.htmlunit.corejs.javascript.regexp.NativeRegExpStringIterator;
import org.htmlunit.corejs.javascript.regexp.REBackTrackData;
import org.htmlunit.corejs.javascript.regexp.RECharSet;
import org.htmlunit.corejs.javascript.regexp.RECompiled;
import org.htmlunit.corejs.javascript.regexp.REGlobalData;
import org.htmlunit.corejs.javascript.regexp.RENode;
import org.htmlunit.corejs.javascript.regexp.REProgState;
import org.htmlunit.corejs.javascript.regexp.RegExpImpl;
import org.htmlunit.corejs.javascript.regexp.SubString;
import org.htmlunit.corejs.javascript.regexp.UnicodeProperties;

public class NativeRegExp
extends IdScriptableObject {
    private static final long serialVersionUID = 4965263491464903264L;
    private static final Object REGEXP_TAG = new Object();
    public static final int JSREG_GLOB = 1;
    public static final int JSREG_FOLD = 2;
    public static final int JSREG_MULTILINE = 4;
    public static final int JSREG_DOTALL = 8;
    public static final int JSREG_STICKY = 16;
    public static final int JSREG_UNICODE = 32;
    public static final int TEST = 0;
    public static final int MATCH = 1;
    public static final int PREFIX = 2;
    private static final boolean debug = RhinoConfig.get("rhino.debugRegexp", false);
    private static final byte REOP_SIMPLE_START = 1;
    private static final byte REOP_EMPTY = 1;
    private static final byte REOP_BOL = 2;
    private static final byte REOP_EOL = 3;
    private static final byte REOP_WBDRY = 4;
    private static final byte REOP_WNONBDRY = 5;
    private static final byte REOP_DOT = 6;
    private static final byte REOP_DIGIT = 7;
    private static final byte REOP_NONDIGIT = 8;
    private static final byte REOP_ALNUM = 9;
    private static final byte REOP_NONALNUM = 10;
    private static final byte REOP_SPACE = 11;
    private static final byte REOP_NONSPACE = 12;
    private static final byte REOP_BACKREF = 13;
    private static final byte REOP_FLAT = 14;
    private static final byte REOP_FLAT1 = 15;
    private static final byte REOP_FLATi = 16;
    private static final byte REOP_FLAT1i = 17;
    private static final byte REOP_UCFLAT1 = 18;
    private static final byte REOP_UCFLAT1i = 19;
    private static final byte REOP_UCSPFLAT1 = 20;
    private static final byte REOP_CLASS = 21;
    private static final byte REOP_NCLASS = 22;
    private static final byte REOP_NAMED_BACKREF = 23;
    private static final byte REOP_UPROP = 24;
    private static final byte REOP_UPROP_NOT = 25;
    private static final byte REOP_SIMPLE_END = 25;
    private static final byte REOP_QUANT = 26;
    private static final byte REOP_STAR = 27;
    private static final byte REOP_PLUS = 28;
    private static final byte REOP_OPT = 29;
    private static final byte REOP_LPAREN = 30;
    private static final byte REOP_RPAREN = 31;
    private static final byte REOP_ALT = 32;
    private static final byte REOP_JUMP = 33;
    private static final byte REOP_ASSERT = 34;
    private static final byte REOP_ASSERT_NOT = 35;
    private static final byte REOP_ASSERTTEST = 36;
    private static final byte REOP_ASSERTNOTTEST = 37;
    private static final byte REOP_MINIMALSTAR = 38;
    private static final byte REOP_MINIMALPLUS = 39;
    private static final byte REOP_MINIMALOPT = 40;
    private static final byte REOP_MINIMALQUANT = 41;
    private static final byte REOP_ENDCHILD = 42;
    private static final byte REOP_REPEAT = 43;
    private static final byte REOP_MINIMALREPEAT = 44;
    private static final byte REOP_ALTPREREQ = 45;
    private static final byte REOP_ALTPREREQi = 46;
    private static final byte REOP_ALTPREREQ2 = 47;
    private static final byte REOP_ASSERTBACK = 48;
    private static final byte REOP_ASSERTBACK_NOT = 49;
    private static final byte REOP_ASSERTBACKTEST = 50;
    private static final byte REOP_ASSERTBACKNOTTEST = 51;
    private static final byte REOP_END = 52;
    private static final int ANCHOR_BOL = -2;
    private static final int INDEX_LEN = 2;
    private static final int Id_lastIndex = 1;
    private static final int Id_source = 2;
    private static final int Id_flags = 3;
    private static final int Id_global = 4;
    private static final int Id_ignoreCase = 5;
    private static final int Id_multiline = 6;
    private static final int Id_dotAll = 7;
    private static final int Id_sticky = 8;
    private static final int Id_unicode = 9;
    private static final int MAX_INSTANCE_ID = 9;
    private static final int Id_compile = 1;
    private static final int Id_toString = 2;
    private static final int Id_toSource = 3;
    private static final int Id_exec = 4;
    private static final int Id_test = 5;
    private static final int Id_prefix = 6;
    private static final int SymbolId_match = 7;
    private static final int SymbolId_matchAll = 8;
    private static final int SymbolId_search = 9;
    private static final int SymbolId_replace = 10;
    private static final int SymbolId_split = 11;
    private static final int MAX_PROTOTYPE_ID = 11;
    private RECompiled re;
    Object lastIndex = ScriptRuntime.zeroObj;
    private int lastIndexAttr = 6;

    static Object init(Context cx, Scriptable scope, boolean sealed) {
        NativeRegExp proto = NativeRegExpInstantiator.withLanguageVersion(cx.getLanguageVersion());
        proto.re = NativeRegExp.compileRE(cx, "", null, false);
        proto.activatePrototypeMap(11);
        proto.setParentScope(scope);
        proto.setPrototype(NativeRegExp.getObjectPrototype(scope));
        LambdaConstructor ctor = NativeRegExpCtor.init(cx, scope, sealed);
        proto.defineProperty("constructor", (Object)ctor, 2);
        ScriptRuntime.setFunctionProtoAndParent((BaseFunction)ctor, cx, scope);
        ctor.setImmunePrototypeProperty(proto);
        if (sealed) {
            proto.sealObject();
            ctor.sealObject();
        }
        ScriptableObject.defineProperty(scope, "RegExp", ctor, 2);
        ScriptRuntimeES6.addSymbolSpecies(cx, scope, ctor);
        return ctor;
    }

    NativeRegExp(Scriptable scope, RECompiled regexpCompiled) {
        this.re = regexpCompiled;
        this.setLastIndex(ScriptRuntime.zeroObj);
        ScriptRuntime.setBuiltinProtoAndParent(this, scope, TopLevel.Builtins.RegExp);
    }

    @Override
    public String getClassName() {
        return "RegExp";
    }

    @Override
    public String getTypeOf() {
        return "object";
    }

    Scriptable compile(Context cx, Scriptable scope, Object[] args) {
        if (args.length >= 1 && args[0] instanceof NativeRegExp && (args.length == 1 || args[1] == Undefined.instance)) {
            this.re = ((NativeRegExp)args[0]).re;
        } else {
            String flags;
            String pattern = args.length == 0 || args[0] == Undefined.instance ? "" : (args[0] instanceof NativeRegExp ? new String(((NativeRegExp)args[0]).re.source) : NativeRegExp.escapeRegExp(args[0]));
            String string = flags = args.length > 1 && args[1] != Undefined.instance ? ScriptRuntime.toString(args[1]) : null;
            if (args.length <= 0 || !(args[0] instanceof NativeRegExp) || flags != null) {
                // empty if block
            }
            this.re = NativeRegExp.compileRE(cx, pattern, flags, false);
        }
        this.setLastIndex(ScriptRuntime.zeroObj);
        return this;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('/');
        if (this.re.source.length != 0) {
            buf.append(this.re.source);
        } else {
            buf.append("(?:)");
        }
        buf.append('/');
        this.appendFlags(buf);
        return buf.toString();
    }

    private void appendFlags(StringBuilder buf) {
        if ((this.re.flags & 1) != 0) {
            buf.append('g');
        }
        if ((this.re.flags & 2) != 0) {
            buf.append('i');
        }
        if ((this.re.flags & 4) != 0) {
            buf.append('m');
        }
        if ((this.re.flags & 8) != 0) {
            buf.append('s');
        }
        if ((this.re.flags & 0x10) != 0) {
            buf.append('y');
        }
        if ((this.re.flags & 0x20) != 0) {
            buf.append('u');
        }
    }

    NativeRegExp() {
    }

    private static RegExpImpl getImpl(Context cx) {
        return (RegExpImpl)ScriptRuntime.getRegExpProxy(cx);
    }

    private static String escapeRegExp(Object src) {
        String s = ScriptRuntime.toString(src);
        StringBuilder sb = null;
        int start = 0;
        int slash = s.indexOf(47);
        while (slash > -1) {
            if (slash == start || s.charAt(slash - 1) != '\\') {
                if (sb == null) {
                    sb = new StringBuilder();
                }
                sb.append(s, start, slash);
                sb.append("\\/");
                start = slash + 1;
            }
            slash = s.indexOf(47, slash + 1);
        }
        if (sb != null) {
            sb.append(s, start, s.length());
            s = sb.toString();
        }
        return s;
    }

    Object execSub(Context cx, Scriptable scopeObj, Object[] args, int matchType) {
        String str;
        RegExpImpl reImpl = NativeRegExp.getImpl(cx);
        if (args.length == 0) {
            str = reImpl.input;
            if (str == null) {
                str = ScriptRuntime.toString(Undefined.instance);
            }
        } else {
            str = ScriptRuntime.toString(args[0]);
        }
        boolean globalOrSticky = (this.re.flags & 1) != 0 || (this.re.flags & 0x10) != 0;
        double d = 0.0;
        if (globalOrSticky && ((d = ScriptRuntime.toInteger(this.lastIndex)) < 0.0 || (double)str.length() < d)) {
            this.setLastIndex(ScriptRuntime.zeroObj);
            return null;
        }
        int[] indexp = new int[]{(int)d};
        Object rval = this.executeRegExp(cx, scopeObj, reImpl, str, indexp, matchType);
        if (globalOrSticky) {
            if (rval == null || rval == Undefined.instance) {
                this.setLastIndex(ScriptRuntime.zeroObj);
            } else {
                this.setLastIndex(indexp[0]);
            }
        }
        return rval;
    }

    private static void prettyPrintRE(RECompiled regexp) {
        int pc = 0;
        block43: while (regexp.program[pc] != 52) {
            System.out.print(pc + ": ");
            byte op = regexp.program[pc];
            ++pc;
            switch (op) {
                case 1: {
                    System.out.println("EMPTY");
                    continue block43;
                }
                case 2: {
                    System.out.println("BOL");
                    continue block43;
                }
                case 3: {
                    System.out.println("EOL");
                    continue block43;
                }
                case 4: {
                    System.out.println("WBDRY");
                    continue block43;
                }
                case 5: {
                    System.out.println("WNONBDRY");
                    continue block43;
                }
                case 6: {
                    System.out.println("DOT");
                    continue block43;
                }
                case 7: {
                    System.out.println("DIGIT");
                    continue block43;
                }
                case 8: {
                    System.out.println("NONDIGIT");
                    continue block43;
                }
                case 9: {
                    System.out.println("ALNUM");
                    continue block43;
                }
                case 10: {
                    System.out.println("NONALNUM");
                    continue block43;
                }
                case 11: {
                    System.out.println("SPACE");
                    continue block43;
                }
                case 12: {
                    System.out.println("NONSPACE");
                    continue block43;
                }
                case 13: {
                    int backrefIndex = NativeRegExp.getIndex(regexp.program, pc);
                    System.out.println("BACKREF " + backrefIndex);
                    pc += 2;
                    continue block43;
                }
                case 23: {
                    int namedBackrefIndex = NativeRegExp.getIndex(regexp.program, pc);
                    System.out.println("NAMED_BACKREF " + regexp.namedBackRefs.get(namedBackrefIndex));
                    pc += 4;
                    continue block43;
                }
                case 14: {
                    int flatIndex = NativeRegExp.getIndex(regexp.program, pc);
                    int flatLength = NativeRegExp.getIndex(regexp.program, pc + 2);
                    System.out.print("FLAT: ");
                    for (int i = 0; i < flatLength; ++i) {
                        System.out.print(regexp.source[flatIndex + i]);
                    }
                    System.out.println();
                    pc += 4;
                    continue block43;
                }
                case 15: {
                    char flat1Char = (char)(regexp.program[pc] & 0xFF);
                    System.out.println("FLAT1: " + flat1Char);
                    ++pc;
                    continue block43;
                }
                case 16: {
                    int flatiIndex = NativeRegExp.getIndex(regexp.program, pc);
                    int flatiLength = NativeRegExp.getIndex(regexp.program, pc + 2);
                    System.out.print("FLATi: ");
                    for (int i = 0; i < flatiLength; ++i) {
                        System.out.print(regexp.source[flatiIndex + i]);
                    }
                    System.out.println();
                    pc += 4;
                    continue block43;
                }
                case 17: {
                    char flat1iChar = (char)(regexp.program[pc] & 0xFF);
                    System.out.println("FLAT1i: " + flat1iChar);
                    ++pc;
                    continue block43;
                }
                case 18: {
                    char ucFlat1Char = (char)NativeRegExp.getIndex(regexp.program, pc);
                    System.out.println("UCFLAT1: " + ucFlat1Char);
                    pc += 2;
                    continue block43;
                }
                case 19: {
                    char ucFlat1iChar = (char)NativeRegExp.getIndex(regexp.program, pc);
                    System.out.println("UCFLAT1i: " + ucFlat1iChar);
                    pc += 2;
                    continue block43;
                }
                case 20: {
                    char highSurrogate = (char)NativeRegExp.getIndex(regexp.program, pc);
                    char lowSurrogate = (char)NativeRegExp.getIndex(regexp.program, pc += 2);
                    pc += 2;
                    StringBuilder sb = new StringBuilder().append("UCSPFLAT1: ").append(highSurrogate).append(lowSurrogate);
                    System.out.println(sb);
                    continue block43;
                }
                case 21: {
                    int classIndex = NativeRegExp.getIndex(regexp.program, pc);
                    System.out.println("CLASS: " + classIndex);
                    pc += 2;
                    continue block43;
                }
                case 22: {
                    int nclassIndex = NativeRegExp.getIndex(regexp.program, pc);
                    System.out.println("NCLASS: " + nclassIndex);
                    pc += 2;
                    continue block43;
                }
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 38: 
                case 39: 
                case 40: 
                case 41: {
                    int max;
                    int min;
                    boolean greedy;
                    boolean bl = greedy = op == 27 || op == 28 || op == 29 || op == 26;
                    if (op == 27 || op == 38) {
                        min = 0;
                        max = Integer.MAX_VALUE;
                    } else if (op == 28 || op == 39) {
                        min = 1;
                        max = Integer.MAX_VALUE;
                    } else if (op == 29 || op == 40) {
                        min = 0;
                        max = 1;
                    } else {
                        min = NativeRegExp.getIndex(regexp.program, pc);
                        max = NativeRegExp.getIndex(regexp.program, pc + 2);
                        pc += 4;
                    }
                    int parenCount = NativeRegExp.getIndex(regexp.program, pc);
                    int parenIndex = NativeRegExp.getIndex(regexp.program, pc + 2);
                    int next = NativeRegExp.getIndex(regexp.program, pc += 4) + pc;
                    System.out.println("QUANT greedy=" + greedy + " min=" + min + " max=" + (max == Integer.MAX_VALUE ? "MAX" : Integer.valueOf(max)) + " parenCount=" + parenCount + " parenIndex=" + parenIndex + " next=" + next);
                    pc += 2;
                    continue block43;
                }
                case 30: {
                    int parenIndex = NativeRegExp.getIndex(regexp.program, pc);
                    System.out.println("LPAREN: " + parenIndex);
                    pc += 2;
                    continue block43;
                }
                case 31: {
                    System.out.println("RPAREN");
                    pc += 2;
                    continue block43;
                }
                case 32: {
                    int altIndex = NativeRegExp.getIndex(regexp.program, pc);
                    System.out.println("ALT: " + altIndex);
                    pc += 2;
                    continue block43;
                }
                case 33: {
                    int jumpIndex = NativeRegExp.getIndex(regexp.program, pc) + pc;
                    System.out.println("JUMP: " + jumpIndex);
                    pc += 2;
                    continue block43;
                }
                case 34: {
                    int assertNextPc = pc + NativeRegExp.getIndex(regexp.program, pc);
                    System.out.println("ASSERT: " + assertNextPc);
                    pc += 2;
                    continue block43;
                }
                case 35: {
                    int assertNotNextPc = pc + NativeRegExp.getIndex(regexp.program, pc);
                    System.out.println("ASSERT_NOT: " + assertNotNextPc);
                    pc += 2;
                    continue block43;
                }
                case 48: {
                    int assertBackNextPc = pc + NativeRegExp.getIndex(regexp.program, pc);
                    System.out.println("ASSERTBACK: " + assertBackNextPc);
                    pc += 2;
                    continue block43;
                }
                case 49: {
                    int assertBackNotNextPc = pc + NativeRegExp.getIndex(regexp.program, pc);
                    System.out.println("ASSERTBACK_NOT: " + assertBackNotNextPc);
                    pc += 2;
                    continue block43;
                }
                case 36: {
                    System.out.println("ASSERTTEST");
                    continue block43;
                }
                case 37: {
                    System.out.println("ASSERTNOTTEST");
                    continue block43;
                }
                case 50: {
                    System.out.println("ASSERTBACKTEST");
                    continue block43;
                }
                case 51: {
                    System.out.println("ASSERTBACKNOTTEST");
                    continue block43;
                }
                case 42: {
                    System.out.println("ENDCHILD");
                    continue block43;
                }
                case 43: {
                    System.out.println("REPEAT");
                    continue block43;
                }
                case 44: {
                    System.out.println("MINIMALREPEAT");
                    continue block43;
                }
                case 45: 
                case 46: 
                case 47: {
                    String opCode = op == 45 ? "REOP_ALTPREREQ" : (op == 46 ? "REOP_ALTPREREQi" : "REOP_ALTPREREQ2");
                    char matchCh1 = (char)NativeRegExp.getIndex(regexp.program, pc);
                    char matchCh2 = (char)NativeRegExp.getIndex(regexp.program, pc += 2);
                    int nextPc = (pc += 2) + NativeRegExp.getIndex(regexp.program, pc);
                    pc += 2;
                    System.out.println(opCode + " " + matchCh1 + " " + matchCh2 + " " + nextPc);
                    continue block43;
                }
                case 52: {
                    System.out.println("END");
                    continue block43;
                }
            }
            System.out.println("UNKNOWN: " + op);
        }
    }

    private static void extractNamedCaptureGroups(char[] src, RENode re, Map<String, List<Integer>> namedCaptureGroups) {
        RENode node = re;
        while (node != null) {
            if (node.op == 30) {
                if (node.namedCaptureGroupName != null) {
                    ArrayList<Integer> entry = new ArrayList<Integer>(1);
                    if (namedCaptureGroups.putIfAbsent(node.namedCaptureGroupName, entry) != null) {
                        NativeRegExp.reportError("msg.duplicate.group.name", node.namedCaptureGroupName);
                    }
                    entry.add(node.parenIndex);
                    NativeRegExp.extractNamedCaptureGroups(src, node.kid, namedCaptureGroups);
                }
            } else if (node.op == 32) {
                HashMap<String, List<Integer>> groupCaptures1 = new HashMap<String, List<Integer>>();
                NativeRegExp.extractNamedCaptureGroups(src, node.kid, groupCaptures1);
                if (groupCaptures1.isEmpty()) {
                    NativeRegExp.extractNamedCaptureGroups(src, node.kid2, namedCaptureGroups);
                } else {
                    HashMap<String, List<Integer>> groupCaptures2 = new HashMap<String, List<Integer>>();
                    NativeRegExp.extractNamedCaptureGroups(src, node.kid2, groupCaptures2);
                    for (Map.Entry entry : groupCaptures2.entrySet()) {
                        groupCaptures1.merge((String)entry.getKey(), (List<Integer>)entry.getValue(), (BiFunction<List<Integer>, List<Integer>, List<Integer>>)((BiFunction<List, List, List>)(v1, v2) -> {
                            v1.addAll(v2);
                            return v1;
                        }));
                    }
                    for (Map.Entry entry : groupCaptures1.entrySet()) {
                        if (namedCaptureGroups.putIfAbsent((String)entry.getKey(), (List<Integer>)entry.getValue()) == null) continue;
                        NativeRegExp.reportError("msg.duplicate.group.name", (String)entry.getKey());
                    }
                }
            } else {
                NativeRegExp.extractNamedCaptureGroups(src, node.kid, namedCaptureGroups);
            }
            node = node.next;
        }
    }

    static RECompiled compileRE(Context cx, String str, String global, boolean flat) {
        RECompiled regexp = new RECompiled(str);
        int length = str.length();
        int flags = 0;
        if (global != null) {
            for (int i = 0; i < global.length(); ++i) {
                char c = global.charAt(i);
                int f = 0;
                if (c == 'g') {
                    f = 1;
                } else if (c == 'i') {
                    f = 2;
                } else if (c == 'm') {
                    f = 4;
                } else if (c == 's') {
                    f = 8;
                } else if (c == 'y') {
                    f = 16;
                } else if (c == 'u') {
                    f = 32;
                } else {
                    NativeRegExp.reportError("msg.invalid.re.flag", String.valueOf(c));
                }
                if ((flags & f) != 0) {
                    NativeRegExp.reportError("msg.invalid.re.flag", String.valueOf(c));
                }
                flags |= f;
            }
        }
        if ((flags & 0x20) != 0 && (flags & 2) != 0) {
            NativeRegExp.reportError("msg.invalid.re.flag", "u and i");
        }
        if ((flags & 0x20) != 0) {
            // empty if block
        }
        regexp.flags = flags;
        CompilerState state = new CompilerState(cx, regexp.source, length, flags);
        if (flat && length > 0) {
            if (debug) {
                System.out.println("flat = \"" + str + "\"");
            }
            state.result = new RENode(14);
            state.result.chr = state.cpbegin[0];
            state.result.length = length;
            state.result.flatIndex = 0;
            state.progLength += 5;
        } else {
            boolean unicodeMode = (flags & 0x20) != 0;
            ParserParameters params = new ParserParameters(unicodeMode, unicodeMode);
            if (!NativeRegExp.parseDisjunction(state, params)) {
                return null;
            }
            CompilerState reParseState = null;
            if (state.maxBackReference > state.parenCount) {
                if (params.unicodeMode) {
                    NativeRegExp.reportError("msg.invalid.escape", "");
                } else {
                    reParseState = new CompilerState(cx, regexp.source, length, flags);
                    reParseState.backReferenceLimit = state.parenCount;
                }
            }
            if (state.namedCaptureGroupsFound && !params.namedCaptureGroups) {
                params.namedCaptureGroups = true;
                if (reParseState == null) {
                    reParseState = new CompilerState(cx, regexp.source, length, flags);
                }
            }
            if (reParseState != null && !NativeRegExp.parseDisjunction(state = reParseState, params)) {
                return null;
            }
        }
        regexp.namedCaptureGroups = new HashMap<String, List<Integer>>();
        if (state.namedCaptureGroupsFound) {
            NativeRegExp.extractNamedCaptureGroups(regexp.source, state.result, regexp.namedCaptureGroups);
            regexp.namedBackRefs = state.namedCaptureBackRefs;
        }
        regexp.program = new byte[state.progLength + 1];
        if (state.classCount != 0) {
            regexp.classList = new RECharSet[state.classCount];
            regexp.classCount = state.classCount;
        }
        int endPC = NativeRegExp.emitREBytecode(state, regexp, 0, state.result);
        regexp.program[endPC++] = 52;
        if (debug) {
            System.out.println("Prog. length = " + endPC);
            for (int i = 0; i < endPC; ++i) {
                System.out.print(regexp.program[i]);
                if (i >= endPC - 1) continue;
                System.out.print(", ");
            }
            System.out.println();
            NativeRegExp.prettyPrintRE(regexp);
        }
        regexp.parenCount = state.parenCount;
        switch (regexp.program[0]) {
            case 18: 
            case 19: {
                regexp.anchorCodePoint = (char)NativeRegExp.getIndex(regexp.program, 1);
                break;
            }
            case 15: 
            case 17: {
                regexp.anchorCodePoint = (char)(regexp.program[1] & 0xFF);
                break;
            }
            case 14: 
            case 16: {
                int k = NativeRegExp.getIndex(regexp.program, 1);
                regexp.anchorCodePoint = regexp.source[k];
                break;
            }
            case 2: {
                regexp.anchorCodePoint = -2;
                break;
            }
            case 32: {
                RENode n = state.result;
                if (n.kid.op != 2 || n.kid2.op != 2) break;
                regexp.anchorCodePoint = -2;
            }
        }
        if (debug && regexp.anchorCodePoint >= 0) {
            System.out.println("Anchor ch = '" + (char)regexp.anchorCodePoint + "'");
        }
        return regexp;
    }

    static boolean isDigit(char c) {
        return '0' <= c && c <= '9';
    }

    private static boolean isWord(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || NativeRegExp.isDigit(c) || c == '_';
    }

    private static boolean isControlLetter(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z';
    }

    private static boolean isLineTerm(char c) {
        return ScriptRuntime.isJSLineTerminator(c);
    }

    private static boolean isREWhiteSpace(int c) {
        return ScriptRuntime.isJSWhitespaceOrLineTerminator(c);
    }

    private static char upcase(char ch) {
        if (ch < '\u0080') {
            if ('a' <= ch && ch <= 'z') {
                return (char)(ch + -32);
            }
            return ch;
        }
        char cu = Character.toUpperCase(ch);
        return cu < '\u0080' ? ch : cu;
    }

    private static char downcase(char ch) {
        if (ch < '\u0080') {
            if ('A' <= ch && ch <= 'Z') {
                return (char)(ch + 32);
            }
            return ch;
        }
        char cl = Character.toLowerCase(ch);
        return cl < '\u0080' ? ch : cl;
    }

    private static boolean parseDisjunction(CompilerState state, ParserParameters params) {
        int index;
        if (!NativeRegExp.parseAlternative(state, params)) {
            return false;
        }
        char[] source = state.cpbegin;
        if ((index = state.cp++) != source.length && source[index] == '|') {
            RENode result = new RENode(32);
            result.kid = state.result;
            if (!NativeRegExp.parseDisjunction(state, params)) {
                return false;
            }
            result.kid2 = state.result;
            state.result = result;
            if (result.kid.op == 14 && result.kid2.op == 14 && result.kid.lowSurrogate == '\u0000' && result.kid2.lowSurrogate == '\u0000') {
                result.op = (byte)((state.flags & 2) == 0 ? 45 : 46);
                result.chr = result.kid.chr;
                result.index = result.kid2.chr;
                state.progLength += 13;
            } else if (result.kid.op == 21 && result.kid.index < 256 && result.kid2.op == 14 && result.kid2.lowSurrogate == '\u0000' && (state.flags & 2) == 0) {
                result.op = (byte)47;
                result.chr = result.kid2.chr;
                result.index = result.kid.index;
                state.progLength += 13;
            } else if (result.kid.op == 14 && result.kid2.op == 21 && result.kid2.index < 256 && result.kid.lowSurrogate == '\u0000' && (state.flags & 2) == 0) {
                result.op = (byte)47;
                result.chr = result.kid.chr;
                result.index = result.kid2.index;
                state.progLength += 13;
            } else {
                state.progLength += 9;
            }
        }
        return true;
    }

    private static boolean parseAlternative(CompilerState state, ParserParameters params) {
        RENode headTerm = null;
        RENode tailTerm = null;
        char[] source = state.cpbegin;
        block0: while (true) {
            if (state.cp == state.cpend || source[state.cp] == '|' || state.parenNesting != 0 && source[state.cp] == ')') {
                state.result = headTerm == null ? new RENode(1) : headTerm;
                return true;
            }
            if (!NativeRegExp.parseTerm(state, params)) {
                return false;
            }
            if (headTerm == null) {
                tailTerm = headTerm = state.result;
            } else {
                tailTerm.next = state.result;
            }
            while (true) {
                if (tailTerm.next == null) continue block0;
                RENode n = tailTerm.next;
                if (tailTerm.op == 14 && tailTerm.flatIndex != -1 && n.op == 14 && n.flatIndex == tailTerm.flatIndex + tailTerm.length) {
                    tailTerm.length += n.length;
                    tailTerm.next = n.next;
                    continue;
                }
                tailTerm = n;
            }
            break;
        }
    }

    private static boolean calculateBitmapSize(int flags, ClassContents classContents, RENode target) {
        char cd;
        char cu;
        char n;
        char max = '\u0000';
        for (char ch : classContents.chars) {
            if (ch > max) {
                max = ch;
            }
            if ((flags & 2) == 0 || (n = (cu = NativeRegExp.upcase(ch)) >= (cd = NativeRegExp.downcase(ch)) ? cu : cd) <= max) continue;
            max = n;
        }
        for (int i = 1; i < classContents.bmpRanges.size(); i += 2) {
            char rangeEnd = classContents.bmpRanges.get(i).charValue();
            if (rangeEnd > max) {
                max = rangeEnd;
            }
            if ((flags & 2) == 0) continue;
            cu = NativeRegExp.upcase(rangeEnd);
            char c = n = cu >= (cd = NativeRegExp.downcase(rangeEnd)) ? cu : cd;
            if (n <= max) continue;
            max = n;
        }
        for (RENode node : classContents.escapeNodes) {
            if (node.op == 14) continue;
            target.bmsize = 65536;
            break;
        }
        target.bmsize = Math.max(target.bmsize, max + '\u0001');
        return true;
    }

    private static void doFlat(CompilerState state, char c) {
        state.result = new RENode(14);
        state.result.chr = c;
        state.result.lowSurrogate = '\u0000';
        state.result.length = 1;
        state.result.flatIndex = -1;
        state.progLength += 3;
    }

    private static void doFlatSurrogatePair(CompilerState state, char high, char low) {
        state.result = new RENode(14);
        state.result.chr = high;
        state.result.lowSurrogate = low;
        state.result.length = 2;
        state.result.flatIndex = -1;
        state.progLength += 5;
    }

    private static int getDecimalValue(char c, CompilerState state, String overflowMessageId) {
        boolean overflow = false;
        int start = state.cp;
        char[] src = state.cpbegin;
        int value = c - 48;
        while (state.cp != state.cpend && NativeRegExp.isDigit(c = src[state.cp])) {
            if (!overflow) {
                int v = value * 10 + (c - 48);
                if (v < 65535) {
                    value = v;
                } else {
                    overflow = true;
                    value = 65535;
                }
            }
            ++state.cp;
        }
        if (overflow) {
            NativeRegExp.reportError(overflowMessageId, String.valueOf(src, start, state.cp - start));
        }
        return value;
    }

    private static RENode reverseNodeList(RENode head) {
        RENode prev = null;
        RENode node = head;
        while (node != null) {
            if (node.kid != null && node.op != 34 && node.op != 35 && node.op != 48 && node.op != 49) {
                node.kid = NativeRegExp.reverseNodeList(node.kid);
            }
            RENode next = node.next;
            node.next = prev;
            prev = node;
            node = next;
        }
        return prev;
    }

    private static boolean extractCaptureGroupName(CompilerState state, StringBuilder builder) {
        char[] src = state.cpbegin;
        int termBegin = state.cp;
        boolean isStart = true;
        int segmentStart = 0;
        int segmentLength = 0;
        if (state.cp >= state.cpend) {
            return false;
        }
        if (src[state.cp++] != '<') {
            state.cp = termBegin;
            return false;
        }
        while (state.cp < state.cpend && src[state.cp] != '>') {
            int codePoint;
            if (state.cp + 1 < state.cpend && src[state.cp] == '\\' && src[state.cp + 1] == 'u') {
                state.cp += 2;
                int n = NativeRegExp.readRegExpUnicodeEscapeSequence(state, new ParserParameters(false, true));
                if (n == -1) {
                    NativeRegExp.reportError("msg.invalid.escape", "");
                    state.cp = termBegin;
                    return false;
                }
                codePoint = n;
                if (segmentLength != 0) {
                    builder.append(src, segmentStart, segmentLength);
                    segmentLength = 0;
                }
                builder.appendCodePoint(codePoint);
            } else {
                codePoint = Character.codePointAt(src, state.cp);
                if (segmentLength != 0) {
                    segmentLength += Character.charCount(codePoint);
                } else {
                    segmentStart = state.cp;
                    segmentLength = Character.charCount(codePoint);
                }
                state.cp += Character.charCount(codePoint);
            }
            if (!(codePoint == 36 || isStart && codePoint == 95 || isStart && Character.isUnicodeIdentifierStart(codePoint) || !isStart && Character.isUnicodeIdentifierPart(codePoint))) {
                state.cp = termBegin;
                return false;
            }
            isStart = false;
        }
        if (state.cp >= state.cpend || src[state.cp++] != '>') {
            state.cp = termBegin;
            return false;
        }
        if (segmentLength != 0) {
            builder.append(src, segmentStart, segmentLength);
        }
        return true;
    }

    private static boolean parseLegacyOctalEscapeSequence(CompilerState state) {
        char[] src = state.cpbegin;
        char c = src[state.cp];
        if (c < '0' || c > '7') {
            return false;
        }
        int num = c - 48;
        ++state.cp;
        int nDigits = 1;
        while (nDigits < 3 && num < 32 && state.cp < state.cpend) {
            c = src[state.cp];
            ++nDigits;
            if (c < '0' || c > '7') break;
            ++state.cp;
            num = 8 * num + (c - 48);
        }
        c = (char)num;
        NativeRegExp.doFlat(state, c);
        return true;
    }

    private static boolean parseIdentityEscape(CompilerState state, ParserParameters params) {
        char[] src = state.cpbegin;
        if (state.cp < state.cpend) {
            char c = src[state.cp++];
            if (params.unicodeMode) {
                switch (c) {
                    case '$': 
                    case '(': 
                    case ')': 
                    case '*': 
                    case '+': 
                    case '.': 
                    case '/': 
                    case '?': 
                    case '[': 
                    case '\\': 
                    case ']': 
                    case '^': 
                    case '{': 
                    case '|': 
                    case '}': {
                        NativeRegExp.doFlat(state, c);
                        state.result.flatIndex = state.cp - 1;
                        return true;
                    }
                }
                --state.cp;
                return false;
            }
            if ('c' != c) {
                if (params.namedCaptureGroups) {
                    if ('k' != c) {
                        NativeRegExp.doFlat(state, c);
                        state.result.flatIndex = state.cp - 1;
                        return true;
                    }
                } else {
                    NativeRegExp.doFlat(state, c);
                    state.result.flatIndex = state.cp - 1;
                    return true;
                }
            }
        }
        --state.cp;
        return false;
    }

    private static int readNHexDigits(CompilerState state, int nDigits, ParserParameters params) {
        int termBegin = state.cp;
        int n = 0;
        for (int i = 0; i < nDigits; ++i) {
            char c;
            if (state.cp >= state.cpend) {
                if (params.unicodeMode || i == 0) {
                    state.cp = termBegin;
                    return -1;
                }
                return n;
            }
            if ((n = Kit.xDigitToInt(c = state.cpbegin[state.cp++], n)) >= 0) continue;
            state.cp = termBegin;
            return -1;
        }
        return n;
    }

    private static int parseUnicodeCodePoint(CompilerState state) {
        int res;
        char[] src = state.cpbegin;
        int cpOriginal = state.cp;
        int n = 0;
        if (state.cp == state.cpend || src[state.cp++] != '{') {
            state.cp = cpOriginal;
            return -1;
        }
        if (state.cp == state.cpend || src[state.cp] == '}') {
            NativeRegExp.reportError("msg.invalid.escape", "");
        }
        while (state.cp != state.cpend && src[state.cp] != '\\' && (res = Kit.xDigitToInt(src[state.cp], n)) != -1) {
            if (res > 0x10FFFF) {
                NativeRegExp.reportError("msg.invalid.escape", "");
            }
            n = res;
            ++state.cp;
        }
        if (state.cp == state.cpend || src[state.cp++] != '}') {
            state.cp = cpOriginal;
            return -1;
        }
        return n;
    }

    public static int readRegExpUnicodeEscapeSequence(CompilerState state, ParserParameters params) {
        char[] src = state.cpbegin;
        int n = NativeRegExp.readNHexDigits(state, 4, params);
        if (n < 0 && params.unicodeMode) {
            return NativeRegExp.parseUnicodeCodePoint(state);
        }
        if (params.unicodeMode && Character.isHighSurrogate((char)n) && state.cp + 2 < state.cpend && src[state.cp] == '\\' && src[state.cp + 1] == 'u') {
            state.cp += 2;
            int n2 = NativeRegExp.readNHexDigits(state, 4, params);
            if (n2 < 0) {
                state.cp -= 2;
            } else {
                if (Character.isLowSurrogate((char)n2)) {
                    return Character.toCodePoint((char)n, (char)n2);
                }
                state.cp -= 6;
            }
        }
        return n;
    }

    public static boolean parseRegExpUnicodeEscapeSequence(CompilerState state, ParserParameters params) {
        int n = NativeRegExp.readRegExpUnicodeEscapeSequence(state, params);
        if (n < 0) {
            return false;
        }
        if (n <= 65535) {
            NativeRegExp.doFlat(state, (char)n);
        } else {
            NativeRegExp.doFlatSurrogatePair(state, Character.highSurrogate(n), Character.lowSurrogate(n));
        }
        return true;
    }

    public static boolean parseUnicodePropertyEscape(CompilerState state) {
        boolean sense;
        char c;
        char[] src = state.cpbegin;
        int termBegin = state.cp;
        if ((c = src[state.cp++]) != 'p' && c != 'P') {
            state.cp = termBegin;
            return false;
        }
        boolean bl = sense = c == 'p';
        if (state.cp == state.cpend || src[state.cp++] != '{') {
            state.cp = termBegin;
            return false;
        }
        int contentBegin = state.cp;
        while (state.cp != state.cpend && (c = src[state.cp++]) != '}') {
        }
        int contentEnd = state.cp;
        if (contentBegin == contentEnd) {
            state.cp = termBegin;
            return false;
        }
        String content = new String(src, contentBegin, contentEnd - contentBegin - 1);
        int encodedProp = UnicodeProperties.lookup(content);
        if (encodedProp == -1) {
            NativeRegExp.reportError("msg.invalid.escape", "");
            return false;
        }
        state.result = new RENode(sense ? (byte)24 : 25);
        state.result.unicodeProperty = encodedProp;
        state.progLength += 3;
        return true;
    }

    private static boolean parseCharacterAndCharacterClassEscape(CompilerState state, ParserParameters params) {
        char[] src = state.cpbegin;
        int nDigits = 2;
        int termBegin = state.cp;
        if (state.cp >= state.cpend) {
            NativeRegExp.reportError("msg.trail.backslash", "");
            return false;
        }
        char c = src[state.cp++];
        switch (c) {
            case '0': {
                if (state.cp < state.cpend && NativeRegExp.isDigit(src[state.cp])) {
                    if (params.unicodeMode) {
                        NativeRegExp.reportError("msg.invalid.escape", "");
                        return false;
                    }
                    --state.cp;
                    if (NativeRegExp.parseLegacyOctalEscapeSequence(state)) break;
                    throw Kit.codeBug("parseLegacyOctalEscapeSequence failed");
                }
                NativeRegExp.doFlat(state, '\u0000');
                break;
            }
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': {
                if (params.unicodeMode) {
                    NativeRegExp.reportError("msg.invalid.escape", "");
                    return false;
                }
                --state.cp;
                if (NativeRegExp.parseLegacyOctalEscapeSequence(state)) break;
                throw Kit.codeBug("parseLegacyOctalEscapeSequence failed");
            }
            case 'f': {
                c = '\f';
                NativeRegExp.doFlat(state, c);
                break;
            }
            case 'n': {
                c = '\n';
                NativeRegExp.doFlat(state, c);
                break;
            }
            case 'r': {
                c = '\r';
                NativeRegExp.doFlat(state, c);
                break;
            }
            case 't': {
                c = '\t';
                NativeRegExp.doFlat(state, c);
                break;
            }
            case 'v': {
                c = '\u000b';
                NativeRegExp.doFlat(state, c);
                break;
            }
            case 'c': {
                if (state.cp >= state.cpend || !NativeRegExp.isControlLetter(src[state.cp])) {
                    state.cp = termBegin;
                    return false;
                }
                c = (char)(src[state.cp++] & 0x1F);
                NativeRegExp.doFlat(state, c);
                break;
            }
            case 'u': {
                if (NativeRegExp.parseRegExpUnicodeEscapeSequence(state, params)) break;
                --state.cp;
                if (NativeRegExp.parseIdentityEscape(state, params)) {
                    return true;
                }
                NativeRegExp.reportError("msg.invalid.escape", "");
                break;
            }
            case 'x': {
                int n = NativeRegExp.readNHexDigits(state, 2, params);
                if (n < 0) {
                    --state.cp;
                    if (NativeRegExp.parseIdentityEscape(state, params)) {
                        return true;
                    }
                    NativeRegExp.reportError("msg.invalid.escape", "");
                }
                NativeRegExp.doFlat(state, (char)n);
                break;
            }
            case 'd': {
                state.result = new RENode(7);
                ++state.progLength;
                break;
            }
            case 'D': {
                state.result = new RENode(8);
                ++state.progLength;
                break;
            }
            case 's': {
                state.result = new RENode(11);
                ++state.progLength;
                break;
            }
            case 'S': {
                state.result = new RENode(12);
                ++state.progLength;
                break;
            }
            case 'w': {
                state.result = new RENode(9);
                ++state.progLength;
                break;
            }
            case 'W': {
                state.result = new RENode(10);
                ++state.progLength;
                break;
            }
            case 'P': 
            case 'p': {
                --state.cp;
                if (NativeRegExp.parseUnicodePropertyEscape(state)) break;
                NativeRegExp.reportError("msg.invalid.property", "");
                break;
            }
            default: {
                --state.cp;
                return NativeRegExp.parseIdentityEscape(state, params);
            }
        }
        return true;
    }

    private static void parseMultipleLeadingZerosAsOctalEscape(CompilerState state) {
        char c;
        char[] src = state.cpbegin;
        int num = 0;
        NativeRegExp.reportWarning(state.cx, "msg.bad.backref", "");
        while (num < 32 && state.cp < state.cpend && (c = src[state.cp]) >= '0' && c <= '7') {
            ++state.cp;
            num = 8 * num + (c - 48);
        }
        c = (char)num;
        NativeRegExp.doFlat(state, c);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static ClassContents parseClassContents(CompilerState state, ParserParameters params) {
        char[] src = state.cpbegin;
        int rangeStart = 0;
        boolean inRange = false;
        int thisCodePoint = Integer.MAX_VALUE;
        ClassContents contents = new ClassContents();
        if (state.cp >= state.cpend) {
            return null;
        }
        if (src[state.cp] == ']') {
            ++state.cp;
            return contents;
        }
        if (src[state.cp] == '^') {
            ++state.cp;
            contents.sense = false;
        }
        while (state.cp != state.cpend && src[state.cp] != ']') {
            block21: {
                block22: {
                    block23: {
                        if (src[state.cp] != '\\') break block22;
                        ++state.cp;
                        if (state.cp >= state.cpend || src[state.cp] != 'b') break block23;
                        ++state.cp;
                        thisCodePoint = 8;
                        break block21;
                    }
                    if (params.unicodeMode && state.cp < state.cpend && src[state.cp] == '-') {
                        ++state.cp;
                        thisCodePoint = 45;
                        break block21;
                    } else {
                        if (!NativeRegExp.parseCharacterAndCharacterClassEscape(state, params)) {
                            if (src[state.cp] == 'c' && !params.unicodeMode) {
                                thisCodePoint = 92;
                                break block21;
                            } else {
                                NativeRegExp.reportError("msg.invalid.escape", "");
                                return null;
                            }
                        }
                        if (state.result.op == 14) {
                            thisCodePoint = state.result.lowSurrogate == '\u0000' ? (int)state.result.chr : Character.toCodePoint(state.result.chr, state.result.lowSurrogate);
                            break block21;
                        } else {
                            contents.escapeNodes.add(state.result);
                            if (inRange) {
                                if (!params.unicodeMode) {
                                    contents.chars.add(Character.valueOf('-'));
                                    inRange = false;
                                    continue;
                                }
                                NativeRegExp.reportError("msg.invalid.class", "");
                                continue;
                            }
                            if (state.cp >= state.cpend || src[state.cp] != '-' || !params.unicodeMode) continue;
                            NativeRegExp.reportError("msg.invalid.class", "");
                            continue;
                        }
                    }
                }
                if ((state.flags & 0x20) != 0) {
                    thisCodePoint = Character.codePointAt(src, state.cp, state.cpend);
                    state.cp += Character.charCount(thisCodePoint);
                } else {
                    thisCodePoint = src[state.cp];
                    ++state.cp;
                }
            }
            if (inRange) {
                if (rangeStart > thisCodePoint) {
                    NativeRegExp.reportError("msg.bad.range", "");
                    return null;
                }
                inRange = false;
                if (rangeStart > 65535 || thisCodePoint > 65535) {
                    contents.nonBMPRanges.add(rangeStart);
                    contents.nonBMPRanges.add(thisCodePoint);
                    continue;
                }
                contents.bmpRanges.add(Character.valueOf((char)rangeStart));
                contents.bmpRanges.add(Character.valueOf((char)thisCodePoint));
                continue;
            }
            if (thisCodePoint > 65535) {
                contents.nonBMPCodepoints.add(thisCodePoint);
            } else {
                contents.chars.add(Character.valueOf((char)thisCodePoint));
            }
            if (state.cp + 1 >= state.cpend || src[state.cp + 1] == ']' || src[state.cp] != '-') continue;
            ++state.cp;
            inRange = true;
            rangeStart = thisCodePoint;
        }
        if (state.cp < state.cpend && src[state.cp] == ']') {
            ++state.cp;
        }
        return contents;
    }

    private static boolean parseTerm(CompilerState state, ParserParameters params) {
        char[] src = state.cpbegin;
        char c = src[state.cp++];
        int parenBaseCount = state.parenCount;
        block0 : switch (c) {
            case '^': {
                state.result = new RENode(2);
                ++state.progLength;
                return true;
            }
            case '$': {
                state.result = new RENode(3);
                ++state.progLength;
                return true;
            }
            case '\\': {
                if (state.cp < state.cpend) {
                    c = src[state.cp++];
                    switch (c) {
                        case 'b': {
                            state.result = new RENode(4);
                            ++state.progLength;
                            return true;
                        }
                        case 'B': {
                            state.result = new RENode(5);
                            ++state.progLength;
                            return true;
                        }
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            int termStart = state.cp - 1;
                            int num = NativeRegExp.getDecimalValue(c, state, "msg.overlarge.backref");
                            if (!params.unicodeMode && num > state.backReferenceLimit) {
                                NativeRegExp.reportWarning(state.cx, "msg.bad.backref", "");
                                state.cp = termStart;
                                if (NativeRegExp.parseCharacterAndCharacterClassEscape(state, params)) break block0;
                                return false;
                            }
                            state.result = new RENode(13);
                            state.result.parenIndex = num - 1;
                            state.progLength += 3;
                            if (state.maxBackReference >= num) break block0;
                            state.maxBackReference = num;
                            break block0;
                        }
                        case '0': {
                            if (state.cp < state.cpend && src[state.cp] == '0') {
                                if (params.unicodeMode) {
                                    NativeRegExp.reportError("msg.invalid.escape", "");
                                    break block0;
                                }
                                NativeRegExp.parseMultipleLeadingZerosAsOctalEscape(state);
                                break block0;
                            }
                        }
                        default: {
                            --state.cp;
                            if (NativeRegExp.parseCharacterAndCharacterClassEscape(state, params)) break block0;
                            if (c == 'k' && params.namedCaptureGroups) {
                                ++state.cp;
                                StringBuilder groupNameBuilder = new StringBuilder();
                                if (NativeRegExp.extractCaptureGroupName(state, groupNameBuilder)) {
                                    String groupName = groupNameBuilder.toString();
                                    if (groupName.isEmpty()) {
                                        NativeRegExp.reportError("msg.invalid.group.name", "");
                                        return false;
                                    }
                                    state.result = new RENode(23);
                                    state.result.namedCaptureGroupBackRefIndex = state.namedCaptureBackRefs.size();
                                    state.namedCaptureBackRefs.add(groupName);
                                    state.progLength += 3;
                                    break block0;
                                }
                                NativeRegExp.reportError("msg.invalid.named.backref", "");
                                break block0;
                            }
                            if ('c' == c && !params.unicodeMode) {
                                NativeRegExp.doFlat(state, '\\');
                                break block0;
                            }
                            NativeRegExp.reportError("msg.invalid.escape", "");
                            return false;
                        }
                    }
                }
                NativeRegExp.reportError("msg.trail.backslash", "");
                break;
            }
            case '(': {
                RENode result = null;
                if (state.cp + 1 < state.cpend && src[state.cp] == '?' && ((c = src[state.cp + 1]) == '=' || c == '!' || c == ':')) {
                    state.cp += 2;
                    if (c == '=') {
                        result = new RENode(34);
                        state.progLength += 4;
                    } else if (c == '!') {
                        result = new RENode(35);
                        state.progLength += 4;
                    }
                } else if (state.cp + 2 < state.cpend && src[state.cp] == '?' && src[state.cp + 1] == '<' && ((c = src[state.cp + 2]) == '=' || c == '!')) {
                    state.cp += 3;
                    if (c == '=') {
                        result = new RENode(48);
                        state.progLength += 4;
                    } else {
                        result = new RENode(49);
                        state.progLength += 4;
                    }
                } else {
                    result = new RENode(30);
                    if (state.cp + 2 < state.cpend && src[state.cp] == '?' && src[state.cp + 1] == '<') {
                        ++state.cp;
                        StringBuilder nameBuilder = new StringBuilder();
                        if (!NativeRegExp.extractCaptureGroupName(state, nameBuilder)) {
                            NativeRegExp.reportError("msg.invalid.group.name", "");
                            return false;
                        }
                        result.namedCaptureGroupName = nameBuilder.toString();
                        if (result.namedCaptureGroupName.isEmpty()) {
                            NativeRegExp.reportError("msg.invalid.group.name", "");
                            return false;
                        }
                        state.namedCaptureGroupsFound = true;
                    }
                    state.progLength += 6;
                    result.parenIndex = state.parenCount++;
                }
                ++state.parenNesting;
                if (!NativeRegExp.parseDisjunction(state, params)) {
                    return false;
                }
                if (state.cp == state.cpend || src[state.cp] != ')') {
                    NativeRegExp.reportError("msg.unterm.paren", "");
                    return false;
                }
                ++state.cp;
                --state.parenNesting;
                if (result == null) break;
                if (result.op == 48 || result.op == 49) {
                    state.result = NativeRegExp.reverseNodeList(state.result);
                }
                result.kid = state.result;
                state.result = result;
                break;
            }
            case ')': {
                NativeRegExp.reportError("msg.re.unmatched.right.paren", "");
                return false;
            }
            case '[': {
                ClassContents classContents = NativeRegExp.parseClassContents(state, params);
                if (classContents == null) {
                    NativeRegExp.reportError("msg.unterm.class", "");
                    return false;
                }
                state.result = new RENode(21);
                state.result.classContents = classContents;
                state.result.index = state.classCount++;
                if (!NativeRegExp.calculateBitmapSize(state.flags, classContents, state.result)) {
                    return false;
                }
                state.progLength += 3;
                break;
            }
            case '.': {
                state.result = new RENode(6);
                ++state.progLength;
                break;
            }
            case '*': 
            case '+': 
            case '?': {
                NativeRegExp.reportError("msg.bad.quant", String.valueOf(src[state.cp - 1]));
                return false;
            }
            default: {
                if (params.unicodeMode && (c == ']' || c == '{' || c == '}')) {
                    NativeRegExp.reportError("msg.lone.quantifier.bracket", "");
                }
                if (params.unicodeMode && Character.isHighSurrogate(c) && state.cp < state.cpend && Character.isLowSurrogate(src[state.cp])) {
                    char low = src[state.cp++];
                    NativeRegExp.doFlatSurrogatePair(state, c, low);
                    break;
                }
                state.result = new RENode(14);
                state.result.chr = c;
                state.result.length = 1;
                state.result.flatIndex = state.cp - 1;
                state.progLength += 3;
            }
        }
        RENode term = state.result;
        if (state.cp == state.cpend) {
            return true;
        }
        boolean hasQ = false;
        switch (src[state.cp]) {
            case '+': {
                state.result = new RENode(26);
                state.result.min = 1;
                state.result.max = -1;
                state.progLength += 8;
                hasQ = true;
                break;
            }
            case '*': {
                state.result = new RENode(26);
                state.result.min = 0;
                state.result.max = -1;
                state.progLength += 8;
                hasQ = true;
                break;
            }
            case '?': {
                state.result = new RENode(26);
                state.result.min = 0;
                state.result.max = 1;
                state.progLength += 8;
                hasQ = true;
                break;
            }
            case '{': {
                int min = 0;
                int max = -1;
                int leftCurl = state.cp++;
                if (state.cp < src.length && NativeRegExp.isDigit(c = src[state.cp])) {
                    ++state.cp;
                    min = NativeRegExp.getDecimalValue(c, state, "msg.overlarge.min");
                    if (state.cp < src.length) {
                        c = src[state.cp];
                        if (c == ',' && ++state.cp < src.length) {
                            c = src[state.cp];
                            if (NativeRegExp.isDigit(c) && ++state.cp < src.length) {
                                max = NativeRegExp.getDecimalValue(c, state, "msg.overlarge.max");
                                c = src[state.cp];
                                if (min > max) {
                                    String msg = ScriptRuntime.getMessageById("msg.max.lt.min", max, min);
                                    throw ScriptRuntime.constructError("SyntaxError", msg);
                                }
                            }
                        } else {
                            max = min;
                        }
                        if (c == '}') {
                            state.result = new RENode(26);
                            state.result.min = min;
                            state.result.max = max;
                            state.progLength += 12;
                            hasQ = true;
                        }
                    }
                }
                if (hasQ) break;
                state.cp = leftCurl;
                break;
            }
        }
        if (!hasQ) {
            return true;
        }
        if (term.op == 48 || term.op == 49) {
            NativeRegExp.reportError("msg.bad.quant", "");
            return false;
        }
        if (params.unicodeMode && (term.op == 34 || term.op == 35)) {
            NativeRegExp.reportError("msg.bad.quant", "");
            return false;
        }
        ++state.cp;
        state.result.kid = term;
        state.result.parenIndex = parenBaseCount;
        state.result.parenCount = state.parenCount - parenBaseCount;
        if (state.cp < state.cpend && src[state.cp] == '?') {
            ++state.cp;
            state.result.greedy = false;
        } else {
            state.result.greedy = true;
        }
        return true;
    }

    private static void resolveForwardJump(byte[] array, int from, int pc) {
        if (from > pc) {
            throw Kit.codeBug();
        }
        NativeRegExp.addIndex(array, from, pc - from);
    }

    private static int getOffset(byte[] array, int pc) {
        return NativeRegExp.getIndex(array, pc);
    }

    private static int addIndex(byte[] array, int pc, int index) {
        if (index < 0) {
            throw Kit.codeBug();
        }
        if (index > 65535) {
            throw Context.reportRuntimeError("Too complex regexp");
        }
        array[pc] = (byte)(index >> 8);
        array[pc + 1] = (byte)index;
        return pc + 2;
    }

    private static int getIndex(byte[] array, int pc) {
        return (array[pc] & 0xFF) << 8 | array[pc + 1] & 0xFF;
    }

    private static int emitREBytecode(CompilerState state, RECompiled re, int pc, RENode t) {
        byte[] program = re.program;
        while (t != null) {
            program[pc++] = t.op;
            switch (t.op) {
                case 1: {
                    --pc;
                    break;
                }
                case 45: 
                case 46: 
                case 47: {
                    boolean ignoreCase = t.op == 46;
                    NativeRegExp.addIndex(program, pc, ignoreCase ? NativeRegExp.upcase(t.chr) : t.chr);
                    NativeRegExp.addIndex(program, pc += 2, ignoreCase ? (int)NativeRegExp.upcase((char)t.index) : t.index);
                    pc += 2;
                }
                case 32: {
                    RENode nextAlt = t.kid2;
                    int nextAltFixup = pc;
                    pc += 2;
                    pc = NativeRegExp.emitREBytecode(state, re, pc, t.kid);
                    program[pc++] = 33;
                    int nextTermFixup = pc;
                    NativeRegExp.resolveForwardJump(program, nextAltFixup, pc += 2);
                    pc = NativeRegExp.emitREBytecode(state, re, pc, nextAlt);
                    program[pc++] = 33;
                    nextAltFixup = pc;
                    NativeRegExp.resolveForwardJump(program, nextTermFixup, pc += 2);
                    NativeRegExp.resolveForwardJump(program, nextAltFixup, pc);
                    break;
                }
                case 14: {
                    if (t.flatIndex != -1 && t.length > 1) {
                        program[pc - 1] = (state.flags & 2) != 0 ? 16 : 14;
                        pc = NativeRegExp.addIndex(program, pc, t.flatIndex);
                        pc = NativeRegExp.addIndex(program, pc, t.length);
                        break;
                    }
                    if (t.chr < '\u0100') {
                        program[pc - 1] = (state.flags & 2) != 0 ? 17 : 15;
                        program[pc++] = (byte)t.chr;
                        break;
                    }
                    if (t.lowSurrogate == '\u0000') {
                        program[pc - 1] = (state.flags & 2) != 0 ? 19 : 18;
                        pc = NativeRegExp.addIndex(program, pc, t.chr);
                        break;
                    }
                    program[pc - 1] = 20;
                    pc = NativeRegExp.addIndex(program, pc, t.chr);
                    pc = NativeRegExp.addIndex(program, pc, t.lowSurrogate);
                    break;
                }
                case 30: {
                    pc = NativeRegExp.addIndex(program, pc, t.parenIndex);
                    pc = NativeRegExp.emitREBytecode(state, re, pc, t.kid);
                    program[pc++] = 31;
                    pc = NativeRegExp.addIndex(program, pc, t.parenIndex);
                    break;
                }
                case 13: {
                    pc = NativeRegExp.addIndex(program, pc, t.parenIndex);
                    break;
                }
                case 23: {
                    String backRefName;
                    if (re.namedBackRefs == null) {
                        NativeRegExp.reportError("msg.invalid.named.backref", "");
                        return pc;
                    }
                    try {
                        backRefName = re.namedBackRefs.get(t.namedCaptureGroupBackRefIndex);
                    }
                    catch (IndexOutOfBoundsException ioobe) {
                        Kit.codeBug("emitREBytecode: namedBackRefIndex(" + t.namedCaptureGroupBackRefIndex + ") out of bounds");
                        return pc;
                    }
                    List<Integer> indices = re.namedCaptureGroups.get(backRefName);
                    if (indices == null) {
                        NativeRegExp.reportError("msg.invalid.named.backref", "");
                        return pc;
                    }
                    if (indices.size() == 1) {
                        program[pc - 1] = 13;
                        pc = NativeRegExp.addIndex(program, pc, indices.get(0));
                        break;
                    }
                    pc = NativeRegExp.addIndex(program, pc, t.namedCaptureGroupBackRefIndex);
                    break;
                }
                case 34: 
                case 48: {
                    int nextTermFixup = pc;
                    pc += 2;
                    pc = NativeRegExp.emitREBytecode(state, re, pc, t.kid);
                    program[pc++] = t.op == 34 ? 36 : 50;
                    NativeRegExp.resolveForwardJump(program, nextTermFixup, pc);
                    break;
                }
                case 35: 
                case 49: {
                    int nextTermFixup = pc;
                    pc += 2;
                    pc = NativeRegExp.emitREBytecode(state, re, pc, t.kid);
                    program[pc++] = t.op == 35 ? 37 : 51;
                    NativeRegExp.resolveForwardJump(program, nextTermFixup, pc);
                    break;
                }
                case 26: {
                    if (t.min == 0 && t.max == -1) {
                        program[pc - 1] = t.greedy ? 27 : 38;
                    } else if (t.min == 0 && t.max == 1) {
                        program[pc - 1] = t.greedy ? 29 : 40;
                    } else if (t.min == 1 && t.max == -1) {
                        program[pc - 1] = t.greedy ? 28 : 39;
                    } else {
                        if (!t.greedy) {
                            program[pc - 1] = 41;
                        }
                        pc = NativeRegExp.addIndex(program, pc, t.min);
                        pc = NativeRegExp.addIndex(program, pc, t.max + 1);
                    }
                    pc = NativeRegExp.addIndex(program, pc, t.parenCount);
                    int nextTermFixup = pc = NativeRegExp.addIndex(program, pc, t.parenIndex);
                    pc += 2;
                    pc = NativeRegExp.emitREBytecode(state, re, pc, t.kid);
                    program[pc++] = 42;
                    NativeRegExp.resolveForwardJump(program, nextTermFixup, pc);
                    break;
                }
                case 21: {
                    if (!t.classContents.sense) {
                        program[pc - 1] = 22;
                    }
                    pc = NativeRegExp.addIndex(program, pc, t.index);
                    re.classList[t.index] = new RECharSet(t.classContents, t.bmsize);
                    break;
                }
                case 24: 
                case 25: {
                    pc = NativeRegExp.addIndex(program, pc, t.unicodeProperty);
                    break;
                }
            }
            t = t.next;
        }
        return pc;
    }

    private static void pushProgState(REGlobalData gData, int min, int max, int cp, boolean matchBackward, REBackTrackData backTrackLastToSave, int continuationOp, int continuationPc) {
        gData.stateStackTop = new REProgState(gData.stateStackTop, min, max, cp, backTrackLastToSave, matchBackward, continuationOp, continuationPc);
    }

    private static REProgState popProgState(REGlobalData gData) {
        REProgState state = gData.stateStackTop;
        gData.stateStackTop = state.previous;
        return state;
    }

    private static void pushBackTrackState(REGlobalData gData, byte op, int pc) {
        REProgState state = gData.stateStackTop;
        gData.backTrackStackTop = new REBackTrackData(gData, op, pc, gData.cp, state.continuationOp, state.continuationPc);
    }

    private static void pushBackTrackState(REGlobalData gData, byte op, int pc, int cp, int continuationOp, int continuationPc) {
        gData.backTrackStackTop = new REBackTrackData(gData, op, pc, cp, continuationOp, continuationPc);
    }

    private static boolean flatNMatcher(REGlobalData gData, int matchChars, int length, String input, int end) {
        if (gData.cp + length > end) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (gData.regexp.source[matchChars + i] == input.charAt(gData.cp + i)) continue;
            return false;
        }
        gData.cp += length;
        return true;
    }

    private static boolean flatNMatcherBackward(REGlobalData gData, int matchChars, int length, String input) {
        if (gData.cp - length < 0) {
            return false;
        }
        for (int i = 1; i <= length; ++i) {
            if (gData.regexp.source[matchChars + length - i] == input.charAt(gData.cp - i)) continue;
            return false;
        }
        gData.cp -= length;
        return true;
    }

    private static boolean flatNIMatcher(REGlobalData gData, int matchChars, int length, String input, int end) {
        if (gData.cp + length > end) {
            return false;
        }
        char[] source = gData.regexp.source;
        for (int i = 0; i < length; ++i) {
            char c1 = source[matchChars + i];
            char c2 = input.charAt(gData.cp + i);
            if (c1 == c2 || NativeRegExp.upcase(c1) == NativeRegExp.upcase(c2)) continue;
            return false;
        }
        gData.cp += length;
        return true;
    }

    private static boolean flatNIMatcherBackward(REGlobalData gData, int matchChars, int length, String input) {
        if (gData.cp - length < 0) {
            return false;
        }
        for (int i = 1; i <= length; ++i) {
            char c1 = gData.regexp.source[matchChars + length - i];
            char c2 = input.charAt(gData.cp - i);
            if (c1 == c2 || NativeRegExp.upcase(c1) == NativeRegExp.upcase(c2)) continue;
            return false;
        }
        gData.cp -= length;
        return true;
    }

    private static boolean backrefMatcher(REGlobalData gData, int parenIndex, String input, int end, boolean matchBackward) {
        if (gData.parens == null || parenIndex >= gData.parens.length) {
            return false;
        }
        int parenContent = gData.parensIndex(parenIndex);
        if (parenContent == -1) {
            return true;
        }
        int len = gData.parensLength(parenIndex);
        if (matchBackward) {
            if (gData.cp - len < 0) {
                return false;
            }
            if ((gData.regexp.flags & 2) != 0) {
                for (int i = 0; i < len; ++i) {
                    char c2;
                    char c1 = input.charAt(parenContent + i);
                    if (c1 == (c2 = input.charAt(gData.cp + i - len)) || NativeRegExp.upcase(c1) == NativeRegExp.upcase(c2)) continue;
                    return false;
                }
            } else if (!input.regionMatches(parenContent, input, gData.cp - len, len)) {
                return false;
            }
            gData.cp -= len;
        } else {
            if (gData.cp + len > end) {
                return false;
            }
            if ((gData.regexp.flags & 2) != 0) {
                for (int i = 0; i < len; ++i) {
                    char c2;
                    char c1 = input.charAt(parenContent + i);
                    if (c1 == (c2 = input.charAt(gData.cp + i)) || NativeRegExp.upcase(c1) == NativeRegExp.upcase(c2)) continue;
                    return false;
                }
            } else if (!input.regionMatches(parenContent, input, gData.cp, len)) {
                return false;
            }
            gData.cp += len;
        }
        return true;
    }

    private static void addCharacterToCharSet(RECharSet cs, char c) {
        int byteIndex = c / 8;
        if (c >= cs.length) {
            throw ScriptRuntime.constructError("SyntaxError", "invalid range in character class");
        }
        int n = byteIndex;
        cs.bits[n] = (byte)(cs.bits[n] | (byte)(1 << (c & 7)));
    }

    private static void addCharacterRangeToCharSet(RECharSet cs, char c1, char c2) {
        int byteIndex1 = c1 / 8;
        int byteIndex2 = c2 / 8;
        if (c2 >= cs.length || c1 > c2) {
            throw ScriptRuntime.constructError("SyntaxError", "invalid range in character class");
        }
        c1 = (char)(c1 & 7);
        c2 = (char)(c2 & 7);
        if (byteIndex1 == byteIndex2) {
            int n = byteIndex1;
            cs.bits[n] = (byte)(cs.bits[n] | (byte)(255 >> 7 - (c2 - c1) << c1));
        } else {
            int n = byteIndex1;
            cs.bits[n] = (byte)(cs.bits[n] | (byte)(255 << c1));
            for (int i = byteIndex1 + 1; i < byteIndex2; ++i) {
                cs.bits[i] = -1;
            }
            int n2 = byteIndex2;
            cs.bits[n2] = (byte)(cs.bits[n2] | (byte)(255 >> 7 - c2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processCharSet(REGlobalData gData, RECharSet charSet) {
        RECharSet rECharSet = charSet;
        synchronized (rECharSet) {
            if (!charSet.converted) {
                NativeRegExp.processCharSetImpl(gData, charSet);
                charSet.converted = true;
            }
        }
    }

    private static void processCharSetImpl(REGlobalData gData, RECharSet charSet) {
        ClassContents classContents = charSet.classContents;
        int byteLength = (charSet.length + 7) / 8;
        charSet.bits = new byte[byteLength];
        for (char ch : classContents.chars) {
            NativeRegExp.addCharacterToCharSet(charSet, ch);
            if ((gData.regexp.flags & 2) == 0) continue;
            char uch = NativeRegExp.upcase(ch);
            char dch = NativeRegExp.downcase(ch);
            if (ch != uch) {
                NativeRegExp.addCharacterToCharSet(charSet, uch);
            }
            if (ch == dch) continue;
            NativeRegExp.addCharacterToCharSet(charSet, dch);
        }
        block11: for (int j = 0; j < classContents.bmpRanges.size(); j += 2) {
            char start = classContents.bmpRanges.get(j).charValue();
            char end = classContents.bmpRanges.get(j + 1).charValue();
            if ((gData.regexp.flags & 2) != 0) {
                char ch = start;
                while (ch <= end) {
                    NativeRegExp.addCharacterToCharSet(charSet, ch);
                    char uch = NativeRegExp.upcase(ch);
                    char dch = NativeRegExp.downcase(ch);
                    if (ch != uch) {
                        NativeRegExp.addCharacterToCharSet(charSet, uch);
                    }
                    if (ch != dch) {
                        NativeRegExp.addCharacterToCharSet(charSet, dch);
                    }
                    if ((ch = (char)(ch + '\u0001')) != '\u0000') continue;
                    continue block11;
                }
                continue;
            }
            NativeRegExp.addCharacterRangeToCharSet(charSet, start, end);
        }
        block13: for (RENode escape : classContents.escapeNodes) {
            switch (escape.op) {
                case 7: {
                    NativeRegExp.addCharacterRangeToCharSet(charSet, '0', '9');
                    continue block13;
                }
                case 8: {
                    NativeRegExp.addCharacterRangeToCharSet(charSet, '\u0000', '/');
                    NativeRegExp.addCharacterRangeToCharSet(charSet, ':', (char)(charSet.length - 1));
                    continue block13;
                }
                case 11: {
                    int i;
                    for (i = charSet.length - 1; i >= 0; --i) {
                        if (!NativeRegExp.isREWhiteSpace(i)) continue;
                        NativeRegExp.addCharacterToCharSet(charSet, (char)i);
                    }
                    continue block13;
                }
                case 12: {
                    int i;
                    for (i = charSet.length - 1; i >= 0; --i) {
                        if (NativeRegExp.isREWhiteSpace(i)) continue;
                        NativeRegExp.addCharacterToCharSet(charSet, (char)i);
                    }
                    continue block13;
                }
                case 9: {
                    int i;
                    for (i = charSet.length - 1; i >= 0; --i) {
                        if (!NativeRegExp.isWord((char)i)) continue;
                        NativeRegExp.addCharacterToCharSet(charSet, (char)i);
                    }
                    continue block13;
                }
                case 10: {
                    int i;
                    for (i = charSet.length - 1; i >= 0; --i) {
                        if (NativeRegExp.isWord((char)i)) continue;
                        NativeRegExp.addCharacterToCharSet(charSet, (char)i);
                    }
                    continue block13;
                }
                case 24: {
                    charSet.unicodeProps.add(escape.unicodeProperty);
                    continue block13;
                }
                case 25: {
                    charSet.negUnicodeProps.add(escape.unicodeProperty);
                    continue block13;
                }
            }
            Kit.codeBug("classContents contains invalid escape node type");
        }
    }

    private static boolean classMatcher(REGlobalData gData, RECharSet charSet, int codePoint) {
        if (!charSet.converted) {
            NativeRegExp.processCharSet(gData, charSet);
        }
        if (codePoint <= 65535) {
            int byteIndex = codePoint >> 3;
            if (charSet.length != 0 && codePoint < charSet.length && (charSet.bits[byteIndex] & 1 << (codePoint & 7)) != 0) {
                return charSet.classContents.sense;
            }
        }
        if (charSet.classContents.nonBMPCodepoints.contains(codePoint)) {
            return charSet.classContents.sense;
        }
        for (int i = 0; i < charSet.classContents.nonBMPRanges.size(); i += 2) {
            if (codePoint < charSet.classContents.nonBMPRanges.get(i) || codePoint > charSet.classContents.nonBMPRanges.get(i + 1)) continue;
            return charSet.classContents.sense;
        }
        for (int encodedProp : charSet.unicodeProps) {
            if (!UnicodeProperties.hasProperty(encodedProp, codePoint)) continue;
            return charSet.classContents.sense;
        }
        for (int encodedProp : charSet.negUnicodeProps) {
            if (UnicodeProperties.hasProperty(encodedProp, codePoint)) continue;
            return charSet.classContents.sense;
        }
        return !charSet.classContents.sense;
    }

    private static boolean reopIsSimple(int op) {
        return op >= 1 && op <= 25;
    }

    private static int simpleMatch(REGlobalData gData, String input, int op, byte[] program, int pc, int end, boolean updatecp, boolean matchBackward) {
        int cpToMatch;
        int cpDelta;
        boolean result = false;
        int startcp = gData.cp;
        if ((gData.regexp.flags & 0x20) != 0 && gData.cp < end) {
            if (matchBackward) {
                if (gData.cp - 2 >= 0 && Character.isSurrogatePair(input.charAt(gData.cp - 2), input.charAt(gData.cp - 1))) {
                    cpDelta = -2;
                    cpToMatch = gData.cp - 2;
                } else {
                    cpDelta = -1;
                    cpToMatch = gData.cp - 1;
                }
            } else {
                cpDelta = Character.charCount(input.codePointAt(gData.cp));
                cpToMatch = gData.cp;
            }
        } else {
            cpDelta = matchBackward ? -1 : 1;
            cpToMatch = gData.cp + (matchBackward ? -1 : 0);
        }
        boolean cpInBounds = cpToMatch >= 0 && cpToMatch < end;
        switch (op) {
            case 1: {
                result = true;
                break;
            }
            case 2: {
                if (gData.cp != 0 && (!gData.multiline || !NativeRegExp.isLineTerm(input.charAt(gData.cp - 1)))) break;
                result = true;
                break;
            }
            case 3: {
                if (gData.cp != end && (!gData.multiline || !NativeRegExp.isLineTerm(input.charAt(gData.cp)))) break;
                result = true;
                break;
            }
            case 4: {
                result = (gData.cp == 0 || !NativeRegExp.isWord(input.charAt(gData.cp - 1))) ^ (gData.cp >= end || !NativeRegExp.isWord(input.charAt(gData.cp)));
                break;
            }
            case 5: {
                result = (gData.cp == 0 || !NativeRegExp.isWord(input.charAt(gData.cp - 1))) ^ (gData.cp < end && NativeRegExp.isWord(input.charAt(gData.cp)));
                break;
            }
            case 6: {
                if (!cpInBounds || (gData.regexp.flags & 8) == 0 && NativeRegExp.isLineTerm(input.charAt(cpToMatch))) break;
                result = true;
                gData.cp += cpDelta;
                break;
            }
            case 7: {
                if (!cpInBounds || !NativeRegExp.isDigit(input.charAt(cpToMatch))) break;
                result = true;
                gData.cp += cpDelta;
                break;
            }
            case 8: {
                if (!cpInBounds || NativeRegExp.isDigit(input.charAt(cpToMatch))) break;
                result = true;
                gData.cp += cpDelta;
                break;
            }
            case 9: {
                if (!cpInBounds || !NativeRegExp.isWord(input.charAt(cpToMatch))) break;
                result = true;
                gData.cp += cpDelta;
                break;
            }
            case 10: {
                if (!cpInBounds || NativeRegExp.isWord(input.charAt(cpToMatch))) break;
                result = true;
                gData.cp += cpDelta;
                break;
            }
            case 11: {
                if (!cpInBounds || !NativeRegExp.isREWhiteSpace(input.charAt(cpToMatch))) break;
                result = true;
                gData.cp += cpDelta;
                break;
            }
            case 12: {
                if (!cpInBounds || NativeRegExp.isREWhiteSpace(input.charAt(cpToMatch))) break;
                result = true;
                gData.cp += cpDelta;
                break;
            }
            case 13: {
                int parenIndex = NativeRegExp.getIndex(program, pc);
                pc += 2;
                result = NativeRegExp.backrefMatcher(gData, parenIndex, input, end, matchBackward);
                break;
            }
            case 23: {
                int backRefNameIndex = NativeRegExp.getIndex(program, pc);
                pc += 2;
                if (gData.parens == null || backRefNameIndex >= gData.regexp.namedBackRefs.size()) break;
                String backRefName = gData.regexp.namedBackRefs.get(backRefNameIndex);
                List<Integer> indices = gData.regexp.namedCaptureGroups.get(backRefName);
                boolean failed = false;
                for (int i : indices) {
                    if (gData.parensIndex(i) == -1) continue;
                    result = NativeRegExp.backrefMatcher(gData, i, input, end, matchBackward);
                    if (result) break;
                    failed = true;
                }
                if (failed) break;
                result = true;
                break;
            }
            case 14: {
                int offset = NativeRegExp.getIndex(program, pc);
                int length = NativeRegExp.getIndex(program, pc += 2);
                pc += 2;
                if (matchBackward) {
                    result = NativeRegExp.flatNMatcherBackward(gData, offset, length, input);
                    break;
                }
                result = NativeRegExp.flatNMatcher(gData, offset, length, input, end);
                break;
            }
            case 15: {
                int inputCodePoint;
                int matchCodePoint = program[pc++] & 0xFF;
                if (!cpInBounds || (inputCodePoint = (gData.regexp.flags & 0x20) != 0 ? input.codePointAt(cpToMatch) : (int)input.charAt(cpToMatch)) != matchCodePoint) break;
                result = true;
                gData.cp += cpDelta;
                break;
            }
            case 16: {
                int offset = NativeRegExp.getIndex(program, pc);
                int length = NativeRegExp.getIndex(program, pc += 2);
                pc += 2;
                if (matchBackward) {
                    result = NativeRegExp.flatNIMatcherBackward(gData, offset, length, input);
                    break;
                }
                result = NativeRegExp.flatNIMatcher(gData, offset, length, input, end);
                break;
            }
            case 17: {
                char c;
                int matchCodePoint = program[pc++] & 0xFF;
                if (!cpInBounds || matchCodePoint != (c = input.charAt(cpToMatch)) && NativeRegExp.upcase((char)matchCodePoint) != NativeRegExp.upcase(c)) break;
                result = true;
                gData.cp += cpDelta;
                break;
            }
            case 18: {
                int inputCodePoint;
                int matchCodePoint = NativeRegExp.getIndex(program, pc);
                pc += 2;
                if (!cpInBounds || (inputCodePoint = (gData.regexp.flags & 0x20) != 0 ? input.codePointAt(cpToMatch) : (int)input.charAt(cpToMatch)) != matchCodePoint) break;
                result = true;
                gData.cp += cpDelta;
                break;
            }
            case 19: {
                char c;
                int matchCodePoint = NativeRegExp.getIndex(program, pc);
                pc += 2;
                if (!cpInBounds || matchCodePoint != (c = input.charAt(cpToMatch)) && NativeRegExp.upcase((char)matchCodePoint) != NativeRegExp.upcase(c)) break;
                result = true;
                gData.cp += cpDelta;
                break;
            }
            case 21: 
            case 22: {
                int inputCodePoint;
                int index = NativeRegExp.getIndex(program, pc);
                pc += 2;
                if (!cpInBounds) break;
                int n = inputCodePoint = (gData.regexp.flags & 0x20) != 0 ? input.codePointAt(cpToMatch) : (int)input.charAt(cpToMatch);
                if (!NativeRegExp.classMatcher(gData, gData.regexp.classList[index], inputCodePoint)) break;
                gData.cp += cpDelta;
                result = true;
                break;
            }
            case 20: {
                int inputCodePoint;
                char highSurrogate = (char)NativeRegExp.getIndex(program, pc);
                char lowSurrogate = (char)NativeRegExp.getIndex(program, pc += 2);
                pc += 2;
                int matchCodePoint = Character.toCodePoint(highSurrogate, lowSurrogate);
                if (!cpInBounds || matchCodePoint != (inputCodePoint = input.codePointAt(cpToMatch))) break;
                result = true;
                gData.cp += cpDelta;
                break;
            }
            case 24: 
            case 25: {
                int encodedProp = NativeRegExp.getIndex(program, pc);
                pc += 2;
                if (!cpInBounds) break;
                boolean sense = op == 24;
                result = sense ^ !UnicodeProperties.hasProperty(encodedProp, input.codePointAt(cpToMatch));
                gData.cp += cpDelta;
                break;
            }
            default: {
                throw Kit.codeBug();
            }
        }
        if (result) {
            if (!updatecp) {
                gData.cp = startcp;
            }
            return pc;
        }
        gData.cp = startcp;
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean executeREBytecode(Context cx, REGlobalData gData, String input, int end) {
        pc = 0;
        program = gData.regexp.program;
        continuationOp = 52;
        continuationPc = 0;
        result = false;
        matchBackward = false;
        op = program[pc++];
        if (gData.regexp.anchorCodePoint < 0 && NativeRegExp.reopIsSimple(op)) {
            anchor = false;
            while (gData.cp <= end) {
                match = NativeRegExp.simpleMatch(gData, input, op, program, pc, end, true, false);
                if (match >= 0) {
                    anchor = true;
                    pc = match;
                    op = program[pc++];
                    break;
                }
                if ((gData.regexp.flags & 16) != 0) {
                    return false;
                }
                if ((gData.regexp.flags & 32) != 0 && gData.cp < end) {
                    toSkip = Character.charCount(input.codePointAt(gData.cp));
                    gData.cp += toSkip;
                    gData.skipped += toSkip;
                    continue;
                }
                ++gData.cp;
                ++gData.skipped;
            }
            if (!anchor) {
                return false;
            }
        }
        v0 = instructionCounting = cx.getInstructionObserverThreshold() != 0;
        block28: while (true) {
            block75: {
                block74: {
                    if (instructionCounting) {
                        ScriptRuntime.addInstructionCount(cx, 5);
                    }
                    if (!NativeRegExp.reopIsSimple(op)) break block74;
                    match = NativeRegExp.simpleMatch(gData, input, op, program, pc, end, true, matchBackward);
                    v1 = result = match >= 0;
                    if (result) {
                        pc = match;
                    }
                    break block75;
                }
                block0 : switch (op) {
                    case 45: 
                    case 46: 
                    case 47: {
                        matchCh1 = (char)NativeRegExp.getIndex(program, pc);
                        matchCh2 = (char)NativeRegExp.getIndex(program, pc += 2);
                        pc += 2;
                        cpToMatch = gData.cp + (matchBackward != false ? -1 : 0);
                        v2 = cpInBounds = cpToMatch >= 0 && cpToMatch < end;
                        if (!cpInBounds) {
                            result = false;
                            break;
                        }
                        c = input.charAt(cpToMatch);
                        if (op != 47) ** GOTO lbl56
                        if (c != matchCh1 && !NativeRegExp.classMatcher(gData, gData.regexp.classList[matchCh2], c)) {
                            result = false;
                            break;
                        }
                        ** GOTO lbl61
lbl56:
                        // 1 sources

                        if (op == 46) {
                            c = NativeRegExp.upcase(c);
                        }
                        if (c != matchCh1 && c != matchCh2) {
                            result = false;
                            break;
                        }
                    }
lbl61:
                    // 4 sources

                    case 32: {
                        nextpc = pc + NativeRegExp.getOffset(program, pc);
                        pc += 2;
                        op = program[pc++];
                        startcp = gData.cp;
                        if (NativeRegExp.reopIsSimple(op)) {
                            match = NativeRegExp.simpleMatch(gData, input, op, program, pc, end, true, matchBackward);
                            if (match < 0) {
                                op = program[nextpc++];
                                pc = nextpc;
                                continue block28;
                            }
                            result = true;
                            pc = match;
                            op = program[pc++];
                        }
                        nextop = program[nextpc++];
                        NativeRegExp.pushBackTrackState(gData, nextop, nextpc, startcp, continuationOp, continuationPc);
                        continue block28;
                    }
                    case 33: {
                        offset = NativeRegExp.getOffset(program, pc);
                        pc += offset;
                        op = program[pc++];
                        continue block28;
                    }
                    case 30: {
                        parenIndex = NativeRegExp.getIndex(program, pc);
                        pc += 2;
                        gData.setParens(parenIndex, gData.cp, 0);
                        op = program[pc++];
                        continue block28;
                    }
                    case 31: {
                        parenIndex = NativeRegExp.getIndex(program, pc);
                        pc += 2;
                        cap_index = gData.parensIndex(parenIndex);
                        if (matchBackward) {
                            gData.setParens(parenIndex, gData.cp, cap_index - gData.cp);
                        } else {
                            gData.setParens(parenIndex, cap_index, gData.cp - cap_index);
                        }
                        op = program[pc++];
                        continue block28;
                    }
                    case 48: {
                        nextpc = pc + NativeRegExp.getIndex(program, pc);
                        pc += 2;
                        op = program[pc++];
                        if (NativeRegExp.reopIsSimple(op) && NativeRegExp.simpleMatch(gData, input, op, program, pc, end, false, true) < 0) {
                            result = false;
                            break;
                        }
                        NativeRegExp.pushProgState(gData, 0, 0, gData.cp, matchBackward, gData.backTrackStackTop, continuationOp, continuationPc);
                        NativeRegExp.pushBackTrackState(gData, (byte)50, nextpc, gData.cp, continuationOp, continuationPc);
                        matchBackward = true;
                        continue block28;
                    }
                    case 49: {
                        nextpc = pc + NativeRegExp.getIndex(program, pc);
                        pc += 2;
                        op = program[pc++];
                        if (NativeRegExp.reopIsSimple(op) && (match = NativeRegExp.simpleMatch(gData, input, op, program, pc, end, false, true)) >= 0 && program[match] == 51) {
                            result = false;
                            break;
                        }
                        NativeRegExp.pushProgState(gData, 0, 0, gData.cp, matchBackward, gData.backTrackStackTop, continuationOp, continuationPc);
                        NativeRegExp.pushBackTrackState(gData, (byte)51, nextpc, gData.cp, continuationOp, continuationPc);
                        matchBackward = true;
                        continue block28;
                    }
                    case 34: {
                        nextpc = pc + NativeRegExp.getIndex(program, pc);
                        pc += 2;
                        op = program[pc++];
                        if (NativeRegExp.reopIsSimple(op) && NativeRegExp.simpleMatch(gData, input, op, program, pc, end, false, false) < 0) {
                            result = false;
                            break;
                        }
                        NativeRegExp.pushProgState(gData, 0, 0, gData.cp, matchBackward, gData.backTrackStackTop, continuationOp, continuationPc);
                        NativeRegExp.pushBackTrackState(gData, (byte)36, nextpc);
                        matchBackward = false;
                        continue block28;
                    }
                    case 35: {
                        nextpc = pc + NativeRegExp.getIndex(program, pc);
                        pc += 2;
                        op = program[pc++];
                        if (NativeRegExp.reopIsSimple(op) && (match = NativeRegExp.simpleMatch(gData, input, op, program, pc, end, false, false)) >= 0 && program[match] == 37) {
                            result = false;
                            break;
                        }
                        NativeRegExp.pushProgState(gData, 0, 0, gData.cp, matchBackward, gData.backTrackStackTop, continuationOp, continuationPc);
                        NativeRegExp.pushBackTrackState(gData, (byte)37, nextpc);
                        matchBackward = false;
                        continue block28;
                    }
                    case 36: 
                    case 37: 
                    case 50: 
                    case 51: {
                        state = NativeRegExp.popProgState(gData);
                        gData.cp = state.index;
                        gData.backTrackStackTop = state.backTrack;
                        matchBackward = state.matchBackward;
                        continuationPc = state.continuationPc;
                        continuationOp = state.continuationOp;
                        if (op != 37 && op != 51) break;
                        result = result == false;
                        break;
                    }
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: {
                        greedy = false;
                        switch (op) {
                            case 27: {
                                greedy = true;
                            }
                            case 38: {
                                min = 0;
                                max = -1;
                                break;
                            }
                            case 28: {
                                greedy = true;
                            }
                            case 39: {
                                min = 1;
                                max = -1;
                                break;
                            }
                            case 29: {
                                greedy = true;
                            }
                            case 40: {
                                min = 0;
                                max = 1;
                                break;
                            }
                            case 26: {
                                greedy = true;
                            }
                            case 41: {
                                min = NativeRegExp.getOffset(program, pc);
                                max = NativeRegExp.getOffset(program, pc += 2) - 1;
                                pc += 2;
                                break;
                            }
                            default: {
                                throw Kit.codeBug();
                            }
                        }
                        NativeRegExp.pushProgState(gData, min, max, gData.cp, matchBackward, null, continuationOp, continuationPc);
                        if (greedy) {
                            NativeRegExp.pushBackTrackState(gData, (byte)43, pc);
                            continuationOp = 43;
                            continuationPc = pc;
                            pc += 6;
                        } else if (min != 0) {
                            continuationOp = 44;
                            continuationPc = pc;
                            pc += 6;
                        } else {
                            NativeRegExp.pushBackTrackState(gData, (byte)44, pc);
                            NativeRegExp.popProgState(gData);
                            pc += 4;
                            pc += NativeRegExp.getOffset(program, pc);
                        }
                        op = program[pc++];
                        continue block28;
                    }
                    case 42: {
                        result = true;
                        pc = continuationPc;
                        op = continuationOp;
                        continue block28;
                    }
                    case 43: {
                        do {
                            state = NativeRegExp.popProgState(gData);
                            if (!result) {
                                if (state.min == 0) {
                                    result = true;
                                }
                                continuationPc = state.continuationPc;
                                continuationOp = state.continuationOp;
                                pc += 4;
                                pc += NativeRegExp.getOffset(program, pc);
                                break block0;
                            }
                            if (state.min == 0 && (gData.cp == state.index || state.max == 0)) {
                                result = false;
                                continuationPc = state.continuationPc;
                                continuationOp = state.continuationOp;
                                pc += 4;
                                pc += NativeRegExp.getOffset(program, pc);
                                break block0;
                            }
                            new_min = state.min;
                            new_max = state.max;
                            if (new_min != 0) {
                                --new_min;
                            }
                            if (new_max != -1) {
                                --new_max;
                            }
                            if (new_max == 0) {
                                result = true;
                                continuationPc = state.continuationPc;
                                continuationOp = state.continuationOp;
                                pc += 4;
                                pc += NativeRegExp.getOffset(program, pc);
                                break block0;
                            }
                            nextpc = pc + 6;
                            nextop = program[nextpc];
                            startcp = gData.cp;
                            if (NativeRegExp.reopIsSimple(nextop)) {
                                if ((match = NativeRegExp.simpleMatch(gData, input, nextop, program, ++nextpc, end, true, matchBackward)) < 0) {
                                    result = new_min == 0;
                                    continuationPc = state.continuationPc;
                                    continuationOp = state.continuationOp;
                                    pc += 4;
                                    pc += NativeRegExp.getOffset(program, pc);
                                    break block0;
                                }
                                result = true;
                                nextpc = match;
                            }
                            continuationOp = 43;
                            continuationPc = pc;
                            NativeRegExp.pushProgState(gData, new_min, new_max, startcp, matchBackward, null, state.continuationOp, state.continuationPc);
                            if (new_min == 0) {
                                NativeRegExp.pushBackTrackState(gData, (byte)43, pc, startcp, state.continuationOp, state.continuationPc);
                            }
                            parenCount = NativeRegExp.getIndex(program, pc);
                            parenIndex = NativeRegExp.getIndex(program, pc + 2);
                            for (k = 0; k < parenCount; ++k) {
                                gData.setParens(parenIndex + k, -1, 0);
                            }
                        } while (program[nextpc] == 42);
                        pc = nextpc;
                        op = program[pc++];
                        continue block28;
                    }
                    case 44: {
                        state = NativeRegExp.popProgState(gData);
                        if (!result) {
                            if (state.max == -1 || state.max > 0) {
                                NativeRegExp.pushProgState(gData, state.min, state.max, gData.cp, matchBackward, null, state.continuationOp, state.continuationPc);
                                continuationOp = 44;
                                continuationPc = pc;
                                parenCount = NativeRegExp.getIndex(program, pc);
                                parenIndex = NativeRegExp.getIndex(program, pc += 2);
                                pc += 4;
                                for (k = 0; k < parenCount; ++k) {
                                    gData.setParens(parenIndex + k, -1, 0);
                                }
                                op = program[pc++];
                                continue block28;
                            }
                            continuationPc = state.continuationPc;
                            continuationOp = state.continuationOp;
                            break;
                        }
                        if (state.min == 0 && gData.cp == state.index) {
                            result = false;
                            continuationPc = state.continuationPc;
                            continuationOp = state.continuationOp;
                            break;
                        }
                        new_min = state.min;
                        new_max = state.max;
                        if (new_min != 0) {
                            --new_min;
                        }
                        if (new_max != -1) {
                            --new_max;
                        }
                        NativeRegExp.pushProgState(gData, new_min, new_max, gData.cp, matchBackward, null, state.continuationOp, state.continuationPc);
                        if (new_min != 0) {
                            continuationOp = 44;
                            continuationPc = pc;
                            parenCount = NativeRegExp.getIndex(program, pc);
                            parenIndex = NativeRegExp.getIndex(program, pc += 2);
                            pc += 4;
                            for (k = 0; k < parenCount; ++k) {
                                gData.setParens(parenIndex + k, -1, 0);
                            }
                        } else {
                            continuationPc = state.continuationPc;
                            continuationOp = state.continuationOp;
                            NativeRegExp.pushBackTrackState(gData, (byte)44, pc);
                            NativeRegExp.popProgState(gData);
                            pc += 4;
                            pc += NativeRegExp.getOffset(program, pc);
                        }
                        op = program[pc++];
                        continue block28;
                    }
                    case 52: {
                        return true;
                    }
                    default: {
                        throw Kit.codeBug("invalid bytecode");
                    }
                }
            }
            if (!result) {
                backTrackData = gData.backTrackStackTop;
                if (backTrackData != null) {
                    gData.backTrackStackTop = backTrackData.previous;
                    gData.parens = backTrackData.parens;
                    gData.cp = backTrackData.cp;
                    gData.stateStackTop = backTrackData.stateStackTop;
                    continuationOp = backTrackData.continuationOp;
                    continuationPc = backTrackData.continuationPc;
                    pc = backTrackData.pc;
                    op = backTrackData.op;
                    continue;
                }
                return false;
            }
            op = program[pc++];
        }
    }

    static boolean matchRegExp(Context cx, REGlobalData gData, RECompiled re, String input, int start, int end, boolean multiline) {
        gData.parens = (long[])(re.parenCount != 0 ? new long[re.parenCount] : null);
        gData.backTrackStackTop = null;
        gData.stateStackTop = null;
        gData.multiline = multiline || (re.flags & 4) != 0;
        gData.regexp = re;
        int anchorCodePoint = gData.regexp.anchorCodePoint;
        for (int i = start; i <= end; ++i) {
            if (anchorCodePoint >= 0) {
                while (true) {
                    int charCount;
                    if (i == end) {
                        return false;
                    }
                    if ((gData.regexp.flags & 0x20) != 0) {
                        int matchCodePoint = input.codePointAt(i);
                        if (matchCodePoint == anchorCodePoint) break;
                        charCount = Character.charCount(matchCodePoint);
                    } else {
                        char matchCh = input.charAt(i);
                        if (matchCh == anchorCodePoint || (gData.regexp.flags & 2) != 0 && NativeRegExp.upcase(matchCh) == NativeRegExp.upcase((char)anchorCodePoint)) break;
                        charCount = 1;
                    }
                    if ((gData.regexp.flags & 0x10) != 0) {
                        return false;
                    }
                    i += charCount;
                }
            }
            gData.cp = i;
            gData.skipped = i - start;
            for (int j = 0; j < re.parenCount; ++j) {
                gData.parens[j] = -1L;
            }
            boolean result = NativeRegExp.executeREBytecode(cx, gData, input, end);
            gData.backTrackStackTop = null;
            gData.stateStackTop = null;
            if (result) {
                return true;
            }
            if (anchorCodePoint == -2 && !gData.multiline) {
                gData.skipped = end;
                return false;
            }
            if ((gData.regexp.flags & 0x10) != 0) {
                return false;
            }
            i = start + gData.skipped;
        }
        return false;
    }

    Object executeRegExp(Context cx, Scriptable scope, RegExpImpl res, String str, int[] indexp, int matchType) {
        Scriptable obj;
        Object result;
        int index;
        boolean matches;
        REGlobalData gData = new REGlobalData();
        int start = indexp[0];
        int end = str.length();
        if (start > end) {
            start = end;
        }
        if (!(matches = NativeRegExp.matchRegExp(cx, gData, this.re, str, start, end, res.multiline))) {
            if (matchType != 2) {
                return null;
            }
            return Undefined.instance;
        }
        int ep = indexp[0] = (index = gData.cp);
        int matchlen = ep - (start + gData.skipped);
        index -= matchlen;
        Scriptable groups = Undefined.SCRIPTABLE_UNDEFINED;
        if (matchType == 0) {
            result = Boolean.TRUE;
            obj = null;
        } else {
            result = cx.newArray(scope, 0);
            obj = (Scriptable)result;
            String matchstr = str.substring(index, index + matchlen);
            obj.put(0, obj, (Object)matchstr);
        }
        if (this.re.parenCount == 0) {
            res.parens = null;
            res.lastParen = new SubString();
        } else {
            SubString parsub = null;
            String[] namedCaptureGroups = null;
            if (matchType != 0) {
                namedCaptureGroups = new String[this.re.parenCount];
                if (!this.re.namedCaptureGroups.isEmpty()) {
                    groups = new NativeObject();
                }
                for (Map.Entry<String, List<Integer>> entry : this.re.namedCaptureGroups.entrySet()) {
                    String key = entry.getKey();
                    List<Integer> indices = entry.getValue();
                    for (int i : indices) {
                        namedCaptureGroups[i] = key;
                    }
                }
            }
            res.parens = new SubString[this.re.parenCount];
            for (int num = 0; num < this.re.parenCount; ++num) {
                int cap_index = gData.parensIndex(num);
                if (cap_index != -1) {
                    int cap_length = gData.parensLength(num);
                    res.parens[num] = parsub = new SubString(str, cap_index, cap_length);
                    if (matchType == 0) continue;
                    obj.put(num + 1, obj, (Object)parsub.toString());
                    if (namedCaptureGroups[num] == null) continue;
                    groups.put(namedCaptureGroups[num], groups, (Object)parsub.toString());
                    continue;
                }
                if (matchType == 0) continue;
                obj.put(num + 1, obj, Undefined.instance);
                if (namedCaptureGroups[num] == null || groups.has(namedCaptureGroups[num], groups)) continue;
                groups.put(namedCaptureGroups[num], groups, Undefined.instance);
            }
            res.lastParen = parsub;
        }
        if (matchType != 0) {
            obj.put("index", obj, (Object)(start + gData.skipped));
            obj.put("input", obj, (Object)str);
            obj.put("groups", obj, (Object)groups);
        }
        if (res.lastMatch == null) {
            res.lastMatch = new SubString();
            res.leftContext = new SubString();
            res.rightContext = new SubString();
        }
        res.lastMatch.str = str;
        res.lastMatch.index = index;
        res.lastMatch.length = matchlen;
        res.leftContext.str = str;
        res.leftContext.index = 0;
        res.leftContext.length = start + gData.skipped;
        res.rightContext.str = str;
        res.rightContext.index = ep;
        res.rightContext.length = end - ep;
        return result;
    }

    public int getFlags() {
        return this.re.flags;
    }

    private static void reportWarning(Context cx, String messageId, String arg) {
    }

    private static void reportError(String messageId, String arg) {
        String msg = ScriptRuntime.getMessageById(messageId, arg);
        throw ScriptRuntime.constructError("SyntaxError", msg);
    }

    @Override
    protected int getMaxInstanceId() {
        return 9;
    }

    @Override
    protected int findInstanceIdInfo(String s) {
        int attr;
        int id;
        switch (s) {
            case "lastIndex": {
                id = 1;
                break;
            }
            case "source": {
                id = 2;
                break;
            }
            case "flags": {
                id = 3;
                break;
            }
            case "global": {
                id = 4;
                break;
            }
            case "ignoreCase": {
                id = 5;
                break;
            }
            case "multiline": {
                id = 6;
                break;
            }
            case "dotAll": {
                id = 7;
                break;
            }
            case "sticky": {
                id = 8;
                break;
            }
            case "unicode": {
                id = 9;
                break;
            }
            default: {
                id = 0;
            }
        }
        if (id == 0) {
            return super.findInstanceIdInfo(s);
        }
        switch (id) {
            case 1: {
                attr = this.lastIndexAttr;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                attr = 7;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return NativeRegExp.instanceIdInfo(attr, id);
    }

    @Override
    protected String getInstanceIdName(int id) {
        switch (id) {
            case 1: {
                return "lastIndex";
            }
            case 2: {
                return "source";
            }
            case 3: {
                return "flags";
            }
            case 4: {
                return "global";
            }
            case 5: {
                return "ignoreCase";
            }
            case 6: {
                return "multiline";
            }
            case 7: {
                return "dotAll";
            }
            case 8: {
                return "sticky";
            }
            case 9: {
                return "unicode";
            }
        }
        return super.getInstanceIdName(id);
    }

    @Override
    protected Object getInstanceIdValue(int id) {
        switch (id) {
            case 1: {
                return this.lastIndex;
            }
            case 2: {
                return new String(this.re.source);
            }
            case 3: {
                StringBuilder buf = new StringBuilder();
                this.appendFlags(buf);
                return buf.toString();
            }
            case 4: {
                return ScriptRuntime.wrapBoolean((this.re.flags & 1) != 0);
            }
            case 5: {
                return ScriptRuntime.wrapBoolean((this.re.flags & 2) != 0);
            }
            case 6: {
                return ScriptRuntime.wrapBoolean((this.re.flags & 4) != 0);
            }
            case 7: {
                return ScriptRuntime.wrapBoolean((this.re.flags & 8) != 0);
            }
            case 8: {
                return ScriptRuntime.wrapBoolean((this.re.flags & 0x10) != 0);
            }
            case 9: {
                return ScriptRuntime.wrapBoolean((this.re.flags & 0x20) != 0);
            }
        }
        return super.getInstanceIdValue(id);
    }

    private void setLastIndex(ScriptableObject thisObj, Object value) {
        if ((thisObj.getAttributes("lastIndex") & 1) != 0) {
            throw ScriptRuntime.typeErrorById("msg.modify.readonly", "lastIndex");
        }
        this.setLastIndex((Scriptable)thisObj, value);
    }

    private void setLastIndex(Scriptable thisObj, Object value) {
        ScriptableObject.putProperty(thisObj, "lastIndex", value);
    }

    private void setLastIndex(Object value) {
        if ((this.lastIndexAttr & 1) != 0) {
            throw ScriptRuntime.typeErrorById("msg.modify.readonly", "lastIndex");
        }
        this.lastIndex = value;
    }

    @Override
    protected void setInstanceIdValue(int id, Object value) {
        switch (id) {
            case 1: {
                this.setLastIndex(value);
                return;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return;
            }
        }
        super.setInstanceIdValue(id, value);
    }

    @Override
    protected void setInstanceIdAttributes(int id, int attr) {
        if (id == 1) {
            this.lastIndexAttr = attr;
            return;
        }
        super.setInstanceIdAttributes(id, attr);
    }

    @Override
    protected void initPrototypeId(int id) {
        String s;
        int arity;
        if (id == 7) {
            this.initPrototypeMethod(REGEXP_TAG, id, SymbolKey.MATCH, "[Symbol.match]", 1);
            return;
        }
        if (id == 8) {
            this.initPrototypeMethod(REGEXP_TAG, id, SymbolKey.MATCH_ALL, "[Symbol.matchAll]", 1);
            return;
        }
        if (id == 9) {
            this.initPrototypeMethod(REGEXP_TAG, id, SymbolKey.SEARCH, "[Symbol.search]", 1);
            return;
        }
        if (id == 10) {
            this.initPrototypeMethod(REGEXP_TAG, id, SymbolKey.REPLACE, "[Symbol.replace]", 2);
            return;
        }
        if (id == 11) {
            this.initPrototypeMethod(REGEXP_TAG, id, SymbolKey.SPLIT, "[Symbol.split]", 2);
            return;
        }
        switch (id) {
            case 1: {
                arity = 2;
                s = "compile";
                break;
            }
            case 2: {
                arity = 0;
                s = "toString";
                break;
            }
            case 3: {
                arity = 0;
                s = "toSource";
                break;
            }
            case 4: {
                arity = 1;
                s = "exec";
                break;
            }
            case 5: {
                arity = 1;
                s = "test";
                break;
            }
            case 6: {
                arity = 1;
                s = "prefix";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(id));
            }
        }
        this.initPrototypeMethod(REGEXP_TAG, id, s, arity);
    }

    @Override
    public Object execIdCall(IdFunctionObject f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!f.hasTag(REGEXP_TAG)) {
            return super.execIdCall(f, cx, scope, thisObj, args);
        }
        int id = f.methodId();
        switch (id) {
            case 1: {
                return NativeRegExp.realThis(thisObj, f).compile(cx, scope, args);
            }
            case 2: {
                if (thisObj != scope && thisObj instanceof NativeObject) {
                    Object sourceObj = thisObj.get("source", thisObj);
                    String source = sourceObj.equals(NOT_FOUND) ? "undefined" : NativeRegExp.escapeRegExp(sourceObj);
                    Object flagsObj = thisObj.get("flags", thisObj);
                    String flags = flagsObj.equals(NOT_FOUND) ? "undefined" : flagsObj.toString();
                    return "/" + source + "/" + flags;
                }
                return NativeRegExp.realThis(thisObj, f).toString();
            }
            case 3: {
                return NativeRegExp.realThis(thisObj, f).toString();
            }
            case 4: {
                return NativeRegExp.js_exec(cx, scope, thisObj, args);
            }
            case 5: {
                Object x = NativeRegExp.realThis(thisObj, f).execSub(cx, scope, args, 0);
                return Boolean.TRUE.equals(x) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 6: {
                return NativeRegExp.realThis(thisObj, f).execSub(cx, scope, args, 2);
            }
            case 7: {
                return this.js_SymbolMatch(cx, scope, thisObj, args);
            }
            case 8: {
                return this.js_SymbolMatchAll(cx, scope, thisObj, args);
            }
            case 9: {
                return this.js_SymbolSearch(cx, scope, thisObj, args);
            }
            case 10: {
                return this.js_SymbolReplace(cx, scope, thisObj, args);
            }
            case 11: {
                return this.js_SymbolSplit(cx, scope, thisObj, args);
            }
        }
        throw new IllegalArgumentException(String.valueOf(id));
    }

    public static Object regExpExec(Scriptable regexp, String string, Context cx, Scriptable scope) {
        Object execMethod = ScriptRuntime.getObjectProp(regexp, "exec", cx, scope);
        if (execMethod instanceof Callable) {
            return ((Callable)execMethod).call(cx, scope, regexp, new Object[]{string});
        }
        return NativeRegExp.js_exec(cx, scope, regexp, new Object[]{string});
    }

    private Object js_SymbolMatch(Context cx, Scriptable scope, Scriptable thisScriptable, Object[] args) {
        boolean fullUnicode;
        ScriptableObject thisObj = ScriptableObject.ensureScriptableObject(thisScriptable);
        String string = ScriptRuntime.toString(args.length > 0 ? args[0] : Undefined.instance);
        String flags = ScriptRuntime.toString(ScriptRuntime.getObjectProp(thisObj, "flags", cx));
        boolean bl = fullUnicode = flags.indexOf(117) != -1 || flags.indexOf(118) != -1;
        if (flags.indexOf(103) == -1) {
            return NativeRegExp.regExpExec(thisObj, string, cx, scope);
        }
        this.setLastIndex(thisObj, (Object)ScriptRuntime.zeroObj);
        Scriptable result = cx.newArray(scope, 0);
        int i = 0;
        while (true) {
            Object match;
            if ((match = NativeRegExp.regExpExec(thisObj, string, cx, scope)) == null) {
                if (i == 0) {
                    return null;
                }
                return result;
            }
            String matchStr = ScriptRuntime.toString(ScriptRuntime.getObjectIndex(match, 0.0, cx, scope));
            result.put(i++, result, (Object)matchStr);
            if (!matchStr.isEmpty()) continue;
            long thisIndex = NativeRegExp.getLastIndex(cx, thisObj);
            long nextIndex = ScriptRuntime.advanceStringIndex(string, thisIndex, fullUnicode);
            this.setLastIndex(thisObj, (Object)nextIndex);
        }
    }

    private Object js_SymbolSearch(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!ScriptRuntime.isObject(thisObj)) {
            throw ScriptRuntime.typeErrorById("msg.arg.not.object", ScriptRuntime.typeof(thisObj));
        }
        String string = ScriptRuntime.toString(args.length > 0 ? args[0] : Undefined.instance);
        long previousLastIndex = NativeRegExp.getLastIndex(cx, thisObj);
        if (previousLastIndex != 0L) {
            this.setLastIndex(thisObj, (Object)ScriptRuntime.zeroObj);
        }
        Object result = NativeRegExp.regExpExec(thisObj, string, cx, scope);
        long currentLastIndex = NativeRegExp.getLastIndex(cx, thisObj);
        if (previousLastIndex != currentLastIndex) {
            this.setLastIndex(thisObj, (Object)previousLastIndex);
        }
        if (result == null) {
            return -1;
        }
        return ScriptRuntime.getObjectProp(result, "index", cx, scope);
    }

    static Object js_exec(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return NativeRegExp.realThis(thisObj, "exec").execSub(cx, scope, args, 1);
    }

    private Object js_SymbolMatchAll(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!ScriptRuntime.isObject(thisObj)) {
            throw ScriptRuntime.typeErrorById("msg.arg.not.object", ScriptRuntime.typeof(thisObj));
        }
        String s = ScriptRuntime.toString(args.length > 0 ? args[0] : Undefined.instance);
        Scriptable topLevelScope = ScriptableObject.getTopLevelScope(scope);
        Function defaultConstructor = ScriptRuntime.getExistingCtor(cx, topLevelScope, this.getClassName());
        Constructable c = AbstractEcmaObjectOperations.speciesConstructor(cx, thisObj, defaultConstructor);
        String flags = ScriptRuntime.toString(ScriptRuntime.getObjectProp(thisObj, "flags", cx));
        Scriptable matcher = c.construct(cx, scope, new Object[]{thisObj, flags});
        long lastIndex = NativeRegExp.getLastIndex(cx, thisObj);
        this.setLastIndex(matcher, (Object)lastIndex);
        boolean global = flags.indexOf(103) != -1;
        boolean fullUnicode = flags.indexOf(117) != -1 || flags.indexOf(118) != -1;
        return new NativeRegExpStringIterator(scope, matcher, s, global, fullUnicode);
    }

    private Object js_SymbolReplace(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        boolean fullUnicode;
        String flags;
        if (!ScriptRuntime.isObject(thisObj)) {
            throw ScriptRuntime.typeErrorById("msg.arg.not.object", ScriptRuntime.typeof(thisObj));
        }
        String s = ScriptRuntime.toString(args.length > 0 ? args[0] : Undefined.instance);
        int lengthS = s.length();
        Object replaceValue = args.length > 1 ? args[1] : Undefined.instance;
        boolean functionalReplace = replaceValue instanceof Callable;
        if (!functionalReplace) {
            replaceValue = ScriptRuntime.toString(replaceValue);
        }
        boolean global = (flags = ScriptRuntime.toString(ScriptRuntime.getObjectProp(thisObj, "flags", cx))).indexOf(103) != -1;
        boolean bl = fullUnicode = flags.indexOf(117) != -1 || flags.indexOf(118) != -1;
        if (global) {
            this.setLastIndex(thisObj, (Object)ScriptRuntime.zeroObj);
        }
        ArrayList<Object> results = new ArrayList<Object>();
        boolean done = false;
        while (!done) {
            Object result = NativeRegExp.regExpExec(thisObj, s, cx, scope);
            if (result == null) {
                done = true;
                continue;
            }
            results.add(result);
            if (!global) {
                done = true;
                continue;
            }
            String matchStr = ScriptRuntime.toString(ScriptRuntime.getObjectIndex(result, 0.0, cx, scope));
            if (!matchStr.isEmpty()) continue;
            long thisIndex = NativeRegExp.getLastIndex(cx, thisObj);
            long nextIndex = ScriptRuntime.advanceStringIndex(s, thisIndex, fullUnicode);
            this.setLastIndex(thisObj, (Object)nextIndex);
        }
        StringBuilder accumulatedResult = new StringBuilder();
        int nextSourcePosition = 0;
        for (Object e : results) {
            String replacementString;
            long resultLength = ScriptRuntime.toLength(ScriptRuntime.getObjectProp(e, "length", cx, scope));
            long nCaptures = Math.max(resultLength - 1L, 0L);
            String matched = ScriptRuntime.toString(ScriptRuntime.getObjectIndex(e, 0.0, cx, scope));
            int matchLength = matched.length();
            double positionDbl = ScriptRuntime.toInteger(ScriptRuntime.getObjectProp(e, "index", cx, scope));
            int position = ScriptRuntime.clamp((int)positionDbl, 0, lengthS);
            ArrayList<Object> captures = new ArrayList<Object>();
            int n = 1;
            while ((long)n <= nCaptures) {
                Object capN = ScriptRuntime.getObjectElem(e, n, cx, scope);
                if (!Undefined.isUndefined(capN)) {
                    capN = ScriptRuntime.toString(capN);
                }
                captures.add(capN);
                ++n;
            }
            Object namedCaptures = ScriptRuntime.getObjectProp(e, "groups", cx, scope);
            if (functionalReplace) {
                ArrayList<Object> replacerArgs = new ArrayList<Object>();
                replacerArgs.add(matched);
                replacerArgs.addAll(captures);
                replacerArgs.add(position);
                replacerArgs.add(s);
                if (!Undefined.isUndefined(namedCaptures)) {
                    replacerArgs.add(namedCaptures);
                }
                Scriptable callThis = ScriptRuntime.getApplyOrCallThis(cx, scope, null, 0, (Callable)replaceValue);
                Object replacementValue = ((Callable)replaceValue).call(cx, scope, callThis, replacerArgs.toArray());
                replacementString = ScriptRuntime.toString(replacementValue);
            } else {
                if (!Undefined.isUndefined(namedCaptures)) {
                    namedCaptures = ScriptRuntime.toObject(scope, namedCaptures);
                }
                NativeArray capturesArray = (NativeArray)cx.newArray(scope, captures.toArray());
                replacementString = AbstractEcmaStringOperations.getSubstitution(cx, scope, matched, s, position, capturesArray, namedCaptures, (String)replaceValue);
            }
            if (position < nextSourcePosition) continue;
            accumulatedResult.append(s, nextSourcePosition, position);
            accumulatedResult.append(replacementString);
            nextSourcePosition = position + matchLength;
        }
        if (nextSourcePosition >= lengthS) {
            return accumulatedResult.toString();
        }
        accumulatedResult.append(s.substring(nextSourcePosition));
        return accumulatedResult.toString();
    }

    private Object js_SymbolSplit(Context cx, Scriptable scope, Scriptable rx, Object[] args) {
        long p;
        if (!ScriptRuntime.isObject(rx)) {
            throw ScriptRuntime.typeErrorById("msg.arg.not.object", ScriptRuntime.typeof(rx));
        }
        String s = ScriptRuntime.toString(args.length > 0 ? args[0] : Undefined.instance);
        Scriptable topLevelScope = ScriptableObject.getTopLevelScope(scope);
        Function defaultConstructor = ScriptRuntime.getExistingCtor(cx, topLevelScope, this.getClassName());
        Constructable c = AbstractEcmaObjectOperations.speciesConstructor(cx, rx, defaultConstructor);
        String flags = ScriptRuntime.toString(ScriptRuntime.getObjectProp(rx, "flags", cx));
        boolean unicodeMatching = flags.indexOf(117) != -1 || flags.indexOf(118) != -1;
        String newFlags = flags.indexOf(121) != -1 ? flags : flags + "y";
        Scriptable splitter = c.construct(cx, scope, new Object[]{rx, newFlags});
        NativeArray a = (NativeArray)cx.newArray(scope, 0);
        int lengthA = 0;
        Object limit = args.length > 1 ? args[1] : Undefined.instance;
        long lim = Undefined.isUndefined(limit) ? Integer.MAX_VALUE : ScriptRuntime.toUint32(limit);
        if (lim == 0L) {
            return a;
        }
        if (s.isEmpty()) {
            Object z = NativeRegExp.regExpExec(splitter, s, cx, scope);
            if (z != null) {
                return a;
            }
            a.put(0, (Scriptable)a, (Object)s);
            return a;
        }
        int size = s.length();
        long q = p = 0L;
        while (q < (long)size) {
            this.setLastIndex(splitter, (Object)q);
            Object z = NativeRegExp.regExpExec(splitter, s, cx, scope);
            if (z == null) {
                q = ScriptRuntime.advanceStringIndex(s, q, unicodeMatching);
                continue;
            }
            long e = NativeRegExp.getLastIndex(cx, splitter);
            if ((e = Math.min(e, (long)size)) == p) {
                q = ScriptRuntime.advanceStringIndex(s, q, unicodeMatching);
                continue;
            }
            String t = s.substring((int)p, (int)q);
            a.put((int)a.getLength(), (Scriptable)a, (Object)t);
            ++lengthA;
            if (a.getLength() == lim) {
                return a;
            }
            p = e;
            long numberOfCaptures = ScriptRuntime.toLength(ScriptRuntime.getObjectProp(z, "length", cx, scope));
            numberOfCaptures = Math.max(numberOfCaptures - 1L, 0L);
            int i = 1;
            while ((long)i <= numberOfCaptures) {
                Object nextCapture = ScriptRuntime.getObjectIndex(z, i, cx, scope);
                a.put((int)a.getLength(), (Scriptable)a, nextCapture);
                ++i;
                if ((long)(++lengthA) != lim) continue;
                return a;
            }
            q = p;
        }
        String t = s.substring((int)p, size);
        a.put((int)a.getLength(), (Scriptable)a, (Object)t);
        return a;
    }

    private static long getLastIndex(Context cx, Scriptable thisObj) {
        return ScriptRuntime.toLength(ScriptRuntime.getObjectProp(thisObj, "lastIndex", cx));
    }

    private static NativeRegExp realThis(Scriptable thisObj, IdFunctionObject f) {
        return NativeRegExp.realThis(thisObj, f.getFunctionName());
    }

    private static NativeRegExp realThis(Scriptable thisObj, String functionName) {
        return NativeRegExp.ensureType(thisObj, NativeRegExp.class, functionName);
    }

    @Override
    protected int findPrototypeId(Symbol k) {
        if (SymbolKey.MATCH.equals(k)) {
            return 7;
        }
        if (SymbolKey.MATCH_ALL.equals(k)) {
            return 8;
        }
        if (SymbolKey.SEARCH.equals(k)) {
            return 9;
        }
        if (SymbolKey.REPLACE.equals(k)) {
            return 10;
        }
        if (SymbolKey.SPLIT.equals(k)) {
            return 11;
        }
        return 0;
    }

    @Override
    protected int findPrototypeId(String s) {
        int id;
        switch (s) {
            case "compile": {
                id = 1;
                break;
            }
            case "toString": {
                id = 2;
                break;
            }
            case "toSource": {
                id = 3;
                break;
            }
            case "exec": {
                id = 4;
                break;
            }
            case "test": {
                id = 5;
                break;
            }
            case "prefix": {
                id = 6;
                break;
            }
            default: {
                id = 0;
            }
        }
        return id;
    }

    static class ClassContents {
        boolean sense = true;
        ArrayList<Character> chars = new ArrayList();
        ArrayList<Character> bmpRanges = new ArrayList();
        ArrayList<RENode> escapeNodes = new ArrayList();
        ArrayList<Integer> nonBMPRanges = new ArrayList();
        ArrayList<Integer> nonBMPCodepoints = new ArrayList();

        ClassContents() {
        }
    }

    static class ParserParameters {
        boolean namedCaptureGroups;
        boolean unicodeMode;

        ParserParameters(boolean namedCaptureGroups, boolean unicodeMode) {
            this.namedCaptureGroups = namedCaptureGroups;
            this.unicodeMode = unicodeMode;
        }
    }
}

