/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript.lc.type.impl.factory;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;
import org.htmlunit.corejs.javascript.lc.type.TypeInfo;
import org.htmlunit.corejs.javascript.lc.type.TypeInfoFactory;
import org.htmlunit.corejs.javascript.lc.type.VariableTypeInfo;
import org.htmlunit.corejs.javascript.lc.type.impl.BasicClassTypeInfo;
import org.htmlunit.corejs.javascript.lc.type.impl.EnumTypeInfo;
import org.htmlunit.corejs.javascript.lc.type.impl.InterfaceTypeInfo;
import org.htmlunit.corejs.javascript.lc.type.impl.VariableTypeInfoImpl;
import org.htmlunit.corejs.javascript.lc.type.impl.factory.FactoryBase;

public abstract class WithCacheFactory
implements FactoryBase {
    private static final long serialVersionUID = 4533445095188189419L;
    private transient Map<TypeVariable<?>, VariableTypeInfoImpl> variableCache = this.createTypeCache();
    private transient Map<Class<?>, BasicClassTypeInfo> basicClassCache = this.createTypeCache();
    private transient Map<Class<?>, InterfaceTypeInfo> interfaceCache = this.createTypeCache();
    private transient Map<Class<?>, EnumTypeInfo> enumCache = this.createTypeCache();
    private transient Map<Class<?>, Map<VariableTypeInfo, TypeInfo>> consolidationMappingCache = this.createConsolidationMappingCache();

    protected abstract <K, V> Map<K, V> createTypeCache();

    protected abstract <K, V> Map<K, V> createConsolidationMappingCache();

    @Override
    public TypeInfo create(Class<?> clazz) {
        TypeInfo predefined = TypeInfoFactory.matchPredefined(clazz);
        if (predefined != null) {
            return predefined;
        }
        if (clazz.isArray()) {
            return this.toArray(this.create(clazz.getComponentType()));
        }
        if (clazz.isEnum()) {
            return this.enumCache.computeIfAbsent(clazz, EnumTypeInfo::new);
        }
        if (clazz.isInterface()) {
            return this.interfaceCache.computeIfAbsent(clazz, InterfaceTypeInfo::new);
        }
        return this.basicClassCache.computeIfAbsent(clazz, BasicClassTypeInfo::new);
    }

    @Override
    public TypeInfo create(TypeVariable<?> typeVariable) {
        return this.variableCache.computeIfAbsent(typeVariable, raw -> new VariableTypeInfoImpl((TypeVariable<?>)raw, this));
    }

    @Override
    public Map<VariableTypeInfo, TypeInfo> getConsolidationMapping(Class<?> from) {
        if (from == null || from == Object.class || from.isPrimitive()) {
            return new HashMap<VariableTypeInfo, TypeInfo>();
        }
        Map<VariableTypeInfo, TypeInfo> got = this.consolidationMappingCache.get(from);
        if (got == null) {
            got = this.computeConsolidationMapping(from);
            this.consolidationMappingCache.put(from, got);
        }
        return got;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.variableCache = this.createTypeCache();
        this.basicClassCache = this.createTypeCache();
        this.interfaceCache = this.createTypeCache();
        this.enumCache = this.createTypeCache();
        this.consolidationMappingCache = this.createConsolidationMappingCache();
    }
}

