/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript.lc.type;

import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.lc.type.TypeInfo;
import org.htmlunit.corejs.javascript.lc.type.TypeInfoFactory;
import org.htmlunit.corejs.javascript.lc.type.VariableTypeInfo;

public interface ParameterizedTypeInfo
extends TypeInfo {
    public TypeInfo rawType();

    public List<TypeInfo> params();

    @Override
    default public TypeInfo param(int index) {
        List<TypeInfo> params = this.params();
        return index >= 0 && index < params.size() ? params.get(index) : TypeInfo.NONE;
    }

    default public Map<VariableTypeInfo, TypeInfo> extractConsolidationMapping(TypeInfoFactory factory) {
        List<TypeInfo> actualParams;
        TypeVariable<Class<?>>[] typeVariables = this.asClass().getTypeParameters();
        int len = typeVariables.length;
        if (len != (actualParams = this.params()).size()) {
            throw new IllegalStateException(String.format("Expecting %s type params for class '%s', but got %s", len, this.asClass().getName(), actualParams.size()));
        }
        if (len == 0) {
            throw new IllegalStateException(String.format("Base class '%s' is not a generic class", this.asClass().getName()));
        }
        if (len == 1) {
            HashMap<VariableTypeInfo, TypeInfo> result = new HashMap<VariableTypeInfo, TypeInfo>();
            result.put((VariableTypeInfo)factory.create(typeVariables[0]), actualParams.get(0));
            return result;
        }
        HashMap<VariableTypeInfo, TypeInfo> mapping = new HashMap<VariableTypeInfo, TypeInfo>();
        for (int i = 0; i < len; ++i) {
            mapping.put((VariableTypeInfo)factory.create(typeVariables[i]), actualParams.get(i));
        }
        return mapping;
    }

    @Override
    default public boolean isInterface() {
        return this.rawType().isInterface();
    }

    @Override
    default public boolean isFunctionalInterface() {
        return this.rawType().isFunctionalInterface();
    }

    @Override
    default public boolean isAssignableFrom(TypeInfo another) {
        return this.rawType().isAssignableFrom(another);
    }

    @Override
    default public boolean isInstance(Object o) {
        return this.rawType().isInstance(o);
    }

    @Override
    default public int getTypeTag() {
        if (Scriptable.class.isAssignableFrom(this.asClass())) {
            return 5;
        }
        return 0;
    }
}

