/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript;

import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.NativeJavaArray;
import org.htmlunit.corejs.javascript.NativeJavaClass;
import org.htmlunit.corejs.javascript.NativeJavaList;
import org.htmlunit.corejs.javascript.NativeJavaMap;
import org.htmlunit.corejs.javascript.NativeJavaObject;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.Undefined;
import org.htmlunit.corejs.javascript.lc.type.TypeInfo;
import org.htmlunit.corejs.javascript.lc.type.TypeInfoFactory;

public class WrapFactory {
    private boolean javaPrimitiveWrap = true;

    public Object wrap(Context cx, Scriptable scope, Object obj, Class<?> staticType) {
        return this.wrap(cx, scope, obj, TypeInfoFactory.GLOBAL.create(staticType));
    }

    public Object wrap(Context cx, Scriptable scope, Object obj, TypeInfo staticType) {
        if (obj == null || obj == Undefined.instance || obj instanceof Scriptable) {
            return obj;
        }
        if (staticType.isPrimitive()) {
            if (staticType == TypeInfo.PRIMITIVE_VOID) {
                return Undefined.instance;
            }
            if (staticType == TypeInfo.PRIMITIVE_CHARACTER) {
                return (int)((Character)obj).charValue();
            }
            return obj;
        }
        if (!this.isJavaPrimitiveWrap()) {
            if (obj instanceof String || obj instanceof Boolean || obj instanceof Integer || obj instanceof Byte || obj instanceof Short || obj instanceof Long || obj instanceof Float || obj instanceof Double || obj instanceof BigInteger) {
                return obj;
            }
            if (obj instanceof Character) {
                return String.valueOf(((Character)obj).charValue());
            }
        }
        return this.wrapAsJavaObject(cx, scope, obj, staticType);
    }

    public Scriptable wrapNewObject(Context cx, Scriptable scope, Object obj) {
        if (obj instanceof Scriptable) {
            return (Scriptable)obj;
        }
        return this.wrapAsJavaObject(cx, scope, obj, TypeInfo.NONE);
    }

    public Scriptable wrapAsJavaObject(Context cx, Scriptable scope, Object javaObject, Class<?> staticType) {
        return this.wrapAsJavaObject(cx, scope, javaObject, TypeInfoFactory.GLOBAL.create(staticType));
    }

    public Scriptable wrapAsJavaObject(Context cx, Scriptable scope, Object javaObject, TypeInfo staticType) {
        if (staticType.shouldReplace() && javaObject != null) {
            staticType = TypeInfoFactory.getOrElse(scope, TypeInfoFactory.GLOBAL).create(javaObject.getClass());
        }
        if (List.class.isAssignableFrom(staticType.asClass())) {
            return new NativeJavaList(scope, javaObject, staticType);
        }
        if (Map.class.isAssignableFrom(staticType.asClass())) {
            return new NativeJavaMap(scope, javaObject, staticType);
        }
        if (staticType.isArray()) {
            return new NativeJavaArray(scope, javaObject, staticType);
        }
        return new NativeJavaObject(scope, javaObject, staticType);
    }

    public Scriptable wrapJavaClass(Context cx, Scriptable scope, Class<?> javaClass) {
        return new NativeJavaClass(scope, javaClass);
    }

    public final boolean isJavaPrimitiveWrap() {
        return this.javaPrimitiveWrap;
    }

    public final void setJavaPrimitiveWrap(boolean value) {
        Context cx = Context.getCurrentContext();
        if (cx != null && cx.isSealed()) {
            Context.onSealedMutation();
        }
        this.javaPrimitiveWrap = value;
    }
}

