/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript;

import java.io.Serializable;
import org.htmlunit.corejs.javascript.NativeSymbol;
import org.htmlunit.corejs.javascript.Symbol;
import org.htmlunit.corejs.javascript.Undefined;

public class SymbolKey
implements Symbol,
Serializable {
    private static final long serialVersionUID = -6019782713330994754L;
    public static final SymbolKey ITERATOR = new SymbolKey("Symbol.iterator", Symbol.Kind.BUILT_IN);
    public static final SymbolKey TO_STRING_TAG = new SymbolKey("Symbol.toStringTag", Symbol.Kind.BUILT_IN);
    public static final SymbolKey SPECIES = new SymbolKey("Symbol.species", Symbol.Kind.BUILT_IN);
    public static final SymbolKey HAS_INSTANCE = new SymbolKey("Symbol.hasInstance", Symbol.Kind.BUILT_IN);
    public static final SymbolKey IS_CONCAT_SPREADABLE = new SymbolKey("Symbol.isConcatSpreadable", Symbol.Kind.BUILT_IN);
    public static final SymbolKey IS_REGEXP = new SymbolKey("Symbol.isRegExp", Symbol.Kind.BUILT_IN);
    public static final SymbolKey TO_PRIMITIVE = new SymbolKey("Symbol.toPrimitive", Symbol.Kind.BUILT_IN);
    public static final SymbolKey MATCH = new SymbolKey("Symbol.match", Symbol.Kind.BUILT_IN);
    public static final SymbolKey MATCH_ALL = new SymbolKey("Symbol.matchAll", Symbol.Kind.BUILT_IN);
    public static final SymbolKey REPLACE = new SymbolKey("Symbol.replace", Symbol.Kind.BUILT_IN);
    public static final SymbolKey SEARCH = new SymbolKey("Symbol.search", Symbol.Kind.BUILT_IN);
    public static final SymbolKey SPLIT = new SymbolKey("Symbol.split", Symbol.Kind.BUILT_IN);
    public static final SymbolKey UNSCOPABLES = new SymbolKey("Symbol.unscopables", Symbol.Kind.BUILT_IN);
    private final String name;
    private final Symbol.Kind kind;

    public SymbolKey(String name, Symbol.Kind kind) {
        this.name = name;
        this.kind = kind;
    }

    @Override
    public Symbol.Kind getKind() {
        return this.kind;
    }

    @Override
    public String getName() {
        return this.name != null ? this.name : "";
    }

    public Object getDescription() {
        return this.name != null ? this.name : Undefined.instance;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public boolean equals(Object o) {
        if (o instanceof SymbolKey) {
            return o == this;
        }
        if (o instanceof NativeSymbol) {
            return ((NativeSymbol)o).getKey() == this;
        }
        return false;
    }

    public String toString() {
        if (this.name == null) {
            return "Symbol()";
        }
        return "Symbol(" + this.name + ')';
    }
}

