/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.htmlunit.corejs.javascript.AccessorSlot;
import org.htmlunit.corejs.javascript.BaseFunction;
import org.htmlunit.corejs.javascript.BuiltInSlot;
import org.htmlunit.corejs.javascript.Callable;
import org.htmlunit.corejs.javascript.CompoundOperationMap;
import org.htmlunit.corejs.javascript.ConstProperties;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.Delegator;
import org.htmlunit.corejs.javascript.ExternalArrayData;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.FunctionObject;
import org.htmlunit.corejs.javascript.JavaScriptException;
import org.htmlunit.corejs.javascript.Kit;
import org.htmlunit.corejs.javascript.LambdaAccessorSlot;
import org.htmlunit.corejs.javascript.LambdaFunction;
import org.htmlunit.corejs.javascript.LambdaSlot;
import org.htmlunit.corejs.javascript.LazilyLoadedCtor;
import org.htmlunit.corejs.javascript.LazyLoadSlot;
import org.htmlunit.corejs.javascript.MemberBox;
import org.htmlunit.corejs.javascript.NativeObject;
import org.htmlunit.corejs.javascript.ScriptRuntime;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.SerializableCallable;
import org.htmlunit.corejs.javascript.Slot;
import org.htmlunit.corejs.javascript.SlotMap;
import org.htmlunit.corejs.javascript.SlotMapOwner;
import org.htmlunit.corejs.javascript.Symbol;
import org.htmlunit.corejs.javascript.SymbolKey;
import org.htmlunit.corejs.javascript.SymbolScriptable;
import org.htmlunit.corejs.javascript.TopLevel;
import org.htmlunit.corejs.javascript.Undefined;
import org.htmlunit.corejs.javascript.Wrapper;
import org.htmlunit.corejs.javascript.annotations.JSConstructor;
import org.htmlunit.corejs.javascript.annotations.JSFunction;
import org.htmlunit.corejs.javascript.annotations.JSGetter;
import org.htmlunit.corejs.javascript.annotations.JSSetter;
import org.htmlunit.corejs.javascript.annotations.JSStaticFunction;
import org.htmlunit.corejs.javascript.debug.DebuggableObject;
import org.htmlunit.corejs.javascript.lc.type.TypeInfoFactory;

public abstract class ScriptableObject
extends SlotMapOwner
implements Scriptable,
SymbolScriptable,
Serializable,
DebuggableObject,
ConstProperties {
    private static final long serialVersionUID = 2829861078851942586L;
    public static final int EMPTY = 0;
    public static final int READONLY = 1;
    public static final int DONTENUM = 2;
    public static final int PERMANENT = 4;
    public static final int UNINITIALIZED_CONST = 8;
    public static final int CONST = 13;
    private Scriptable prototypeObject;
    private Scriptable parentScopeObject;
    private transient ExternalArrayData externalData;
    private volatile Map<Object, Object> associatedValues;
    private boolean isExtensible = true;
    private boolean isSealed = false;
    private static final Method GET_ARRAY_LENGTH;
    private static final Comparator<Object> KEY_COMPARATOR;

    protected static ScriptableObject buildDataDescriptor(Scriptable scope, Object value, int attributes) {
        NativeObject desc = new NativeObject();
        ScriptRuntime.setBuiltinProtoAndParent(desc, scope, TopLevel.Builtins.Object);
        desc.defineProperty("value", value, 0);
        desc.setCommonDescriptorProperties(attributes, true);
        return desc;
    }

    protected void setCommonDescriptorProperties(int attributes, boolean defineWritable) {
        if (defineWritable) {
            this.defineProperty("writable", (Object)((attributes & 1) == 0 ? 1 : 0), 0);
        }
        this.defineProperty("enumerable", (Object)((attributes & 2) == 0 ? 1 : 0), 0);
        this.defineProperty("configurable", (Object)((attributes & 4) == 0 ? 1 : 0), 0);
    }

    static void checkValidAttributes(int attributes) {
        int mask = 15;
        if ((attributes & 0xFFFFFFF0) != 0) {
            throw new IllegalArgumentException(String.valueOf(attributes));
        }
    }

    public ScriptableObject() {
        super(0);
    }

    public ScriptableObject(Scriptable scope, Scriptable prototype) {
        super(0);
        if (scope == null) {
            throw new IllegalArgumentException();
        }
        this.parentScopeObject = scope;
        this.prototypeObject = prototype;
    }

    public String getTypeOf() {
        return this.avoidObjectDetection() ? "undefined" : "object";
    }

    @Override
    public abstract String getClassName();

    @Override
    public boolean has(String name, Scriptable start) {
        return null != this.getMap().query(name, 0);
    }

    @Override
    public boolean has(int index, Scriptable start) {
        if (this.externalData != null) {
            return index < this.externalData.getArrayLength();
        }
        return null != this.getMap().query(null, index);
    }

    @Override
    public boolean has(Symbol key, Scriptable start) {
        return null != this.getMap().query(key, 0);
    }

    @Override
    public Object get(String name, Scriptable start) {
        Slot slot = this.getMap().query(name, 0);
        if (slot == null) {
            return Scriptable.NOT_FOUND;
        }
        return slot.getValue(start);
    }

    @Override
    public Object get(int index, Scriptable start) {
        if (this.externalData != null) {
            if (index < this.externalData.getArrayLength()) {
                return this.externalData.getArrayElement(index);
            }
            return Scriptable.NOT_FOUND;
        }
        Slot slot = this.getMap().query(null, index);
        if (slot == null) {
            return Scriptable.NOT_FOUND;
        }
        return slot.getValue(start);
    }

    @Override
    public Object get(Symbol key, Scriptable start) {
        Slot slot = this.getMap().query(key, 0);
        if (slot == null) {
            return Scriptable.NOT_FOUND;
        }
        return slot.getValue(start);
    }

    @Override
    public void put(String name, Scriptable start, Object value) {
        if (this.putOwnProperty(name, start, value, Context.isCurrentContextStrict())) {
            return;
        }
        if (start == this) {
            throw Kit.codeBug();
        }
        start.put(name, start, value);
    }

    protected boolean putOwnProperty(String name, Scriptable start, Object value, boolean isThrow) {
        return this.putImpl(name, 0, start, value, isThrow);
    }

    @Override
    public void put(int index, Scriptable start, Object value) {
        if (this.externalData != null) {
            if (index >= this.externalData.getArrayLength()) {
                throw new JavaScriptException(ScriptRuntime.newNativeError(Context.getCurrentContext(), this, TopLevel.NativeErrors.RangeError, new Object[]{"External array index out of bounds "}), null, 0);
            }
            this.externalData.setArrayElement(index, value);
            return;
        }
        if (this.putOwnProperty(index, start, value, Context.isCurrentContextStrict())) {
            return;
        }
        if (start == this) {
            throw Kit.codeBug();
        }
        start.put(index, start, value);
    }

    protected boolean putOwnProperty(int index, Scriptable start, Object value, boolean isThrow) {
        return this.putImpl(null, index, start, value, isThrow);
    }

    @Override
    public void put(Symbol key, Scriptable start, Object value) {
        if (this.putOwnProperty(key, start, value, Context.isCurrentContextStrict())) {
            return;
        }
        if (start == this) {
            throw Kit.codeBug();
        }
        ScriptableObject.ensureSymbolScriptable(start).put(key, start, value);
    }

    protected boolean putOwnProperty(Symbol key, Scriptable start, Object value, boolean isThrow) {
        return this.putImpl(key, 0, start, value, isThrow);
    }

    @Override
    public void delete(String name) {
        this.checkNotSealed(name, 0);
        this.getMap().compute(this, name, 0, ScriptableObject::checkSlotRemoval);
    }

    @Override
    public void delete(int index) {
        this.checkNotSealed(null, index);
        this.getMap().compute(this, null, index, ScriptableObject::checkSlotRemoval);
    }

    @Override
    public void delete(Symbol key) {
        this.checkNotSealed(key, 0);
        this.getMap().compute(this, key, 0, ScriptableObject::checkSlotRemoval);
    }

    protected static Slot checkSlotRemoval(Object key, int index, Slot slot, CompoundOperationMap compoundOp, SlotMapOwner owner) {
        if (slot != null && (slot.getAttributes() & 4) != 0) {
            Context cx = Context.getContext();
            if (cx.isStrictMode()) {
                throw ScriptRuntime.typeErrorById("msg.delete.property.with.configurable.false", key);
            }
            return slot;
        }
        return null;
    }

    @Override
    public void putConst(String name, Scriptable start, Object value) {
        if (this.putConstImpl(name, 0, start, value, 1)) {
            return;
        }
        if (start == this) {
            throw Kit.codeBug();
        }
        if (start instanceof ConstProperties) {
            ((ConstProperties)((Object)start)).putConst(name, start, value);
        } else {
            start.put(name, start, value);
        }
    }

    @Override
    public void defineConst(String name, Scriptable start) {
        if (this.putConstImpl(name, 0, start, Undefined.instance, 8)) {
            return;
        }
        if (start == this) {
            throw Kit.codeBug();
        }
        if (start instanceof ConstProperties) {
            ((ConstProperties)((Object)start)).defineConst(name, start);
        }
    }

    @Override
    public boolean isConst(String name) {
        Slot slot = this.getMap().query(name, 0);
        if (slot == null) {
            return false;
        }
        return (slot.getAttributes() & 5) == 5;
    }

    @Deprecated
    public final int getAttributes(String name, Scriptable start) {
        return this.getAttributes(name);
    }

    @Deprecated
    public final int getAttributes(int index, Scriptable start) {
        return this.getAttributes(index);
    }

    @Deprecated
    public final void setAttributes(String name, Scriptable start, int attributes) {
        this.setAttributes(name, attributes);
    }

    @Deprecated
    public void setAttributes(int index, Scriptable start, int attributes) {
        this.setAttributes(index, attributes);
    }

    public int getAttributes(String name) {
        return this.getAttributeSlot(name, 0).getAttributes();
    }

    public int getAttributes(int index) {
        return this.getAttributeSlot(null, index).getAttributes();
    }

    public int getAttributes(Symbol sym) {
        return this.getAttributeSlot(sym).getAttributes();
    }

    public void setAttributes(String name, int attributes) {
        this.checkNotSealed(name, 0);
        Slot attrSlot = this.getMap().modify(this, name, 0, 0);
        attrSlot.setAttributes(attributes);
    }

    public void setAttributes(int index, int attributes) {
        this.checkNotSealed(null, index);
        Slot attrSlot = this.getMap().modify(this, null, index, 0);
        attrSlot.setAttributes(attributes);
    }

    public void setAttributes(Symbol key, int attributes) {
        this.checkNotSealed(key, 0);
        Slot attrSlot = this.getMap().modify(this, key, 0, 0);
        attrSlot.setAttributes(attributes);
    }

    public void setGetterOrSetter(Object name, int index, Callable getterOrSetter, boolean isSetter) {
        AccessorSlot aSlot;
        if (name != null && index != 0) {
            throw new IllegalArgumentException(name.toString());
        }
        this.checkNotSealed(name, index);
        if (this.isExtensible()) {
            aSlot = this.getMap().compute(this, name, index, ScriptableObject::ensureAccessorSlot);
        } else {
            Slot slot = this.getMap().query(name, index);
            if (slot instanceof AccessorSlot) {
                aSlot = (AccessorSlot)slot;
            } else {
                return;
            }
        }
        int attributes = aSlot.getAttributes();
        if ((attributes & 1) != 0) {
            throw Context.reportRuntimeErrorById("msg.modify.readonly", name);
        }
        if (isSetter) {
            aSlot.setter = getterOrSetter instanceof Function ? new AccessorSlot.FunctionSetter(getterOrSetter) : null;
        } else {
            aSlot.getter = getterOrSetter instanceof Function ? new AccessorSlot.FunctionGetter(getterOrSetter) : null;
        }
        aSlot.value = Undefined.instance;
    }

    public Object getGetterOrSetter(String name, int index, Scriptable scope, boolean isSetter) {
        if (name != null && index != 0) {
            throw new IllegalArgumentException(name);
        }
        Slot slot = this.getMap().query(name, index);
        if (slot == null) {
            return null;
        }
        Function getterOrSetter = isSetter ? slot.getSetterFunction(name, scope) : slot.getGetterFunction(name, scope);
        return getterOrSetter == null ? Undefined.instance : getterOrSetter;
    }

    @Deprecated
    public Object getGetterOrSetter(String name, int index, boolean isSetter) {
        return this.getGetterOrSetter(name, index, this, isSetter);
    }

    protected boolean isGetterOrSetter(String name, int index, boolean setter) {
        try (CompoundOperationMap map = this.startCompoundOp(false);){
            boolean bl = this.isGetterOrSetter(map, name, index, setter);
            return bl;
        }
    }

    protected boolean isGetterOrSetter(CompoundOperationMap map, String name, int index, boolean setter) {
        Slot slot = map.query(name, index);
        return slot != null && slot.isSetterSlot();
    }

    void addLazilyInitializedValue(String name, int index, LazilyLoadedCtor init, int attributes) {
        if (name != null && index != 0) {
            throw new IllegalArgumentException(name);
        }
        this.checkNotSealed(name, index);
        LazyLoadSlot lslot = this.getMap().compute(this, name, index, ScriptableObject::ensureLazySlot);
        lslot.setAttributes(attributes);
        lslot.value = init;
    }

    void addLazilyInitializedValue(Symbol key, int index, LazilyLoadedCtor init, int attributes) {
        if (key != null && index != 0) {
            throw new IllegalArgumentException(key.toString());
        }
        this.checkNotSealed(key, index);
        LazyLoadSlot lslot = this.getMap().compute(this, key, index, ScriptableObject::ensureLazySlot);
        lslot.setAttributes(attributes);
        lslot.value = init;
    }

    public void setExternalArrayData(ExternalArrayData array) {
        this.externalData = array;
        if (array == null) {
            this.delete("length");
        } else {
            this.defineProperty("length", null, GET_ARRAY_LENGTH, null, 3);
        }
    }

    public ExternalArrayData getExternalArrayData() {
        return this.externalData;
    }

    public Object getExternalArrayLength() {
        return this.externalData == null ? 0 : this.externalData.getArrayLength();
    }

    @Override
    public Scriptable getPrototype() {
        return this.prototypeObject;
    }

    @Override
    public void setPrototype(Scriptable m) {
        this.prototypeObject = m;
    }

    @Override
    public Scriptable getParentScope() {
        return this.parentScopeObject;
    }

    @Override
    public void setParentScope(Scriptable m) {
        this.parentScopeObject = m;
    }

    @Override
    public Object[] getIds() {
        try (CompoundOperationMap map = this.startCompoundOp(false);){
            Object[] objectArray = this.getIds(map, false, false);
            return objectArray;
        }
    }

    @Override
    public Object[] getAllIds() {
        try (CompoundOperationMap map = this.startCompoundOp(false);){
            Object[] objectArray = this.getIds(map, true, false);
            return objectArray;
        }
    }

    @Override
    public Object getDefaultValue(Class<?> typeHint) {
        return ScriptableObject.getDefaultValue(this, typeHint);
    }

    public static Object getDefaultValue(Scriptable object, Class<?> typeHint) {
        Context cx = null;
        for (int i = 0; i < 2; ++i) {
            Object u;
            boolean tryToString = typeHint == ScriptRuntime.StringClass ? i == 0 : i == 1;
            String methodName = tryToString ? "toString" : "valueOf";
            Object v = ScriptableObject.getProperty(object, methodName);
            if (!(v instanceof Function)) continue;
            Function fun = (Function)v;
            if (cx == null) {
                cx = Context.getContext();
            }
            if ((v = fun.call(cx, fun.getDeclarationScope(), object, ScriptRuntime.emptyArgs)) == null) continue;
            if (!(v instanceof Scriptable)) {
                return v;
            }
            if (typeHint == ScriptRuntime.ScriptableClass || typeHint == ScriptRuntime.FunctionClass) {
                return v;
            }
            if (!tryToString || !(v instanceof Wrapper) || !((u = ((Wrapper)v).unwrap()) instanceof String)) continue;
            return u;
        }
        String arg = typeHint == null ? "undefined" : typeHint.getName();
        throw ScriptRuntime.typeErrorById("msg.default.value", arg);
    }

    @Override
    public boolean hasInstance(Scriptable instance) {
        Context cx = Context.getCurrentContext();
        Object hasInstance = ScriptRuntime.getObjectElem(this, (Object)SymbolKey.HAS_INSTANCE, cx);
        if (hasInstance instanceof Function) {
            Scriptable scope = ((Function)hasInstance).getDeclarationScope();
            return ScriptRuntime.toBoolean(((Function)hasInstance).call(cx, scope, this, new Object[]{this}));
        }
        if (!(this instanceof Callable)) {
            throw ScriptRuntime.typeErrorById("msg.instanceof.bad.target", new Object[0]);
        }
        return ScriptRuntime.jsDelegatesTo(instance, this);
    }

    public boolean avoidObjectDetection() {
        return false;
    }

    protected Object equivalentValues(Object value) {
        return this == value ? Boolean.TRUE : Scriptable.NOT_FOUND;
    }

    public static <T extends Scriptable> void defineClass(Scriptable scope, Class<T> clazz) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        ScriptableObject.defineClass(scope, clazz, false, false);
    }

    public static <T extends Scriptable> void defineClass(Scriptable scope, Class<T> clazz, boolean sealed) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        ScriptableObject.defineClass(scope, clazz, sealed, false);
    }

    public static <T extends Scriptable> String defineClass(Scriptable scope, Class<T> clazz, boolean sealed, boolean mapInheritance) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        BaseFunction ctor = ScriptableObject.buildClassCtor(scope, clazz, sealed, mapInheritance);
        if (ctor == null) {
            return null;
        }
        String name = ctor.getClassPrototype().getClassName();
        ScriptableObject.defineProperty(scope, name, ctor, 2);
        return name;
    }

    /*
     * WARNING - void declaration
     */
    static <T extends Scriptable> BaseFunction buildClassCtor(Scriptable scope, Class<T> clazz, boolean sealed, boolean mapInheritance) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        FunctionObject ctor;
        void var10_25;
        void var10_23;
        Class<T> superScriptable;
        String name;
        Class<T> superClass;
        Object object;
        AccessibleObject[] methods;
        for (Method method : methods = FunctionObject.getMethodList(clazz)) {
            if (!"init".equals(method.getName())) continue;
            Class<?>[] parmTypes = method.getParameterTypes();
            if (parmTypes.length == 3 && parmTypes[0] == ScriptRuntime.ContextClass && parmTypes[1] == ScriptRuntime.ScriptableClass && parmTypes[2] == Boolean.TYPE && Modifier.isStatic(method.getModifiers())) {
                Object[] objectArray = new Object[]{Context.getContext(), scope, sealed ? Boolean.TRUE : Boolean.FALSE};
                method.invoke(null, objectArray);
                return null;
            }
            if (parmTypes.length != 1 || parmTypes[0] != ScriptRuntime.ScriptableClass || !Modifier.isStatic(method.getModifiers())) continue;
            Object[] objectArray = new Object[]{scope};
            method.invoke(null, objectArray);
            return null;
        }
        AccessibleObject[] ctors = clazz.getConstructors();
        Constructor<?> protoCtor = null;
        for (Constructor<?> constructor : ctors) {
            if (constructor.getParameterTypes().length != 0) continue;
            protoCtor = constructor;
            break;
        }
        if (protoCtor == null) {
            throw Context.reportRuntimeErrorById("msg.zero.arg.ctor", clazz.getName());
        }
        Scriptable proto = (Scriptable)protoCtor.newInstance(ScriptRuntime.emptyArgs);
        String string = proto.getClassName();
        Object existing = ScriptableObject.getProperty(ScriptableObject.getTopLevelScope(scope), string);
        if (existing instanceof BaseFunction && (object = ((BaseFunction)existing).getPrototypeProperty()) != null && clazz.equals(object.getClass())) {
            return (BaseFunction)existing;
        }
        Object var10_21 = null;
        if (mapInheritance && ScriptRuntime.ScriptableClass.isAssignableFrom(superClass = clazz.getSuperclass()) && !Modifier.isAbstract(superClass.getModifiers()) && (name = ScriptableObject.defineClass(scope, superScriptable = ScriptableObject.extendsScriptable(superClass), sealed, mapInheritance)) != null) {
            Scriptable scriptable = ScriptableObject.getClassPrototype(scope, name);
        }
        if (var10_23 == null) {
            Scriptable scriptable = ScriptableObject.getObjectPrototype(scope);
        }
        proto.setPrototype((Scriptable)var10_25);
        String functionPrefix = "jsFunction_";
        String staticFunctionPrefix = "jsStaticFunction_";
        String getterPrefix = "jsGet_";
        String setterPrefix = "jsSet_";
        String ctorName = "jsConstructor";
        Object ctorMember = ScriptableObject.findAnnotatedMember(methods, JSConstructor.class);
        if (ctorMember == null) {
            ctorMember = ScriptableObject.findAnnotatedMember(ctors, JSConstructor.class);
        }
        if (ctorMember == null) {
            ctorMember = FunctionObject.findSingleMethod((Method[])methods, "jsConstructor");
        }
        if (ctorMember == null) {
            if (ctors.length == 1) {
                ctorMember = ctors[0];
            } else if (ctors.length == 2) {
                if (((Constructor)ctors[0]).getParameterTypes().length == 0) {
                    ctorMember = ctors[1];
                } else if (((Constructor)ctors[1]).getParameterTypes().length == 0) {
                    ctorMember = ctors[0];
                }
            }
            if (ctorMember == null) {
                throw Context.reportRuntimeErrorById("msg.ctor.multiple.parms", clazz.getName());
            }
        }
        if ((ctor = new FunctionObject(string, (Member)ctorMember, scope)).isVarArgsMethod()) {
            throw Context.reportRuntimeErrorById("msg.varargs.ctor", ctorMember.getName());
        }
        ctor.initAsConstructor(scope, proto, 7);
        AccessibleObject finishInit = null;
        HashSet<String> staticNames = new HashSet<String>();
        HashSet instanceNames = new HashSet();
        for (AccessibleObject method : methods) {
            String propName;
            boolean isStatic;
            HashSet<String> names;
            Class<?>[] parmTypes;
            if (method == ctorMember) continue;
            String name2 = ((Method)method).getName();
            if ("finishInit".equals(name2) && (parmTypes = ((Method)method).getParameterTypes()).length == 3 && parmTypes[0] == ScriptRuntime.ScriptableClass && parmTypes[1] == FunctionObject.class && parmTypes[2] == ScriptRuntime.ScriptableClass && Modifier.isStatic(((Method)method).getModifiers())) {
                finishInit = method;
                continue;
            }
            if (name2.indexOf(36) != -1 || name2.equals("jsConstructor")) continue;
            Annotation annotation = null;
            String prefix = null;
            if (method.isAnnotationPresent(JSFunction.class)) {
                annotation = ((Method)method).getAnnotation(JSFunction.class);
            } else if (method.isAnnotationPresent(JSStaticFunction.class)) {
                annotation = ((Method)method).getAnnotation(JSStaticFunction.class);
            } else if (method.isAnnotationPresent(JSGetter.class)) {
                annotation = ((Method)method).getAnnotation(JSGetter.class);
            } else if (method.isAnnotationPresent(JSSetter.class)) continue;
            if (annotation == null) {
                if (name2.startsWith("jsFunction_")) {
                    prefix = "jsFunction_";
                } else if (name2.startsWith("jsStaticFunction_")) {
                    prefix = "jsStaticFunction_";
                } else {
                    if (!name2.startsWith("jsGet_")) continue;
                    prefix = "jsGet_";
                }
            }
            if ((names = (isStatic = annotation instanceof JSStaticFunction || Objects.equals(prefix, "jsStaticFunction_")) ? staticNames : instanceNames).contains(propName = ScriptableObject.getPropertyName(name2, prefix, annotation))) {
                throw Context.reportRuntimeErrorById("duplicate.defineClass.name", name2, propName);
            }
            names.add(propName);
            name2 = propName;
            if (annotation instanceof JSGetter || Objects.equals(prefix, "jsGet_")) {
                if (!(proto instanceof ScriptableObject)) {
                    throw Context.reportRuntimeErrorById("msg.extend.scriptable", proto.getClass().toString(), name2);
                }
                Method setter = ScriptableObject.findSetterMethod((Method[])methods, name2, "jsSet_");
                int attr = 6 | (setter != null ? 0 : 1);
                ((ScriptableObject)proto).defineProperty(name2, null, (Method)method, setter, attr);
                continue;
            }
            if (isStatic && !Modifier.isStatic(((Method)method).getModifiers())) {
                throw Context.reportRuntimeError("jsStaticFunction must be used with static method.");
            }
            FunctionObject f = new FunctionObject(name2, (Member)((Object)method), proto);
            if (f.isVarArgsConstructor()) {
                throw Context.reportRuntimeErrorById("msg.varargs.fun", ctorMember.getName());
            }
            ScriptableObject.defineProperty(isStatic ? ctor : proto, name2, f, 2);
            if (!sealed) continue;
            f.sealObject();
        }
        if (finishInit != null) {
            Object[] finishArgs = new Object[]{scope, ctor, proto};
            finishInit.invoke(null, finishArgs);
        }
        if (sealed) {
            ctor.sealObject();
            if (proto instanceof ScriptableObject) {
                ((ScriptableObject)proto).sealObject();
            }
        }
        return ctor;
    }

    private static Member findAnnotatedMember(AccessibleObject[] members, Class<? extends Annotation> annotation) {
        for (AccessibleObject member : members) {
            if (!member.isAnnotationPresent(annotation)) continue;
            return (Member)((Object)member);
        }
        return null;
    }

    private static Method findSetterMethod(Method[] methods, String name, String prefix) {
        String newStyleName = "set" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
        for (Method method : methods) {
            JSSetter annotation = method.getAnnotation(JSSetter.class);
            if (annotation == null || !name.equals(annotation.value()) && (!"".equals(annotation.value()) || !newStyleName.equals(method.getName()))) continue;
            return method;
        }
        String oldStyleName = prefix + name;
        for (Method method : methods) {
            if (!oldStyleName.equals(method.getName())) continue;
            return method;
        }
        return null;
    }

    private static String getPropertyName(String methodName, String prefix, Annotation annotation) {
        if (prefix != null) {
            return methodName.substring(prefix.length());
        }
        String propName = null;
        if (annotation instanceof JSGetter) {
            propName = ((JSGetter)annotation).value();
            if ((propName == null || propName.length() == 0) && methodName.length() > 3 && methodName.startsWith("get") && Character.isUpperCase((propName = methodName.substring(3)).charAt(0))) {
                if (propName.length() == 1) {
                    propName = propName.toLowerCase(Locale.ROOT);
                } else if (!Character.isUpperCase(propName.charAt(1))) {
                    propName = Character.toLowerCase(propName.charAt(0)) + propName.substring(1);
                }
            }
        } else if (annotation instanceof JSFunction) {
            propName = ((JSFunction)annotation).value();
        } else if (annotation instanceof JSStaticFunction) {
            propName = ((JSStaticFunction)annotation).value();
        }
        if (propName == null || propName.length() == 0) {
            propName = methodName;
        }
        return propName;
    }

    private static <T extends Scriptable> Class<T> extendsScriptable(Class<?> c) {
        if (ScriptRuntime.ScriptableClass.isAssignableFrom(c)) {
            return c;
        }
        return null;
    }

    public void defineProperty(String propertyName, Object value, int attributes) {
        this.checkNotSealed(propertyName, 0);
        this.put(propertyName, (Scriptable)this, value);
        this.setAttributes(propertyName, attributes);
    }

    public void defineProperty(Symbol key, Object value, int attributes) {
        this.checkNotSealed(key, 0);
        this.put(key, (Scriptable)this, value);
        this.setAttributes(key, attributes);
    }

    public static void defineProperty(Scriptable destination, String propertyName, Object value, int attributes) {
        if (!(destination instanceof ScriptableObject)) {
            destination.put(propertyName, destination, value);
            return;
        }
        ScriptableObject so = (ScriptableObject)destination;
        so.defineProperty(propertyName, value, attributes);
    }

    public void defineProperty(Scriptable scope, String name, int length, SerializableCallable target, int attributes, int propertyAttributes) {
        LambdaFunction f = new LambdaFunction(scope, name, length, target, true);
        f.setStandardPropertyAttributes(propertyAttributes);
        this.defineProperty(name, (Object)f, attributes);
    }

    public void defineProperty(Scriptable scope, String name, int length, SerializableCallable target) {
        this.defineProperty(scope, name, length, target, 2, 3);
    }

    public void defineBuiltinProperty(Scriptable scope, String name, int length, SerializableCallable target) {
        this.defineBuiltinProperty(scope, name, length, target, 2, 3);
    }

    public void defineBuiltinProperty(Scriptable scope, String name, int length, SerializableCallable target, int attributes, int propertyAttributes) {
        LambdaFunction f = new LambdaFunction(scope, name, length, target, false);
        f.setStandardPropertyAttributes(propertyAttributes);
        this.defineProperty(name, (Object)f, attributes);
    }

    public static void defineConstProperty(Scriptable destination, String propertyName) {
        if (destination instanceof ConstProperties) {
            ConstProperties cp = (ConstProperties)((Object)destination);
            cp.defineConst(propertyName, destination);
        } else {
            ScriptableObject.defineProperty(destination, propertyName, Undefined.instance, 13);
        }
    }

    public void defineProperty(String propertyName, Class<?> clazz, int attributes) {
        int length = propertyName.length();
        if (length == 0) {
            throw new IllegalArgumentException();
        }
        char[] buf = new char[3 + length];
        propertyName.getChars(0, length, buf, 3);
        buf[3] = Character.toUpperCase(buf[3]);
        buf[0] = 103;
        buf[1] = 101;
        buf[2] = 116;
        String getterName = new String(buf);
        buf[0] = 115;
        String setterName = new String(buf);
        Method[] methods = FunctionObject.getMethodList(clazz);
        Method getter = FunctionObject.findSingleMethod(methods, getterName);
        Method setter = FunctionObject.findSingleMethod(methods, setterName);
        if (setter == null) {
            attributes |= 1;
        }
        this.defineProperty(propertyName, null, getter, setter == null ? null : setter, attributes);
    }

    public void defineProperty(String propertyName, Object delegateTo, Method getter, Method setter, int attributes) {
        TypeInfoFactory typeFactory = TypeInfoFactory.getOrElse(this, TypeInfoFactory.GLOBAL);
        MemberBox getterBox = null;
        if (getter != null) {
            boolean delegatedForm;
            getterBox = new MemberBox(getter, typeFactory);
            if (!Modifier.isStatic(getter.getModifiers())) {
                delegatedForm = delegateTo != null;
                getterBox.delegateTo = delegateTo;
            } else {
                delegatedForm = true;
                getterBox.delegateTo = Void.TYPE;
            }
            String errorId = null;
            Class<?>[] parmTypes = getter.getParameterTypes();
            if (parmTypes.length == 0) {
                if (delegatedForm) {
                    errorId = "msg.obj.getter.parms";
                }
            } else if (parmTypes.length == 1) {
                Class<?> argType = parmTypes[0];
                if (argType != ScriptRuntime.ScriptableClass && argType != ScriptRuntime.ScriptableObjectClass) {
                    errorId = "msg.bad.getter.parms";
                } else if (!delegatedForm) {
                    errorId = "msg.bad.getter.parms";
                }
            } else {
                errorId = "msg.bad.getter.parms";
            }
            if (errorId != null) {
                throw Context.reportRuntimeErrorById(errorId, getter.toString());
            }
        }
        MemberBox setterBox = null;
        if (setter != null) {
            boolean delegatedForm;
            if (setter.getReturnType() != Void.TYPE) {
                throw Context.reportRuntimeErrorById("msg.setter.return", setter.toString());
            }
            setterBox = new MemberBox(setter, typeFactory);
            if (!Modifier.isStatic(setter.getModifiers())) {
                delegatedForm = delegateTo != null;
                setterBox.delegateTo = delegateTo;
            } else {
                delegatedForm = true;
                setterBox.delegateTo = Void.TYPE;
            }
            String errorId = null;
            Class<?>[] parmTypes = setter.getParameterTypes();
            if (parmTypes.length == 1) {
                if (delegatedForm) {
                    errorId = "msg.setter2.expected";
                }
            } else if (parmTypes.length == 2) {
                Class<?> argType = parmTypes[0];
                if (argType != ScriptRuntime.ScriptableClass && argType != ScriptRuntime.ScriptableObjectClass) {
                    errorId = "msg.setter2.parms";
                } else if (!delegatedForm) {
                    errorId = "msg.setter1.parms";
                }
            } else {
                errorId = "msg.setter.parms";
            }
            if (errorId != null) {
                throw Context.reportRuntimeErrorById(errorId, setter.toString());
            }
        }
        AccessorSlot aSlot = this.getMap().compute(this, propertyName, 0, ScriptableObject::ensureAccessorSlot);
        aSlot.setAttributes(attributes);
        if (getterBox != null) {
            aSlot.getter = new AccessorSlot.MemberBoxGetter(getterBox);
        }
        if (setterBox != null) {
            aSlot.setter = new AccessorSlot.MemberBoxSetter(setterBox);
        }
    }

    public void defineOwnProperties(Context cx, ScriptableObject props) {
        int i;
        Object[] ids;
        try (CompoundOperationMap map = props.startCompoundOp(false);){
            ids = props.getIds(map, false, true);
        }
        ScriptableObject[] descs = new ScriptableObject[ids.length];
        int len = ids.length;
        for (i = 0; i < len; ++i) {
            Object descObj = ScriptRuntime.getObjectElem(props, ids[i], cx);
            ScriptableObject desc = ScriptableObject.ensureScriptableObject(descObj);
            this.checkPropertyDefinition(desc);
            descs[i] = desc;
        }
        len = ids.length;
        for (i = 0; i < len; ++i) {
            this.defineOwnProperty(cx, ids[i], descs[i]);
        }
    }

    public boolean defineOwnProperty(Context cx, Object id, ScriptableObject desc) {
        this.checkPropertyDefinition(desc);
        return this.defineOwnProperty(cx, id, desc, true);
    }

    protected boolean defineOwnProperty(Context cx, Object id, ScriptableObject desc, boolean checkValid) {
        Object key = null;
        int index = 0;
        if (id instanceof Symbol) {
            key = id;
        } else {
            ScriptRuntime.StringIdOrIndex s = ScriptRuntime.toStringIdOrIndex(id);
            if (s.stringId == null) {
                index = s.index;
            } else {
                key = s.stringId;
            }
        }
        Slot aSlot = this.getMap().query(key, index);
        DescriptorInfo info = new DescriptorInfo(desc);
        if (aSlot instanceof BuiltInSlot) {
            return ((BuiltInSlot)aSlot).applyNewDescriptor(id, info, checkValid, key, index);
        }
        try (CompoundOperationMap map = this.startCompoundOp(true);){
            boolean bl = ScriptableObject.defineOrdinaryProperty(ScriptableObject::setSlotValue, this, map, id, info, checkValid, key, index);
            return bl;
        }
    }

    static boolean defineOrdinaryProperty(PropDescValueSetter descValueSetter, ScriptableObject owner, CompoundOperationMap compoundOp, Object id, DescriptorInfo info, boolean checkValid, Object key, int index) {
        compoundOp.compute(owner, compoundOp, key, index, (k, ix, existing, map, mapOwner) -> {
            int attributes;
            Slot slot;
            if (checkValid) {
                owner.checkPropertyChangeForSlot(id, existing, info);
            }
            if (existing == null) {
                slot = new Slot(k, ix, 0);
                attributes = ScriptableObject.applyDescriptorToAttributeBitset(7, info.enumerable, info.writable, info.configurable);
            } else {
                slot = existing;
                attributes = ScriptableObject.applyDescriptorToAttributeBitset(existing.getAttributes(), info.enumerable, info.writable, info.configurable);
            }
            slot = descValueSetter.execute(owner, info, key, existing, map, slot);
            slot.setAttributes(attributes);
            return slot;
        });
        return true;
    }

    static Slot setSlotValue(ScriptableObject owner, DescriptorInfo info, Object key, Slot existing, CompoundOperationMap map, Slot slot) {
        if (info.accessorDescriptor) {
            AccessorSlot fslot;
            if (slot instanceof AccessorSlot) {
                fslot = (AccessorSlot)slot;
            } else {
                fslot = slot instanceof LambdaAccessorSlot && "__proto__".equals(key) ? ((LambdaAccessorSlot)slot).asAccessorSlot() : new AccessorSlot(slot);
                slot = fslot;
            }
            if (info.getter != NOT_FOUND) {
                fslot.getter = new AccessorSlot.FunctionGetter(info.getter);
            }
            if (info.setter != NOT_FOUND) {
                fslot.setter = new AccessorSlot.FunctionSetter(info.setter);
            }
            fslot.value = Undefined.instance;
        } else if (slot instanceof BuiltInSlot) {
            if (info.value != NOT_FOUND) {
                ((BuiltInSlot)slot).setValueFromDescriptor(info.value, owner, owner, true);
            }
        } else {
            if (!slot.isValueSlot() && ScriptableObject.isDataDescriptor(info)) {
                slot = new Slot(slot);
            }
            if (info.value != NOT_FOUND) {
                slot.value = info.value;
            } else if (existing == null) {
                slot.value = Undefined.instance;
            }
        }
        return slot;
    }

    public void defineProperty(String name, Supplier<Object> getter, Consumer<Object> setter, int attributes) {
        LambdaSlot slot = this.getMap().compute(this, name, 0, ScriptableObject::ensureLambdaSlot);
        slot.setAttributes(attributes);
        slot.getter = getter;
        slot.setter = setter;
    }

    public void defineProperty(Context cx, String name, LambdaGetterFunction getter, LambdaSetterFunction setter, int attributes) {
        if (getter == null && setter == null) {
            throw ScriptRuntime.typeError("at least one of {getter, setter} is required");
        }
        LambdaAccessorSlot newSlot = this.createLambdaAccessorSlot(name, 0, getter, setter, attributes);
        this.replaceLambdaAccessorSlot(cx, name, newSlot);
    }

    public void defineProperty(Context cx, String name, LambdaGetterFunction getter, int attributes) {
        this.defineProperty(cx, name, getter, null, attributes);
    }

    public void defineProperty(Context cx, Symbol key, LambdaGetterFunction getter, LambdaSetterFunction setter, int attributes) {
        if (getter == null && setter == null) {
            throw ScriptRuntime.typeError("at least one of {getter, setter} is required");
        }
        LambdaAccessorSlot newSlot = this.createLambdaAccessorSlot(key, 0, getter, setter, attributes);
        this.replaceLambdaAccessorSlot(cx, key, newSlot);
    }

    private void replaceLambdaAccessorSlot(Context cx, Object key, LambdaAccessorSlot newSlot) {
        ScriptableObject newDesc = newSlot.buildPropertyDescriptor(cx);
        this.checkPropertyDefinition(newDesc);
        this.getMap().compute(this, key, 0, (id, index, existing, compoundOpMap, o) -> {
            if (existing != null) {
                return this.replaceExistingLambdaSlot(cx, key, existing, newSlot);
            }
            this.checkPropertyChangeForSlot(key, null, newDesc);
            return newSlot;
        });
    }

    private LambdaAccessorSlot replaceExistingLambdaSlot(Context cx, Object key, Slot existing, LambdaAccessorSlot newSlot) {
        LambdaAccessorSlot replacedSlot = existing instanceof LambdaAccessorSlot ? (LambdaAccessorSlot)existing : new LambdaAccessorSlot(existing);
        replacedSlot.replaceWith(newSlot);
        ScriptableObject replacedDesc = replacedSlot.buildPropertyDescriptor(cx);
        this.checkPropertyChangeForSlot(key, existing, replacedDesc);
        return replacedSlot;
    }

    private LambdaAccessorSlot createLambdaAccessorSlot(Object name, int index, LambdaGetterFunction getter, LambdaSetterFunction setter, int attributes) {
        LambdaAccessorSlot slot = new LambdaAccessorSlot(name, index);
        slot.setGetter(this, getter);
        slot.setSetter(this, setter);
        slot.setAttributes(attributes);
        return slot;
    }

    protected void checkPropertyDefinition(ScriptableObject desc) {
        Object getter = ScriptableObject.getProperty((Scriptable)desc, "get");
        if (getter != NOT_FOUND && getter != Undefined.instance && !(getter instanceof Callable)) {
            throw ScriptRuntime.notFunctionError(getter);
        }
        Object setter = ScriptableObject.getProperty((Scriptable)desc, "set");
        if (setter != NOT_FOUND && setter != Undefined.instance && !(setter instanceof Callable)) {
            throw ScriptRuntime.notFunctionError(setter);
        }
        if (ScriptableObject.isDataDescriptor(desc) && ScriptableObject.isAccessorDescriptor(desc)) {
            throw ScriptRuntime.typeErrorById("msg.both.data.and.accessor.desc", new Object[0]);
        }
    }

    protected final void checkPropertyChangeForSlot(Object id, Slot current, ScriptableObject desc) {
        this.checkPropertyChangeForSlot(id, current, new DescriptorInfo(desc));
    }

    protected final void checkPropertyChangeForSlot(Object id, Slot current, DescriptorInfo info) {
        if (current == null) {
            if (!this.isExtensible()) {
                throw ScriptRuntime.typeErrorById("msg.not.extensible", new Object[0]);
            }
        } else if ((current.getAttributes() & 4) != 0) {
            if (ScriptableObject.isTrue(info.configurable)) {
                throw ScriptRuntime.typeErrorById("msg.change.configurable.false.to.true", id);
            }
            if ((current.getAttributes() & 2) == 0 != ScriptableObject.isTrue(info.enumerable)) {
                throw ScriptRuntime.typeErrorById("msg.change.enumerable.with.configurable.false", id);
            }
            boolean isData = ScriptableObject.isDataDescriptor(info);
            boolean isBuiltIn = current instanceof BuiltInSlot;
            boolean isAccessor = info.accessorDescriptor;
            if (isData || isAccessor) {
                if (isData) {
                    if ((current.getAttributes() & 1) != 0) {
                        Object currentValue;
                        if (ScriptableObject.isTrue(info.writable)) {
                            throw ScriptRuntime.typeErrorById("msg.change.writable.false.to.true.with.configurable.false", id);
                        }
                        Object object = currentValue = isBuiltIn ? ((BuiltInSlot)current).getValue(null) : current.value;
                        if (!this.sameValue(info.value, currentValue)) {
                            throw ScriptRuntime.typeErrorById("msg.change.value.with.writable.false", id);
                        }
                    }
                } else if (isAccessor && current instanceof AccessorSlot) {
                    AccessorSlot accessor = (AccessorSlot)current;
                    if (!accessor.isSameSetterFunction(info.setter)) {
                        throw ScriptRuntime.typeErrorById("msg.change.setter.with.configurable.false", id);
                    }
                    if (!accessor.isSameGetterFunction(info.getter)) {
                        throw ScriptRuntime.typeErrorById("msg.change.getter.with.configurable.false", id);
                    }
                } else {
                    throw ScriptRuntime.typeErrorById("msg.change.property.data.to.accessor.with.configurable.false", id);
                }
            }
        }
    }

    protected static boolean isTrue(Object value) {
        return value != NOT_FOUND && ScriptRuntime.toBoolean(value);
    }

    protected static boolean isFalse(Object value) {
        return !ScriptableObject.isTrue(value);
    }

    protected boolean sameValue(Object newValue, Object currentValue) {
        if (newValue == NOT_FOUND) {
            return true;
        }
        if (currentValue == NOT_FOUND) {
            currentValue = Undefined.instance;
        }
        if (currentValue instanceof Number && newValue instanceof Number) {
            double d1 = ((Number)currentValue).doubleValue();
            double d2 = ((Number)newValue).doubleValue();
            if (Double.isNaN(d1) && Double.isNaN(d2)) {
                return true;
            }
            if (d1 == 0.0 && Double.doubleToLongBits(d1) != Double.doubleToLongBits(d2)) {
                return false;
            }
        }
        return ScriptRuntime.shallowEq(currentValue, newValue);
    }

    protected static int applyDescriptorToAttributeBitset(int attributes, Object enumerable, Object writable, Object configurable) {
        if (enumerable != NOT_FOUND) {
            int n = attributes = ScriptRuntime.toBoolean(enumerable) ? attributes & 0xFFFFFFFD : attributes | 2;
        }
        if (writable != NOT_FOUND) {
            int n = attributes = ScriptRuntime.toBoolean(writable) ? attributes & 0xFFFFFFFE : attributes | 1;
        }
        if (configurable != NOT_FOUND) {
            attributes = ScriptRuntime.toBoolean(configurable) ? attributes & 0xFFFFFFFB : attributes | 4;
        }
        return attributes;
    }

    protected static boolean isDataDescriptor(ScriptableObject desc) {
        return ScriptableObject.hasProperty((Scriptable)desc, "value") || ScriptableObject.hasProperty((Scriptable)desc, "writable");
    }

    protected static boolean isDataDescriptor(DescriptorInfo info) {
        return info.value != NOT_FOUND || info.writable != NOT_FOUND;
    }

    protected static boolean isAccessorDescriptor(ScriptableObject desc) {
        return ScriptableObject.hasProperty((Scriptable)desc, "get") || ScriptableObject.hasProperty((Scriptable)desc, "set");
    }

    protected static boolean isGenericDescriptor(ScriptableObject desc) {
        return !ScriptableObject.isDataDescriptor(desc) && !ScriptableObject.isAccessorDescriptor(desc);
    }

    protected static Scriptable ensureScriptable(Object arg) {
        if (!(arg instanceof Scriptable)) {
            throw ScriptRuntime.typeErrorById("msg.arg.not.object", ScriptRuntime.typeof(arg));
        }
        return (Scriptable)arg;
    }

    protected static SymbolScriptable ensureSymbolScriptable(Object arg) {
        if (!(arg instanceof SymbolScriptable)) {
            throw ScriptRuntime.typeErrorById("msg.object.not.symbolscriptable", ScriptRuntime.typeof(arg));
        }
        return (SymbolScriptable)arg;
    }

    protected static ScriptableObject ensureScriptableObject(Object arg) {
        if (arg instanceof ScriptableObject) {
            return (ScriptableObject)arg;
        }
        if (arg instanceof Delegator) {
            return (ScriptableObject)((Delegator)arg).getDelegee();
        }
        throw ScriptRuntime.typeErrorById("msg.arg.not.object", ScriptRuntime.typeof(arg));
    }

    protected static ScriptableObject ensureScriptableObjectButNotSymbol(Object arg) {
        if (arg instanceof Symbol) {
            throw ScriptRuntime.typeErrorById("msg.arg.not.object", ScriptRuntime.typeof(arg));
        }
        return ScriptableObject.ensureScriptableObject(arg);
    }

    public void defineFunctionProperties(String[] names, Class<?> clazz, int attributes) {
        Method[] methods = FunctionObject.getMethodList(clazz);
        for (String name : names) {
            Method m = FunctionObject.findSingleMethod(methods, name);
            if (m == null) {
                throw Context.reportRuntimeErrorById("msg.method.not.found", name, clazz.getName());
            }
            FunctionObject f = new FunctionObject(name, m, this);
            this.defineProperty(name, (Object)f, attributes);
        }
    }

    public static Scriptable getObjectPrototype(Scriptable scope) {
        return TopLevel.getBuiltinPrototype(ScriptableObject.getTopLevelScope(scope), TopLevel.Builtins.Object);
    }

    public static Scriptable getFunctionPrototype(Scriptable scope) {
        return TopLevel.getBuiltinPrototype(ScriptableObject.getTopLevelScope(scope), TopLevel.Builtins.Function);
    }

    public static Scriptable getGeneratorFunctionPrototype(Scriptable scope) {
        return TopLevel.getBuiltinPrototype(ScriptableObject.getTopLevelScope(scope), TopLevel.Builtins.GeneratorFunction);
    }

    public static Scriptable getArrayPrototype(Scriptable scope) {
        return TopLevel.getBuiltinPrototype(ScriptableObject.getTopLevelScope(scope), TopLevel.Builtins.Array);
    }

    public static Scriptable getClassPrototype(Scriptable scope, String className) {
        Object proto;
        Object ctor = ScriptableObject.getProperty(scope = ScriptableObject.getTopLevelScope(scope), className);
        if (ctor instanceof BaseFunction) {
            proto = ((BaseFunction)ctor).getPrototypeProperty();
        } else if (ctor instanceof Scriptable) {
            Scriptable ctorObj = (Scriptable)ctor;
            proto = ctorObj.get("prototype", ctorObj);
        } else {
            return null;
        }
        if (proto instanceof Scriptable) {
            return (Scriptable)proto;
        }
        return null;
    }

    public static Scriptable getTopLevelScope(Scriptable obj) {
        Scriptable parent;
        while ((parent = obj.getParentScope()) != null) {
            obj = parent;
        }
        return obj;
    }

    public boolean isExtensible() {
        return this.isExtensible;
    }

    public boolean preventExtensions() {
        this.isExtensible = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sealObject() {
        ArrayList<Slot> toInitialize = new ArrayList<Slot>();
        while (!this.isSealed) {
            for (Slot slot : toInitialize) {
                Object value = slot.value;
                if (!(value instanceof LazilyLoadedCtor)) continue;
                LazilyLoadedCtor initializer = (LazilyLoadedCtor)value;
                try {
                    initializer.init();
                }
                finally {
                    slot.value = initializer.getValue();
                }
            }
            toInitialize.clear();
            CompoundOperationMap map = this.startCompoundOp(false);
            Throwable throwable = null;
            try {
                for (Slot slot : map) {
                    Object value = slot.value;
                    if (!(value instanceof LazilyLoadedCtor)) continue;
                    toInitialize.add(slot);
                }
                if (!toInitialize.isEmpty()) continue;
                this.isSealed = true;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (map == null) continue;
                if (throwable != null) {
                    try {
                        map.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                map.close();
            }
        }
    }

    public final boolean isSealed() {
        return this.isSealed;
    }

    private void checkNotSealed(Object key, int index) {
        if (!this.isSealed()) {
            return;
        }
        String str = key != null ? key.toString() : Integer.toString(index);
        throw Context.reportRuntimeErrorById("msg.modify.sealed", str);
    }

    protected static void checkNotSealed(ScriptableObject obj, Object key, int index) {
        obj.checkNotSealed(key, index);
    }

    public static Object getProperty(Scriptable obj, String name) {
        return ScriptableObject.getPropWalkingPrototypeChain(obj, name, obj);
    }

    public static Object getSuperProperty(Scriptable superObj, Scriptable thisObj, String name) {
        return ScriptableObject.getPropWalkingPrototypeChain(superObj, name, thisObj);
    }

    private static Object getPropWalkingPrototypeChain(Scriptable obj, String name, Scriptable start) {
        Object result;
        while ((result = obj.get(name, start)) == Scriptable.NOT_FOUND && (obj = obj.getPrototype()) != null) {
        }
        return result;
    }

    public static Object getProperty(Scriptable obj, Symbol key) {
        return ScriptableObject.getPropWalkingPrototypeChain(obj, obj, key);
    }

    public static Object getSuperProperty(Scriptable superObj, Scriptable thisObj, Symbol key) {
        return ScriptableObject.getPropWalkingPrototypeChain(superObj, thisObj, key);
    }

    private static Object getPropWalkingPrototypeChain(Scriptable obj, Scriptable start, Symbol key) {
        Object result;
        while ((result = ScriptableObject.ensureSymbolScriptable(obj).get(key, start)) == Scriptable.NOT_FOUND && (obj = obj.getPrototype()) != null) {
        }
        return result;
    }

    public static <T> T getTypedProperty(Scriptable s, int index, Class<T> type) {
        Object val = ScriptableObject.getProperty(s, index);
        if (val == Scriptable.NOT_FOUND) {
            val = null;
        }
        return type.cast(Context.jsToJava(val, type));
    }

    public static Object getProperty(Scriptable obj, int index) {
        return ScriptableObject.getPropWalkingPrototypeChain(obj, index, obj);
    }

    public static Object getSuperProperty(Scriptable superObj, Scriptable thisObj, int index) {
        return ScriptableObject.getPropWalkingPrototypeChain(superObj, index, thisObj);
    }

    private static Object getPropWalkingPrototypeChain(Scriptable obj, int index, Scriptable start) {
        Object result;
        while ((result = obj.get(index, start)) == Scriptable.NOT_FOUND && (obj = obj.getPrototype()) != null) {
        }
        return result;
    }

    public static <T> T getTypedProperty(Scriptable s, String name, Class<T> type) {
        Object val = ScriptableObject.getProperty(s, name);
        if (val == Scriptable.NOT_FOUND) {
            val = null;
        }
        return type.cast(Context.jsToJava(val, type));
    }

    public static boolean hasProperty(Scriptable obj, String name) {
        return null != ScriptableObject.getBase(obj, name);
    }

    public static void redefineProperty(Scriptable obj, String name, boolean isConst) {
        ConstProperties cp;
        Scriptable base = ScriptableObject.getBase(obj, name);
        if (base == null) {
            return;
        }
        if (base instanceof ConstProperties && (cp = (ConstProperties)((Object)base)).isConst(name)) {
            throw ScriptRuntime.typeErrorById("msg.const.redecl", name);
        }
        if (isConst) {
            throw ScriptRuntime.typeErrorById("msg.var.redecl", name);
        }
    }

    public static boolean hasProperty(Scriptable obj, int index) {
        return null != ScriptableObject.getBase(obj, index);
    }

    public static boolean hasProperty(Scriptable obj, Symbol key) {
        return null != ScriptableObject.getBase(obj, key);
    }

    public static void putProperty(Scriptable obj, String name, Object value) {
        Scriptable base = ScriptableObject.getBase(obj, name);
        if (base == null) {
            base = obj;
        }
        base.put(name, obj, value);
    }

    public static void putSuperProperty(Scriptable superObj, Scriptable thisObj, String name, Object value) {
        Scriptable base = ScriptableObject.getBase(superObj, name);
        if (base == null) {
            base = superObj;
        }
        base.put(name, thisObj, value);
    }

    public static void putProperty(Scriptable obj, Symbol key, Object value) {
        Scriptable base = ScriptableObject.getBase(obj, key);
        if (base == null) {
            base = obj;
        }
        ScriptableObject.ensureSymbolScriptable(base).put(key, obj, value);
    }

    public static void putSuperProperty(Scriptable superObj, Scriptable thisObj, Symbol key, Object value) {
        Scriptable base = ScriptableObject.getBase(superObj, key);
        if (base == null) {
            base = superObj;
        }
        ScriptableObject.ensureSymbolScriptable(base).put(key, thisObj, value);
    }

    public static void putConstProperty(Scriptable obj, String name, Object value) {
        Scriptable base = ScriptableObject.getBase(obj, name);
        if (base == null) {
            base = obj;
        }
        if (base instanceof ConstProperties) {
            ((ConstProperties)((Object)base)).putConst(name, obj, value);
        }
    }

    public static void putProperty(Scriptable obj, int index, Object value) {
        Scriptable base = ScriptableObject.getBase(obj, index);
        if (base == null) {
            base = obj;
        }
        base.put(index, obj, value);
    }

    public static void putSuperProperty(Scriptable superObj, Scriptable thisObj, int index, Object value) {
        Scriptable base = ScriptableObject.getBase(superObj, index);
        if (base == null) {
            base = superObj;
        }
        base.put(index, thisObj, value);
    }

    public static boolean deleteProperty(Scriptable obj, String name) {
        Scriptable base = ScriptableObject.getBase(obj, name);
        if (base == null) {
            return true;
        }
        base.delete(name);
        return !base.has(name, obj);
    }

    public static boolean deleteProperty(Scriptable obj, int index) {
        Scriptable base = ScriptableObject.getBase(obj, index);
        if (base == null) {
            return true;
        }
        base.delete(index);
        return !base.has(index, obj);
    }

    public static boolean deleteProperty(Scriptable obj, Symbol key) {
        Scriptable base = ScriptableObject.getBase(obj, key);
        if (base == null) {
            return true;
        }
        SymbolScriptable scriptable = ScriptableObject.ensureSymbolScriptable(base);
        scriptable.delete(key);
        return !scriptable.has(key, obj);
    }

    public static Object[] getPropertyIds(Scriptable obj) {
        if (obj == null) {
            return ScriptRuntime.emptyArgs;
        }
        Object[] result = obj.getIds();
        HashSet<Object> map = null;
        while ((obj = obj.getPrototype()) != null) {
            int i;
            Object[] ids = obj.getIds();
            if (ids.length == 0) continue;
            if (map == null) {
                if (result.length == 0) {
                    result = ids;
                    continue;
                }
                map = new HashSet<Object>();
                for (i = 0; i != result.length; ++i) {
                    map.add(result[i]);
                }
                result = null;
            }
            for (i = 0; i != ids.length; ++i) {
                map.add(ids[i]);
            }
        }
        if (map != null) {
            result = map.toArray();
        }
        return result;
    }

    public static Object callMethod(Scriptable obj, String methodName, Object[] args) {
        return ScriptableObject.callMethod(null, obj, methodName, args);
    }

    public static Object callMethod(Context cx, Scriptable obj, String methodName, Object[] args) {
        Object funObj = ScriptableObject.getProperty(obj, methodName);
        if (!(funObj instanceof Function)) {
            throw ScriptRuntime.notFunctionError(obj, methodName);
        }
        Function fun = (Function)funObj;
        Scriptable scope = ScriptableObject.getTopLevelScope(obj);
        if (cx != null) {
            return fun.call(cx, scope, obj, args);
        }
        return Context.call(null, fun, scope, obj, args);
    }

    static Scriptable getBase(Scriptable start, String name) {
        Scriptable obj = start;
        while (!obj.has(name, start) && (obj = obj.getPrototype()) != null) {
        }
        return obj;
    }

    static Scriptable getBase(Scriptable start, int index) {
        Scriptable obj = start;
        while (!obj.has(index, start) && (obj = obj.getPrototype()) != null) {
        }
        return obj;
    }

    static Scriptable getBase(Scriptable start, Symbol key) {
        Scriptable obj = start;
        while (!ScriptableObject.ensureSymbolScriptable(obj).has(key, start) && (obj = obj.getPrototype()) != null) {
        }
        return obj;
    }

    public final Object getAssociatedValue(Object key) {
        Map<Object, Object> h = this.associatedValues;
        if (h == null) {
            return null;
        }
        return h.get(key);
    }

    public static Object getTopScopeValue(Scriptable scope, Object key) {
        scope = ScriptableObject.getTopLevelScope(scope);
        do {
            ScriptableObject so;
            Object value;
            if (!(scope instanceof ScriptableObject) || (value = (so = (ScriptableObject)scope).getAssociatedValue(key)) == null) continue;
            return value;
        } while ((scope = scope.getPrototype()) != null);
        return null;
    }

    public final synchronized Object associateValue(Object key, Object value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        Map<Object, Object> h = this.associatedValues;
        if (h == null) {
            this.associatedValues = h = new HashMap<Object, Object>();
        }
        return Kit.initHash(h, key, value);
    }

    private boolean putImpl(Object key, int index, Scriptable start, Object value, boolean isThrow) {
        Slot slot;
        if (this != start) {
            slot = this.getMap().query(key, index);
            if (!this.isExtensible && (slot == null || !(slot instanceof AccessorSlot) && (slot.getAttributes() & 1) != 0) && isThrow) {
                throw ScriptRuntime.typeErrorById("msg.not.extensible", new Object[0]);
            }
            if (slot == null) {
                return false;
            }
        } else if (!this.isExtensible) {
            slot = this.getMap().query(key, index);
            if ((slot == null || !(slot instanceof AccessorSlot) && (slot.getAttributes() & 1) != 0) && isThrow) {
                throw ScriptRuntime.typeErrorById("msg.not.extensible", new Object[0]);
            }
            if (slot == null) {
                return true;
            }
        } else {
            if (this.isSealed) {
                this.checkNotSealed(key, index);
            }
            slot = this.getMap().modify(this, key, index, 0);
        }
        return slot.setValue(value, this, start, isThrow);
    }

    private boolean putConstImpl(String name, int index, Scriptable start, Object value, int constFlag) {
        Slot slot;
        Context cx;
        assert (constFlag != 0);
        if (!this.isExtensible && (cx = Context.getContext()).isStrictMode()) {
            throw ScriptRuntime.typeErrorById("msg.not.extensible", new Object[0]);
        }
        if (this != start) {
            slot = this.getMap().query(name, index);
            if (slot == null) {
                return false;
            }
        } else if (!this.isExtensible()) {
            slot = this.getMap().query(name, index);
            if (slot == null) {
                return true;
            }
        } else {
            this.checkNotSealed(name, index);
            slot = this.getMap().modify(this, name, index, 13);
            int attr = slot.getAttributes();
            if ((attr & 1) == 0) {
                throw Context.reportRuntimeErrorById("msg.var.redecl", name);
            }
            slot.value = value;
            if (constFlag != 8) {
                slot.setAttributes(attr & 0xFFFFFFF7);
            }
            return true;
        }
        return slot.setValue(value, this, start);
    }

    private Slot getAttributeSlot(String name, int index) {
        Slot slot = this.getMap().query(name, index);
        if (slot == null) {
            String str = name != null ? name : Integer.toString(index);
            throw Context.reportRuntimeErrorById("msg.prop.not.found", str);
        }
        return slot;
    }

    private Slot getAttributeSlot(Symbol key) {
        Slot slot = this.getMap().query(key, 0);
        if (slot == null) {
            throw Context.reportRuntimeErrorById("msg.prop.not.found", key);
        }
        return slot;
    }

    Object[] getIds(CompoundOperationMap map, boolean getNonEnumerable, boolean getSymbols) {
        Object[] result;
        Object[] a;
        int externalLen;
        int n = externalLen = this.externalData == null ? 0 : this.externalData.getArrayLength();
        if (externalLen == 0) {
            a = ScriptRuntime.emptyArgs;
        } else {
            a = new Object[externalLen];
            for (int i = 0; i < externalLen; ++i) {
                a[i] = i;
            }
        }
        if (map.isEmpty()) {
            return a;
        }
        int c = externalLen;
        for (Slot slot : map) {
            if (!getNonEnumerable && (slot.getAttributes() & 2) != 0 || !getSymbols && slot.name instanceof Symbol) continue;
            if (c == externalLen) {
                Object[] oldA = a;
                a = new Object[map.dirtySize() + externalLen];
                if (oldA != null) {
                    System.arraycopy(oldA, 0, a, 0, externalLen);
                }
            }
            a[c++] = slot.name != null ? slot.name : Integer.valueOf(slot.indexOrHash);
        }
        if (c == a.length + externalLen) {
            result = a;
        } else {
            result = new Object[c];
            System.arraycopy(a, 0, result, 0, c);
        }
        Context cx = Context.getCurrentContext();
        if (cx != null) {
            Arrays.sort(result, KEY_COMPARATOR);
        }
        return result;
    }

    private static AccessorSlot ensureAccessorSlot(Object name, int index, Slot existing, SlotMap compoundOp, SlotMapOwner owner) {
        if (existing == null) {
            return new AccessorSlot(name, index);
        }
        if (existing instanceof AccessorSlot) {
            return (AccessorSlot)existing;
        }
        return new AccessorSlot(existing);
    }

    private static LazyLoadSlot ensureLazySlot(Object name, int index, Slot existing, SlotMap compoundOp, SlotMapOwner owner) {
        if (existing == null) {
            return new LazyLoadSlot(name, index);
        }
        if (existing instanceof LazyLoadSlot) {
            return (LazyLoadSlot)existing;
        }
        return new LazyLoadSlot(existing);
    }

    private static LambdaSlot ensureLambdaSlot(Object name, int index, Slot existing, SlotMap compoundOp, SlotMapOwner owner) {
        if (existing == null) {
            return new LambdaSlot(name, index);
        }
        if (existing instanceof LambdaSlot) {
            return (LambdaSlot)existing;
        }
        return new LambdaSlot(existing);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        try (CompoundOperationMap map = this.startCompoundOp(false);){
            int objectsCount = map.dirtySize();
            if (objectsCount == 0) {
                out.writeInt(0);
            } else {
                out.writeInt(objectsCount);
                for (Slot slot : this.getMap()) {
                    out.writeObject(slot);
                }
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int tableSize = in.readInt();
        this.setMap(ScriptableObject.createSlotMap(tableSize));
        for (int i = 0; i < tableSize; ++i) {
            Slot slot = (Slot)in.readObject();
            this.getMap().add(this, slot);
        }
    }

    protected ScriptableObject getOwnPropertyDescriptor(Context cx, Object id) {
        Slot slot = this.querySlot(cx, id);
        if (slot == null) {
            return null;
        }
        return slot.getPropertyDescriptor(cx, this);
    }

    protected final Slot querySlot(Context cx, Object id) {
        if (id instanceof Symbol) {
            return this.getMap().query(id, 0);
        }
        ScriptRuntime.StringIdOrIndex s = ScriptRuntime.toStringIdOrIndex(id);
        if (s.stringId == null) {
            return this.getMap().query(null, s.index);
        }
        return this.getMap().query(s.stringId, 0);
    }

    public int size() {
        return this.getMap().size();
    }

    public boolean isEmpty() {
        return this.getMap().isEmpty();
    }

    public Object get(Object key) {
        Object value = null;
        if (key instanceof String) {
            value = this.get((String)key, (Scriptable)this);
        } else if (key instanceof Symbol) {
            value = this.get((Symbol)key, (Scriptable)this);
        } else if (key instanceof Number) {
            value = this.get(((Number)key).intValue(), (Scriptable)this);
        }
        if (value == Scriptable.NOT_FOUND || value == Undefined.instance) {
            return null;
        }
        if (value instanceof Wrapper) {
            return ((Wrapper)value).unwrap();
        }
        return value;
    }

    public static <T extends ScriptableObject> void defineBuiltInProperty(T owner, String name, int attributes, BuiltInSlot.Getter<T> getter, BuiltInSlot.Setter<T> setter) {
        owner.getMap().add(owner, new BuiltInSlot<T>(name, 0, attributes, owner, getter, setter));
    }

    public static <T extends ScriptableObject> void defineBuiltInProperty(T owner, Object name, int attributes, BuiltInSlot.Getter<T> getter, BuiltInSlot.Setter<T> setter, BuiltInSlot.AttributeSetter<T> attrSetter) {
        owner.getMap().add(owner, new BuiltInSlot<T>(name, 0, attributes, owner, getter, setter, attrSetter));
    }

    public static <T extends ScriptableObject> void defineBuiltInProperty(T owner, Object name, int attributes, BuiltInSlot.Getter<T> getter) {
        owner.getMap().add(owner, new BuiltInSlot<T>(name, 0, attributes, owner, getter));
    }

    public static <T extends ScriptableObject> void defineBuiltInProperty(T owner, String name, int attributes, BuiltInSlot.Getter<T> getter, BuiltInSlot.Setter<T> setter, BuiltInSlot.AttributeSetter<T> attrSetter, BuiltInSlot.PropDescriptionSetter<T> propDescSetter) {
        owner.getMap().add(owner, new BuiltInSlot<T>(name, 0, attributes, owner, getter, setter, attrSetter, propDescSetter));
    }

    protected static <T> T ensureType(Object obj, Class<T> clazz, String functionName) {
        if (clazz.isInstance(obj)) {
            return (T)obj;
        }
        if (obj == null) {
            throw ScriptRuntime.typeErrorById("msg.incompat.call.details", functionName, "null", clazz.getName());
        }
        throw ScriptRuntime.typeErrorById("msg.incompat.call.details", functionName, obj.getClass().getName(), clazz.getName());
    }

    static {
        try {
            GET_ARRAY_LENGTH = ScriptableObject.class.getMethod("getExternalArrayLength", new Class[0]);
        }
        catch (NoSuchMethodException nsm) {
            throw new RuntimeException(nsm);
        }
        KEY_COMPARATOR = new KeyComparator();
    }

    public static final class KeyComparator
    implements Comparator<Object>,
    Serializable {
        private static final long serialVersionUID = 6411335891523988149L;

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof Integer) {
                if (o2 instanceof Integer) {
                    return ((Integer)o1).compareTo((Integer)o2);
                }
                return -1;
            }
            if (o2 instanceof Integer) {
                return 1;
            }
            return 0;
        }
    }

    public static interface LambdaSetterFunction
    extends Serializable {
        public void accept(Scriptable var1, Object var2);
    }

    public static interface LambdaGetterFunction
    extends Serializable {
        public Object apply(Scriptable var1);
    }

    static interface PropDescValueSetter {
        public Slot execute(ScriptableObject var1, DescriptorInfo var2, Object var3, Slot var4, CompoundOperationMap var5, Slot var6);
    }

    public static final class DescriptorInfo {
        Object enumerable;
        Object writable;
        Object configurable;
        Object getter;
        Object setter;
        Object value;
        boolean accessorDescriptor;

        DescriptorInfo(ScriptableObject desc) {
            this.enumerable = ScriptableObject.getProperty((Scriptable)desc, "enumerable");
            this.writable = ScriptableObject.getProperty((Scriptable)desc, "writable");
            this.configurable = ScriptableObject.getProperty((Scriptable)desc, "configurable");
            this.getter = ScriptableObject.getProperty((Scriptable)desc, "get");
            this.setter = ScriptableObject.getProperty((Scriptable)desc, "set");
            this.value = ScriptableObject.getProperty((Scriptable)desc, "value");
            this.accessorDescriptor = this.getter != Scriptable.NOT_FOUND || this.setter != Scriptable.NOT_FOUND;
        }
    }
}

