/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript;

import java.util.ArrayList;
import org.htmlunit.corejs.javascript.AbstractEcmaObjectOperations;
import org.htmlunit.corejs.javascript.Callable;
import org.htmlunit.corejs.javascript.Constructable;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.EcmaError;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.IteratorLikeIterable;
import org.htmlunit.corejs.javascript.JavaScriptException;
import org.htmlunit.corejs.javascript.LambdaConstructor;
import org.htmlunit.corejs.javascript.LambdaFunction;
import org.htmlunit.corejs.javascript.NativeError;
import org.htmlunit.corejs.javascript.RhinoException;
import org.htmlunit.corejs.javascript.ScriptRuntime;
import org.htmlunit.corejs.javascript.ScriptRuntimeES6;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.corejs.javascript.SymbolKey;
import org.htmlunit.corejs.javascript.TopLevel;
import org.htmlunit.corejs.javascript.Undefined;

public class NativePromise
extends ScriptableObject {
    private State state = State.PENDING;
    private Object result = null;
    private boolean handled = false;
    private ArrayList<Reaction> fulfillReactions = new ArrayList();
    private ArrayList<Reaction> rejectReactions = new ArrayList();

    public static Object init(Context cx, Scriptable scope, boolean sealed) {
        LambdaConstructor constructor = new LambdaConstructor(scope, "Promise", 1, 2, NativePromise::constructor);
        constructor.setPrototypePropertyAttributes(7);
        constructor.defineConstructorMethod(scope, "resolve", 1, NativePromise::resolve);
        constructor.defineConstructorMethod(scope, "reject", 1, NativePromise::reject);
        constructor.defineConstructorMethod(scope, "all", 1, NativePromise::all);
        constructor.defineConstructorMethod(scope, "allSettled", 1, NativePromise::allSettled);
        constructor.defineConstructorMethod(scope, "race", 1, NativePromise::race);
        constructor.defineConstructorMethod(scope, "any", 1, NativePromise::any);
        constructor.defineConstructorMethod(scope, "withResolvers", 0, NativePromise::withResolvers);
        constructor.defineConstructorMethod(scope, "try", 1, NativePromise::promiseTry);
        ScriptRuntimeES6.addSymbolSpecies(cx, scope, constructor);
        constructor.definePrototypeMethod(scope, "then", 2, NativePromise::doThen);
        constructor.definePrototypeMethod(scope, "catch", 1, NativePromise::doCatch);
        constructor.definePrototypeMethod(scope, "finally", 1, NativePromise::doFinally);
        constructor.definePrototypeProperty(SymbolKey.TO_STRING_TAG, (Object)"Promise", 3);
        if (sealed) {
            constructor.sealObject();
            ((ScriptableObject)constructor.getPrototypeProperty()).sealObject();
        }
        return constructor;
    }

    private static Scriptable constructor(Context cx, Scriptable scope, Object[] args) {
        Scriptable tcs;
        if (args.length < 1 || !(args[0] instanceof Callable)) {
            throw ScriptRuntime.typeErrorById("msg.function.expected", new Object[0]);
        }
        Callable executor = (Callable)args[0];
        NativePromise promise = new NativePromise();
        ResolvingFunctions resolving = new ResolvingFunctions(scope, promise);
        Scriptable thisObj = Undefined.SCRIPTABLE_UNDEFINED;
        if (!cx.isStrictMode() && (tcs = cx.topCallScope) != null) {
            thisObj = tcs;
        }
        try {
            executor.call(cx, scope, thisObj, new Object[]{resolving.resolve, resolving.reject});
        }
        catch (RhinoException re) {
            resolving.reject.call(cx, scope, thisObj, new Object[]{NativePromise.getErrorObject(cx, scope, re)});
        }
        return promise;
    }

    @Override
    public String getClassName() {
        return "Promise";
    }

    Object getResult() {
        return this.result;
    }

    private static Object resolve(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!ScriptRuntime.isObject(thisObj)) {
            throw ScriptRuntime.typeErrorById("msg.arg.not.object", ScriptRuntime.typeof(thisObj));
        }
        Object arg = args.length > 0 ? args[0] : Undefined.instance;
        return NativePromise.resolveInternal(cx, scope, thisObj, arg);
    }

    private static Object resolveInternal(Context cx, Scriptable scope, Object constructor, Object arg) {
        Object argConstructor;
        if (arg instanceof NativePromise && (argConstructor = ScriptRuntime.getObjectProp(arg, "constructor", cx, scope)) == constructor) {
            return arg;
        }
        Capability cap = new Capability(cx, scope, constructor);
        cap.resolve.call(cx, scope, Undefined.SCRIPTABLE_UNDEFINED, new Object[]{arg});
        return cap.promise;
    }

    private static Object reject(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!ScriptRuntime.isObject(thisObj)) {
            throw ScriptRuntime.typeErrorById("msg.arg.not.object", ScriptRuntime.typeof(thisObj));
        }
        Object arg = args.length > 0 ? args[0] : Undefined.instance;
        Capability cap = new Capability(cx, scope, thisObj);
        cap.reject.call(cx, scope, Undefined.SCRIPTABLE_UNDEFINED, new Object[]{arg});
        return cap.promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object doAll(Context cx, Scriptable scope, Scriptable thisObj, Object[] args, boolean failFast) {
        IteratorLikeIterable iterable;
        Capability cap = new Capability(cx, scope, thisObj);
        Object arg = args.length > 0 ? args[0] : Undefined.instance;
        try {
            Object maybeIterable = ScriptRuntime.callIterator(arg, cx, scope);
            iterable = new IteratorLikeIterable(cx, scope, maybeIterable);
        }
        catch (RhinoException re) {
            cap.reject.call(cx, scope, Undefined.SCRIPTABLE_UNDEFINED, new Object[]{NativePromise.getErrorObject(cx, scope, re)});
            return cap.promise;
        }
        IteratorLikeIterable.Itr iterator = iterable.iterator();
        PromiseAllResolver resolver = new PromiseAllResolver(iterator, thisObj, cap, failFast);
        try {
            Object object = resolver.resolve(cx, scope);
            if (!iterator.isDone()) {
                iterable.close();
            }
            return object;
        }
        catch (Throwable throwable) {
            try {
                if (!iterator.isDone()) {
                    iterable.close();
                }
                throw throwable;
            }
            catch (RhinoException re) {
                cap.reject.call(cx, scope, Undefined.SCRIPTABLE_UNDEFINED, new Object[]{NativePromise.getErrorObject(cx, scope, re)});
                return cap.promise;
            }
        }
    }

    private static Object all(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return NativePromise.doAll(cx, scope, thisObj, args, true);
    }

    private static Object allSettled(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return NativePromise.doAll(cx, scope, thisObj, args, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object race(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        IteratorLikeIterable iterable;
        Capability cap = new Capability(cx, scope, thisObj);
        Object arg = args.length > 0 ? args[0] : Undefined.instance;
        try {
            Object maybeIterable = ScriptRuntime.callIterator(arg, cx, scope);
            iterable = new IteratorLikeIterable(cx, scope, maybeIterable);
        }
        catch (RhinoException re) {
            cap.reject.call(cx, scope, Undefined.SCRIPTABLE_UNDEFINED, new Object[]{NativePromise.getErrorObject(cx, scope, re)});
            return cap.promise;
        }
        IteratorLikeIterable.Itr iterator = iterable.iterator();
        try {
            Object object = NativePromise.performRace(cx, scope, iterator, thisObj, cap);
            if (!iterator.isDone()) {
                iterable.close();
            }
            return object;
        }
        catch (Throwable throwable) {
            try {
                if (!iterator.isDone()) {
                    iterable.close();
                }
                throw throwable;
            }
            catch (RhinoException re) {
                cap.reject.call(cx, scope, Undefined.SCRIPTABLE_UNDEFINED, new Object[]{NativePromise.getErrorObject(cx, scope, re)});
                return cap.promise;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object performRace(Context cx, Scriptable scope, IteratorLikeIterable.Itr iterator, Scriptable thisObj, Capability cap) {
        ScriptRuntime.LookupResult resolve = ScriptRuntime.getPropAndThis(thisObj, "resolve", cx, scope);
        while (true) {
            boolean hasNext;
            Object nextVal = Undefined.instance;
            boolean nextOk = false;
            try {
                hasNext = iterator.hasNext();
                if (hasNext) {
                    nextVal = iterator.next();
                }
                nextOk = true;
            }
            finally {
                if (!nextOk) {
                    iterator.setDone(true);
                }
            }
            if (!hasNext) {
                return cap.promise;
            }
            Object nextPromise = resolve.call(cx, scope, new Object[]{nextVal});
            ScriptRuntime.LookupResult thenFunc = ScriptRuntime.getPropAndThis(nextPromise, "then", cx, scope);
            thenFunc.call(cx, scope, new Object[]{cap.resolve, cap.reject});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object any(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        IteratorLikeIterable iterable;
        Capability cap = new Capability(cx, scope, thisObj);
        Object arg = args.length > 0 ? args[0] : Undefined.instance;
        try {
            Object maybeIterable = ScriptRuntime.callIterator(arg, cx, scope);
            iterable = new IteratorLikeIterable(cx, scope, maybeIterable);
        }
        catch (RhinoException re) {
            cap.reject.call(cx, scope, Undefined.SCRIPTABLE_UNDEFINED, new Object[]{NativePromise.getErrorObject(cx, scope, re)});
            return cap.promise;
        }
        IteratorLikeIterable.Itr iterator = iterable.iterator();
        PromiseAnyRejector rejector = new PromiseAnyRejector(iterator, thisObj, cap);
        try {
            Object object = rejector.reject(cx, scope);
            if (!iterator.isDone()) {
                iterable.close();
            }
            return object;
        }
        catch (Throwable throwable) {
            try {
                if (!iterator.isDone()) {
                    iterable.close();
                }
                throw throwable;
            }
            catch (RhinoException re) {
                cap.reject.call(cx, scope, Undefined.SCRIPTABLE_UNDEFINED, new Object[]{NativePromise.getErrorObject(cx, scope, re)});
                return cap.promise;
            }
        }
    }

    private static Object withResolvers(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!ScriptRuntime.isObject(thisObj)) {
            throw ScriptRuntime.typeErrorById("msg.arg.not.object", ScriptRuntime.typeof(thisObj));
        }
        Capability cap = new Capability(cx, scope, thisObj);
        Scriptable result = cx.newObject(scope);
        result.put("promise", result, cap.promise);
        result.put("resolve", result, (Object)cap.resolve);
        result.put("reject", result, (Object)cap.reject);
        return result;
    }

    private static Object promiseTry(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!ScriptRuntime.isObject(thisObj)) {
            throw ScriptRuntime.typeErrorById("msg.arg.not.object", ScriptRuntime.typeof(thisObj));
        }
        if (args.length < 1 || !(args[0] instanceof Callable)) {
            throw ScriptRuntime.typeErrorById("msg.function.expected", new Object[0]);
        }
        Callable func = (Callable)args[0];
        Capability cap = new Capability(cx, scope, thisObj);
        Object[] funcArgs = new Object[args.length - 1];
        System.arraycopy(args, 1, funcArgs, 0, funcArgs.length);
        try {
            Object result = func.call(cx, scope, Undefined.SCRIPTABLE_UNDEFINED, funcArgs);
            cap.resolve.call(cx, scope, Undefined.SCRIPTABLE_UNDEFINED, new Object[]{result});
        }
        catch (RhinoException re) {
            cap.reject.call(cx, scope, Undefined.SCRIPTABLE_UNDEFINED, new Object[]{NativePromise.getErrorObject(cx, scope, re)});
        }
        return cap.promise;
    }

    private Object then(Context cx, Scriptable scope, Object[] args) {
        Constructable constructable = AbstractEcmaObjectOperations.speciesConstructor(cx, this, TopLevel.getBuiltinCtor(cx, ScriptableObject.getTopLevelScope(scope), TopLevel.Builtins.Promise));
        Capability capability = new Capability(cx, scope, constructable);
        Callable onFulfilled = null;
        if (args.length >= 1 && args[0] instanceof Callable) {
            onFulfilled = (Callable)args[0];
        }
        Callable onRejected = null;
        if (args.length >= 2 && args[1] instanceof Callable) {
            onRejected = (Callable)args[1];
        }
        Reaction fulfillReaction = new Reaction(capability, ReactionType.FULFILL, onFulfilled);
        Reaction rejectReaction = new Reaction(capability, ReactionType.REJECT, onRejected);
        if (this.state == State.PENDING) {
            this.fulfillReactions.add(fulfillReaction);
            this.rejectReactions.add(rejectReaction);
        } else if (this.state == State.FULFILLED) {
            cx.enqueueMicrotask(() -> fulfillReaction.invoke(cx, scope, this.result));
        } else {
            assert (this.state == State.REJECTED);
            this.markHandled(cx);
            cx.enqueueMicrotask(() -> rejectReaction.invoke(cx, scope, this.result));
        }
        return capability.promise;
    }

    private void markHandled(Context cx) {
        if (!this.handled) {
            cx.getUnhandledPromiseTracker().promiseHandled(this);
            this.handled = true;
        }
    }

    private static Object doThen(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        NativePromise self = LambdaConstructor.convertThisObject(thisObj, NativePromise.class);
        return self.then(cx, scope, args);
    }

    private static Object doCatch(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object arg = args.length > 0 ? args[0] : Undefined.instance;
        Scriptable coercedThis = ScriptRuntime.toObject(cx, scope, thisObj);
        ScriptRuntime.LookupResult thenFunc = ScriptRuntime.getPropAndThis(coercedThis, "then", cx, scope);
        return thenFunc.call(cx, scope, new Object[]{Undefined.instance, arg});
    }

    private static Object doFinally(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!ScriptRuntime.isObject(thisObj)) {
            throw ScriptRuntime.typeErrorById("msg.arg.not.object", ScriptRuntime.typeof(thisObj));
        }
        Scriptable onFinally = args.length > 0 ? args[0] : Undefined.SCRIPTABLE_UNDEFINED;
        Object thenFinally = onFinally;
        Object catchFinally = onFinally;
        Function ctor = TopLevel.getBuiltinCtor(cx, ScriptableObject.getTopLevelScope(scope), TopLevel.Builtins.Promise);
        Constructable constructor = AbstractEcmaObjectOperations.speciesConstructor(cx, thisObj, ctor);
        if (onFinally instanceof Callable) {
            Callable callableOnFinally = (Callable)thenFinally;
            thenFinally = NativePromise.makeThenFinally(scope, constructor, callableOnFinally);
            catchFinally = NativePromise.makeCatchFinally(scope, constructor, callableOnFinally);
        }
        ScriptRuntime.LookupResult thenFunc = ScriptRuntime.getPropAndThis(thisObj, "then", cx, scope);
        return thenFunc.call(cx, scope, new Object[]{thenFinally, catchFinally});
    }

    private static Callable makeThenFinally(Scriptable scope, Object constructor, Callable onFinally) {
        return new LambdaFunction(scope, 1, (cx, ls, thisObj, args) -> {
            Object value = args.length > 0 ? args[0] : Undefined.instance;
            LambdaFunction valueThunk = new LambdaFunction(scope, 0, (vc, vs, vt, va) -> value);
            Object result = onFinally.call(cx, ls, Undefined.SCRIPTABLE_UNDEFINED, ScriptRuntime.emptyArgs);
            Object promise = NativePromise.resolveInternal(cx, scope, constructor, result);
            ScriptRuntime.LookupResult thenFunc = ScriptRuntime.getPropAndThis(promise, "then", cx, scope);
            return thenFunc.call(cx, scope, new Object[]{valueThunk});
        });
    }

    private static Callable makeCatchFinally(Scriptable scope, Object constructor, Callable onFinally) {
        return new LambdaFunction(scope, 1, (cx, ls, thisObj, args) -> {
            Object reason = args.length > 0 ? args[0] : Undefined.instance;
            LambdaFunction reasonThrower = new LambdaFunction(scope, 0, (vc, vs, vt, va) -> {
                throw new JavaScriptException(reason, null, 0);
            });
            Object result = onFinally.call(cx, ls, Undefined.SCRIPTABLE_UNDEFINED, ScriptRuntime.emptyArgs);
            Object promise = NativePromise.resolveInternal(cx, scope, constructor, result);
            ScriptRuntime.LookupResult thenFunc = ScriptRuntime.getPropAndThis(promise, "then", cx, scope);
            return thenFunc.call(cx, scope, new Object[]{reasonThrower});
        });
    }

    private Object fulfillPromise(Context cx, Scriptable scope, Object value) {
        assert (this.state == State.PENDING);
        this.result = value;
        ArrayList<Reaction> reactions = this.fulfillReactions;
        this.fulfillReactions = new ArrayList();
        if (!this.rejectReactions.isEmpty()) {
            this.rejectReactions = new ArrayList();
        }
        this.state = State.FULFILLED;
        for (Reaction r : reactions) {
            cx.enqueueMicrotask(() -> r.invoke(cx, scope, value));
        }
        return Undefined.instance;
    }

    private Object rejectPromise(Context cx, Scriptable scope, Object reason) {
        assert (this.state == State.PENDING);
        this.result = reason;
        ArrayList<Reaction> reactions = this.rejectReactions;
        this.rejectReactions = new ArrayList();
        if (!this.fulfillReactions.isEmpty()) {
            this.fulfillReactions = new ArrayList();
        }
        this.state = State.REJECTED;
        cx.getUnhandledPromiseTracker().promiseRejected(this);
        for (Reaction r : reactions) {
            cx.enqueueMicrotask(() -> r.invoke(cx, scope, reason));
        }
        if (!reactions.isEmpty()) {
            this.markHandled(cx);
        }
        return Undefined.instance;
    }

    private void callThenable(Context cx, Scriptable scope, Object resolution, Callable thenFunc) {
        ResolvingFunctions resolving = new ResolvingFunctions(scope, this);
        Scriptable thisObj = resolution instanceof Scriptable ? (Scriptable)resolution : Undefined.SCRIPTABLE_UNDEFINED;
        try {
            thenFunc.call(cx, scope, thisObj, new Object[]{resolving.resolve, resolving.reject});
        }
        catch (RhinoException re) {
            resolving.reject.call(cx, scope, Undefined.SCRIPTABLE_UNDEFINED, new Object[]{NativePromise.getErrorObject(cx, scope, re)});
        }
    }

    private static Object getErrorObject(Context cx, Scriptable scope, RhinoException re) {
        if (re instanceof JavaScriptException) {
            return ((JavaScriptException)re).getValue();
        }
        TopLevel.NativeErrors constructor = TopLevel.NativeErrors.Error;
        if (re instanceof EcmaError) {
            EcmaError ee = (EcmaError)re;
            switch (ee.getName()) {
                case "EvalError": {
                    constructor = TopLevel.NativeErrors.EvalError;
                    break;
                }
                case "RangeError": {
                    constructor = TopLevel.NativeErrors.RangeError;
                    break;
                }
                case "ReferenceError": {
                    constructor = TopLevel.NativeErrors.ReferenceError;
                    break;
                }
                case "SyntaxError": {
                    constructor = TopLevel.NativeErrors.SyntaxError;
                    break;
                }
                case "TypeError": {
                    constructor = TopLevel.NativeErrors.TypeError;
                    break;
                }
                case "URIError": {
                    constructor = TopLevel.NativeErrors.URIError;
                    break;
                }
                case "InternalError": {
                    constructor = TopLevel.NativeErrors.InternalError;
                    break;
                }
                case "JavaException": {
                    constructor = TopLevel.NativeErrors.JavaException;
                    break;
                }
            }
        }
        return ScriptRuntime.newNativeError(cx, scope, constructor, new Object[]{re.getMessage()});
    }

    private static class PromiseElementResolver {
        private boolean alreadyCalled = false;
        private final int index;

        PromiseElementResolver(int ix) {
            this.index = ix;
        }

        Object resolve(Context cx, Scriptable scope, Object result, PromiseAllResolver resolver) {
            if (this.alreadyCalled) {
                return Undefined.instance;
            }
            this.alreadyCalled = true;
            resolver.values.set(this.index, result);
            if (--resolver.remainingElements == 0) {
                resolver.finalResolution(cx, scope);
            }
            return Undefined.instance;
        }

        Object reject(Context cx, Scriptable scope, Object result, PromiseAnyRejector rejector) {
            if (this.alreadyCalled) {
                return Undefined.instance;
            }
            this.alreadyCalled = true;
            rejector.errors.set(this.index, result);
            if (--rejector.remainingElements == 0) {
                rejector.finalRejection(cx, scope);
            }
            return Undefined.instance;
        }
    }

    private static class PromiseAnyRejector {
        private static final int MAX_PROMISES = 0x200000;
        final ArrayList<Object> errors = new ArrayList();
        int remainingElements = 1;
        IteratorLikeIterable.Itr iterator;
        Scriptable thisObj;
        Capability capability;

        PromiseAnyRejector(IteratorLikeIterable.Itr iter, Scriptable thisObj, Capability cap) {
            this.iterator = iter;
            this.thisObj = thisObj;
            this.capability = cap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object reject(Context topCx, Scriptable topScope) {
            int index = 0;
            ScriptRuntime.LookupResult resolve = ScriptRuntime.getPropAndThis(this.thisObj, "resolve", topCx, topScope);
            while (true) {
                boolean hasNext;
                if (index == 0x200000) {
                    throw ScriptRuntime.rangeErrorById("msg.promise.any.toobig", new Object[0]);
                }
                Object nextVal = Undefined.instance;
                boolean nextOk = false;
                try {
                    hasNext = this.iterator.hasNext();
                    if (hasNext) {
                        nextVal = this.iterator.next();
                    }
                    nextOk = true;
                }
                finally {
                    if (!nextOk) {
                        this.iterator.setDone(true);
                    }
                }
                if (!hasNext) {
                    if (--this.remainingElements == 0) {
                        Scriptable newArray = topCx.newArray(topScope, this.errors.toArray());
                        NativeError error = (NativeError)topCx.newObject(topScope, "AggregateError", new Object[]{newArray});
                        throw new JavaScriptException(error, null, 0);
                    }
                    return this.capability.promise;
                }
                this.errors.add(Undefined.instance);
                Object nextPromise = resolve.call(topCx, topScope, new Object[]{nextVal});
                PromiseElementResolver eltResolver = new PromiseElementResolver(index);
                LambdaFunction rejectFunc = new LambdaFunction(topScope, 1, (cx, scope, thisObj, args) -> {
                    Object value = args.length > 0 ? args[0] : Undefined.instance;
                    return eltResolver.reject(cx, scope, value, this);
                });
                ++this.remainingElements;
                ScriptRuntime.LookupResult thenFunc = ScriptRuntime.getPropAndThis(nextPromise, "then", topCx, topScope);
                thenFunc.call(topCx, topScope, new Object[]{this.capability.resolve, rejectFunc});
                ++index;
            }
        }

        void finalRejection(Context cx, Scriptable scope) {
            Scriptable newArray = cx.newArray(scope, this.errors.toArray());
            NativeError error = (NativeError)cx.newObject(scope, "AggregateError", new Object[]{newArray});
            this.capability.reject.call(cx, scope, Undefined.SCRIPTABLE_UNDEFINED, new Object[]{error});
        }
    }

    private static class PromiseAllResolver {
        private static final int MAX_PROMISES = 0x200000;
        final ArrayList<Object> values = new ArrayList();
        int remainingElements = 1;
        IteratorLikeIterable.Itr iterator;
        Scriptable thisObj;
        Capability capability;
        boolean failFast;

        PromiseAllResolver(IteratorLikeIterable.Itr iter, Scriptable thisObj, Capability cap, boolean failFast) {
            this.iterator = iter;
            this.thisObj = thisObj;
            this.capability = cap;
            this.failFast = failFast;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object resolve(Context topCx, Scriptable topScope) {
            int index = 0;
            ScriptRuntime.LookupResult resolve = ScriptRuntime.getPropAndThis(this.thisObj, "resolve", topCx, topScope);
            while (true) {
                boolean hasNext;
                if (index == 0x200000) {
                    throw ScriptRuntime.rangeErrorById("msg.promise.all.toobig", new Object[0]);
                }
                Object nextVal = Undefined.instance;
                boolean nextOk = false;
                try {
                    hasNext = this.iterator.hasNext();
                    if (hasNext) {
                        nextVal = this.iterator.next();
                    }
                    nextOk = true;
                }
                finally {
                    if (!nextOk) {
                        this.iterator.setDone(true);
                    }
                }
                if (!hasNext) {
                    if (--this.remainingElements == 0) {
                        this.finalResolution(topCx, topScope);
                    }
                    return this.capability.promise;
                }
                this.values.add(Undefined.instance);
                Object nextPromise = resolve.call(topCx, topScope, new Object[]{nextVal});
                PromiseElementResolver eltResolver = new PromiseElementResolver(index);
                LambdaFunction resolveFunc = new LambdaFunction(topScope, 1, (cx, scope, thisObj, args) -> {
                    Object value;
                    Object object = value = args.length > 0 ? args[0] : Undefined.instance;
                    if (!this.failFast) {
                        Scriptable elementResult = cx.newObject(scope);
                        elementResult.put("status", elementResult, (Object)"fulfilled");
                        elementResult.put("value", elementResult, value);
                        value = elementResult;
                    }
                    return eltResolver.resolve(cx, scope, value, this);
                });
                Callable rejectFunc = this.capability.reject;
                if (!this.failFast) {
                    LambdaFunction resolveSettledRejection = new LambdaFunction(topScope, 1, (cx, scope, thisObj, args) -> {
                        Scriptable result = cx.newObject(scope);
                        result.put("status", result, (Object)" rejected");
                        result.put("reason", result, args.length > 0 ? args[0] : Undefined.instance);
                        return eltResolver.resolve(cx, scope, result, this);
                    });
                    resolveSettledRejection.setStandardPropertyAttributes(3);
                    rejectFunc = resolveSettledRejection;
                }
                ++this.remainingElements;
                ScriptRuntime.LookupResult thenFunc = ScriptRuntime.getPropAndThis(nextPromise, "then", topCx, topScope);
                thenFunc.call(topCx, topScope, new Object[]{resolveFunc, rejectFunc});
                ++index;
            }
        }

        void finalResolution(Context cx, Scriptable scope) {
            Scriptable newArray = cx.newArray(scope, this.values.toArray());
            this.capability.resolve.call(cx, scope, Undefined.SCRIPTABLE_UNDEFINED, new Object[]{newArray});
        }
    }

    private static class Capability {
        Object promise;
        private Object rawResolve = Undefined.instance;
        Callable resolve;
        private Object rawReject = Undefined.instance;
        Callable reject;

        Capability(Context topCx, Scriptable topScope, Object pc) {
            if (!(pc instanceof Constructable)) {
                throw ScriptRuntime.typeErrorById("msg.constructor.expected", new Object[0]);
            }
            LambdaFunction executorFunc = new LambdaFunction(topScope, 2, (cx, scope, thisObj, args) -> this.executor(args));
            this.promise = ((Constructable)pc).construct(topCx, topScope, new Object[]{executorFunc});
            if (!(this.rawResolve instanceof Callable)) {
                throw ScriptRuntime.typeErrorById("msg.function.expected", new Object[0]);
            }
            this.resolve = (Callable)this.rawResolve;
            if (!(this.rawReject instanceof Callable)) {
                throw ScriptRuntime.typeErrorById("msg.function.expected", new Object[0]);
            }
            this.reject = (Callable)this.rawReject;
        }

        private Object executor(Object[] args) {
            if (!Undefined.isUndefined(this.rawResolve) || !Undefined.isUndefined(this.rawReject)) {
                throw ScriptRuntime.typeErrorById("msg.promise.capability.state", new Object[0]);
            }
            if (args.length > 0) {
                this.rawResolve = args[0];
            }
            if (args.length > 1) {
                this.rawReject = args[1];
            }
            return Undefined.instance;
        }
    }

    private static class Reaction {
        Capability capability;
        ReactionType reaction = ReactionType.REJECT;
        Callable handler;

        Reaction(Capability cap, ReactionType type, Callable handler) {
            this.capability = cap;
            this.reaction = type;
            this.handler = handler;
        }

        void invoke(Context cx, Scriptable scope, Object arg) {
            try {
                Object result = null;
                if (this.handler == null) {
                    switch (this.reaction) {
                        case FULFILL: {
                            result = arg;
                            break;
                        }
                        case REJECT: {
                            this.capability.reject.call(cx, scope, Undefined.SCRIPTABLE_UNDEFINED, new Object[]{arg});
                            return;
                        }
                    }
                } else {
                    result = this.handler.call(cx, scope, Undefined.SCRIPTABLE_UNDEFINED, new Object[]{arg});
                }
                this.capability.resolve.call(cx, scope, Undefined.SCRIPTABLE_UNDEFINED, new Object[]{result});
            }
            catch (RhinoException re) {
                this.capability.reject.call(cx, scope, Undefined.SCRIPTABLE_UNDEFINED, new Object[]{NativePromise.getErrorObject(cx, scope, re)});
            }
        }
    }

    private static class ResolvingFunctions {
        private boolean alreadyResolved = false;
        LambdaFunction resolve;
        LambdaFunction reject;

        ResolvingFunctions(Scriptable topScope, NativePromise promise) {
            this.resolve = new LambdaFunction(topScope, 1, (cx, scope, thisObj, args) -> this.resolve(cx, scope, promise, args.length > 0 ? args[0] : Undefined.instance));
            this.reject = new LambdaFunction(topScope, 1, (cx, scope, thisObj, args) -> this.reject(cx, scope, promise, args.length > 0 ? args[0] : Undefined.instance));
        }

        private Object reject(Context cx, Scriptable scope, NativePromise promise, Object reason) {
            if (this.alreadyResolved) {
                return Undefined.instance;
            }
            this.alreadyResolved = true;
            return promise.rejectPromise(cx, scope, reason);
        }

        private Object resolve(Context cx, Scriptable scope, NativePromise promise, Object resolution) {
            if (this.alreadyResolved) {
                return Undefined.instance;
            }
            this.alreadyResolved = true;
            if (resolution == promise) {
                Scriptable err = ScriptRuntime.newNativeError(cx, scope, TopLevel.NativeErrors.TypeError, new Object[]{"No promise self-resolution"});
                return promise.rejectPromise(cx, scope, err);
            }
            if (!ScriptRuntime.isObject(resolution)) {
                return promise.fulfillPromise(cx, scope, resolution);
            }
            Scriptable sresolution = ScriptableObject.ensureScriptable(resolution);
            Object thenObj = ScriptableObject.getProperty(sresolution, "then");
            if (!(thenObj instanceof Callable)) {
                return promise.fulfillPromise(cx, scope, resolution);
            }
            cx.enqueueMicrotask(() -> promise.callThenable(cx, scope, resolution, (Callable)thenObj));
            return Undefined.instance;
        }
    }

    static enum ReactionType {
        FULFILL,
        REJECT;

    }

    static enum State {
        PENDING,
        FULFILLED,
        REJECTED;

    }
}

