/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript;

import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.JSCode;
import org.htmlunit.corejs.javascript.JSDescriptor;
import org.htmlunit.corejs.javascript.Script;
import org.htmlunit.corejs.javascript.ScriptOrFn;
import org.htmlunit.corejs.javascript.ScriptRuntime;
import org.htmlunit.corejs.javascript.Scriptable;

public class JSScript
implements Script,
ScriptOrFn<JSScript> {
    private final JSDescriptor<JSScript> descriptor;
    private final Scriptable homeObject;

    public JSScript(JSDescriptor<JSScript> descriptor, Scriptable homeObject) {
        this.descriptor = descriptor;
        this.homeObject = homeObject;
    }

    @Override
    public JSDescriptor<JSScript> getDescriptor() {
        return this.descriptor;
    }

    @Override
    public Scriptable getHomeObject() {
        return this.homeObject;
    }

    JSCode<JSScript> getCode() {
        return this.descriptor.getCode();
    }

    @Override
    public Object exec(Context cx, Scriptable scope, Scriptable thisObj) {
        Object ret;
        if (!ScriptRuntime.hasTopCall(cx)) {
            ret = ScriptRuntime.doTopCall(this, cx, scope, thisObj, this.descriptor.isStrict());
            cx.processMicrotasks();
        } else {
            ret = this.descriptor.getCode().execute(cx, this, null, scope, thisObj, ScriptRuntime.emptyArgs);
        }
        return ret;
    }
}

