/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript;

import java.util.EnumSet;
import org.htmlunit.corejs.javascript.Arguments;
import org.htmlunit.corejs.javascript.BaseFunction;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.DecompilerFlag;
import org.htmlunit.corejs.javascript.JSCode;
import org.htmlunit.corejs.javascript.JSDescriptor;
import org.htmlunit.corejs.javascript.JSScript;
import org.htmlunit.corejs.javascript.ScriptOrFn;
import org.htmlunit.corejs.javascript.ScriptRuntime;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.Undefined;
import org.htmlunit.corejs.javascript.debug.DebuggableScript;

public class JSFunction
extends BaseFunction
implements ScriptOrFn<JSFunction> {
    private final JSDescriptor<JSFunction> descriptor;
    private final Scriptable lexicalThis;
    private final Scriptable homeObject;
    private Arguments arguments;

    public JSFunction(Context cx, Scriptable scope, JSDescriptor<JSFunction> descriptor, Scriptable lexicalThis, Scriptable homeObject) {
        this.descriptor = descriptor;
        this.lexicalThis = lexicalThis;
        this.homeObject = homeObject;
        ScriptRuntime.setFunctionProtoAndParent(this, cx, scope, descriptor.isES6Generator());
        if (!descriptor.isShorthand()) {
            this.setupDefaultPrototype(scope);
        }
    }

    @Override
    public Scriptable getDeclarationScope() {
        return this.getParentScope();
    }

    @Override
    public JSDescriptor<JSFunction> getDescriptor() {
        return this.descriptor;
    }

    @Override
    final String decompile(int indent, EnumSet<DecompilerFlag> flags) {
        return this.descriptor.getRawSource();
    }

    public boolean isShorthand() {
        return this.descriptor.isShorthand();
    }

    public boolean isStrict() {
        return this.descriptor.isStrict();
    }

    @Override
    public int getArity() {
        return this.descriptor.getArity();
    }

    public DebuggableScript getDebuggableView() {
        return null;
    }

    protected int getLanguageVersion() {
        return this.descriptor.getLanguageVersion();
    }

    @Override
    protected boolean hasPrototypeProperty() {
        return true;
    }

    @Override
    public int getLength() {
        int arity = this.descriptor.getArity();
        return arity;
    }

    protected int getParamAndVarCount() {
        return this.descriptor.getParamAndVarCount();
    }

    protected int getParamCount() {
        int count = this.descriptor.getParamCount();
        if (this.descriptor.hasRestArg()) {
            return count - 1;
        }
        return count;
    }

    protected boolean getParamOrVarConst(int index) {
        return this.descriptor.getParamOrVarConst(index);
    }

    protected String getParamOrVarName(int index) {
        return this.descriptor.getParamOrVarName(index);
    }

    public String getRawSource() {
        return this.descriptor.getRawSource();
    }

    @Override
    protected void createPrototypeProperty() {
        if (this.descriptor.hasPrototype()) {
            super.createPrototypeProperty();
        }
    }

    JSCode<JSFunction> getCode() {
        return this.descriptor.getCode();
    }

    JSCode<JSFunction> getConstructor() {
        return this.descriptor.getConstructor();
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!ScriptRuntime.hasTopCall(cx)) {
            return ScriptRuntime.doTopCall(this, cx, scope, thisObj, args, this.isStrict());
        }
        Scriptable realThis = this.descriptor.hasLexicalThis() ? this.lexicalThis : thisObj;
        return this.descriptor.getCode().execute(cx, this, Undefined.instance, scope, realThis, args);
    }

    @Override
    public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
        if (this.descriptor.getConstructor() == null) {
            throw ScriptRuntime.typeErrorById("msg.not.ctor", this.getFunctionName());
        }
        Scriptable thisObj = this.homeObject == null ? this.createObject(cx, scope) : null;
        Object res = this.descriptor.getConstructor().execute(cx, this, this, scope, thisObj, args);
        if (res instanceof Scriptable) {
            thisObj = (Scriptable)res;
        }
        return thisObj;
    }

    public boolean isScript() {
        return this.descriptor.isScript();
    }

    @Override
    protected boolean hasDefaultParameters() {
        return this.descriptor.hasDefaultParameters();
    }

    public boolean hasFunctionNamed(String name) {
        return this.descriptor.hasFunctionNamed(name);
    }

    @Override
    public String getFunctionName() {
        return this.descriptor.getName();
    }

    public Object resumeGenerator(Context cx, Scriptable scope, int operation, Object state, Object value) {
        return this.descriptor.getCode().resume(cx, this, state, scope, operation, value);
    }

    @Override
    public Scriptable getHomeObject() {
        return this.homeObject;
    }

    @Override
    public void setHomeObject(Scriptable homeObject) {
        throw new UnsupportedOperationException("Cannot set home object on JS function.");
    }

    public Scriptable getFunctionThis(Scriptable functionThis) {
        if (this.descriptor.hasLexicalThis()) {
            return this.lexicalThis;
        }
        return functionThis;
    }

    public static JSScript createScript(JSDescriptor<JSScript> desc, Scriptable homeObject, Object staticSecurityDomain) {
        assert (desc.getSecurityDomain() == staticSecurityDomain);
        assert (desc.isScript());
        return new JSScript(desc, homeObject);
    }

    public static JSFunction createFunction(Context cx, Scriptable scope, JSDescriptor<JSFunction> desc, Scriptable homeObject, Object staticSecurityDomain) {
        assert (desc.getSecurityDomain() == staticSecurityDomain);
        JSFunction f = new JSFunction(cx, scope, desc, null, homeObject);
        return f;
    }

    static JSFunction createFunction(Context cx, Scriptable scope, JSDescriptor<?> parent, int index, Scriptable homeObject) {
        DebuggableScript desc = parent.getFunction(index);
        JSFunction f = new JSFunction(cx, scope, (JSDescriptor<JSFunction>)desc, null, homeObject);
        return f;
    }

    void setArguments(Arguments arguments) {
        if (arguments == null) {
            this.arguments = null;
            return;
        }
        this.arguments = new Arguments(arguments){

            @Override
            public void put(int index, Scriptable start, Object value) {
            }

            @Override
            public void put(String name, Scriptable start, Object value) {
            }

            @Override
            public void delete(int index) {
            }

            @Override
            public void delete(String name) {
            }
        };
    }

    @Override
    public Object get(String name, Scriptable start) {
        if (start == this && "arguments".equals(name)) {
            return this.arguments;
        }
        return super.get(name, start);
    }
}

