/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.htmlunit.corejs.javascript.Callable;
import org.htmlunit.corejs.javascript.CompoundOperationMap;
import org.htmlunit.corejs.javascript.Constructable;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.IdFunctionObject;
import org.htmlunit.corejs.javascript.IteratorLikeIterable;
import org.htmlunit.corejs.javascript.LambdaConstructor;
import org.htmlunit.corejs.javascript.LambdaFunction;
import org.htmlunit.corejs.javascript.NativeArray;
import org.htmlunit.corejs.javascript.RegExpProxy;
import org.htmlunit.corejs.javascript.ScriptRuntime;
import org.htmlunit.corejs.javascript.ScriptRuntimeES6;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.corejs.javascript.Symbol;
import org.htmlunit.corejs.javascript.SymbolKey;
import org.htmlunit.corejs.javascript.Undefined;

public class AbstractEcmaObjectOperations {
    static boolean hasOwnProperty(Context cx, Object o, Object property) {
        boolean result;
        Scriptable obj = ScriptableObject.ensureScriptable(o);
        if (property instanceof Symbol) {
            result = ScriptableObject.ensureSymbolScriptable(o).has((Symbol)property, obj);
        } else {
            ScriptRuntime.StringIdOrIndex s = ScriptRuntime.toStringIdOrIndex(property);
            result = s.stringId == null ? obj.has(s.index, obj) : obj.has(s.stringId, obj);
        }
        return result;
    }

    static boolean testIntegrityLevel(Context cx, Object o, INTEGRITY_LEVEL level) {
        Object[] ids;
        ScriptableObject obj = ScriptableObject.ensureScriptableObject(o);
        if (obj.isExtensible()) {
            return false;
        }
        try (CompoundOperationMap map = obj.startCompoundOp(false);){
            ids = obj.getIds(map, true, true);
        }
        for (Object name : ids) {
            ScriptableObject desc = obj.getOwnPropertyDescriptor(cx, name);
            if (Boolean.TRUE.equals(desc.get("configurable"))) {
                return false;
            }
            if (level != INTEGRITY_LEVEL.FROZEN || !ScriptableObject.isDataDescriptor(desc) || !Boolean.TRUE.equals(desc.get("writable"))) continue;
            return false;
        }
        return true;
    }

    static boolean setIntegrityLevel(Context cx, Object o, INTEGRITY_LEVEL level) {
        Object[] ids;
        ScriptableObject obj = ScriptableObject.ensureScriptableObject(o);
        if (!obj.preventExtensions()) {
            return false;
        }
        try (CompoundOperationMap map = obj.startCompoundOp(false);){
            ids = obj.getIds(map, true, true);
        }
        for (Object key : ids) {
            ScriptableObject desc = obj.getOwnPropertyDescriptor(cx, key);
            if (level == INTEGRITY_LEVEL.SEALED) {
                if (!Boolean.TRUE.equals(desc.get("configurable"))) continue;
                desc.put("configurable", (Scriptable)desc, (Object)Boolean.FALSE);
                obj.defineOwnProperty(cx, key, desc, false);
                continue;
            }
            if (ScriptableObject.isDataDescriptor(desc) && Boolean.TRUE.equals(desc.get("writable"))) {
                desc.put("writable", (Scriptable)desc, (Object)Boolean.FALSE);
            }
            if (Boolean.TRUE.equals(desc.get("configurable"))) {
                desc.put("configurable", (Scriptable)desc, (Object)Boolean.FALSE);
            }
            obj.defineOwnProperty(cx, key, desc, false);
        }
        return true;
    }

    public static Constructable speciesConstructor(Context cx, Scriptable s, Constructable defaultConstructor) {
        Object constructor = ScriptableObject.getProperty(s, "constructor");
        if (constructor == Scriptable.NOT_FOUND || Undefined.isUndefined(constructor)) {
            return defaultConstructor;
        }
        if (!ScriptRuntime.isObject(constructor)) {
            throw ScriptRuntime.typeErrorById("msg.arg.not.object", ScriptRuntime.typeof(constructor));
        }
        Object species = ScriptableObject.getProperty((Scriptable)constructor, SymbolKey.SPECIES);
        if (species == Scriptable.NOT_FOUND || species == null || Undefined.isUndefined(species)) {
            return defaultConstructor;
        }
        if (!(species instanceof Constructable)) {
            throw ScriptRuntime.typeErrorById("msg.not.ctor", ScriptRuntime.typeof(species));
        }
        return (Constructable)species;
    }

    static void put(Context cx, Scriptable o, String p, Object v, boolean isThrow) {
        Scriptable base = ScriptableObject.getBase(o, p);
        if (base == null) {
            base = o;
        }
        if (base instanceof ScriptableObject) {
            if (((ScriptableObject)base).putOwnProperty(p, o, v, isThrow)) {
                return;
            }
            o.put(p, o, v);
        } else {
            base.put(p, o, v);
        }
    }

    static void put(Context cx, Scriptable o, int p, Object v, boolean isThrow) {
        Scriptable base = ScriptableObject.getBase(o, p);
        if (base == null) {
            base = o;
        }
        if (base instanceof ScriptableObject) {
            if (((ScriptableObject)base).putOwnProperty(p, o, v, isThrow)) {
                return;
            }
            o.put(p, o, v);
        } else {
            base.put(p, o, v);
        }
    }

    static void put(Context cx, Scriptable o, Symbol p, Object v, boolean isThrow) {
        Scriptable base = ScriptableObject.getBase(o, p);
        if (base == null) {
            base = o;
        }
        if (base instanceof ScriptableObject) {
            if (((ScriptableObject)base).putOwnProperty(p, o, v, isThrow)) {
                return;
            }
            ScriptableObject.ensureSymbolScriptable(o).put(p, o, v);
        } else {
            ScriptableObject.ensureSymbolScriptable(base).put(p, o, v);
        }
    }

    static Map<Object, List<Object>> groupBy(Context cx, Scriptable scope, IdFunctionObject f, Object items, Object callback, KEY_COERCION keyCoercion) {
        return AbstractEcmaObjectOperations.groupBy(cx, scope, f.getTag(), f.getFunctionName(), items, callback, keyCoercion);
    }

    static Map<Object, List<Object>> groupBy(Context cx, Scriptable scope, Object classTag, String functionName, Object items, Object callback, KEY_COERCION keyCoercion) {
        ScriptRuntimeES6.requireObjectCoercible(cx, items, classTag, functionName);
        if (!(callback instanceof Callable)) {
            throw ScriptRuntime.typeErrorById("msg.isnt.function", callback, ScriptRuntime.typeof(callback));
        }
        LinkedHashMap<Object, List<Object>> groups = new LinkedHashMap<Object, List<Object>>();
        Object iterator = ScriptRuntime.callIterator(items, cx, scope);
        try (IteratorLikeIterable it = new IteratorLikeIterable(cx, scope, iterator);){
            double i = 0.0;
            for (Object o : it) {
                if (i > 9.007199254740991E15) {
                    it.close();
                    throw ScriptRuntime.typeError("Too many values to iterate");
                }
                Object[] args = new Object[]{o, i};
                Object key = ((Callable)callback).call(cx, scope, Undefined.SCRIPTABLE_UNDEFINED, args);
                if (keyCoercion == KEY_COERCION.PROPERTY) {
                    if (!ScriptRuntime.isSymbol(key)) {
                        key = ScriptRuntime.toString(key);
                    }
                } else {
                    assert (keyCoercion == KEY_COERCION.COLLECTION);
                    if (key instanceof Number && ((Number)key).doubleValue() == ScriptRuntime.negativeZero) {
                        key = ScriptRuntime.zeroObj;
                    }
                }
                List group = groups.computeIfAbsent(key, k -> new ArrayList());
                group.add(o);
                i += 1.0;
            }
        }
        return groups;
    }

    static List<Object> createListFromArrayLike(Context cx, Scriptable o, Predicate<Object> elementTypesPredicate, String msg) {
        ScriptableObject obj = ScriptableObject.ensureScriptableObject(o);
        if (obj instanceof NativeArray) {
            Object[] arr;
            for (Object next : arr = ((NativeArray)obj).toArray()) {
                if (elementTypesPredicate.test(next)) continue;
                throw ScriptRuntime.typeError(msg);
            }
            return Arrays.asList(arr);
        }
        long len = AbstractEcmaObjectOperations.lengthOfArrayLike(cx, obj);
        ArrayList<Object> list = new ArrayList<Object>();
        for (long index = 0L; index < len; ++index) {
            Object next = ScriptableObject.getProperty((Scriptable)obj, (int)index);
            if (!elementTypesPredicate.test(next)) {
                throw ScriptRuntime.typeError(msg);
            }
            list.add(next);
        }
        return list;
    }

    public static long lengthOfArrayLike(Context cx, Scriptable o) {
        Object value = ScriptableObject.getProperty(o, "length");
        long len = ScriptRuntime.toLength(new Object[]{value}, 0);
        return len;
    }

    static boolean isCompatiblePropertyDescriptor(Context cx, boolean extensible, ScriptableObject desc, ScriptableObject current) {
        return AbstractEcmaObjectOperations.validateAndApplyPropertyDescriptor(cx, Undefined.SCRIPTABLE_UNDEFINED, Undefined.SCRIPTABLE_UNDEFINED, extensible, desc, current);
    }

    static boolean validateAndApplyPropertyDescriptor(Context cx, Scriptable o, Scriptable p, boolean extensible, ScriptableObject desc, ScriptableObject current) {
        if (Undefined.isUndefined(current)) {
            if (!extensible) {
                return false;
            }
            if (ScriptableObject.isGenericDescriptor(desc) || ScriptableObject.isDataDescriptor(desc)) {
                // empty if block
            }
            return true;
        }
        if (desc.getIds().length == 0) {
            return true;
        }
        if (Boolean.FALSE.equals(current.get("configurable"))) {
            if (Boolean.TRUE.equals(ScriptableObject.hasProperty((Scriptable)desc, "configurable")) && Boolean.TRUE.equals(desc.get("configurable"))) {
                return false;
            }
            if (Boolean.TRUE.equals(ScriptableObject.hasProperty((Scriptable)desc, "enumerable")) && !Objects.equals(desc.get("enumerable"), current.get("enumerable"))) {
                return false;
            }
        }
        if (ScriptableObject.isGenericDescriptor(desc)) {
            return true;
        }
        if (ScriptableObject.isDataDescriptor(current) != ScriptableObject.isDataDescriptor(desc)) {
            if (Boolean.FALSE.equals(current.get("configurable"))) {
                return false;
            }
            if (ScriptableObject.isDataDescriptor(current) && Boolean.FALSE.equals(current.get("configurable"))) {
                // empty if block
            }
        } else if (ScriptableObject.isDataDescriptor(current) && ScriptableObject.isDataDescriptor(desc)) {
            if (Boolean.FALSE.equals(current.get("configurable")) && Boolean.FALSE.equals(current.get("writable"))) {
                if (Boolean.TRUE.equals(ScriptableObject.hasProperty((Scriptable)desc, "writable")) && Boolean.TRUE.equals(desc.get("writable"))) {
                    return false;
                }
                return !Boolean.TRUE.equals(ScriptableObject.hasProperty((Scriptable)desc, "value")) || Objects.equals(desc.get("value"), current.get("value"));
            }
        } else if (Boolean.FALSE.equals(current.get("configurable"))) {
            if (Boolean.TRUE.equals(ScriptableObject.hasProperty((Scriptable)desc, "set")) && !Objects.equals(desc.get("set"), current.get("set"))) {
                return false;
            }
            return !Boolean.TRUE.equals(ScriptableObject.hasProperty((Scriptable)desc, "get")) || Objects.equals(desc.get("get"), current.get("get"));
        }
        return true;
    }

    public static boolean isConstructor(Context cx, Object argument) {
        if (argument instanceof LambdaConstructor) {
            return true;
        }
        if (argument instanceof LambdaFunction) {
            return false;
        }
        return argument instanceof Constructable;
    }

    static boolean isRegExp(Context cx, Scriptable scope, Object argument) {
        if (!ScriptRuntime.isObject(argument)) {
            return false;
        }
        Object matcher = ScriptRuntime.getObjectElem(argument, SymbolKey.MATCH, cx, scope);
        if (!Undefined.isUndefined(matcher)) {
            return ScriptRuntime.toBoolean(matcher);
        }
        RegExpProxy regExpProxy = ScriptRuntime.checkRegExpProxy(cx);
        return argument instanceof Scriptable && regExpProxy.isRegExp((Scriptable)argument);
    }

    static enum KEY_COERCION {
        PROPERTY,
        COLLECTION;

    }

    static enum INTEGRITY_LEVEL {
        FROZEN,
        SEALED;

    }
}

