/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript.typedarrays;

import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.LambdaConstructor;
import org.htmlunit.corejs.javascript.ScriptRuntime;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.corejs.javascript.SymbolKey;
import org.htmlunit.corejs.javascript.Undefined;
import org.htmlunit.corejs.javascript.typedarrays.ByteIo;
import org.htmlunit.corejs.javascript.typedarrays.Conversions;
import org.htmlunit.corejs.javascript.typedarrays.NativeArrayBuffer;
import org.htmlunit.corejs.javascript.typedarrays.NativeArrayBufferView;

public class NativeDataView
extends NativeArrayBufferView {
    private static final long serialVersionUID = 1427967607557438968L;
    public static final String CLASS_NAME = "DataView";

    public NativeDataView() {
    }

    public NativeDataView(NativeArrayBuffer ab, int offset, int length) {
        super(ab, offset, length);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    public static Object init(Context cx, Scriptable scope, boolean sealed) {
        LambdaConstructor constructor = new LambdaConstructor(scope, CLASS_NAME, 1, 2, NativeDataView::js_constructor);
        constructor.setPrototypePropertyAttributes(7);
        constructor.definePrototypeProperty(cx, "buffer", thisObj -> NativeDataView.realThis((Scriptable)thisObj).arrayBuffer, 3);
        constructor.definePrototypeProperty(cx, "byteLength", thisObj -> {
            NativeDataView self = NativeDataView.realThis(thisObj);
            if (self.isDataViewOutOfBounds()) {
                throw ScriptRuntime.typeErrorById("msg.dataview.bounds", new Object[0]);
            }
            return self.byteLength;
        }, 3);
        constructor.definePrototypeProperty(cx, "byteOffset", thisObj -> {
            NativeDataView self = NativeDataView.realThis(thisObj);
            if (self.isDataViewOutOfBounds()) {
                throw ScriptRuntime.typeErrorById("msg.dataview.bounds", new Object[0]);
            }
            return self.offset;
        }, 3);
        constructor.definePrototypeProperty(SymbolKey.TO_STRING_TAG, (Object)CLASS_NAME, 3);
        constructor.definePrototypeMethod(scope, "getFloat32", 1, (lcx, lscope, thisObj, args) -> NativeDataView.realThis(thisObj).js_getFloat(4, args), 2, 3);
        constructor.definePrototypeMethod(scope, "getFloat64", 1, (lcx, lscope, thisObj, args) -> NativeDataView.realThis(thisObj).js_getFloat(8, args), 2, 3);
        constructor.definePrototypeMethod(scope, "getInt8", 1, (lcx, lscope, thisObj, args) -> NativeDataView.realThis(thisObj).js_getInt(1, true, args), 2, 3);
        constructor.definePrototypeMethod(scope, "getInt16", 1, (lcx, lscope, thisObj, args) -> NativeDataView.realThis(thisObj).js_getInt(2, true, args), 2, 3);
        constructor.definePrototypeMethod(scope, "getInt32", 1, (lcx, lscope, thisObj, args) -> NativeDataView.realThis(thisObj).js_getInt(4, true, args), 2, 3);
        constructor.definePrototypeMethod(scope, "getUint8", 1, (lcx, lscope, thisObj, args) -> NativeDataView.realThis(thisObj).js_getInt(1, false, args), 2, 3);
        constructor.definePrototypeMethod(scope, "getUint16", 1, (lcx, lscope, thisObj, args) -> NativeDataView.realThis(thisObj).js_getInt(2, false, args), 2, 3);
        constructor.definePrototypeMethod(scope, "getUint32", 1, (lcx, lscope, thisObj, args) -> NativeDataView.realThis(thisObj).js_getInt(4, false, args), 2, 3);
        constructor.definePrototypeMethod(scope, "setFloat32", 2, (lcx, lscope, thisObj, args) -> {
            NativeDataView.realThis(thisObj).js_setFloat(4, args);
            return Undefined.instance;
        }, 2, 3);
        constructor.definePrototypeMethod(scope, "setFloat64", 2, (lcx, lscope, thisObj, args) -> {
            NativeDataView.realThis(thisObj).js_setFloat(8, args);
            return Undefined.instance;
        }, 2, 3);
        constructor.definePrototypeMethod(scope, "setInt8", 2, (lcx, lscope, thisObj, args) -> {
            NativeDataView.realThis(thisObj).js_setInt(1, true, args);
            return Undefined.instance;
        }, 2, 3);
        constructor.definePrototypeMethod(scope, "setInt16", 2, (lcx, lscope, thisObj, args) -> {
            NativeDataView.realThis(thisObj).js_setInt(2, true, args);
            return Undefined.instance;
        }, 2, 3);
        constructor.definePrototypeMethod(scope, "setInt32", 2, (lcx, lscope, thisObj, args) -> {
            NativeDataView.realThis(thisObj).js_setInt(4, true, args);
            return Undefined.instance;
        }, 2, 3);
        constructor.definePrototypeMethod(scope, "setUint8", 2, (lcx, lscope, thisObj, args) -> {
            NativeDataView.realThis(thisObj).js_setInt(1, false, args);
            return Undefined.instance;
        }, 2, 3);
        constructor.definePrototypeMethod(scope, "setUint16", 2, (lcx, lscope, thisObj, args) -> {
            NativeDataView.realThis(thisObj).js_setInt(2, false, args);
            return Undefined.instance;
        }, 2, 3);
        constructor.definePrototypeMethod(scope, "setUint32", 2, (lcx, lscope, thisObj, args) -> {
            NativeDataView.realThis(thisObj).js_setInt(4, false, args);
            return Undefined.instance;
        }, 2, 3);
        if (sealed) {
            constructor.sealObject();
            ((ScriptableObject)constructor.getPrototypeProperty()).sealObject();
        }
        return constructor;
    }

    private static NativeDataView realThis(Scriptable thisObj) {
        return LambdaConstructor.convertThisObject(thisObj, NativeDataView.class);
    }

    private static NativeDataView js_constructor(Context cx, Scriptable scope, Object[] args) {
        int len;
        if (!NativeDataView.isArg(args, 0) || !(args[0] instanceof NativeArrayBuffer)) {
            throw ScriptRuntime.constructError("TypeError", "Missing parameters");
        }
        NativeArrayBuffer ab = (NativeArrayBuffer)args[0];
        int pos = ScriptRuntime.toIndex(NativeDataView.isArg(args, 1) ? args[1] : Undefined.instance);
        if (ab.isDetached()) {
            throw ScriptRuntime.typeErrorById("msg.arraybuf.detached", new Object[0]);
        }
        int bufferByteLength = ab.getLength();
        if (pos > bufferByteLength) {
            throw ScriptRuntime.rangeErrorById("msg.dataview.offset.range", new Object[0]);
        }
        if (NativeDataView.isArg(args, 2)) {
            len = ScriptRuntime.toIndex(args[2]);
            if ((long)pos + (long)len > (long)bufferByteLength) {
                throw ScriptRuntime.rangeErrorById("msg.dataview.length.range", new Object[0]);
            }
        } else {
            len = bufferByteLength - pos;
        }
        if (ab.isDetached()) {
            throw ScriptRuntime.typeErrorById("msg.arraybuf.detached", new Object[0]);
        }
        bufferByteLength = ab.getLength();
        if (pos > bufferByteLength) {
            throw ScriptRuntime.rangeErrorById("msg.dataview.offset.range", new Object[0]);
        }
        if (NativeDataView.isArg(args, 2) && (long)pos + (long)len > (long)bufferByteLength) {
            throw ScriptRuntime.rangeErrorById("msg.dataview.length.range", new Object[0]);
        }
        return new NativeDataView(ab, pos, len);
    }

    private Object js_getInt(int bytes, boolean signed, Object[] args) {
        boolean littleEndian;
        int pos = ScriptRuntime.toIndex(NativeDataView.isArg(args, 0) ? args[0] : Undefined.instance);
        boolean bl = littleEndian = NativeDataView.isArg(args, 1) && bytes > 1 && ScriptRuntime.toBoolean(args[1]);
        if (this.isDataViewOutOfBounds()) {
            throw ScriptRuntime.typeErrorById("msg.dataview.bounds", new Object[0]);
        }
        int viewSize = this.byteLength;
        if ((long)pos + (long)bytes > (long)viewSize) {
            throw ScriptRuntime.rangeErrorById("msg.dataview.offset.range", new Object[0]);
        }
        switch (bytes) {
            case 1: {
                if (signed) {
                    return ByteIo.readInt8(this.arrayBuffer.buffer, this.offset + pos);
                }
                return ByteIo.readUint8(this.arrayBuffer.buffer, this.offset + pos);
            }
            case 2: {
                if (signed) {
                    return ByteIo.readInt16(this.arrayBuffer.buffer, this.offset + pos, littleEndian);
                }
                return ByteIo.readUint16(this.arrayBuffer.buffer, this.offset + pos, littleEndian);
            }
            case 4: {
                return signed ? ByteIo.readInt32(this.arrayBuffer.buffer, this.offset + pos, littleEndian) : ByteIo.readUint32(this.arrayBuffer.buffer, this.offset + pos, littleEndian);
            }
        }
        throw new AssertionError();
    }

    private Object js_getFloat(int bytes, Object[] args) {
        boolean littleEndian;
        int pos = ScriptRuntime.toIndex(NativeDataView.isArg(args, 0) ? args[0] : Undefined.instance);
        boolean bl = littleEndian = NativeDataView.isArg(args, 1) && bytes > 1 && ScriptRuntime.toBoolean(args[1]);
        if (this.isDataViewOutOfBounds()) {
            throw ScriptRuntime.typeErrorById("msg.dataview.bounds", new Object[0]);
        }
        int viewSize = this.byteLength;
        if ((long)pos + (long)bytes > (long)viewSize) {
            throw ScriptRuntime.rangeErrorById("msg.dataview.offset.range", new Object[0]);
        }
        switch (bytes) {
            case 4: {
                return ByteIo.readFloat32(this.arrayBuffer.buffer, this.offset + pos, littleEndian);
            }
            case 8: {
                return ByteIo.readFloat64(this.arrayBuffer.buffer, this.offset + pos, littleEndian);
            }
        }
        throw new AssertionError();
    }

    private void js_setInt(int bytes, boolean signed, Object[] args) {
        boolean littleEndian;
        int pos = ScriptRuntime.toIndex(NativeDataView.isArg(args, 0) ? args[0] : Undefined.instance);
        Double val = NativeDataView.isArg(args, 1) ? ScriptRuntime.toNumber(args[1]) : (double)ScriptRuntime.zeroObj.intValue();
        boolean bl = littleEndian = NativeDataView.isArg(args, 2) && bytes > 1 && ScriptRuntime.toBoolean(args[2]);
        if (this.isDataViewOutOfBounds()) {
            throw ScriptRuntime.typeErrorById("msg.dataview.bounds", new Object[0]);
        }
        int viewSize = this.byteLength;
        if ((long)pos + (long)bytes > (long)viewSize) {
            throw ScriptRuntime.rangeErrorById("msg.dataview.offset.range", new Object[0]);
        }
        switch (bytes) {
            case 1: {
                if (signed) {
                    int value = Conversions.toInt8(val);
                    if (pos + bytes > this.byteLength) {
                        throw ScriptRuntime.rangeErrorById("msg.dataview.offset.range", new Object[0]);
                    }
                    ByteIo.writeInt8(this.arrayBuffer.buffer, this.offset + pos, value);
                    break;
                }
                int value = Conversions.toUint8(val);
                if (pos + bytes > this.byteLength) {
                    throw ScriptRuntime.rangeErrorById("msg.dataview.offset.range", new Object[0]);
                }
                ByteIo.writeUint8(this.arrayBuffer.buffer, this.offset + pos, value);
                break;
            }
            case 2: {
                if (signed) {
                    int value = Conversions.toInt16(val);
                    if (pos + bytes > this.byteLength) {
                        throw ScriptRuntime.rangeErrorById("msg.dataview.offset.range", new Object[0]);
                    }
                    ByteIo.writeInt16(this.arrayBuffer.buffer, this.offset + pos, value, littleEndian);
                    break;
                }
                int value = Conversions.toUint16(val);
                if (pos + bytes > this.byteLength) {
                    throw ScriptRuntime.rangeErrorById("msg.dataview.offset.range", new Object[0]);
                }
                ByteIo.writeUint16(this.arrayBuffer.buffer, this.offset + pos, value, littleEndian);
                break;
            }
            case 4: {
                if (signed) {
                    int value = Conversions.toInt32(val);
                    if (pos + bytes > this.byteLength) {
                        throw ScriptRuntime.rangeErrorById("msg.dataview.offset.range", new Object[0]);
                    }
                    ByteIo.writeInt32(this.arrayBuffer.buffer, this.offset + pos, value, littleEndian);
                    break;
                }
                long value = Conversions.toUint32(val);
                if (pos + bytes > this.byteLength) {
                    throw ScriptRuntime.rangeErrorById("msg.dataview.offset.range", new Object[0]);
                }
                ByteIo.writeUint32(this.arrayBuffer.buffer, this.offset + pos, value, littleEndian);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    private void js_setFloat(int bytes, Object[] args) {
        boolean littleEndian;
        int pos = ScriptRuntime.toIndex(NativeDataView.isArg(args, 0) ? args[0] : Undefined.instance);
        double val = NativeDataView.isArg(args, 1) ? ScriptRuntime.toNumber(args[1]) : Double.NaN;
        boolean bl = littleEndian = NativeDataView.isArg(args, 2) && bytes > 1 && ScriptRuntime.toBoolean(args[2]);
        if (this.isDataViewOutOfBounds()) {
            throw ScriptRuntime.typeErrorById("msg.dataview.bounds", new Object[0]);
        }
        int viewSize = this.byteLength;
        if ((long)pos + (long)bytes > (long)viewSize) {
            throw ScriptRuntime.rangeErrorById("msg.dataview.offset.range", new Object[0]);
        }
        switch (bytes) {
            case 4: {
                ByteIo.writeFloat32(this.arrayBuffer.buffer, this.offset + pos, val, littleEndian);
                break;
            }
            case 8: {
                ByteIo.writeFloat64(this.arrayBuffer.buffer, this.offset + pos, val, littleEndian);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    public boolean isDataViewOutOfBounds() {
        if (this.arrayBuffer.isDetached()) {
            return true;
        }
        int bufferByteLength = this.arrayBuffer.getLength();
        int byteOffsetStart = this.offset;
        int byteOffsetEnd = this.offset + this.byteLength;
        return byteOffsetStart > bufferByteLength || byteOffsetEnd > bufferByteLength;
    }
}

