/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript.typedarrays;

import java.math.BigInteger;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.LambdaConstructor;
import org.htmlunit.corejs.javascript.ScriptRuntime;
import org.htmlunit.corejs.javascript.ScriptRuntimeES6;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.corejs.javascript.Undefined;
import org.htmlunit.corejs.javascript.typedarrays.ByteIo;
import org.htmlunit.corejs.javascript.typedarrays.NativeArrayBuffer;
import org.htmlunit.corejs.javascript.typedarrays.NativeBigIntArrayView;
import org.htmlunit.corejs.javascript.typedarrays.NativeFloat64Array;
import org.htmlunit.corejs.javascript.typedarrays.NativeTypedArrayView;

public class NativeBigInt64Array
extends NativeBigIntArrayView {
    private static final long serialVersionUID = -1255405650050639335L;
    private static final String CLASS_NAME = "BigInt64Array";
    private static final int BYTES_PER_ELEMENT = 8;

    public NativeBigInt64Array() {
    }

    public NativeBigInt64Array(NativeArrayBuffer ab, int off, int len) {
        super(ab, off, len, len * 8);
    }

    public NativeBigInt64Array(int len) {
        this(new NativeArrayBuffer((double)len * 8.0), 0, len);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    public static Object init(Context cx, Scriptable scope, boolean sealed) {
        LambdaConstructor constructor = new LambdaConstructor(scope, CLASS_NAME, 3, 2, (lcx, lscope, args) -> NativeTypedArrayView.js_constructor(lcx, lscope, args, NativeBigInt64Array::new, 8));
        constructor.setPrototypePropertyAttributes(7);
        NativeTypedArrayView.init(cx, scope, constructor, NativeBigInt64Array::realThis);
        constructor.defineProperty("BYTES_PER_ELEMENT", (Object)8, 7);
        constructor.definePrototypeProperty("BYTES_PER_ELEMENT", (Object)8, 7);
        ScriptRuntimeES6.addSymbolSpecies(cx, scope, constructor);
        if (sealed) {
            constructor.sealObject();
            ((ScriptableObject)constructor.getPrototypeProperty()).sealObject();
        }
        return constructor;
    }

    @Override
    public int getBytesPerElement() {
        return 8;
    }

    private static NativeFloat64Array realThis(Scriptable thisObj) {
        return LambdaConstructor.convertThisObject(thisObj, NativeFloat64Array.class);
    }

    @Override
    protected Object js_get(int index) {
        if (this.checkIndex(index)) {
            return Undefined.instance;
        }
        long base = ByteIo.readUint64Primitive(this.arrayBuffer.buffer, index * 8 + this.offset, NativeBigInt64Array.useLittleEndian());
        return BigInteger.valueOf(base);
    }

    @Override
    protected Object js_set(int index, Object c) {
        BigInteger val = ScriptRuntime.toBigInt(c);
        if (this.checkIndex(index)) {
            return Undefined.instance;
        }
        long base = val.longValue();
        ByteIo.writeUint64(this.arrayBuffer.buffer, index * 8 + this.offset, base, true);
        return null;
    }

    @Override
    public BigInteger get(int i) {
        if (this.checkIndex(i)) {
            throw new IndexOutOfBoundsException();
        }
        return (BigInteger)this.js_get(i);
    }

    @Override
    public BigInteger set(int i, BigInteger aByte) {
        if (this.checkIndex(i)) {
            throw new IndexOutOfBoundsException();
        }
        return (BigInteger)this.js_set(i, aByte);
    }
}

