/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript;

import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.ScriptRuntime;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.corejs.javascript.SymbolKey;

final class NativeMath
extends ScriptableObject {
    private static final long serialVersionUID = -8838847185801131569L;
    private static final String MATH_TAG = "Math";
    private static final double LOG2E = 1.4426950408889634;
    private static final Double Double32 = 32.0;

    static Object init(Context cx, Scriptable scope, boolean sealed) {
        NativeMath math = new NativeMath();
        math.setPrototype(NativeMath.getObjectPrototype(scope));
        math.setParentScope(scope);
        math.defineProperty("toSource", (Object)MATH_TAG, 7);
        math.defineProperty(scope, "abs", 1, NativeMath::abs, 2, 3);
        math.defineProperty(scope, "acos", 1, NativeMath::acos, 2, 3);
        math.defineProperty(scope, "acosh", 1, NativeMath::acosh, 2, 3);
        math.defineProperty(scope, "asin", 1, NativeMath::asin, 2, 3);
        math.defineProperty(scope, "asinh", 1, NativeMath::asinh, 2, 3);
        math.defineProperty(scope, "atan", 1, NativeMath::atan, 2, 3);
        math.defineProperty(scope, "atanh", 1, NativeMath::atanh, 2, 3);
        math.defineProperty(scope, "atan2", 2, NativeMath::atan2, 2, 3);
        math.defineProperty(scope, "cbrt", 1, NativeMath::cbrt, 2, 3);
        math.defineProperty(scope, "ceil", 1, NativeMath::ceil, 2, 3);
        math.defineProperty(scope, "clz32", 1, NativeMath::clz32, 2, 3);
        math.defineProperty(scope, "cos", 1, NativeMath::cos, 2, 3);
        math.defineProperty(scope, "cosh", 1, NativeMath::cosh, 2, 3);
        math.defineProperty(scope, "exp", 1, NativeMath::exp, 2, 3);
        math.defineProperty(scope, "expm1", 1, NativeMath::expm1, 2, 3);
        math.defineProperty(scope, "f16round", 1, NativeMath::f16round, 2, 3);
        math.defineProperty(scope, "floor", 1, NativeMath::floor, 2, 3);
        math.defineProperty(scope, "fround", 1, NativeMath::fround, 2, 3);
        math.defineProperty(scope, "hypot", 2, NativeMath::hypot, 2, 3);
        math.defineProperty(scope, "imul", 2, NativeMath::imul, 2, 3);
        math.defineProperty(scope, "log", 1, NativeMath::log, 2, 3);
        math.defineProperty(scope, "log1p", 1, NativeMath::log1p, 2, 3);
        math.defineProperty(scope, "log10", 1, NativeMath::log10, 2, 3);
        math.defineProperty(scope, "log2", 1, NativeMath::log2, 2, 3);
        math.defineProperty(scope, "max", 2, NativeMath::max, 2, 3);
        math.defineProperty(scope, "min", 2, NativeMath::min, 2, 3);
        math.defineProperty(scope, "pow", 2, NativeMath::pow, 2, 3);
        math.defineProperty(scope, "random", 0, NativeMath::random, 2, 3);
        math.defineProperty(scope, "round", 1, NativeMath::round, 2, 3);
        math.defineProperty(scope, "sign", 1, NativeMath::sign, 2, 3);
        math.defineProperty(scope, "sin", 1, NativeMath::sin, 2, 3);
        math.defineProperty(scope, "sinh", 1, NativeMath::sinh, 2, 3);
        math.defineProperty(scope, "sqrt", 1, NativeMath::sqrt, 2, 3);
        math.defineProperty(scope, "tan", 1, NativeMath::tan, 2, 3);
        math.defineProperty(scope, "tanh", 1, NativeMath::tanh, 2, 3);
        math.defineProperty(scope, "trunc", 1, NativeMath::trunc, 2, 3);
        math.defineProperty("E", (Object)Math.E, 7);
        math.defineProperty("PI", (Object)Math.PI, 7);
        math.defineProperty("LN10", (Object)2.302585092994046, 7);
        math.defineProperty("LN2", (Object)0.6931471805599453, 7);
        math.defineProperty("LOG2E", (Object)1.4426950408889634, 7);
        math.defineProperty("LOG10E", (Object)0.4342944819032518, 7);
        math.defineProperty("SQRT1_2", (Object)0.7071067811865476, 7);
        math.defineProperty("SQRT2", (Object)1.4142135623730951, 7);
        math.defineProperty(SymbolKey.TO_STRING_TAG, (Object)MATH_TAG, 3);
        if (sealed) {
            math.sealObject();
        }
        return math;
    }

    private NativeMath() {
    }

    @Override
    public String getClassName() {
        return MATH_TAG;
    }

    private static Object abs(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        double x = ScriptRuntime.toNumber(args, 0);
        x = x == 0.0 ? 0.0 : (x < 0.0 ? -x : x);
        return ScriptRuntime.wrapNumber(x);
    }

    private static Object acos(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        double x = ScriptRuntime.toNumber(args, 0);
        x = !Double.isNaN(x) && -1.0 <= x && x <= 1.0 ? Math.acos(x) : Double.NaN;
        return ScriptRuntime.wrapNumber(x);
    }

    private static Object acosh(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        double x = ScriptRuntime.toNumber(args, 0);
        if (!Double.isNaN(x)) {
            return Math.log(x + Math.sqrt(x * x - 1.0));
        }
        return ScriptRuntime.NaNobj;
    }

    private static Object asin(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        double x = ScriptRuntime.toNumber(args, 0);
        x = !Double.isNaN(x) && -1.0 <= x && x <= 1.0 ? Math.asin(x) : Double.NaN;
        return ScriptRuntime.wrapNumber(x);
    }

    private static Object asinh(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        double x = ScriptRuntime.toNumber(args, 0);
        if (Double.isInfinite(x)) {
            return x;
        }
        if (!Double.isNaN(x)) {
            if (x == 0.0) {
                if (1.0 / x > 0.0) {
                    return ScriptRuntime.zeroObj;
                }
                return ScriptRuntime.negativeZeroObj;
            }
            return Math.log(x + Math.sqrt(x * x + 1.0));
        }
        return ScriptRuntime.NaNobj;
    }

    private static Object atan(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        double x = ScriptRuntime.toNumber(args, 0);
        x = Math.atan(x);
        return ScriptRuntime.wrapNumber(x);
    }

    private static Object atanh(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        double x = ScriptRuntime.toNumber(args, 0);
        if (!Double.isNaN(x) && -1.0 <= x && x <= 1.0) {
            if (x == 0.0) {
                if (1.0 / x > 0.0) {
                    return ScriptRuntime.zeroObj;
                }
                return ScriptRuntime.negativeZeroObj;
            }
            return 0.5 * Math.log((1.0 + x) / (1.0 - x));
        }
        return ScriptRuntime.NaNobj;
    }

    private static Object atan2(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        double x = ScriptRuntime.toNumber(args, 0);
        x = Math.atan2(x, ScriptRuntime.toNumber(args, 1));
        return ScriptRuntime.wrapNumber(x);
    }

    private static Object cbrt(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        double x = ScriptRuntime.toNumber(args, 0);
        x = Math.cbrt(x);
        return ScriptRuntime.wrapNumber(x);
    }

    private static Object ceil(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        double x = ScriptRuntime.toNumber(args, 0);
        x = Math.ceil(x);
        return ScriptRuntime.wrapNumber(x);
    }

    private static Object clz32(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        double x = ScriptRuntime.toNumber(args, 0);
        if (x == 0.0 || Double.isNaN(x) || Double.isInfinite(x)) {
            return Double32;
        }
        long n = ScriptRuntime.toUint32(x);
        if (n == 0L) {
            return Double32;
        }
        int place = 0;
        if ((n & 0xFFFFFFFFFFFF0000L) != 0L) {
            place += 16;
            n >>>= 16;
        }
        if ((n & 0xFF00L) != 0L) {
            place += 8;
            n >>>= 8;
        }
        if ((n & 0xF0L) != 0L) {
            place += 4;
            n >>>= 4;
        }
        if ((n & 0xCL) != 0L) {
            place += 2;
            n >>>= 2;
        }
        if ((n & 2L) != 0L) {
            ++place;
            n >>>= 1;
        }
        if ((n & 1L) != 0L) {
            ++place;
        }
        return (double)(32 - place);
    }

    private static Object cos(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        double x = ScriptRuntime.toNumber(args, 0);
        x = Double.isInfinite(x) ? Double.NaN : Math.cos(x);
        return ScriptRuntime.wrapNumber(x);
    }

    private static Object cosh(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        double x = ScriptRuntime.toNumber(args, 0);
        x = Math.cosh(x);
        return ScriptRuntime.wrapNumber(x);
    }

    private static Object exp(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        double x = ScriptRuntime.toNumber(args, 0);
        x = x == Double.POSITIVE_INFINITY ? x : (x == Double.NEGATIVE_INFINITY ? 0.0 : Math.exp(x));
        return ScriptRuntime.wrapNumber(x);
    }

    private static Object expm1(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        double x = ScriptRuntime.toNumber(args, 0);
        x = Math.expm1(x);
        return ScriptRuntime.wrapNumber(x);
    }

    private static Object floor(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        double x = ScriptRuntime.toNumber(args, 0);
        x = Math.floor(x);
        return ScriptRuntime.wrapNumber(x);
    }

    private static Object f16round(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (args.length == 0) {
            return ScriptRuntime.NaNobj;
        }
        double x = ScriptRuntime.toNumber(args[0]);
        if (Double.isNaN(x)) {
            return ScriptRuntime.NaNobj;
        }
        if (x == 0.0) {
            return ScriptRuntime.wrapNumber(x);
        }
        if (Double.isInfinite(x)) {
            return ScriptRuntime.wrapNumber(x);
        }
        long bits = Double.doubleToLongBits(x);
        int sign = (int)(bits >>> 63);
        int exponent = (int)(bits >>> 52 & 0x7FFL);
        long mantissa = bits & 0xFFFFFFFFFFFFFL;
        if ((exponent = exponent - 1023 + 15) >= 31) {
            return ScriptRuntime.wrapNumber(sign != 0 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
        }
        if (exponent < 0) {
            return NativeMath.handleSubnormalF16(sign, exponent, mantissa);
        }
        return NativeMath.handleNormalF16(sign, exponent, mantissa);
    }

    private static Object handleSubnormalF16(int sign, int exponent, long mantissa) {
        if (exponent < -10) {
            return ScriptRuntime.wrapNumber(sign != 0 ? -0.0 : 0.0);
        }
        if (exponent == -10 && mantissa == 0L) {
            return ScriptRuntime.wrapNumber(sign != 0 ? -0.0 : 0.0);
        }
        if (exponent == -10 && mantissa > 0L) {
            double smallestSubnormal = 5.960464477539063E-8;
            return ScriptRuntime.wrapNumber(sign != 0 ? -smallestSubnormal : smallestSubnormal);
        }
        int totalShift = 42 + (1 - exponent);
        long roundBit = (mantissa |= 0x10000000000000L) >> totalShift - 1 & 1L;
        long stickyBits = mantissa & (1L << totalShift - 1) - 1L;
        if (roundBit == 1L && (stickyBits != 0L || ((mantissa >>>= totalShift) & 1L) == 1L)) {
            ++mantissa;
        }
        if (mantissa == 0L) {
            return ScriptRuntime.wrapNumber(sign != 0 ? -0.0 : 0.0);
        }
        if (mantissa >= 1024L) {
            return ScriptRuntime.wrapNumber(sign != 0 ? -6.103515625E-5 : 6.103515625E-5);
        }
        double value = Math.scalb((double)mantissa / 1024.0, -14);
        return ScriptRuntime.wrapNumber(sign != 0 ? -value : value);
    }

    private static Object handleNormalF16(int sign, int exponent, long mantissa) {
        long fullMantissa = mantissa | 0x10000000000000L;
        long roundBit = fullMantissa >> 41 & 1L;
        long stickyBits = fullMantissa & 0x1FFFFFFFFFFL;
        fullMantissa >>>= 42;
        if (exponent == 0) {
            if (fullMantissa == 2046L) {
                return NativeMath.reconstructSubnormalF16(sign, 1023L);
            }
            if (fullMantissa == 2047L && roundBit == 0L && stickyBits == 0L) {
                return NativeMath.reconstructNormalF16(sign, 1, 0L);
            }
        }
        mantissa = fullMantissa & 0x3FFL;
        if (roundBit == 1L && (stickyBits != 0L || (mantissa & 1L) == 1L)) {
            ++mantissa;
        }
        if (mantissa >= 1024L) {
            mantissa = 0L;
            if (++exponent >= 31) {
                return ScriptRuntime.wrapNumber(sign != 0 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
            }
        }
        if (exponent == 0) {
            return NativeMath.reconstructSubnormalF16(sign, mantissa);
        }
        return NativeMath.reconstructNormalF16(sign, exponent, mantissa);
    }

    private static Object reconstructSubnormalF16(int sign, long mantissa) {
        if (mantissa == 0L) {
            return ScriptRuntime.wrapNumber(sign != 0 ? -0.0 : 0.0);
        }
        double value = Math.scalb((double)mantissa / 1024.0, -14);
        return ScriptRuntime.wrapNumber(sign != 0 ? -value : value);
    }

    private static Object reconstructNormalF16(int sign, int exponent, long mantissa) {
        long resultBits = (long)sign << 63 | (long)(exponent + 1023 - 15) << 52 | mantissa << 42;
        return ScriptRuntime.wrapNumber(Double.longBitsToDouble(resultBits));
    }

    private static Object fround(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        double x = ScriptRuntime.toNumber(args, 0);
        float fx = (float)x;
        return ScriptRuntime.wrapNumber(fx);
    }

    private static Object hypot(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (args == null) {
            return 0.0;
        }
        double y = 0.0;
        boolean hasNaN = false;
        boolean hasInfinity = false;
        for (Object o : args) {
            double d = ScriptRuntime.toNumber(o);
            if (Double.isNaN(d)) {
                hasNaN = true;
                continue;
            }
            if (Double.isInfinite(d)) {
                hasInfinity = true;
                continue;
            }
            y += d * d;
        }
        if (hasInfinity) {
            return Double.POSITIVE_INFINITY;
        }
        if (hasNaN) {
            return Double.NaN;
        }
        return Math.sqrt(y);
    }

    private static Object imul(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (args == null) {
            return 0;
        }
        int x = ScriptRuntime.toInt32(args, 0);
        int y = ScriptRuntime.toInt32(args, 1);
        return ScriptRuntime.wrapNumber(x * y);
    }

    private static Object log(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        double x = ScriptRuntime.toNumber(args, 0);
        x = x < 0.0 ? Double.NaN : Math.log(x);
        return ScriptRuntime.wrapNumber(x);
    }

    private static Object log1p(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        double x = ScriptRuntime.toNumber(args, 0);
        x = Math.log1p(x);
        return ScriptRuntime.wrapNumber(x);
    }

    private static Object log10(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        double x = ScriptRuntime.toNumber(args, 0);
        x = Math.log10(x);
        return ScriptRuntime.wrapNumber(x);
    }

    private static Object log2(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        double x = ScriptRuntime.toNumber(args, 0);
        x = x < 0.0 ? Double.NaN : Math.log(x) * 1.4426950408889634;
        return ScriptRuntime.wrapNumber(x);
    }

    private static Object max(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        double x = Double.NEGATIVE_INFINITY;
        for (int i = 0; i != args.length; ++i) {
            double d = ScriptRuntime.toNumber(args[i]);
            x = Math.max(x, d);
        }
        return ScriptRuntime.wrapNumber(x);
    }

    private static Object min(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        double x = Double.POSITIVE_INFINITY;
        for (int i = 0; i != args.length; ++i) {
            double d = ScriptRuntime.toNumber(args[i]);
            x = Math.min(x, d);
        }
        return ScriptRuntime.wrapNumber(x);
    }

    private static Object pow(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        double result;
        double x = ScriptRuntime.toNumber(args, 0);
        double y = ScriptRuntime.toNumber(args, 1);
        if (Double.isNaN(y)) {
            result = y;
        } else if (y == 0.0) {
            result = 1.0;
        } else if (x == 0.0) {
            long y_long;
            result = 1.0 / x > 0.0 ? (y > 0.0 ? 0.0 : Double.POSITIVE_INFINITY) : ((double)(y_long = (long)y) == y && (y_long & 1L) != 0L ? (y > 0.0 ? -0.0 : Double.NEGATIVE_INFINITY) : (y > 0.0 ? 0.0 : Double.POSITIVE_INFINITY));
        } else {
            result = Math.pow(x, y);
            if (Double.isNaN(result)) {
                if (y == Double.POSITIVE_INFINITY) {
                    if (x < -1.0 || 1.0 < x) {
                        result = Double.POSITIVE_INFINITY;
                    } else if (-1.0 < x && x < 1.0) {
                        result = 0.0;
                    }
                } else if (y == Double.NEGATIVE_INFINITY) {
                    if (x < -1.0 || 1.0 < x) {
                        result = 0.0;
                    } else if (-1.0 < x && x < 1.0) {
                        result = Double.POSITIVE_INFINITY;
                    }
                } else if (x == Double.POSITIVE_INFINITY) {
                    result = y > 0.0 ? Double.POSITIVE_INFINITY : 0.0;
                } else if (x == Double.NEGATIVE_INFINITY) {
                    long y_long = (long)y;
                    result = (double)y_long == y && (y_long & 1L) != 0L ? (y > 0.0 ? Double.NEGATIVE_INFINITY : -0.0) : (y > 0.0 ? Double.POSITIVE_INFINITY : 0.0);
                }
            }
        }
        return ScriptRuntime.wrapNumber(result);
    }

    private static Object random(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return ScriptRuntime.wrapNumber(Math.random());
    }

    private static Object round(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        double x = ScriptRuntime.toNumber(args, 0);
        if (!Double.isNaN(x) && !Double.isInfinite(x)) {
            long l = Math.round(x);
            if (l != 0L) {
                x = l;
            } else if (x < 0.0) {
                x = ScriptRuntime.negativeZero;
            } else if (x != 0.0) {
                x = 0.0;
            }
        }
        return ScriptRuntime.wrapNumber(x);
    }

    private static Object sign(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        double x = ScriptRuntime.toNumber(args, 0);
        if (!Double.isNaN(x)) {
            if (x == 0.0) {
                if (1.0 / x > 0.0) {
                    return ScriptRuntime.zeroObj;
                }
                return ScriptRuntime.negativeZeroObj;
            }
            return Math.signum(x);
        }
        return ScriptRuntime.NaNobj;
    }

    private static Object sin(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        double x = ScriptRuntime.toNumber(args, 0);
        x = Double.isInfinite(x) ? Double.NaN : Math.sin(x);
        return ScriptRuntime.wrapNumber(x);
    }

    private static Object sinh(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        double x = ScriptRuntime.toNumber(args, 0);
        x = Math.sinh(x);
        return ScriptRuntime.wrapNumber(x);
    }

    private static Object sqrt(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        double x = ScriptRuntime.toNumber(args, 0);
        x = Math.sqrt(x);
        return ScriptRuntime.wrapNumber(x);
    }

    private static Object tan(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        double x = ScriptRuntime.toNumber(args, 0);
        x = Math.tan(x);
        return ScriptRuntime.wrapNumber(x);
    }

    private static Object tanh(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        double x = ScriptRuntime.toNumber(args, 0);
        x = Math.tanh(x);
        return ScriptRuntime.wrapNumber(x);
    }

    private static Object trunc(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        double x = ScriptRuntime.toNumber(args, 0);
        x = x < 0.0 ? Math.ceil(x) : Math.floor(x);
        return ScriptRuntime.wrapNumber(x);
    }
}

