/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript;

import java.lang.reflect.Method;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.htmlunit.corejs.javascript.BaseFunction;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.DecompilerFlag;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.JavaMembers;
import org.htmlunit.corejs.javascript.Kit;
import org.htmlunit.corejs.javascript.MemberBox;
import org.htmlunit.corejs.javascript.NativeJavaObject;
import org.htmlunit.corejs.javascript.ResolvedOverload;
import org.htmlunit.corejs.javascript.ScriptRuntime;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.Undefined;
import org.htmlunit.corejs.javascript.Wrapper;
import org.htmlunit.corejs.javascript.lc.type.TypeInfo;
import org.htmlunit.corejs.javascript.lc.type.TypeInfoFactory;

public class NativeJavaMethod
extends BaseFunction {
    private static final long serialVersionUID = -3440381785576412928L;
    private static final int PREFERENCE_EQUAL = 0;
    private static final int PREFERENCE_FIRST_ARG = 1;
    private static final int PREFERENCE_SECOND_ARG = 2;
    private static final int PREFERENCE_AMBIGUOUS = 3;
    private static final boolean debug = false;
    MemberBox[] methods;
    private String functionName;
    private final transient CopyOnWriteArrayList<ResolvedOverload> overloadCache = new CopyOnWriteArrayList();

    NativeJavaMethod(MemberBox[] methods) {
        this.functionName = methods[0].getName();
        this.methods = methods;
    }

    NativeJavaMethod(MemberBox[] methods, String name) {
        this.functionName = name;
        this.methods = methods;
    }

    NativeJavaMethod(MemberBox method, String name) {
        this.functionName = name;
        this.methods = new MemberBox[]{method};
    }

    @Deprecated
    public NativeJavaMethod(Method method, String name) {
        this(new MemberBox(method, TypeInfoFactory.GLOBAL), name);
    }

    @Override
    public String getFunctionName() {
        return this.functionName;
    }

    static String scriptSignature(Object[] values) {
        StringBuilder sig = new StringBuilder();
        for (int i = 0; i != values.length; ++i) {
            String s;
            Object value = values[i];
            if (value == null) {
                s = "null";
            } else if (value instanceof Boolean) {
                s = "boolean";
            } else if (value instanceof String) {
                s = "string";
            } else if (value instanceof Number) {
                s = "number";
            } else if (value instanceof Scriptable) {
                if (value instanceof Undefined) {
                    s = "undefined";
                } else if (value instanceof Wrapper) {
                    Object wrapped = ((Wrapper)value).unwrap();
                    s = wrapped.getClass().getName();
                } else {
                    s = value instanceof Function ? "function" : "object";
                }
            } else {
                s = JavaMembers.javaSignature(value.getClass());
            }
            if (i != 0) {
                sig.append(',');
            }
            sig.append(s);
        }
        return sig.toString();
    }

    @Override
    String decompile(int indent, EnumSet<DecompilerFlag> flags) {
        StringBuilder sb = new StringBuilder();
        boolean justbody = flags.contains((Object)DecompilerFlag.ONLY_BODY);
        if (!justbody) {
            sb.append("function ");
            sb.append(this.getFunctionName());
            sb.append("() {");
        }
        sb.append("/*\n");
        sb.append(this.toString());
        sb.append(justbody ? "*/\n" : "*/}\n");
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int N = this.methods.length;
        for (int i = 0; i != N; ++i) {
            if (this.methods[i].isMethod()) {
                Method method = this.methods[i].method();
                sb.append(JavaMembers.javaSignature(method.getReturnType()));
                sb.append(' ');
                sb.append(method.getName());
            } else {
                sb.append(this.methods[i].getName());
            }
            sb.append(JavaMembers.liveConnectSignature(this.methods[i].getArgTypes()));
            sb.append('\n');
        }
        return sb.toString();
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object javaObject;
        if (this.methods.length == 0) {
            throw new RuntimeException("No methods defined for call");
        }
        int index = this.findCachedFunction(cx, args);
        if (index < 0) {
            Class<?> c = this.methods[0].method().getDeclaringClass();
            String sig = c.getName() + '.' + this.getFunctionName() + '(' + NativeJavaMethod.scriptSignature(args) + ')';
            throw Context.reportRuntimeErrorById("msg.java.no_such_method", sig);
        }
        MemberBox meth = this.methods[index];
        args = meth.wrapArgsInternal(args);
        if (meth.isStatic()) {
            javaObject = null;
        } else {
            Scriptable o = thisObj;
            Class<?> c = meth.getDeclaringClass();
            while (true) {
                if (o == null) {
                    throw Context.reportRuntimeErrorById("msg.nonjava.method", this.getFunctionName(), ScriptRuntime.toString(thisObj), c.getName());
                }
                if (o instanceof Wrapper && c.isInstance(javaObject = ((Wrapper)((Object)o)).unwrap())) break;
                o = o.getPrototype();
            }
        }
        Object returnValue = meth.invoke(javaObject, args);
        Class<?> returnType = meth.method().getReturnType();
        if (returnType == Void.TYPE) {
            return Undefined.instance;
        }
        Object wrapped = cx.getWrapFactory().wrap(cx, scope, returnValue, returnType);
        return wrapped;
    }

    int findCachedFunction(Context cx, Object[] args) {
        if (this.methods.length > 1) {
            for (ResolvedOverload ovl : this.overloadCache) {
                if (!ovl.matches(args)) continue;
                return ovl.index;
            }
            int index = NativeJavaMethod.findFunction(cx, this.methods, args);
            if (this.overloadCache.size() < this.methods.length * 2) {
                ResolvedOverload ovl;
                ovl = new ResolvedOverload(args, index);
                this.overloadCache.addIfAbsent(ovl);
            }
            return index;
        }
        return NativeJavaMethod.findFunction(cx, this.methods, args);
    }

    static int findFunction(Context cx, MemberBox[] methodsOrCtors, Object[] args) {
        if (methodsOrCtors.length == 0) {
            return -1;
        }
        if (methodsOrCtors.length == 1) {
            if (NativeJavaMethod.failFastConversionWeights(args, methodsOrCtors[0]) == null) {
                return -1;
            }
            return 0;
        }
        int firstBestFit = -1;
        int[] firstBestFitWeights = null;
        int[] extraBestFits = null;
        Object extraBestFitWeights = null;
        int extraBestFitsCount = 0;
        block0: for (int i = 0; i < methodsOrCtors.length; ++i) {
            int[] bestFitWeights;
            int bestFitIndex;
            MemberBox bestFit;
            int preference;
            MemberBox member = methodsOrCtors[i];
            int[] weights = NativeJavaMethod.failFastConversionWeights(args, member);
            if (weights == null) continue;
            if (firstBestFit < 0) {
                firstBestFit = i;
                firstBestFitWeights = weights;
                continue;
            }
            int betterCount = 0;
            int worseCount = 0;
            for (int j = -1; j != extraBestFitsCount && (preference = NativeJavaMethod.preferSignature(args, member, weights, bestFit = methodsOrCtors[bestFitIndex = j < 0 ? firstBestFit : extraBestFits[j]], bestFitWeights = j < 0 ? firstBestFitWeights : extraBestFitWeights[j])) != 3; ++j) {
                if (preference == 1) {
                    ++betterCount;
                    continue;
                }
                if (preference == 2) {
                    ++worseCount;
                    continue;
                }
                if (preference != 0) {
                    Kit.codeBug();
                }
                if (!bestFit.isStatic() || !bestFit.getDeclaringClass().isAssignableFrom(member.getDeclaringClass())) continue block0;
                if (j == -1) {
                    firstBestFit = i;
                    firstBestFitWeights = weights;
                    continue block0;
                }
                extraBestFits[j] = i;
                extraBestFitWeights[j] = weights;
                continue block0;
            }
            if (betterCount == 1 + extraBestFitsCount) {
                firstBestFit = i;
                firstBestFitWeights = weights;
                extraBestFitsCount = 0;
                continue;
            }
            if (worseCount == 1 + extraBestFitsCount) continue;
            if (extraBestFits == null) {
                extraBestFits = new int[methodsOrCtors.length - 1];
                extraBestFitWeights = new int[methodsOrCtors.length - 1][];
            }
            extraBestFits[extraBestFitsCount] = i;
            extraBestFitWeights[extraBestFitsCount] = weights;
            ++extraBestFitsCount;
        }
        if (firstBestFit < 0) {
            return -1;
        }
        if (extraBestFitsCount == 0) {
            return firstBestFit;
        }
        StringBuilder buf = new StringBuilder();
        for (int j = -1; j != extraBestFitsCount; ++j) {
            int bestFitIndex = j == -1 ? firstBestFit : extraBestFits[j];
            buf.append("\n    ");
            buf.append(methodsOrCtors[bestFitIndex].toJavaDeclaration());
        }
        MemberBox firstFitMember = methodsOrCtors[firstBestFit];
        String memberName = firstFitMember.getName();
        String memberClass = firstFitMember.getDeclaringClass().getName();
        if (methodsOrCtors[0].isCtor()) {
            throw Context.reportRuntimeErrorById("msg.constructor.ambiguous", memberName, NativeJavaMethod.scriptSignature(args), buf.toString());
        }
        throw Context.reportRuntimeErrorById("msg.method.ambiguous", memberClass, memberName, NativeJavaMethod.scriptSignature(args), buf.toString());
    }

    private static int preferSignature(Object[] args, MemberBox member1, int[] computedWeights1, MemberBox member2, int[] computedWeights2) {
        List<TypeInfo> types1 = member1.getArgTypes();
        List<TypeInfo> types2 = member2.getArgTypes();
        int totalPreference = 0;
        for (int j = 0; j < args.length; ++j) {
            int rank2;
            TypeInfo type2;
            TypeInfo type1 = member1.vararg && j >= types1.size() ? types1.get(types1.size() - 1) : types1.get(j);
            TypeInfo typeInfo = type2 = member2.vararg && j >= types2.size() ? types2.get(types2.size() - 1) : types2.get(j);
            if (type1.asClass() == type2.asClass()) continue;
            Object arg = args[j];
            int rank1 = j < computedWeights1.length ? computedWeights1[j] : NativeJavaObject.getConversionWeight(arg, type1);
            int n = rank2 = j < computedWeights2.length ? computedWeights2[j] : NativeJavaObject.getConversionWeight(arg, type2);
            int preference = rank1 < rank2 ? 1 : (rank1 > rank2 ? 2 : (rank1 == 0 ? (type1.isAssignableFrom(type2) ? 2 : (type2.isAssignableFrom(type1) ? 1 : 3)) : 3));
            if ((totalPreference |= preference) == 3) break;
        }
        return totalPreference;
    }

    static int[] failFastConversionWeights(Object[] args, MemberBox member) {
        List<TypeInfo> argTypes = member.getArgTypes();
        int typeLen = argTypes.size();
        if (member.vararg ? --typeLen > args.length : typeLen != args.length) {
            return null;
        }
        int[] weights = new int[typeLen];
        for (int i = 0; i < typeLen; ++i) {
            int weight = NativeJavaObject.getConversionWeight(args[i], argTypes.get(i));
            if (weight >= 99) {
                return null;
            }
            weights[i] = weight;
        }
        return weights;
    }

    private static void printDebug(String msg, MemberBox member, Object[] args) {
    }
}

