/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript;

import java.util.EnumSet;
import org.htmlunit.corejs.javascript.BoundFunction;
import org.htmlunit.corejs.javascript.BuiltInSlot;
import org.htmlunit.corejs.javascript.Callable;
import org.htmlunit.corejs.javascript.CompoundOperationMap;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.DecompilerFlag;
import org.htmlunit.corejs.javascript.DefaultErrorReporter;
import org.htmlunit.corejs.javascript.Delegator;
import org.htmlunit.corejs.javascript.ErrorReporter;
import org.htmlunit.corejs.javascript.Evaluator;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.JavaScriptException;
import org.htmlunit.corejs.javascript.KnownBuiltInFunction;
import org.htmlunit.corejs.javascript.LambdaConstructor;
import org.htmlunit.corejs.javascript.LambdaFunction;
import org.htmlunit.corejs.javascript.NativeCall;
import org.htmlunit.corejs.javascript.NativeFunction;
import org.htmlunit.corejs.javascript.NativeObject;
import org.htmlunit.corejs.javascript.ScriptRuntime;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.corejs.javascript.SerializableCallable;
import org.htmlunit.corejs.javascript.SymbolKey;
import org.htmlunit.corejs.javascript.TopLevel;
import org.htmlunit.corejs.javascript.Undefined;
import org.htmlunit.corejs.javascript.UniqueTag;

public class BaseFunction
extends ScriptableObject
implements Function {
    private static final long serialVersionUID = 5311394446546053859L;
    private static final Object FUNCTION_TAG = "Function";
    private static final String FUNCTION_CLASS = "Function";
    static final String GENERATOR_FUNCTION_CLASS = "__GeneratorFunction";
    private static final String APPLY_TAG = "APPLY_TAG";
    private static final String CALL_TAG = "CALL_TAG";
    private static final String PROTOTYPE_PROPERTY_NAME = "prototype";
    protected static final int Id_length = 1;
    protected static final int Id_arity = 2;
    protected static final int Id_name = 3;
    protected static final int Id_prototype = 4;
    protected static final int Id_arguments = 5;
    protected static final int MAX_INSTANCE_ID = 5;
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toSource = 3;
    private static final int Id_apply = 4;
    private static final int Id_call = 5;
    private static final int Id_bind = 6;
    private static final int SymbolId_hasInstance = 7;
    private static final int MAX_PROTOTYPE_ID = 7;
    private Object prototypeProperty;
    private Object argumentsObj = NOT_FOUND;
    private Object nameValue = null;
    private boolean isGeneratorFunction = false;
    private Scriptable homeObject = null;
    private int prototypePropertyAttributes = 6;

    static LambdaConstructor init(Context cx, Scriptable scope, boolean sealed) {
        LambdaConstructor ctor = new LambdaConstructor(scope, FUNCTION_CLASS, 1, BaseFunction::js_constructorCall, BaseFunction::js_constructor);
        LambdaFunction proto = new LambdaFunction(scope, "", 0, null, (lcx, lscope, lthisObj, largs) -> Undefined.instance);
        proto.defineProperty("constructor", (Object)ctor, 2);
        ctor.setPrototypeProperty(proto);
        ScriptableObject.defineProperty(scope, FUNCTION_CLASS, ctor, 2);
        ctor.setPrototype((Scriptable)ctor.getPrototypeProperty());
        BaseFunction.defKnownBuiltInOnProto(ctor, APPLY_TAG, scope, "apply", 2, BaseFunction::js_apply);
        BaseFunction.defOnProto(ctor, scope, "bind", 1, BaseFunction::js_bind);
        BaseFunction.defKnownBuiltInOnProto(ctor, CALL_TAG, scope, "call", 1, BaseFunction::js_call);
        BaseFunction.defOnProto(ctor, scope, "toSource", 1, BaseFunction::js_toSource);
        BaseFunction.defOnProto(ctor, scope, "toString", 0, BaseFunction::js_toString);
        BaseFunction.defOnProto(ctor, scope, SymbolKey.HAS_INSTANCE, 1, BaseFunction::js_hasInstance, 7);
        ctor.setPrototypePropertyAttributes(7);
        ctor.setStandardPropertyAttributes(3);
        ScriptableObject.defineProperty(scope, FUNCTION_CLASS, ctor, 2);
        if (sealed) {
            ctor.sealObject();
            ((ScriptableObject)ctor.getPrototypeProperty()).sealObject();
        }
        return ctor;
    }

    private static void defOnProto(LambdaConstructor constructor, Scriptable scope, String name, int length, SerializableCallable target) {
        constructor.definePrototypeMethod(scope, name, length, null, target, 2, 3);
    }

    private static void defKnownBuiltInOnProto(LambdaConstructor constructor, Object tag, Scriptable scope, String name, int length, SerializableCallable target) {
        constructor.defineKnownBuiltInPrototypeMethod(tag, scope, name, length, null, target, 2, 3);
    }

    private static void defOnProto(LambdaConstructor constructor, Scriptable scope, SymbolKey name, int length, SerializableCallable target, int attributes) {
        constructor.definePrototypeMethod(scope, name, length, null, target, attributes, 3);
    }

    @Deprecated
    static void init(Scriptable scope, boolean sealed) {
        BaseFunction.init(Context.getContext(), scope, sealed);
    }

    static Object initAsGeneratorFunction(Scriptable scope, boolean sealed) {
        NativeObject proto = new NativeObject();
        Scriptable function = (Scriptable)ScriptableObject.getProperty(scope, FUNCTION_CLASS);
        Scriptable functionProto = (Scriptable)ScriptableObject.getProperty(function, PROTOTYPE_PROPERTY_NAME);
        proto.setPrototype(functionProto);
        Scriptable iterator = (Scriptable)ScriptableObject.getProperty(scope, "Iterator");
        Object iteratorPrototype = ScriptableObject.getProperty(iterator, PROTOTYPE_PROPERTY_NAME);
        ScriptableObject.putProperty((Scriptable)proto, PROTOTYPE_PROPERTY_NAME, iteratorPrototype);
        LambdaConstructor ctor = new LambdaConstructor(scope, GENERATOR_FUNCTION_CLASS, 1, proto, BaseFunction::js_gen_constructorCall, BaseFunction::js_gen_constructor);
        proto.defineProperty("constructor", (Object)ctor, 2);
        ctor.setPrototypePropertyAttributes(7);
        ScriptableObject.putProperty(scope, GENERATOR_FUNCTION_CLASS, (Object)ctor);
        return ctor;
    }

    public BaseFunction() {
        this.createProperties();
    }

    public BaseFunction(boolean isGenerator) {
        this.createProperties();
        this.isGeneratorFunction = isGenerator;
    }

    public BaseFunction(Scriptable scope, Scriptable prototype) {
        super(scope, prototype);
        this.createProperties();
        ScriptRuntime.setBuiltinProtoAndParent(this, scope, TopLevel.Builtins.Function);
    }

    protected void createProperties() {
        ScriptableObject.defineBuiltInProperty(this, "length", 3, BaseFunction::lengthGetter);
        ScriptableObject.defineBuiltInProperty(this, "name", 3, BaseFunction::nameGetter, BaseFunction::nameSetter);
        if (this.includeNonStandardProps()) {
            ScriptableObject.defineBuiltInProperty(this, "arity", 7, BaseFunction::arityGetter);
            ScriptableObject.defineBuiltInProperty(this, "arguments", 6, BaseFunction::argumentsGetter, BaseFunction::argumentsSetter);
        }
    }

    protected boolean includeNonStandardProps() {
        return !Context.isCurrentContextStrict();
    }

    private static Object lengthGetter(BaseFunction function, Scriptable start) {
        return function.getLength();
    }

    private static Object arityGetter(BaseFunction function, Scriptable start) {
        return function.getArity();
    }

    private static Object argumentsGetter(BaseFunction function, Scriptable start) {
        return function.getArguments();
    }

    private static boolean argumentsSetter(BaseFunction function, Object value, Scriptable owner, Scriptable start, boolean isThrow) {
        function.argumentsObj = value;
        return true;
    }

    private static Object nameGetter(BaseFunction function, Scriptable start) {
        return function.nameValue != null ? function.nameValue : function.getFunctionName();
    }

    private static boolean nameSetter(BaseFunction function, Object value, Scriptable owner, Scriptable start, boolean isThrow) {
        function.nameValue = value;
        return true;
    }

    void setFunctionName(String name) {
        this.nameValue = name;
    }

    protected void createPrototypeProperty() {
        try (CompoundOperationMap map = this.startCompoundOp(true);){
            this.createPrototypeProperty(map);
        }
    }

    protected void createPrototypeProperty(CompoundOperationMap compoundOp) {
        compoundOp.compute(this, compoundOp, PROTOTYPE_PROPERTY_NAME, 0, (k, i, s, m, o) -> {
            if (s == null) {
                return new BuiltInSlot<BaseFunction>(PROTOTYPE_PROPERTY_NAME, 0, this.prototypePropertyAttributes, this, BaseFunction::prototypeGetter, BaseFunction::prototypeSetter, BaseFunction::prototypeAttrSetter, BaseFunction::prototypeDescSetter);
            }
            return s;
        });
    }

    private static Object prototypeGetter(BaseFunction function, Scriptable start) {
        return function.getPrototypeProperty();
    }

    private static boolean prototypeSetter(BaseFunction function, Object value, Scriptable owner, Scriptable start, boolean isThrow) {
        function.prototypeProperty = value == null ? UniqueTag.NULL_VALUE : value;
        return true;
    }

    private static void prototypeAttrSetter(BaseFunction function, int attributes) {
        function.prototypePropertyAttributes = attributes;
    }

    protected static boolean prototypeDescSetter(BaseFunction builtIn, BuiltInSlot<BaseFunction> current, Object id, ScriptableObject.DescriptorInfo info, boolean checkValid, Object key, int index) {
        try (CompoundOperationMap map = builtIn.startCompoundOp(true);){
            boolean bl = ScriptableObject.defineOrdinaryProperty((o, i, k, e, m, s) -> {
                if (i.value != NOT_FOUND) {
                    builtIn.prototypeProperty = i.value == null ? UniqueTag.NULL_VALUE : i.value;
                }
                return s;
            }, builtIn, map, id, info, checkValid, key, index);
            return bl;
        }
    }

    protected final boolean defaultHas(String name) {
        return super.has(name, (Scriptable)this);
    }

    protected final Object defaultGet(String name) {
        return super.get(name, (Scriptable)this);
    }

    protected final void defaultPut(String name, Object value) {
        super.put(name, (Scriptable)this, value);
    }

    @Override
    public String getClassName() {
        return this.isGeneratorFunction() ? GENERATOR_FUNCTION_CLASS : FUNCTION_CLASS;
    }

    protected boolean isGeneratorFunction() {
        return this.isGeneratorFunction;
    }

    protected boolean hasDefaultParameters() {
        return false;
    }

    @Override
    public String getTypeOf() {
        return this.avoidObjectDetection() ? "undefined" : "function";
    }

    @Override
    public boolean hasInstance(Scriptable instance) {
        Object protoProp = ScriptableObject.getProperty((Scriptable)this, PROTOTYPE_PROPERTY_NAME);
        if (protoProp instanceof Scriptable) {
            return ScriptRuntime.jsDelegatesTo(instance, (Scriptable)protoProp);
        }
        throw ScriptRuntime.typeErrorById("msg.instanceof.bad.prototype", this.getFunctionName());
    }

    static boolean isApply(KnownBuiltInFunction f) {
        return f.getTag() == APPLY_TAG;
    }

    static boolean isApplyOrCall(KnownBuiltInFunction f) {
        Object tag = f.getTag();
        return tag == APPLY_TAG || tag == CALL_TAG;
    }

    private static Object js_hasInstance(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!(thisObj instanceof Callable)) {
            return false;
        }
        Object protoProp = null;
        protoProp = thisObj instanceof BoundFunction ? ((NativeFunction)((BoundFunction)thisObj).getTargetFunction()).getPrototypeProperty() : ScriptableObject.getProperty(thisObj, PROTOTYPE_PROPERTY_NAME);
        if (ScriptRuntime.isObject(protoProp)) {
            if (args.length > 0 && args[0] instanceof Scriptable) {
                Scriptable obj = (Scriptable)args[0];
                return ScriptRuntime.jsDelegatesTo(obj, (Scriptable)protoProp);
            }
            return false;
        }
        throw ScriptRuntime.typeErrorById("msg.instanceof.bad.prototype", thisObj instanceof BaseFunction ? ((BaseFunction)thisObj).getFunctionName() : "unknown");
    }

    private static Object js_bind(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object[] boundArgs;
        Scriptable boundThis;
        if (!(thisObj instanceof Callable)) {
            throw ScriptRuntime.notFunctionError(thisObj);
        }
        Callable targetFunction = (Callable)((Object)thisObj);
        int argc = args.length;
        if (argc > 0) {
            boundThis = ScriptRuntime.toObjectOrNull(cx, args[0], scope);
            boundArgs = new Object[argc - 1];
            System.arraycopy(args, 1, boundArgs, 0, argc - 1);
        } else {
            boundThis = null;
            boundArgs = ScriptRuntime.emptyArgs;
        }
        return new BoundFunction(cx, scope, targetFunction, boundThis, boundArgs);
    }

    private static Object js_apply(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return ScriptRuntime.applyOrCall(true, cx, scope, thisObj, args);
    }

    private static Object js_call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return ScriptRuntime.applyOrCall(false, cx, scope, thisObj, args);
    }

    private static Object js_toSource(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        BaseFunction realf = BaseFunction.realFunction(thisObj, "toSource");
        int indent = 0;
        EnumSet<DecompilerFlag> flags = EnumSet.of(DecompilerFlag.TO_SOURCE);
        if (args.length != 0) {
            indent = ScriptRuntime.toInt32(args[0]);
            if (indent >= 0) {
                flags = EnumSet.noneOf(DecompilerFlag.class);
            } else {
                indent = 0;
            }
        }
        return realf.decompile(indent, flags);
    }

    private static Object js_toString(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        BaseFunction realf = BaseFunction.realFunction(thisObj, "toString");
        int indent = ScriptRuntime.toInt32(args, 0);
        return realf.decompile(indent, EnumSet.noneOf(DecompilerFlag.class));
    }

    private static Scriptable js_gen_constructorCall(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return BaseFunction.js_gen_constructor(cx, scope, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Scriptable js_constructor(Context cx, Scriptable scope, Object[] args) {
        if (cx.isStrictMode()) {
            NativeCall activation = cx.currentActivationCall;
            boolean strictMode = cx.isTopLevelStrict;
            try {
                cx.currentActivationCall = null;
                cx.isTopLevelStrict = false;
                Scriptable scriptable = BaseFunction.jsConstructor(cx, scope, args, false);
                return scriptable;
            }
            finally {
                cx.isTopLevelStrict = strictMode;
                cx.currentActivationCall = activation;
            }
        }
        return BaseFunction.jsConstructor(cx, scope, args, false);
    }

    private static Scriptable js_constructorCall(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return BaseFunction.js_constructor(cx, scope, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Scriptable js_gen_constructor(Context cx, Scriptable scope, Object[] args) {
        if (cx.isStrictMode()) {
            NativeCall activation = cx.currentActivationCall;
            boolean strictMode = cx.isTopLevelStrict;
            try {
                cx.currentActivationCall = null;
                cx.isTopLevelStrict = false;
                Scriptable scriptable = BaseFunction.jsConstructor(cx, scope, args, true);
                return scriptable;
            }
            finally {
                cx.isTopLevelStrict = strictMode;
                cx.currentActivationCall = activation;
            }
        }
        return BaseFunction.jsConstructor(cx, scope, args, true);
    }

    private static BaseFunction realFunction(Scriptable thisObj, String functionName) {
        if (thisObj == null) {
            throw ScriptRuntime.notFunctionError(null);
        }
        Object x = thisObj.getDefaultValue(ScriptRuntime.FunctionClass);
        if (x instanceof Delegator) {
            x = ((Delegator)x).getDelegee();
        }
        return BaseFunction.ensureType(x, BaseFunction.class, functionName);
    }

    public void setImmunePrototypeProperty(Object value) {
        if ((this.prototypePropertyAttributes & 1) != 0) {
            throw new IllegalStateException();
        }
        this.prototypeProperty = value != null ? value : UniqueTag.NULL_VALUE;
        this.createPrototypeProperty();
        this.setAttributes(PROTOTYPE_PROPERTY_NAME, 7);
    }

    public Scriptable getClassPrototype() {
        Object protoVal = this.getPrototypeProperty();
        if (protoVal instanceof Scriptable) {
            return (Scriptable)protoVal;
        }
        return ScriptableObject.getObjectPrototype(this);
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return Undefined.instance;
    }

    @Override
    public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
        if (this.getHomeObject() != null) {
            throw ScriptRuntime.typeErrorById("msg.not.ctor", this.getFunctionName());
        }
        Scriptable result = this.createObject(cx, scope);
        if (result != null) {
            Object val = this.call(cx, scope, result, args);
            if (val instanceof Scriptable) {
                result = (Scriptable)val;
            }
        } else {
            Scriptable parent;
            Scriptable proto;
            Object val = this.call(cx, scope, null, args);
            if (!(val instanceof Scriptable)) {
                throw new IllegalStateException("Bad implementation of call as constructor, name=" + this.getFunctionName() + " in " + this.getClass().getName());
            }
            result = (Scriptable)val;
            if (result.getPrototype() == null && result != (proto = this.getClassPrototype())) {
                result.setPrototype(proto);
            }
            if (result.getParentScope() == null && result != (parent = this.getParentScope())) {
                result.setParentScope(parent);
            }
        }
        return result;
    }

    public Scriptable createObject(Context cx, Scriptable scope) {
        NativeObject newInstance = new NativeObject();
        newInstance.setPrototype(this.getClassPrototype());
        newInstance.setParentScope(this.getParentScope());
        return newInstance;
    }

    String decompile(int indent, EnumSet<DecompilerFlag> flags) {
        StringBuilder sb = new StringBuilder();
        boolean justbody = flags.contains((Object)DecompilerFlag.ONLY_BODY);
        if (!justbody) {
            sb.append("function ");
            sb.append(this.getFunctionName());
            sb.append("() {\n    ");
        }
        sb.append("[native code]\n");
        if (!justbody) {
            sb.append("}");
        }
        return sb.toString();
    }

    public int getArity() {
        return 0;
    }

    public int getLength() {
        return 0;
    }

    public String getFunctionName() {
        return "";
    }

    public void setStandardPropertyAttributes(int attributes) {
        this.setAttributes("name", attributes);
        this.setAttributes("length", attributes);
        this.setAttributes("arity", attributes);
    }

    public void setPrototypePropertyAttributes(int attributes) {
        this.prototypePropertyAttributes = attributes;
        this.getMap().compute(this, PROTOTYPE_PROPERTY_NAME, 0, (k, i, s, m, o) -> {
            if (s != null) {
                s.setAttributes(attributes);
            }
            return s;
        });
    }

    protected boolean hasPrototypeProperty() {
        return this.prototypeProperty != null && this.prototypeProperty != UniqueTag.NOT_FOUND || this instanceof NativeFunction;
    }

    public Object getPrototypeProperty() {
        Object result = this.prototypeProperty;
        if (result == null || result == UniqueTag.NOT_FOUND) {
            result = Undefined.instance;
        } else if (result == UniqueTag.NULL_VALUE) {
            result = null;
        }
        return result;
    }

    protected void setPrototypeProperty(Object prototype) {
        if (prototype != null) {
            this.createPrototypeProperty();
            this.prototypeProperty = prototype;
        } else {
            this.prototypeProperty = UniqueTag.NOT_FOUND;
        }
    }

    protected synchronized Object setupDefaultPrototype(Scriptable scope) {
        if (!this.has(PROTOTYPE_PROPERTY_NAME, (Scriptable)this)) {
            this.createPrototypeProperty();
        }
        NativeObject obj = new NativeObject();
        obj.setParentScope(this.getParentScope());
        this.prototypeProperty = obj;
        Scriptable proto = BaseFunction.getObjectPrototype(this);
        if (proto != obj) {
            obj.setPrototype(proto);
        }
        obj.defineProperty("constructor", (Object)this, 2);
        return obj;
    }

    private Object getArguments() {
        if (this.argumentsObj != NOT_FOUND) {
            return this.argumentsObj;
        }
        Context cx = Context.getContext();
        NativeCall activation = ScriptRuntime.findFunctionActivation(cx, this);
        return activation == null ? null : activation.get("arguments", (Scriptable)activation);
    }

    private static Scriptable jsConstructor(Context cx, Scriptable scope, Object[] args, boolean isGeneratorFunction) {
        int arglen = args.length;
        StringBuilder sourceBuf = new StringBuilder();
        sourceBuf.append("function ");
        if (isGeneratorFunction) {
            sourceBuf.append("* ");
        }
        sourceBuf.append("anonymous");
        sourceBuf.append('(');
        for (int i = 0; i < arglen - 1; ++i) {
            if (i > 0) {
                sourceBuf.append(',');
            }
            sourceBuf.append(ScriptRuntime.toString(args[i]));
        }
        sourceBuf.append(") {");
        if (arglen != 0) {
            String funBody = ScriptRuntime.toString(args[arglen - 1]);
            sourceBuf.append(funBody);
        }
        sourceBuf.append("\n}");
        String source = sourceBuf.toString();
        int[] linep = new int[1];
        String filename = Context.getSourcePositionFromStack(linep);
        if (filename == null) {
            filename = "<eval'ed string>";
            linep[0] = 1;
        }
        String sourceURI = ScriptRuntime.makeUrlForGeneratedScript(false, filename, linep[0]);
        Scriptable global = ScriptableObject.getTopLevelScope(scope);
        ErrorReporter reporter = DefaultErrorReporter.forEval(cx.getErrorReporter());
        Evaluator evaluator = Context.createInterpreter();
        if (evaluator == null) {
            throw new JavaScriptException("Interpreter not present", filename, linep[0]);
        }
        return cx.compileFunction(global, source, evaluator, reporter, sourceURI, 1, null);
    }

    public void setHomeObject(Scriptable homeObject) {
        this.homeObject = homeObject;
    }

    public Scriptable getHomeObject() {
        return this.homeObject;
    }
}

