/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript;

import java.util.Arrays;
import org.htmlunit.corejs.javascript.ArrowFunction;
import org.htmlunit.corejs.javascript.BaseFunction;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.Kit;
import org.htmlunit.corejs.javascript.NativeFunction;
import org.htmlunit.corejs.javascript.ScriptRuntime;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.corejs.javascript.Symbol;
import org.htmlunit.corejs.javascript.Undefined;

public abstract class NewLiteralStorage {
    protected Object[] keys;
    protected int[] getterSetters;
    protected Object[] values;
    protected int index = 0;

    protected NewLiteralStorage(Object[] ids, int length, boolean createKeys) {
        int l;
        if (ids != null) {
            this.keys = ids;
            l = ids.length;
        } else {
            this.keys = createKeys ? new Object[length] : null;
            l = length;
        }
        this.getterSetters = new int[l];
        this.values = new Object[l];
    }

    public void pushValue(Object value) {
        this.values[this.index] = value;
        this.attemptToInferFunctionName(value);
        ++this.index;
    }

    public void pushGetter(Object value) {
        this.getterSetters[this.index] = -1;
        this.pushValue(value);
    }

    public void pushSetter(Object value) {
        this.getterSetters[this.index] = 1;
        this.pushValue(value);
    }

    public void pushKey(Object key) {
        this.keys[this.index] = key instanceof Symbol ? key : ScriptRuntime.toString(key);
    }

    public void spread(Context cx, Scriptable scope, Object source) {
        if (source != null && !Undefined.isUndefined(source)) {
            Scriptable src = ScriptRuntime.toObject(cx, scope, source);
            Object[] ids = src instanceof ScriptableObject ? ((ScriptableObject)src).getIds(false, true) : src.getIds();
            int newLen = this.values.length + ids.length;
            this.keys = Arrays.copyOf(this.keys, newLen);
            this.getterSetters = Arrays.copyOf(this.getterSetters, newLen);
            this.values = Arrays.copyOf(this.values, newLen);
            for (Object id : ids) {
                Object value;
                if (id instanceof String) {
                    value = ScriptableObject.getProperty(src, (String)id);
                } else if (id instanceof Integer) {
                    value = ScriptableObject.getProperty(src, (Integer)id);
                } else if (ScriptRuntime.isSymbol(id)) {
                    value = ScriptableObject.getProperty(src, (Symbol)id);
                } else {
                    throw Kit.codeBug();
                }
                this.pushKey(id);
                this.pushValue(value);
            }
        }
    }

    public Object[] getKeys() {
        return this.keys;
    }

    public int[] getGetterSetters() {
        return this.getterSetters;
    }

    public Object[] getValues() {
        return this.values;
    }

    public static NewLiteralStorage create(Context cx, Object[] ids) {
        return new NameInference(ids, -1, false);
    }

    public static NewLiteralStorage create(Context cx, int length, boolean createKeys) {
        return new NameInference(null, length, createKeys);
    }

    protected abstract void attemptToInferFunctionName(Object var1);

    private static final class NameInference
    extends NewLiteralStorage {
        NameInference(Object[] ids, int length, boolean createKeys) {
            super(ids, length, createKeys);
        }

        @Override
        protected void attemptToInferFunctionName(Object value) {
            if (this.keys == null || !(value instanceof NativeFunction) && !(value instanceof ArrowFunction)) {
                return;
            }
            BaseFunction fun = (BaseFunction)value;
            if (!"".equals(fun.get("name", (Scriptable)fun))) {
                return;
            }
            String prefix = "";
            if (this.getterSetters[this.index] == -1) {
                prefix = "get ";
            } else if (this.getterSetters[this.index] == 1) {
                prefix = "set ";
            }
            Object propKey = this.keys[this.index];
            if (propKey instanceof Symbol) {
                String symbolName = ((Symbol)propKey).getName();
                if (!symbolName.isEmpty()) {
                    fun.setFunctionName(prefix + "[" + symbolName + "]");
                } else if (!prefix.isEmpty()) {
                    fun.setFunctionName(prefix);
                }
            } else if (!propKey.equals("__proto__")) {
                fun.setFunctionName(prefix + propKey);
            } else if (fun instanceof NativeFunction && ((NativeFunction)fun).isShorthand()) {
                fun.setFunctionName(prefix + propKey);
            }
        }
    }

    private static final class NoInference
    extends NewLiteralStorage {
        NoInference(Object[] ids, int length, boolean createKeys) {
            super(ids, length, createKeys);
        }

        @Override
        protected void attemptToInferFunctionName(Object value) {
        }
    }
}

