/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript;

import java.io.Serializable;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.EcmaError;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.Kit;
import org.htmlunit.corejs.javascript.LambdaConstructor;
import org.htmlunit.corejs.javascript.LambdaFunction;
import org.htmlunit.corejs.javascript.NativeError;
import org.htmlunit.corejs.javascript.NativeNumber;
import org.htmlunit.corejs.javascript.ScriptRuntime;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.corejs.javascript.SerializableCallable;
import org.htmlunit.corejs.javascript.SerializableConstructable;
import org.htmlunit.corejs.javascript.TopLevel;
import org.htmlunit.corejs.javascript.Undefined;
import org.htmlunit.corejs.javascript.xml.XMLLib;

public class NativeGlobal
implements Serializable {
    static final long serialVersionUID = 6080442165748707530L;
    private static final String URI_DECODE_RESERVED = ";/?:@&=+$,#";
    private static final int INVALID_UTF8 = Integer.MAX_VALUE;

    public static void init(Context cx, Scriptable scope, boolean sealed) {
        NativeGlobal.defineGlobalFunction(scope, sealed, "decodeURI", 1, (callCx, callScope, thisObj, args) -> NativeGlobal.js_decodeURI(args));
        NativeGlobal.defineGlobalFunction(scope, sealed, "decodeURIComponent", 1, (callCx, callScope, thisObj, args) -> NativeGlobal.js_decodeURIComponent(args));
        NativeGlobal.defineGlobalFunction(scope, sealed, "encodeURI", 1, (callCx, callScope, thisObj, args) -> NativeGlobal.js_encodeURI(args));
        NativeGlobal.defineGlobalFunction(scope, sealed, "encodeURIComponent", 1, (callCx, callScope, thisObj, args) -> NativeGlobal.js_encodeURIComponent(args));
        NativeGlobal.defineGlobalFunction(scope, sealed, "escape", 1, (callCx, callScope, thisObj, args) -> NativeGlobal.js_escape(args));
        NativeGlobal.defineGlobalFunction(scope, sealed, "isFinite", 1, (callCx, callScope, thisObj, args) -> NativeGlobal.js_isFinite(args));
        NativeGlobal.defineGlobalFunction(scope, sealed, "isNaN", 1, (callCx, callScope, thisObj, args) -> NativeGlobal.js_isNaN(args));
        NativeGlobal.defineGlobalFunction(scope, sealed, "isXMLName", 1, (callCx, callScope, thisObj, args) -> NativeGlobal.js_isXMLName(callCx, callScope, args));
        NativeGlobal.defineGlobalFunction(scope, sealed, "parseFloat", 1, (callCx, callScope, thisObj, args) -> NativeGlobal.js_parseFloat(args));
        NativeGlobal.defineGlobalFunction(scope, sealed, "parseInt", 2, (callCx, callScope, thisObj, args) -> NativeGlobal.js_parseInt(callCx, args));
        NativeGlobal.defineGlobalFunction(scope, sealed, "unescape", 1, (callCx, callScope, thisObj, args) -> NativeGlobal.js_unescape(args));
        NativeGlobal.defineGlobalFunction(scope, sealed, "uneval", 1, (callCx, callScope, thisObj, args) -> NativeGlobal.js_uneval(callCx, callScope, args));
        NativeGlobal.defineGlobalFunctionEval(scope, sealed);
        ScriptableObject.defineProperty(scope, "NaN", ScriptRuntime.NaNobj, 7);
        ScriptableObject.defineProperty(scope, "Infinity", Double.POSITIVE_INFINITY, 7);
        ScriptableObject.defineProperty(scope, "undefined", Undefined.instance, 7);
        ScriptableObject.defineProperty(scope, "globalThis", scope, 2);
        Scriptable nativeError = ScriptableObject.ensureScriptable(ScriptableObject.getProperty(scope, "Error"));
        Scriptable nativeErrorProto = ScriptableObject.ensureScriptable(ScriptableObject.getProperty(nativeError, "prototype"));
        for (TopLevel.NativeErrors error : TopLevel.NativeErrors.values()) {
            LambdaConstructor ctor;
            SerializableConstructableWithInjectableCtor target;
            if (error == TopLevel.NativeErrors.Error) continue;
            String name = error.name();
            Scriptable topLevelScope = ScriptableObject.getTopLevelScope(scope);
            Function builtinErrorCtor = TopLevel.getBuiltinCtor(cx, topLevelScope, TopLevel.Builtins.Error);
            NativeError errorProto = NativeError.makeProto(topLevelScope, builtinErrorCtor);
            errorProto.defineProperty("name", (Object)name, 2);
            errorProto.defineProperty("message", (Object)"", 2);
            if (error == TopLevel.NativeErrors.AggregateError) {
                target = new SerializableConstructableWithInjectableCtor(){

                    @Override
                    public Scriptable construct(Context callCx, Scriptable callScope, Object[] args) {
                        return NativeError.makeAggregate(callCx, callScope, this.lateBoundCtor, args);
                    }
                };
                ctor = new LambdaConstructor(scope, name, 2, target){

                    @Override
                    public Scriptable createObject(Context cx, Scriptable scope) {
                        return null;
                    }
                };
                target.lateBoundCtor = ctor;
            } else {
                target = new SerializableConstructableWithInjectableCtor(){

                    @Override
                    public Scriptable construct(Context callCx, Scriptable callScope, Object[] args) {
                        return NativeError.make(callCx, callScope, this.lateBoundCtor, args);
                    }
                };
                ctor = new LambdaConstructor(scope, name, 1, target);
                target.lateBoundCtor = ctor;
            }
            ctor.setImmunePrototypeProperty(errorProto);
            ctor.setPrototype(nativeError);
            ((ScriptableObject)errorProto).put("constructor", (Scriptable)errorProto, (Object)ctor);
            ((ScriptableObject)errorProto).setAttributes("constructor", 2);
            errorProto.setPrototype(nativeErrorProto);
            if (sealed) {
                errorProto.sealObject();
                ctor.sealObject();
            }
            ctor.setAttributes("name", 3);
            ctor.setAttributes("length", 3);
            ScriptableObject.defineProperty(scope, name, ctor, 2);
        }
    }

    private static void defineGlobalFunction(Scriptable scope, boolean sealed, String name, int length, SerializableCallable callable) {
        LambdaFunction fun = new LambdaFunction(scope, name, length, callable);
        NativeGlobal.registerGlobalFunction(scope, sealed, name, fun);
    }

    private static void registerGlobalFunction(Scriptable scope, boolean sealed, String name, LambdaFunction fun) {
        ScriptableObject.defineProperty(scope, name, fun, 2);
        if (sealed) {
            fun.sealObject();
        }
        fun.setPrototypeProperty(null);
    }

    private static void defineGlobalFunctionEval(Scriptable scope, boolean sealed) {
        EvalLambdaFunction evalFun = new EvalLambdaFunction(scope);
        NativeGlobal.registerGlobalFunction(scope, sealed, "eval", evalFun);
    }

    static boolean isEvalFunction(Object functionObj) {
        return functionObj instanceof EvalLambdaFunction;
    }

    private static String js_uneval(Context cx, Scriptable scope, Object[] args) {
        Object value = args.length != 0 ? args[0] : Undefined.instance;
        return ScriptRuntime.uneval(cx, scope, value);
    }

    private static Boolean js_isXMLName(Context cx, Scriptable scope, Object[] args) {
        Object name = args.length == 0 ? Undefined.instance : args[0];
        XMLLib xmlLib = XMLLib.extractFromScope(scope);
        return xmlLib.isXMLName(cx, name);
    }

    private static Boolean js_isNaN(Object[] args) {
        if (args.length < 1) {
            return true;
        }
        double d = ScriptRuntime.toNumber(args[0]);
        return Double.isNaN(d);
    }

    private static Object js_isFinite(Object[] args) {
        if (args.length < 1) {
            return Boolean.FALSE;
        }
        return NativeNumber.isFinite(args[0]);
    }

    private static String js_decodeURI(Object[] args) {
        String str = ScriptRuntime.toString(args, 0);
        return NativeGlobal.decode(str, true);
    }

    private static String js_decodeURIComponent(Object[] args) {
        String str = ScriptRuntime.toString(args, 0);
        return NativeGlobal.decode(str, false);
    }

    private static String js_encodeURI(Object[] args) {
        String str = ScriptRuntime.toString(args, 0);
        return NativeGlobal.encode(str, true);
    }

    private static String js_encodeURIComponent(Object[] args) {
        String str = ScriptRuntime.toString(args, 0);
        return NativeGlobal.encode(str, false);
    }

    static Object js_parseInt(Context cx, Object[] args) {
        char c;
        String s = ScriptRuntime.toString(args, 0);
        int radix = ScriptRuntime.toInt32(args, 1);
        int len = s.length();
        if (len == 0) {
            return ScriptRuntime.NaNobj;
        }
        boolean negative = false;
        int start = 0;
        while (ScriptRuntime.isStrWhiteSpaceChar(c = s.charAt(start)) && ++start < len) {
        }
        if (c == '+' || (negative = c == '-')) {
            ++start;
        }
        int NO_RADIX = -1;
        if (radix == 0) {
            radix = -1;
        } else {
            if (radix < 2 || radix > 36) {
                return ScriptRuntime.NaNobj;
            }
            if (radix == 16 && len - start > 1 && s.charAt(start) == '0' && ((c = s.charAt(start + 1)) == 'x' || c == 'X')) {
                start += 2;
            }
        }
        if (radix == -1) {
            radix = 10;
            if (len - start > 1 && s.charAt(start) == '0') {
                c = s.charAt(start + 1);
                if (c == 'x' || c == 'X') {
                    radix = 16;
                    start += 2;
                } else if ('0' <= c && c <= '9' && cx == null) {
                    radix = 8;
                    ++start;
                }
            }
        }
        double d = ScriptRuntime.stringPrefixToNumber(s, start, radix);
        return negative ? -d : d;
    }

    static Object js_parseFloat(Object[] args) {
        char c;
        if (args.length < 1) {
            return ScriptRuntime.NaNobj;
        }
        String s = ScriptRuntime.toString(args[0]);
        int len = s.length();
        int start = 0;
        while (true) {
            if (start == len) {
                return ScriptRuntime.NaNobj;
            }
            c = s.charAt(start);
            if (!ScriptRuntime.isStrWhiteSpaceChar(c)) break;
            ++start;
        }
        int i = start;
        if (c == '+' || c == '-') {
            if (++i == len) {
                return ScriptRuntime.NaNobj;
            }
            c = s.charAt(i);
        }
        if (c == 'I') {
            if (i + 8 <= len && s.regionMatches(i, "Infinity", 0, 8)) {
                if (s.charAt(start) == '-') {
                    return Double.NEGATIVE_INFINITY;
                }
                return Double.POSITIVE_INFINITY;
            }
            return ScriptRuntime.NaNobj;
        }
        int decimal = -1;
        int exponent = -1;
        boolean exponentValid = false;
        block9: while (i < len) {
            switch (s.charAt(i)) {
                case '.': {
                    if (decimal != -1) break block9;
                    decimal = i;
                    break;
                }
                case 'E': 
                case 'e': {
                    if (exponent != -1 || i == len - 1) break block9;
                    exponent = i;
                    break;
                }
                case '+': 
                case '-': {
                    if (exponent != i - 1) break block9;
                    if (i != len - 1) break;
                    --i;
                    break block9;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (exponent == -1) break;
                    exponentValid = true;
                    break;
                }
                default: {
                    break block9;
                }
            }
            ++i;
        }
        if (exponent != -1 && !exponentValid) {
            i = exponent;
        }
        s = s.substring(start, i);
        try {
            return Double.valueOf(s);
        }
        catch (NumberFormatException ex) {
            return ScriptRuntime.NaNobj;
        }
    }

    private static Object js_escape(Object[] args) {
        double d;
        boolean URL_XALPHAS = true;
        int URL_XPALPHAS = 2;
        int URL_PATH = 4;
        String s = ScriptRuntime.toString(args, 0);
        int mask = 7;
        if (args.length > 1 && (Double.isNaN(d = ScriptRuntime.toNumber(args[1])) || (double)(mask = (int)d) != d || 0 != (mask & 0xFFFFFFF8))) {
            throw Context.reportRuntimeErrorById("msg.bad.esc.mask", new Object[0]);
        }
        StringBuilder sb = null;
        int L = s.length();
        for (int k = 0; k != L; ++k) {
            int hexSize;
            char c = s.charAt(k);
            if (mask != 0 && (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '@' || c == '*' || c == '_' || c == '-' || c == '.' || 0 != (mask & 4) && (c == '/' || c == '+'))) {
                if (sb == null) continue;
                sb.append(c);
                continue;
            }
            if (sb == null) {
                sb = new StringBuilder(L + 3);
                sb.append(s);
                sb.setLength(k);
            }
            if (c < '\u0100') {
                if (c == ' ' && mask == 2) {
                    sb.append('+');
                    continue;
                }
                sb.append('%');
                hexSize = 2;
            } else {
                sb.append('%');
                sb.append('u');
                hexSize = 4;
            }
            for (int shift = (hexSize - 1) * 4; shift >= 0; shift -= 4) {
                int digit = 0xF & c >> shift;
                int hc = digit < 10 ? 48 + digit : 55 + digit;
                sb.append((char)hc);
            }
        }
        return sb == null ? s : sb.toString();
    }

    private static Object js_unescape(Object[] args) {
        String s = ScriptRuntime.toString(args, 0);
        int firstEscapePos = s.indexOf(37);
        if (firstEscapePos >= 0) {
            int L = s.length();
            char[] buf = s.toCharArray();
            int destination = firstEscapePos;
            int k = firstEscapePos;
            while (k != L) {
                char c = buf[k];
                if (c == '%' && ++k != L) {
                    int end;
                    int start;
                    if (buf[k] == 'u') {
                        start = k + 1;
                        end = k + 5;
                    } else {
                        start = k;
                        end = k + 2;
                    }
                    if (end <= L) {
                        int x = 0;
                        for (int i = start; i != end; ++i) {
                            x = Kit.xDigitToInt(buf[i], x);
                        }
                        if (x >= 0) {
                            c = (char)x;
                            k = end;
                        }
                    }
                }
                buf[destination] = c;
                ++destination;
            }
            s = new String(buf, 0, destination);
        }
        return s;
    }

    private static Object js_eval(Context cx, Scriptable scope, Object[] args) {
        Scriptable global = ScriptableObject.getTopLevelScope(scope);
        return ScriptRuntime.evalSpecial(cx, global, global, args, "eval code", 1);
    }

    @Deprecated
    public static EcmaError constructError(Context cx, String error, String message, Scriptable scope) {
        return ScriptRuntime.constructError(error, message);
    }

    @Deprecated
    public static EcmaError constructError(Context cx, String error, String message, Scriptable scope, String sourceName, int lineNumber, int columnNumber, String lineSource) {
        return ScriptRuntime.constructError(error, message, sourceName, lineNumber, lineSource, columnNumber);
    }

    private static String encode(String str, boolean fullUri) {
        byte[] utf8buf = null;
        StringBuilder sb = null;
        int length = str.length();
        for (int k = 0; k != length; ++k) {
            int V;
            int C = str.charAt(k);
            if (NativeGlobal.encodeUnescaped((char)C, fullUri)) {
                if (sb == null) continue;
                sb.append((char)C);
                continue;
            }
            if (sb == null) {
                sb = new StringBuilder(length + 3);
                sb.append(str);
                sb.setLength(k);
                utf8buf = new byte[6];
            }
            if (56320 <= C && C <= 57343) {
                throw NativeGlobal.uriError();
            }
            if (C < 55296 || 56319 < C) {
                V = C;
            } else {
                if (++k == length) {
                    throw NativeGlobal.uriError();
                }
                char C2 = str.charAt(k);
                if ('\udc00' > C2 || C2 > '\udfff') {
                    throw NativeGlobal.uriError();
                }
                V = (C - 55296 << 10) + (C2 - 56320) + 65536;
            }
            int L = NativeGlobal.oneUcs4ToUtf8Char(utf8buf, V);
            for (int j = 0; j < L; ++j) {
                int d = 0xFF & utf8buf[j];
                sb.append('%');
                sb.append(NativeGlobal.toHexChar(d >>> 4));
                sb.append(NativeGlobal.toHexChar(d & 0xF));
            }
        }
        return sb == null ? str : sb.toString();
    }

    private static char toHexChar(int i) {
        if (i >> 4 != 0) {
            Kit.codeBug();
        }
        return (char)(i < 10 ? i + 48 : i - 10 + 65);
    }

    private static int unHex(char c) {
        if ('A' <= c && c <= 'F') {
            return c - 65 + 10;
        }
        if ('a' <= c && c <= 'f') {
            return c - 97 + 10;
        }
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        return -1;
    }

    private static int unHex(char c1, char c2) {
        int i1 = NativeGlobal.unHex(c1);
        int i2 = NativeGlobal.unHex(c2);
        if (i1 >= 0 && i2 >= 0) {
            return i1 << 4 | i2;
        }
        return -1;
    }

    private static String decode(String str, boolean fullUri) {
        char[] buf = null;
        int bufTop = 0;
        int k = 0;
        int length = str.length();
        while (k != length) {
            char C = str.charAt(k);
            if (C != '%') {
                if (buf != null) {
                    buf[bufTop++] = C;
                }
                ++k;
                continue;
            }
            if (buf == null) {
                buf = new char[length];
                str.getChars(0, k, buf, 0);
                bufTop = k;
            }
            int start = k;
            if (k + 3 > length) {
                throw NativeGlobal.uriError();
            }
            int B = NativeGlobal.unHex(str.charAt(k + 1), str.charAt(k + 2));
            if (B < 0) {
                throw NativeGlobal.uriError();
            }
            k += 3;
            if ((B & 0x80) == 0) {
                C = (char)B;
            } else {
                int minUcs4Char;
                int ucs4Char;
                int utf8Tail;
                if ((B & 0xC0) == 128) {
                    throw NativeGlobal.uriError();
                }
                if ((B & 0x20) == 0) {
                    utf8Tail = 1;
                    ucs4Char = B & 0x1F;
                    minUcs4Char = 128;
                } else if ((B & 0x10) == 0) {
                    utf8Tail = 2;
                    ucs4Char = B & 0xF;
                    minUcs4Char = 2048;
                } else if ((B & 8) == 0) {
                    utf8Tail = 3;
                    ucs4Char = B & 7;
                    minUcs4Char = 65536;
                } else if ((B & 4) == 0) {
                    utf8Tail = 4;
                    ucs4Char = B & 3;
                    minUcs4Char = 0x200000;
                } else if ((B & 2) == 0) {
                    utf8Tail = 5;
                    ucs4Char = B & 1;
                    minUcs4Char = 0x4000000;
                } else {
                    throw NativeGlobal.uriError();
                }
                if (k + 3 * utf8Tail > length) {
                    throw NativeGlobal.uriError();
                }
                for (int j = 0; j != utf8Tail; ++j) {
                    if (str.charAt(k) != '%') {
                        throw NativeGlobal.uriError();
                    }
                    B = NativeGlobal.unHex(str.charAt(k + 1), str.charAt(k + 2));
                    if (B < 0 || (B & 0xC0) != 128) {
                        throw NativeGlobal.uriError();
                    }
                    ucs4Char = ucs4Char << 6 | B & 0x3F;
                    k += 3;
                }
                if (ucs4Char < minUcs4Char || ucs4Char >= 55296 && ucs4Char <= 57343) {
                    ucs4Char = Integer.MAX_VALUE;
                } else if (ucs4Char == 65534 || ucs4Char == 65535) {
                    ucs4Char = 65533;
                }
                if (ucs4Char >= 65536) {
                    if ((ucs4Char -= 65536) > 1048575) {
                        throw NativeGlobal.uriError();
                    }
                    char H = (char)((ucs4Char >>> 10) + 55296);
                    C = (char)((ucs4Char & 0x3FF) + 56320);
                    buf[bufTop++] = H;
                } else {
                    C = (char)ucs4Char;
                }
            }
            if (fullUri && URI_DECODE_RESERVED.indexOf(C) >= 0) {
                for (int x = start; x != k; ++x) {
                    buf[bufTop++] = str.charAt(x);
                }
                continue;
            }
            buf[bufTop++] = C;
        }
        return buf == null ? str : new String(buf, 0, bufTop);
    }

    private static boolean encodeUnescaped(char c, boolean fullUri) {
        if ('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z' || '0' <= c && c <= '9') {
            return true;
        }
        if ("-_.!~*'()".indexOf(c) >= 0) {
            return true;
        }
        if (fullUri) {
            return URI_DECODE_RESERVED.indexOf(c) >= 0;
        }
        return false;
    }

    private static EcmaError uriError() {
        return ScriptRuntime.constructError("URIError", ScriptRuntime.getMessageById("msg.bad.uri", new Object[0]));
    }

    private static int oneUcs4ToUtf8Char(byte[] utf8Buffer, int ucs4Char) {
        int utf8Length = 1;
        if ((ucs4Char & 0xFFFFFF80) == 0) {
            utf8Buffer[0] = (byte)ucs4Char;
        } else {
            int a = ucs4Char >>> 11;
            utf8Length = 2;
            while (a != 0) {
                a >>>= 5;
                ++utf8Length;
            }
            int i = utf8Length;
            while (--i > 0) {
                utf8Buffer[i] = (byte)(ucs4Char & 0x3F | 0x80);
                ucs4Char >>>= 6;
            }
            utf8Buffer[0] = (byte)(256 - (1 << 8 - utf8Length) + ucs4Char);
        }
        return utf8Length;
    }

    private static class EvalLambdaFunction
    extends LambdaFunction {
        public EvalLambdaFunction(Scriptable scope) {
            super(scope, "eval", 1, (callCx, callScope, thisObj, args) -> NativeGlobal.js_eval(callCx, callScope, args));
        }
    }

    private static abstract class SerializableConstructableWithInjectableCtor
    implements SerializableConstructable {
        Function lateBoundCtor;

        private SerializableConstructableWithInjectableCtor() {
        }
    }
}

