/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.reactor.excel.spec;

import java.io.InputStream;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import org.hswebframework.reactor.excel.BoundedCell;
import org.hswebframework.reactor.excel.Cell;
import org.hswebframework.reactor.excel.ExcelOption;
import org.hswebframework.reactor.excel.spec.DefaultReaderSpec;
import org.hswebframework.reactor.excel.spi.ExcelReader;
import org.hswebframework.reactor.excel.utils.StreamUtils;
import reactor.core.publisher.Flux;
import reactor.function.Consumer3;

public interface ReaderSpec<T> {
    public ReaderSpec<T> oneInstanceEachSheet();

    public ReaderSpec<T> oneInstanceAllSheets();

    public ReaderSpec<T> oneInstanceEachRow();

    public ReaderSpec<T> skipRow(int var1);

    public Flux<T> read(InputStream var1, ExcelOption ... var2);

    default public Flux<T> readAndClose(InputStream stream, ExcelOption ... options) {
        return Flux.using(() -> stream, _stream -> this.read((InputStream)_stream, options), StreamUtils::safeClose);
    }

    public static <T> ReaderSpecSelector<T> readFor(ExcelReader reader, Supplier<T> instanceSupplier) {
        return new DefaultReaderSpec<T>(reader, instanceSupplier);
    }

    public static interface MultiSheetHeaderReaderSpec<T>
    extends MultiSheetReaderSpec<T> {
        public MultiSheetHeaderReaderSpec<T> header(String var1, String var2);

        public MultiSheetHeaderReaderSpec<T> headers(Map<String, String> var1);

        public MultiSheetHeaderReaderSpec<T> sheet(int var1, Consumer3<T, String, BoundedCell> var2);

        public MultiSheetHeaderReaderSpec<T> sheet(String var1, Consumer3<T, String, BoundedCell> var2);

        @Override
        public MultiSheetHeaderReaderSpec<T> oneInstanceEachRow();

        @Override
        public MultiSheetHeaderReaderSpec<T> oneInstanceEachSheet();

        @Override
        public MultiSheetHeaderReaderSpec<T> oneInstanceAllSheets();

        @Override
        public MultiSheetHeaderReaderSpec<T> instanceCondition(BiPredicate<T, ? extends BoundedCell> var1);

        @Override
        public MultiSheetHeaderReaderSpec<T> skipRow(int var1);

        public MultiSheetHeaderReaderSpec<T> headerRow(int var1);
    }

    public static interface MultiSheetCellReaderSpec<T>
    extends MultiSheetReaderSpec<T> {
        public MultiSheetCellReaderSpec<T> sheet(int var1, BiConsumer<T, BoundedCell> var2);

        public MultiSheetCellReaderSpec<T> sheet(String var1, BiConsumer<T, BoundedCell> var2);

        @Override
        public MultiSheetCellReaderSpec<T> oneInstanceEachRow();

        @Override
        public MultiSheetCellReaderSpec<T> oneInstanceEachSheet();

        @Override
        public MultiSheetCellReaderSpec<T> oneInstanceAllSheets();

        @Override
        public MultiSheetCellReaderSpec<T> instanceCondition(BiPredicate<T, ? extends BoundedCell> var1);

        @Override
        public MultiSheetCellReaderSpec<T> skipRow(int var1);
    }

    public static interface MultiSheetReaderSpec<T>
    extends ReaderSpec<T> {
        @Override
        public MultiSheetReaderSpec<T> oneInstanceEachSheet();

        @Override
        public MultiSheetReaderSpec<T> oneInstanceAllSheets();

        @Override
        public MultiSheetReaderSpec<T> oneInstanceEachRow();

        public MultiSheetReaderSpec<T> instanceCondition(BiPredicate<T, ? extends BoundedCell> var1);

        @Override
        public MultiSheetReaderSpec<T> skipRow(int var1);
    }

    public static interface SheetHeaderReaderSpec<T>
    extends ReaderSpec<T> {
        public SheetHeaderReaderSpec<T> header(String var1, String var2);

        public SheetHeaderReaderSpec<T> headers(Map<String, String> var1);

        public SheetReaderSpec<T> wrapper(Consumer3<T, String, Cell> var1);

        @Override
        public MultiSheetReaderSpec<T> oneInstanceEachSheet();

        @Override
        public MultiSheetReaderSpec<T> oneInstanceAllSheets();

        @Override
        public MultiSheetReaderSpec<T> oneInstanceEachRow();

        public SheetReaderSpec<T> instanceCondition(BiPredicate<T, ? extends Cell> var1);

        @Override
        public SheetReaderSpec<T> skipRow(int var1);

        public MultiSheetHeaderReaderSpec<T> headerRow(int var1);
    }

    public static interface SheetReaderSpec<T>
    extends ReaderSpec<T> {
        public SheetReaderSpec<T> wrapper(BiConsumer<T, Cell> var1);

        @Override
        public SheetReaderSpec<T> oneInstanceEachSheet();

        @Override
        public SheetReaderSpec<T> oneInstanceAllSheets();

        @Override
        public SheetReaderSpec<T> oneInstanceEachRow();

        public SheetReaderSpec<T> instanceCondition(BiPredicate<T, Cell> var1);

        @Override
        public SheetReaderSpec<T> skipRow(int var1);
    }

    public static interface ReaderSpecSelector<T> {
        public SheetReaderSpec<T> justRead();

        public SheetHeaderReaderSpec<T> justReadByHeader();

        public MultiSheetCellReaderSpec<T> multiSheet();

        public MultiSheetHeaderReaderSpec<T> multiSheetByHeader();
    }
}

