/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.reactor.excel.converter;

import java.util.Optional;
import org.hswebframework.reactor.excel.Cell;
import org.hswebframework.reactor.excel.CellDataType;
import org.hswebframework.reactor.excel.ExcelHeader;
import org.hswebframework.reactor.excel.WritableCell;

public class SimpleWritableCell
implements WritableCell {
    private CellDataType type;
    public Object value;
    private long rowIndex;
    private int columnIndex;
    private boolean endOfRow;
    private int sheetIndex;

    public SimpleWritableCell(ExcelHeader header, Object value, long rowIndex, int columnIndex, boolean endOfRow, int sheetIndex) {
        this(header.getType(), value, rowIndex, columnIndex, endOfRow, sheetIndex);
    }

    public SimpleWritableCell(CellDataType dataType, Object value, long rowIndex, int columnIndex, boolean endOfRow, int sheetIndex) {
        this.type = dataType;
        this.value = value;
        this.rowIndex = rowIndex;
        this.columnIndex = columnIndex;
        this.endOfRow = endOfRow;
        this.sheetIndex = sheetIndex;
    }

    public SimpleWritableCell(Cell cell, int sheetIndex) {
        this(cell.getType(), cell.value().orElse(null), cell.getRowIndex(), cell.getColumnIndex(), cell.isEndOfRow(), sheetIndex);
    }

    @Override
    public Optional<Object> value() {
        return Optional.ofNullable(this.value);
    }

    @Override
    public CellDataType getType() {
        return this.type;
    }

    @Override
    public long getRowIndex() {
        return this.rowIndex;
    }

    @Override
    public int getColumnIndex() {
        return this.columnIndex;
    }

    @Override
    public boolean isEndOfRow() {
        return this.endOfRow;
    }

    @Override
    public int getSheetIndex() {
        return this.sheetIndex;
    }
}

