/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.reactor.excel;

import org.hswebframework.reactor.excel.InSheetCell;
import org.hswebframework.reactor.excel.ReplaceValueCell;

public interface BoundedCell
extends InSheetCell {
    public int getNumberOfRows();

    public int getNumberOfColumns();

    public int getNumberOfSheets();

    default public boolean isLastColumn() {
        return this.getColumnIndex() == this.getNumberOfColumns() - 1;
    }

    default public boolean isLastRow() {
        return this.getRowIndex() == (long)(this.getNumberOfRows() - 1);
    }

    default public boolean isFirstColumn() {
        return this.getColumnIndex() == 0;
    }

    default public boolean isLastSheet() {
        return this.getSheetIndex() == this.getNumberOfSheets() - 1;
    }

    public static BoundedCell of(BoundedCell source, Object value) {
        return new ReplaceValueCell(source, value);
    }
}

