/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rights;

import org.hsqldb.HsqlNameManager;
import org.hsqldb.error.Error;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.rights.Grantee;
import org.hsqldb.rights.GranteeManager;

public class User
extends Grantee {
    private String password;
    private HsqlNameManager.HsqlName initialSchema = null;

    User(HsqlNameManager.HsqlName hsqlName, GranteeManager granteeManager) {
        super(hsqlName, granteeManager);
        if (granteeManager != null) {
            this.updateAllRights();
        }
    }

    public String getSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE").append(' ').append("USER");
        stringBuffer.append(' ').append(this.granteeName.statementName).append(' ');
        stringBuffer.append("PASSWORD").append(' ');
        stringBuffer.append('\'').append(this.password).append('\'');
        return stringBuffer.toString();
    }

    public long getChangeTimestamp() {
        return 0L;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void checkPassword(String string) {
        if (!string.equals(this.password)) {
            throw Error.error(4000);
        }
    }

    public HsqlNameManager.HsqlName getInitialSchema() {
        return this.initialSchema;
    }

    public HsqlNameManager.HsqlName getInitialOrDefaultSchema() {
        if (this.initialSchema != null) {
            return this.initialSchema;
        }
        HsqlNameManager.HsqlName hsqlName = this.granteeManager.database.schemaManager.findSchemaHsqlName(this.getNameString());
        if (hsqlName == null) {
            return this.granteeManager.database.schemaManager.getDefaultSchemaHsqlName();
        }
        return hsqlName;
    }

    public void setInitialSchema(HsqlNameManager.HsqlName hsqlName) {
        this.initialSchema = hsqlName;
    }

    public String getAlterUserSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ALTER").append(' ');
        stringBuffer.append("USER").append(' ');
        stringBuffer.append(this.getStatementName()).append(' ');
        stringBuffer.append("SET").append(' ');
        stringBuffer.append("PASSWORD").append(' ');
        stringBuffer.append('\"').append(this.password).append('\"');
        return stringBuffer.toString();
    }

    public String getInitialSchemaSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ALTER").append(' ');
        stringBuffer.append("USER").append(' ');
        stringBuffer.append(this.getStatementName()).append(' ');
        stringBuffer.append("SET").append(' ');
        stringBuffer.append("INITIAL").append(' ');
        stringBuffer.append("SCHEMA").append(' ');
        stringBuffer.append(this.initialSchema.statementName);
        return stringBuffer.toString();
    }

    public String getCreateUserSQL() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("CREATE").append(' ');
        stringBuffer.append("USER").append(' ');
        stringBuffer.append(this.getStatementName()).append(' ');
        stringBuffer.append("PASSWORD").append(' ');
        stringBuffer.append(StringConverter.toQuotedString(this.password, '\"', true));
        return stringBuffer.toString();
    }

    public String getConnectUserSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SET").append(' ');
        stringBuffer.append("SESSION").append(' ');
        stringBuffer.append("AUTHORIZATION").append(' ');
        stringBuffer.append(StringConverter.toQuotedString(this.getNameString(), '\'', true));
        return stringBuffer.toString();
    }
}

