/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.sql.SQLException;
import java.sql.Savepoint;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.Util;

public class JDBCSavepoint
implements Savepoint {
    int id;
    String name;
    JDBCConnection connection;

    JDBCSavepoint(String string, JDBCConnection jDBCConnection) throws SQLException {
        if (string == null) {
            throw Util.nullArgument("name");
        }
        if (jDBCConnection == null) {
            throw Util.nullArgument("conn");
        }
        this.name = string;
        this.connection = jDBCConnection;
    }

    JDBCSavepoint(JDBCConnection jDBCConnection) throws SQLException {
        if (jDBCConnection == null) {
            throw Util.nullArgument("conn");
        }
        this.id = jDBCConnection.getSavepointID();
        this.connection = jDBCConnection;
    }

    public int getSavepointId() throws SQLException {
        if (this.name == null) {
            return this.id;
        }
        throw Util.notSupported();
    }

    public String getSavepointName() throws SQLException {
        if (this.name == null) {
            throw Util.notSupported();
        }
        return this.name;
    }

    public String toString() {
        return super.toString() + "[name=" + this.name + "]";
    }
}

