/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.hamcrest;

import java.util.Collection;
import org.hamcrest.BaseMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

public class HasNullElementsMatcher<C extends Collection<?>>
extends BaseMatcher<C> {
    public static final HasNullElementsMatcher HAS_NULL_ELEMENTS_MATCHER = new HasNullElementsMatcher(false);
    public static final HasNullElementsMatcher HAS_NO_NULL_ELEMENTS_MATCHER = new HasNullElementsMatcher(true);
    private final boolean negated;

    public HasNullElementsMatcher(boolean negated) {
        this.negated = negated;
    }

    public boolean matches(Object item) {
        MatcherAssert.assertThat((Object)item, (Matcher)CoreMatchers.instanceOf(Collection.class));
        Collection collection = (Collection)item;
        if (this.negated) {
            collection.forEach(e -> MatcherAssert.assertThat((Object)e, (Matcher)CoreMatchers.notNullValue()));
            return true;
        }
        boolean foundOne = false;
        for (Object e2 : collection) {
            if (e2 != null) continue;
            foundOne = true;
            break;
        }
        return foundOne;
    }

    public void describeTo(Description description) {
        description.appendText("had null elements");
    }
}

