/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.bytecode.enhancement.extension.engine;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.bytecode.enhance.spi.Enhancer;
import org.hibernate.bytecode.enhance.spi.UnloadedClass;
import org.hibernate.bytecode.enhance.spi.UnloadedField;
import org.hibernate.bytecode.internal.BytecodeProviderInitiator;
import org.hibernate.testing.bytecode.enhancement.ClassEnhancementSelector;
import org.hibernate.testing.bytecode.enhancement.ClassEnhancementSelectors;
import org.hibernate.testing.bytecode.enhancement.ClassSelector;
import org.hibernate.testing.bytecode.enhancement.CustomEnhancementContext;
import org.hibernate.testing.bytecode.enhancement.EnhancementOptions;
import org.hibernate.testing.bytecode.enhancement.EnhancementSelector;
import org.hibernate.testing.bytecode.enhancement.EnhancerTestContext;
import org.hibernate.testing.bytecode.enhancement.ImplEnhancementSelector;
import org.hibernate.testing.bytecode.enhancement.ImplEnhancementSelectors;
import org.hibernate.testing.bytecode.enhancement.PackageEnhancementSelector;
import org.hibernate.testing.bytecode.enhancement.PackageEnhancementSelectors;
import org.hibernate.testing.bytecode.enhancement.PackageSelector;

final class BytecodeEnhancedClassUtils {
    private BytecodeEnhancedClassUtils() {
    }

    static Map<Object, Class<?>> enhanceTestClass(Class<?> klass) throws ClassNotFoundException {
        String packageName = klass.getPackage().getName();
        LinkedHashMap classes = new LinkedHashMap();
        try {
            if (klass.isAnnotationPresent(EnhancementOptions.class) || klass.isAnnotationPresent(ClassEnhancementSelector.class) || klass.isAnnotationPresent(ClassEnhancementSelectors.class) || klass.isAnnotationPresent(PackageEnhancementSelector.class) || klass.isAnnotationPresent(PackageEnhancementSelectors.class) || klass.isAnnotationPresent(ImplEnhancementSelector.class) || klass.isAnnotationPresent(ImplEnhancementSelectors.class)) {
                classes.put("-", BytecodeEnhancedClassUtils.buildEnhancerClassLoader(klass).loadClass(klass.getName()));
            } else if (klass.isAnnotationPresent(CustomEnhancementContext.class)) {
                for (Class<? extends EnhancementContext> contextClass : klass.getAnnotation(CustomEnhancementContext.class).value()) {
                    EnhancementContext enhancementContextInstance = contextClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    classes.put(contextClass.getSimpleName(), BytecodeEnhancedClassUtils.getEnhancerClassLoader(enhancementContextInstance, packageName).loadClass(klass.getName()));
                }
            } else {
                classes.put("-", BytecodeEnhancedClassUtils.getEnhancerClassLoader((EnhancementContext)new EnhancerTestContext(), packageName).loadClass(klass.getName()));
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return classes;
    }

    private static ClassLoader buildEnhancerClassLoader(Class<?> klass) {
        final EnhancementOptions options = klass.getAnnotation(EnhancementOptions.class);
        EnhancerTestContext enhancerContext = options == null ? new EnhancerTestContext() : new EnhancerTestContext(){

            @Override
            public boolean doBiDirectionalAssociationManagement(UnloadedField field) {
                return options.biDirectionalAssociationManagement() && super.doBiDirectionalAssociationManagement(field);
            }

            @Override
            public boolean doDirtyCheckingInline(UnloadedClass classDescriptor) {
                return options.inlineDirtyChecking() && super.doDirtyCheckingInline(classDescriptor);
            }

            @Override
            public boolean doExtendedEnhancement(UnloadedClass classDescriptor) {
                return options.extendedEnhancement() && super.doExtendedEnhancement(classDescriptor);
            }

            @Override
            public boolean hasLazyLoadableAttributes(UnloadedClass classDescriptor) {
                return options.lazyLoading() && super.hasLazyLoadableAttributes(classDescriptor);
            }

            @Override
            public boolean isLazyLoadable(UnloadedField field) {
                return options.lazyLoading() && super.isLazyLoadable(field);
            }
        };
        ArrayList<EnhancementSelector> selectors = new ArrayList<EnhancementSelector>();
        selectors.add(new PackageSelector(klass.getPackage().getName()));
        BytecodeEnhancedClassUtils.applySelectors(klass, ClassEnhancementSelector.class, ClassEnhancementSelectors.class, selectorAnnotation -> selectors.add(new ClassSelector(selectorAnnotation.value().getName())));
        BytecodeEnhancedClassUtils.applySelectors(klass, PackageEnhancementSelector.class, PackageEnhancementSelectors.class, selectorAnnotation -> selectors.add(new PackageSelector(selectorAnnotation.value())));
        BytecodeEnhancedClassUtils.applySelectors(klass, ImplEnhancementSelector.class, ImplEnhancementSelectors.class, selectorAnnotation -> {
            try {
                selectors.add(selectorAnnotation.impl().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        return BytecodeEnhancedClassUtils.buildEnhancerClassLoader((EnhancementContext)enhancerContext, selectors);
    }

    private static <A extends Annotation> void applySelectors(Class<?> klass, Class<A> selectorAnnotationType, Class<? extends Annotation> selectorsAnnotationType, Consumer<A> action) {
        A selectorAnnotation = klass.getAnnotation(selectorAnnotationType);
        Annotation selectorsAnnotation = klass.getAnnotation(selectorsAnnotationType);
        if (selectorAnnotation != null) {
            action.accept(selectorAnnotation);
        } else if (selectorsAnnotation != null) {
            try {
                Annotation[] selectorAnnotations;
                Method valuesMethod = selectorsAnnotationType.getDeclaredMethods()[0];
                for (Annotation groupedSelectorAnnotation : selectorAnnotations = (Annotation[])valuesMethod.invoke((Object)selectorsAnnotation, new Object[0])) {
                    action.accept(groupedSelectorAnnotation);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static ClassLoader buildEnhancerClassLoader(EnhancementContext enhancerContext, List<EnhancementSelector> selectors) {
        return new EnhancingClassLoader(BytecodeProviderInitiator.buildDefaultBytecodeProvider().getEnhancer(enhancerContext), selectors);
    }

    private static ClassLoader getEnhancerClassLoader(EnhancementContext context, String packageName) {
        return BytecodeEnhancedClassUtils.buildEnhancerClassLoader(context, Collections.singletonList(new PackageSelector(packageName)));
    }

    private static class EnhancingClassLoader
    extends ClassLoader {
        private final Enhancer enhancer;
        private final List<EnhancementSelector> selectors;

        public EnhancingClassLoader(Enhancer enhancer, List<EnhancementSelector> selectors) {
            this.enhancer = enhancer;
            this.selectors = selectors;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            EnhancementSelector selector;
            Iterator<EnhancementSelector> iterator = this.selectors.iterator();
            do {
                if (!iterator.hasNext()) return this.getParent().loadClass(name);
            } while (!(selector = iterator.next()).select(name));
            Class<?> c = this.findLoadedClass(name);
            if (c != null) {
                return c;
            }
            try (InputStream is = this.getResourceAsStream(name.replace('.', '/') + ".class");){
                if (is == null) {
                    throw new ClassNotFoundException(name + " not found");
                }
                byte[] original = new byte[is.available()];
                try (BufferedInputStream bis = new BufferedInputStream(is);){
                    bis.read(original);
                }
                byte[] enhanced = this.enhancer.enhance(name, original);
                if (enhanced == null) {
                    Class<?> clazz2 = this.defineClass(name, original, 0, original.length);
                    return clazz2;
                }
                Path f = Files.createTempDirectory("", new FileAttribute[0]).getParent().resolve(name.replace(".", File.separator) + ".class");
                Files.createDirectories(f.getParent(), new FileAttribute[0]);
                try (OutputStream out = Files.newOutputStream(f, new OpenOption[0]);){
                    out.write(enhanced);
                }
                Class<?> clazz = this.defineClass(name, enhanced, 0, enhanced.length);
                return clazz;
            }
            catch (Exception t) {
                throw new ClassNotFoundException(name + " not found", t);
            }
        }
    }
}

